/*
 * Decompiled with CFR 0.152.
 */
package rasterviewer.imageloaders;

import com.sun.media.jai.codec.ByteArraySeekableStream;
import com.sun.media.jai.codec.FileSeekableStream;
import com.sun.media.jai.codec.SeekableStream;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import javax.media.jai.PlanarImage;
import rasterviewer.imageloaders.JAIImageReader;

public class ImageLoader {
    public static final int JPEG = 1;
    public static final int PNG = 2;
    public static final int TIFF = 3;

    public Image loadImage(String filename, int type, int page) {
        BufferedImage img = null;
        switch (type) {
            case 1: 
            case 2: {
                PlanarImage img2 = null;
                try {
                    img2 = JAIImageReader.readImage((SeekableStream)new FileSeekableStream(filename));
                }
                catch (IOException iox) {
                    System.out.println(" File " + filename + " could not be read");
                    return null;
                }
                img = img2.getAsBufferedImage();
                BufferedImage comp = new BufferedImage(((Image)img).getWidth(null), ((Image)img).getHeight(null), 1);
                Graphics g = ((Image)comp).getGraphics();
                g.drawImage(img, 0, 0, ((Image)comp).getWidth(null), ((Image)comp).getHeight(null), null);
                return comp;
            }
            case 3: {
                PlanarImage img3 = null;
                try {
                    img3 = JAIImageReader.readImageTIFF((SeekableStream)new FileSeekableStream(filename), page);
                }
                catch (IOException iox) {
                    System.out.println(" File " + filename + " could not be read");
                    return null;
                }
                BufferedImage comp = new BufferedImage(img3.getWidth(), img3.getHeight(), 1);
                Graphics g = ((Image)comp).getGraphics();
                img = img3.getAsBufferedImage();
                g.drawImage(img, 0, 0, ((Image)comp).getWidth(null), ((Image)comp).getHeight(null), null);
                return comp;
            }
        }
        return null;
    }

    public Image loadImage(InputStream inputStream, int type, int page) {
        BufferedImage img = null;
        switch (type) {
            case 1: 
            case 2: {
                PlanarImage img2 = null;
                img2 = JAIImageReader.readImage(SeekableStream.wrapInputStream((InputStream)inputStream, (boolean)false));
                img = img2.getAsBufferedImage();
                BufferedImage comp = new BufferedImage(((Image)img).getWidth(null), ((Image)img).getHeight(null), 1);
                Graphics g = ((Image)comp).getGraphics();
                g.drawImage(img, 0, 0, ((Image)comp).getWidth(null), ((Image)comp).getHeight(null), null);
                return comp;
            }
            case 3: {
                PlanarImage img3 = null;
                img3 = JAIImageReader.readImageTIFF(SeekableStream.wrapInputStream((InputStream)inputStream, (boolean)false), page);
                BufferedImage comp = new BufferedImage(img3.getWidth(), img3.getHeight(), 1);
                Graphics g = ((Image)comp).getGraphics();
                img = img3.getAsBufferedImage();
                g.drawImage(img, 0, 0, ((Image)comp).getWidth(null), ((Image)comp).getHeight(null), null);
                return comp;
            }
        }
        return null;
    }

    public Image loadImage(byte[] bytearray, int type, int page) {
        BufferedImage img = null;
        switch (type) {
            case 1: 
            case 2: {
                PlanarImage img2 = null;
                try {
                    img2 = JAIImageReader.readImage((SeekableStream)new ByteArraySeekableStream(bytearray));
                }
                catch (IOException iox) {
                    System.out.println("Error readion ByteArraySeekableStream");
                    return null;
                }
                img = img2.getAsBufferedImage();
                return img;
            }
            case 3: {
                PlanarImage img3 = null;
                try {
                    img3 = JAIImageReader.readImageTIFF((SeekableStream)new ByteArraySeekableStream(bytearray), page);
                }
                catch (IOException iox) {
                    System.out.println("Error readion ByteArraySeekableStream");
                    return null;
                }
                img = img3.getAsBufferedImage();
                return img;
            }
        }
        return null;
    }
}

