/*
 * Decompiled with CFR 0.152.
 */
package com.bmw.tetis.eba.psi;

import com.bmw.tetis.eba.psi.AppEntry;
import com.bmw.tetis.eba.psi.DmsService;
import com.bmw.tetis.eba.psi.PsiException;
import com.bmw.tetis.eba.psi.PsiParser;
import com.bmw.tetis.eba.psi.PsiUser;
import com.softlab.scms.asap.amet.rec.model.AccessRecordList;
import com.softlab.scms.asap.amet.rec.model.AmetMessage;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.io.Writer;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionBindingEvent;
import javax.servlet.http.HttpSessionBindingListener;

public class PsiManager
implements HttpSessionBindingListener,
Serializable {
    private static Boolean debug = null;
    private transient PsiParser parser = new PsiParser();
    private AccessRecordList urls = new AccessRecordList();
    private String serverName;
    private int serverPort;
    private String xmlStream;
    private Set allRegisteredApps = new HashSet();
    private Collection userRoles;
    private Collection userPermissions;
    public static final String BEAN_NAME = "com.bmw.tetis.eba.psi.PsiManager";
    private boolean keepPsiSession = false;

    void setAppName(String appName) {
        this.parser.setAppName(appName);
    }

    public String getAppName() {
        return this.parser.getAppName();
    }

    void setPortalSessionId(String portalSessionId) {
        this.parser.setPortalSessionId(portalSessionId);
    }

    public String getPortalSessionId() {
        return this.parser.getPortalSessionId();
    }

    void setPsiInfoUrl(String psiInfoUrl) {
        this.parser.setPsiInfoUrl(psiInfoUrl);
    }

    public String getPsiInfoUrl() {
        return this.parser.getPsiInfoUrl();
    }

    void setPsiCallUrl(String psiCallUrl) {
        this.parser.setPsiCallUrl(psiCallUrl);
    }

    public String getPsiCallUrl() {
        return this.parser.getPsiCallUrl();
    }

    public String getPsiCallString() {
        return this.parser.getPsiCallString();
    }

    public AppEntry[] getAppEntries(String connectionId) {
        return this.parser.getAppEntries(connectionId);
    }

    public PsiUser getUser() {
        PsiUser psiUser = this.parser.getUser();
        psiUser.setPsiManager(this);
        return psiUser;
    }

    public DmsService getDmsService() {
        return this.parser.getDmsService();
    }

    private void requestPsiInfo() throws MalformedURLException, IOException, PsiException {
        PsiManager.print("requestPsiInfo: creating URL ... psiInfoUrl=" + this.getPsiInfoUrl() + " ... APP=" + this.getAppName() + " ... " + "SESSIONID= " + this.getPortalSessionId());
        URL url = new URL(this.getPsiInfoUrl() + "?FUNCTION=PINFO&APP=" + this.getAppName() + "&PSESSID=" + this.getPortalSessionId());
        PsiManager.print("requestPsiInfo: connecting to url = " + url.getPath());
        PsiManager.print("requestPsiInfo: protocol = " + url.getProtocol());
        PsiManager.print("requestPsiInfo: getting InputStream ....");
        InputStream inputStream = this.getServletResponse(url);
        this.parser.parse(inputStream);
    }

    public Collection getUserRoles() throws Exception {
        return this.getUserRoles(this.getUser().getUserId(), true);
    }

    public Collection getUserRoles(boolean getFromSession) throws Exception {
        return this.getUserRoles(this.getUser().getUserId(), getFromSession);
    }

    public Collection getUserRoles(String userId, boolean getFromSession) throws Exception {
        if (this.userRoles != null && getFromSession) {
            return this.userRoles;
        }
        String groupen = "";
        StringBuffer stb = new StringBuffer();
        Collection groups = this.getUser().getGroups();
        if (groups != null && !groups.isEmpty()) {
            stb.append("&GROUPS=");
            Iterator it = groups.iterator();
            while (it.hasNext()) {
                stb.append(it.next());
                if (!it.hasNext()) continue;
                stb.append(";");
            }
            groupen = stb.toString();
            groupen = groupen.replaceAll("#", "%h%");
        }
        URL url = new URL(this.getPsiInfoUrl() + "?FUNCTION=" + "PUSER_ROLES_INFO" + "&APP=" + this.getAppName() + "&PSESSID=" + this.getPortalSessionId() + "&" + "USER_ID" + "=" + userId + groupen);
        InputStream inputStream = this.getServletResponse(url);
        PsiParser roleParser = new PsiParser();
        roleParser.parseUserRoles(inputStream);
        this.userRoles = roleParser.getUserRoles();
        return this.userRoles;
    }

    public Collection getUserPermissions() throws Exception {
        return this.getUserPermissions(this.getUser().getUserId(), true);
    }

    public Collection getUserPermissions(String userId, boolean isGetOld) throws MalformedURLException, IOException, PsiException {
        if (this.userPermissions != null && isGetOld) {
            return this.userPermissions;
        }
        String groupen = "";
        StringBuffer stb = new StringBuffer();
        Collection groups = this.getUser().getGroups();
        if (groups != null && !groups.isEmpty()) {
            stb.append("&GROUPS=");
            Iterator it = groups.iterator();
            while (it.hasNext()) {
                stb.append(it.next());
                if (!it.hasNext()) continue;
                stb.append(";");
            }
            groupen = stb.toString();
            groupen = groupen.replaceAll("#", "%h%");
        }
        URL url = new URL(this.getPsiInfoUrl() + "?FUNCTION=" + "PUSER_PERMISSIONS_INFO" + "&APP=" + this.getAppName() + "&PSESSID=" + this.getPortalSessionId() + "&" + "USER_ID" + "=" + userId + groupen);
        InputStream inputStream = this.getServletResponse(url);
        PsiParser permissionParser = new PsiParser();
        permissionParser.parseUserPermissions(inputStream);
        this.userPermissions = permissionParser.getUserPermissions();
        return this.userPermissions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private InputStream getServletResponse(URL url) throws PsiException {
        InputStream inputStream = null;
        UrlThread urlThread = new UrlThread();
        urlThread.url = url;
        try {
            UrlThread urlThread2 = urlThread;
            synchronized (urlThread2) {
                PsiManager.print("getServletResponse: STARTING PSI THREAD FOR URL: " + url.toString());
                urlThread.start();
                PsiManager.print("getServletResponse: WAITING 5000: ");
                urlThread.wait(5000L);
                if (urlThread.exception != null) {
                    PsiManager.print("getServletResponse: Exception occured .... " + urlThread.exception.getMessage());
                    this.print(urlThread.exception);
                    throw new PsiException(urlThread.exception.getMessage());
                }
                if (!urlThread.success) {
                    PsiManager.print("getServletResponse: PSI TIMEOUT occured .... ");
                    throw new PsiException("PSI timeout");
                }
            }
            PsiManager.print("getServletResponse: no exceptions ... inputstream received ...");
            inputStream = urlThread.inputStream;
        }
        catch (PsiException pe) {
            PsiManager.print("getServletResponse: unexpected exception .... " + pe.getMessage());
            this.print(pe);
            throw pe;
        }
        catch (Throwable ie) {
            PsiManager.print("getServletResponse: unexpected throwable .... " + ie.getMessage());
            this.print(ie);
            throw new PsiException("PSI timeout");
        }
        return inputStream;
    }

    public Collection getAllBrands() throws MalformedURLException, IOException, PsiException {
        URL url = new URL(this.getPsiInfoUrl() + "?FUNCTION=" + "PALL_BRANDS_INFO" + "&APP=" + this.getAppName() + "&PSESSID=" + this.getPortalSessionId());
        InputStream inputStream = this.getServletResponse(url);
        PsiParser allBrandsParser = new PsiParser();
        allBrandsParser.parseAllBrands(inputStream);
        return allBrandsParser.getAllBrands();
    }

    public DmsService getDMSInfoObject(String dealerId) throws MalformedURLException, IOException, PsiException {
        return this.getDMSInfoObject(dealerId, null);
    }

    public DmsService getDMSInfoObject(String dealerId, String userId) throws MalformedURLException, IOException, PsiException {
        InputStream in = this.getDMSInfoStream(dealerId, userId);
        PsiParser dmsParser = new PsiParser();
        dmsParser.parseDMSService(in);
        in.close();
        DmsService psiDmsService = this.getDmsService();
        DmsService dmsService = dmsParser.getDmsService();
        if (psiDmsService != null) {
            dmsService.setServerName(psiDmsService.getServerName());
            dmsService.setServerPort(psiDmsService.getServerPort());
            dmsService.setAppName(psiDmsService.getAppName());
        }
        return dmsService;
    }

    public String getDMSInfoString(String dealerId) throws MalformedURLException, IOException, PsiException {
        return this.getDMSInfoString(dealerId, null);
    }

    public String getDMSInfoString(String dealerId, String userId) throws MalformedURLException, IOException, PsiException {
        String xml = "";
        InputStream in = this.getDMSInfoStream(dealerId, userId);
        ByteArrayOutputStream bites = new ByteArrayOutputStream();
        int nextByte = in.read();
        while (nextByte != -1) {
            bites.write(nextByte);
            nextByte = in.read();
        }
        in.close();
        xml = bites.toString("UTF-8");
        return xml;
    }

    private InputStream getDMSInfoStream(String dealerId, String userId) throws MalformedURLException, IOException, PsiException {
        String urlStr = this.getPsiInfoUrl() + "?FUNCTION=" + "PDMS_INFO" + "&APP=" + this.getAppName() + "&" + "DEALER_ID" + "=" + dealerId + "&PSESSID=" + this.getPortalSessionId();
        if (userId != null) {
            urlStr = urlStr + "&USER_ID=" + userId;
        }
        URL url = new URL(urlStr);
        InputStream inputStream = this.getServletResponse(url);
        return inputStream;
    }

    public static PsiManager getPsiManager(HttpServletRequest request) throws PsiException {
        PsiManager.print("getPsiManager: Trying to get PsiManager for request: " + request.getQueryString());
        if (request.getSession(true).getAttribute(BEAN_NAME) != null) {
            return (PsiManager)request.getSession(true).getAttribute(BEAN_NAME);
        }
        PsiManager.print("getPsiManager: PsiManager is not in session .. trying to set a new PsiManager ... ");
        PsiManager psiManager = new PsiManager();
        psiManager.setPsiManager(request);
        request.getSession(true).setAttribute(BEAN_NAME, (Object)psiManager);
        PsiManager.print("getPsiManager: PsiManager set correctly");
        return psiManager;
    }

    public static PsiManager getPsiManager(HttpSession session) throws PsiException {
        PsiManager.print("Trying to get PsiManager from session ... THIS SHOULD NOT BE THE CASE FOR EXTERNAL APPLICATIONS");
        PsiManager instance = null;
        instance = (PsiManager)session.getAttribute(BEAN_NAME);
        if (instance == null) {
            throw new PsiException("no valid portal session");
        }
        return instance;
    }

    public void setPsiManager(HttpServletRequest servletRequest) throws PsiException {
        this.setPsiManager(servletRequest, true);
    }

    public void setPsiManager(HttpServletRequest servletRequest, boolean setInSession) throws PsiException {
        PsiManager.print("setPsiManager:  setting a new PsiManager .... ");
        this.serverName = servletRequest.getServerName();
        this.serverPort = servletRequest.getServerPort();
        PsiManager.print("setPsiManager:  serverName = " + this.serverName + " , serverPort=" + this.serverPort);
        try {
            String appName = servletRequest.getParameter("APP");
            if (appName != null) {
                this.setAppName(appName);
            }
            PsiManager.print("setPsiManager:  appName = " + appName);
            String sessionId = servletRequest.getParameter("PSESSID");
            if (sessionId != null) {
                this.setPortalSessionId(sessionId);
            }
            PsiManager.print("setPsiManager:  sessionId = " + sessionId);
            String param = servletRequest.getParameter("PURL");
            if (param != null) {
                this.setPsiInfoUrl(param);
            }
            PsiManager.print("setPsiManager:  param = " + param);
            String pcJunction = servletRequest.getParameter("PCJUNCT");
            String param2 = servletRequest.getParameter("PCALLURL");
            if (param2 != null) {
                String pcUrl = null;
                pcUrl = pcJunction != null && pcJunction.trim().length() > 0 ? this.replaceUrlDomain(param2, pcJunction) : this.getRelativeUrl(param2, servletRequest);
                this.setPsiCallUrl(pcUrl);
                PsiManager.print("setPsiManager:  pcUrl = " + pcUrl);
            }
            PsiManager.print("setPsiManager:  requesting PsiInfo ....");
            this.requestPsiInfo();
            PsiManager.print("setPsiManager:  PsiInfo received correctly ....");
            PsiManager oldBean = (PsiManager)servletRequest.getSession().getAttribute(BEAN_NAME);
            if (oldBean != null) {
                oldBean.setKeepPsiSession(true);
                this.allRegisteredApps.addAll(oldBean.allRegisteredApps);
            }
            if (setInSession) {
                servletRequest.getSession().setAttribute(BEAN_NAME, (Object)this);
            }
            this.allRegisteredApps.add(this.getAppName());
        }
        catch (PsiException pe) {
            PsiManager.print("setPsiManager:  PsiException occured: ");
            this.print(pe);
            throw pe;
        }
        catch (Exception e) {
            PsiManager.print("setPsiManager:  general Exception occured: ");
            this.print(e);
            throw new PsiException("no valid portal session", e);
        }
    }

    public void setPsiManager(String appName, String sessionId, String pURL, String pcURL, HttpSession session) throws PsiException {
        try {
            if (appName != null) {
                this.setAppName(appName);
            }
            if (sessionId != null) {
                this.setPortalSessionId(sessionId);
            }
            if (pURL != null) {
                this.setPsiInfoUrl(pURL);
            }
            if (pcURL != null) {
                this.setPsiCallUrl(pcURL);
            }
            this.requestPsiInfo();
            if (session != null) {
                PsiManager oldBean = (PsiManager)session.getAttribute(BEAN_NAME);
                if (oldBean != null) {
                    oldBean.setKeepPsiSession(true);
                    this.allRegisteredApps.addAll(oldBean.allRegisteredApps);
                }
                session.setAttribute(BEAN_NAME, (Object)this);
                this.allRegisteredApps.add(this.getAppName());
            }
        }
        catch (PsiException pe) {
            throw pe;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new PsiException("no valid portal session");
        }
    }

    private String getRelativeUrl(String url, HttpServletRequest servletRequest) {
        String requestUrl = servletRequest.getRequestURL().toString();
        return this.getRelativeUrl(url, requestUrl);
    }

    private String getRelativeUrl(String url, String requestUrl) {
        int domainPos = requestUrl.indexOf("//");
        int pathPos = requestUrl.indexOf("/", domainPos + 2);
        String prefix = requestUrl.substring(0, pathPos + 1);
        if (url.startsWith(prefix)) {
            url = url.substring(pathPos);
        }
        return url;
    }

    private String replaceUrlDomain(String url, String prefixNew) {
        int domainPos = url.indexOf("//");
        int pathPos = url.indexOf("/", domainPos + 2);
        url = prefixNew.trim() + url.substring(pathPos);
        return url;
    }

    private static void print(String str) {
        if (debug == null) {
            debug = new Boolean("true".equalsIgnoreCase(System.getProperty("softlab.psi.debug")));
        }
        if (debug.booleanValue()) {
            System.out.println("softlab.psi.debug " + str);
        }
    }

    private void print(Throwable exception) {
        if (debug == null) {
            debug = new Boolean("true".equalsIgnoreCase(System.getProperty("softlab.psi.debug")));
        }
        if (debug.booleanValue()) {
            System.out.print("softlab.psi.debug ");
            exception.printStackTrace();
        }
    }

    public void valueBound(HttpSessionBindingEvent e) {
    }

    void setKeepPsiSession(boolean val) {
        this.keepPsiSession = val;
    }

    public void valueUnbound(HttpSessionBindingEvent e) {
        if (this.keepPsiSession) {
            return;
        }
        try {
            Iterator iter = this.allRegisteredApps.iterator();
            while (iter.hasNext()) {
                String appName = (String)iter.next();
                LogoutThread logout = new LogoutThread();
                logout.urlString = this.getPsiInfoUrl() + "?FUNCTION=PLOGOUT&APP=" + appName + "&PSESSID=" + this.getPortalSessionId();
                WatchDog watchdog = new WatchDog(logout, 10000L);
                logout.start();
                watchdog.start();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public String toXml() {
        return this.xmlStream;
    }

    public void recordUrl(String url, long timestamp) throws IOException {
        this.recordUrl(url, timestamp, 1000);
    }

    public void recordUrl(String url, long timestamp, int buffer) throws IOException {
        if (buffer <= 0) {
            buffer = 1000;
        }
        AmetMessage aMessage = new AmetMessage();
        aMessage.setUrl(url);
        aMessage.setAccount(this.getUser().getUserId());
        aMessage.setTimestamp(timestamp);
        aMessage.setSubsidaryId(this.getUser().getSubsidaryId());
        this.urls.add(aMessage);
        if (this.urls.size() >= buffer) {
            String service = this.getAppserverRoot() + "/remoteRec";
            this.send(service, "REMOTE_RECORD_SET", this.urls.toXML());
            this.urls.clear();
        }
    }

    public void register(String xml) throws IOException {
        String service = this.getAppserverRoot() + "/reg";
        this.send(service, "REGISTRATION_OBJECT", xml);
    }

    private void send(String serviceUrl, String serviceName, String xml) throws IOException {
        System.out.println("call http service " + serviceUrl);
        URL url = new URL(serviceUrl);
        HttpURLConnection con = (HttpURLConnection)url.openConnection();
        con.setRequestMethod("POST");
        con.setDoOutput(true);
        con.setDoInput(true);
        con.setUseCaches(false);
        OutputStream out = con.getOutputStream();
        BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(out));
        writer.write(xml);
        ((Writer)writer).flush();
        ((Writer)writer).close();
        con.getResponseCode();
        con.getResponseMessage();
    }

    public String getUrlRoot() {
        String url = this.getPsiCallUrl();
        if (url.startsWith("/tetis")) {
            return "http://" + this.serverName + ":" + this.serverPort;
        }
        int posSlash = url.indexOf("/", 8);
        return url.substring(0, posSlash);
    }

    private String getAppserverRoot() {
        String url = this.getPsiInfoUrl();
        int pos = url.length() - 4;
        return url.substring(0, pos);
    }

    public Collection getAllMarken() {
        return null;
    }

    static /* synthetic */ String access$102(PsiManager x0, String x1) {
        x0.xmlStream = x1;
        return x0.xmlStream;
    }

    static /* synthetic */ String access$100(PsiManager x0) {
        return x0.xmlStream;
    }

    private class WatchDog
    extends Thread {
        public long timeout;
        public Thread toWatch;
        public boolean psiInterrupted = false;

        public WatchDog(Thread toWatch, long timeout) {
            this.timeout = timeout;
            this.toWatch = toWatch;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                WatchDog.sleep(this.timeout);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (this.toWatch != null && this.toWatch.isAlive()) {
                Thread thread = this.toWatch;
                synchronized (thread) {
                    System.out.println("interrupting " + this.toWatch);
                    this.psiInterrupted = true;
                    this.toWatch.interrupt();
                    this.toWatch.notifyAll();
                }
            }
        }
    }

    private class LogoutThread
    extends Thread {
        public String urlString;

        private LogoutThread() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void run() {
            InputStream inputStream = null;
            URL url = new URL(this.urlString);
            System.out.println(url.toString());
            url.openConnection();
            inputStream = url.openStream();
            BufferedReader br = new BufferedReader(new InputStreamReader(inputStream));
            String line = br.readLine();
            while (line != null) {
                System.out.println(line);
                line = br.readLine();
            }
            Object var6_6 = null;
            if (inputStream == null) return;
            try {
                inputStream.close();
                return;
            }
            catch (Exception e) {}
            return;
            {
                catch (Exception exception) {
                    Object var6_7 = null;
                    if (inputStream == null) return;
                    try {
                        inputStream.close();
                        return;
                    }
                    catch (Exception e) {}
                    return;
                }
            }
            catch (Throwable throwable) {
                Object var6_8 = null;
                if (inputStream == null) throw throwable;
                try {
                    inputStream.close();
                    throw throwable;
                }
                catch (Exception e) {
                    // empty catch block
                }
                throw throwable;
            }
        }
    }

    private class UrlThread
    extends Thread {
        public URL url;
        public InputStream inputStream;
        public Exception exception;
        public boolean success = false;

        private UrlThread() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         */
        public void run() {
            block16: {
                urlInputStream = null;
                try {
                    this.success = false;
                    this.exception = null;
                    this.inputStream = null;
                    System.out.println("request " + this.url.toString());
                    this.url.openConnection();
                    urlInputStream = this.url.openStream();
                    bites = new ByteArrayOutputStream();
                    nextByte = urlInputStream.read();
                    while (nextByte != -1) {
                        bites.write(nextByte);
                        nextByte = urlInputStream.read();
                    }
                    this.inputStream = new ByteArrayInputStream(bites.toByteArray());
                    PsiManager.access$102(PsiManager.this, bites.toString("UTF-8"));
                    if (PsiManager.access$100(PsiManager.this).indexOf("ISO-8859-1") >= 0) {
                        PsiManager.access$102(PsiManager.this, bites.toString("ISO-8859-1"));
                    }
                    System.out.println("success " + this.url.toString());
                    this.success = true;
                    var5_5 = null;
                    ** if (urlInputStream == null) goto lbl-1000
                }
                catch (Throwable var4_11) {
                    var5_7 = null;
                    if (urlInputStream != null) {
                        try {
                            urlInputStream.close();
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                    }
                    throw var4_11;
                }
lbl-1000:
                // 1 sources

                {
                    try {
                        urlInputStream.close();
                    }
                    catch (Exception e) {}
                }
lbl-1000:
                // 2 sources

                {
                    break block16;
                    catch (Exception e) {
                        e.printStackTrace();
                        this.exception = e;
                        var5_6 = null;
                        if (urlInputStream != null) {
                            try {
                                urlInputStream.close();
                            }
                            catch (Exception e) {}
                        }
                    }
                }
            }
            var2_2 = this;
            synchronized (var2_2) {
                this.notifyAll();
            }
        }
    }
}

