/*
 * Decompiled with CFR 0.152.
 */
package webetk.install.standalone;

import cz.autel.dmi.HIGConstraints;
import cz.autel.dmi.HIGLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.ServerSocket;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Vector;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarOutputStream;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.plaf.metal.MetalLookAndFeel;
import org.apache.log4j.BasicConfigurator;
import org.apache.log4j.Layout;
import org.apache.log4j.Logger;
import org.apache.log4j.PatternLayout;
import org.apache.log4j.Priority;
import org.apache.log4j.RollingFileAppender;
import webetk.install.lookandfeel.WebETKTheme;
import webetk.install.resources.Resource;
import webetk.install.standalone.AskProperties;
import webetk.install.standalone.DummyFrame;
import webetk.install.utils.ImageCache;
import webetk.install.utils.LimitedNumberField;
import webetk.install.utils.LineBreakPanel;

public class AskPort
extends JDialog {
    private static Logger log = null;
    private boolean nurTomcatPort = false;
    private Container mContentPane;
    private JButton mButtonUebernehmen;
    private LineBreakPanel mInformation;
    private JLabel mtxtTomcat;
    private JLabel mtxtShutdownPort;
    private JTextField mtfShutdownPort;
    private JLabel mtxtPort;
    private JTextField mtfPort;
    private JLabel mtxtTb;
    private JLabel mtxtShutdownPortTb;
    private JTextField mtfShutdownPortTb;
    private JLabel mtxtPortTb;
    private JTextField mtfPortTb;
    private String mszTargetDir = "";

    public AskPort(String targetDir, boolean nurTomcatPort) {
        super(DummyFrame.getInstance());
        this.nurTomcatPort = nurTomcatPort;
        this.mszTargetDir = targetDir;
        this.setModal(true);
        this.setSize(500, 380);
        this.setLocation(50, 10);
        this.initComponents();
    }

    public static void main(String[] args) throws Exception {
        StringBuffer sBuf = new StringBuffer();
        for (int i = 0; i < args.length; ++i) {
            sBuf.append(args[i]);
            sBuf.append("\n");
        }
        PatternLayout pl = new PatternLayout("%d: %m:  %l " + System.getProperty("line.separator"));
        File tempDir = new File(System.getProperty("user.dir") + File.separator + "tempAskPort");
        boolean bmkDir = tempDir.exists();
        if (!bmkDir) {
            bmkDir = tempDir.mkdir();
        }
        if (bmkDir) {
            RollingFileAppender fileAppender = new RollingFileAppender((Layout)pl, System.getProperty("user.dir") + File.separator + "tempAskPort" + File.separator + "AskPort.log");
            fileAppender.setMaxBackupIndex(1);
            fileAppender.setMaximumFileSize(1000000L);
            fileAppender.setThreshold(Priority.INFO);
            log = Logger.getLogger(AskProperties.class);
            log.addAppender(fileAppender);
        }
        if (log != null) {
            log.info("*** webetk.install.standalone.AskPort started with following arguments: " + sBuf);
        }
        if (args.length < 2) {
            System.out.println("Usage: AskPort LangISO TargetDir");
            System.exit(0);
        }
        MetalLookAndFeel.setCurrentTheme(new WebETKTheme());
        BasicConfigurator.configure();
        Resource.setLanguage(args[0]);
        WebETKTheme.changeFont(args[0].substring(0, 2));
        AskPort dlg = null;
        dlg = args.length < 3 ? new AskPort(args[1], false) : new AskPort(args[1], "nurTomcatPort".equals(args[2]));
        dlg.setVisible(true);
        System.exit(0);
    }

    private void initComponents() {
        ServerSocket shutdownSocketTb;
        ServerSocket applicationSocketTb;
        ServerSocket shutdownSocket;
        ServerSocket applicationSocket;
        ServerSocket asapSocket2;
        ServerSocket asapSocket;
        block15: {
            this.setTitle(Resource.getInstance().getAuswahlDesPorts());
            this.mButtonUebernehmen = new JButton(Resource.getInstance().getOk(), ImageCache.getInstance().getIcon("ok.gif"));
            this.mInformation = new LineBreakPanel(Resource.getInstance().getExplainPort());
            Dimension size = new Dimension(this.getWidth(), 80);
            this.mInformation.setMinimumSize(size);
            this.mtxtTomcat = new JLabel(Resource.getInstance().getTomcat());
            this.mtxtPort = new JLabel(Resource.getInstance().getApplicationPort() + ":");
            this.mtxtShutdownPort = new JLabel(Resource.getInstance().getShutdownPort() + ":");
            this.mtxtTb = new JLabel(Resource.getInstance().getTransbase());
            this.mtxtPortTb = new JLabel(Resource.getInstance().getApplicationPort() + ":");
            this.mtxtShutdownPortTb = new JLabel(Resource.getInstance().getShutdownPort() + ":");
            asapSocket = null;
            asapSocket2 = null;
            applicationSocket = null;
            shutdownSocket = null;
            applicationSocketTb = null;
            shutdownSocketTb = null;
            try {
                asapSocket = new ServerSocket(3097);
                asapSocket2 = new ServerSocket(3098);
            }
            catch (IOException ex) {
                // empty catch block
            }
            try {
                applicationSocket = new ServerSocket(0);
                shutdownSocket = new ServerSocket(0);
                this.mtfPort = applicationSocket.getLocalPort() > 9999 ? new LimitedNumberField(5) : new LimitedNumberField(4);
                this.mtfPort.setText("" + applicationSocket.getLocalPort());
                this.mtfShutdownPort = shutdownSocket.getLocalPort() > 9999 ? new LimitedNumberField(5) : new LimitedNumberField(4);
                this.mtfShutdownPort.setText("" + shutdownSocket.getLocalPort());
                if (this.nurTomcatPort) {
                    this.mtxtTb.setText("");
                    this.mtxtTb.setVisible(false);
                    this.mtxtTb.setEnabled(false);
                    this.mtxtPortTb.setText("");
                    this.mtxtPortTb.setVisible(false);
                    this.mtxtPortTb.setEnabled(false);
                    this.mtfPortTb = new LimitedNumberField(0);
                    this.mtfPortTb.setVisible(false);
                    this.mtfPortTb.setEditable(false);
                    this.mtxtShutdownPortTb.setText("");
                    this.mtxtShutdownPortTb.setVisible(false);
                    this.mtxtShutdownPortTb.setEnabled(false);
                    this.mtfShutdownPortTb = new LimitedNumberField(0);
                    this.mtfShutdownPortTb.setVisible(false);
                    this.mtfShutdownPortTb.setEnabled(false);
                    break block15;
                }
                try {
                    applicationSocketTb = new ServerSocket(2024);
                    shutdownSocketTb = new ServerSocket(2025);
                }
                catch (IOException e) {
                    applicationSocketTb = new ServerSocket(0);
                    shutdownSocketTb = new ServerSocket(0);
                }
                this.mtfPortTb = applicationSocketTb.getLocalPort() > 9999 ? new LimitedNumberField(5) : new LimitedNumberField(4);
                this.mtfPortTb.setText("" + applicationSocketTb.getLocalPort());
                this.mtfShutdownPortTb = shutdownSocketTb.getLocalPort() > 9999 ? new LimitedNumberField(5) : new LimitedNumberField(4);
                this.mtfShutdownPortTb.setText("" + shutdownSocketTb.getLocalPort());
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        try {
            if (applicationSocket != null) {
                applicationSocket.close();
            }
            if (shutdownSocket != null) {
                shutdownSocket.close();
            }
            if (applicationSocketTb != null) {
                applicationSocketTb.close();
            }
            if (shutdownSocketTb != null) {
                shutdownSocketTb.close();
            }
            if (asapSocket != null) {
                asapSocket.close();
            }
            if (asapSocket2 != null) {
                asapSocket2.close();
            }
        }
        catch (IOException e) {
            // empty catch block
        }
        this.layoutAll();
    }

    private void layoutAll() {
        this.mContentPane = this.getContentPane();
        int[] w = new int[]{0};
        int[] h = new int[]{0, 0, 0};
        HIGLayout l = new HIGLayout(w, h);
        l.setColumnWeight(1, 1);
        l.setRowWeight(3, 1);
        HIGConstraints c = new HIGConstraints();
        this.mContentPane.setLayout(l);
        JPanel content = this.createContent();
        this.mContentPane.add((Component)content, c.rc(3, 1, "tlbr"));
    }

    private JPanel createContent() {
        JPanel panel = new JPanel();
        HIGConstraints c = new HIGConstraints();
        int[] widths = new int[]{10, 0, 10};
        int[] heights = new int[]{10, 0, 10, 0, 10};
        HIGLayout layoutPosTeileliste = new HIGLayout(widths, heights);
        layoutPosTeileliste.setColumnWeight(2, 1);
        layoutPosTeileliste.setRowWeight(5, 1);
        panel.setLayout(layoutPosTeileliste);
        panel.add((Component)this.createCenterPanel(), c.rc(2, 2, "lrtb"));
        panel.add((Component)this.createButtonPanel(), c.rc(4, 2, "lrtb"));
        return panel;
    }

    private JPanel createCenterPanel() {
        JPanel panel = new JPanel();
        HIGConstraints c = new HIGConstraints();
        int[] widths = new int[]{10, 0, 10, 0, 10};
        int[] heights = null;
        heights = new int[]{10, 0, 10, 0, 10, 0, 10, 0, 10, 0, 10, 0, 10, 0, 10};
        HIGLayout layout = new HIGLayout(widths, heights);
        layout.setColumnWeight(4, 1);
        panel.setLayout(layout);
        panel.add((Component)this.mInformation, c.rcwh(2, 2, 3, 1, "tlbr"));
        int nRowOffset = 4;
        panel.add((Component)this.mtxtTomcat, c.rc(4, 2, "l"));
        panel.add((Component)this.mtxtPort, c.rc(6, 2, "l"));
        panel.add((Component)this.mtfPort, c.rc(6, 4, "l"));
        panel.add((Component)this.mtxtShutdownPort, c.rc(8, 2, "l"));
        panel.add((Component)this.mtfShutdownPort, c.rc(8, 4, "l"));
        nRowOffset = 10;
        panel.add((Component)this.mtxtTb, c.rc(nRowOffset, 2, "l"));
        panel.add((Component)this.mtxtPortTb, c.rc(nRowOffset + 2, 2, "l"));
        panel.add((Component)this.mtfPortTb, c.rc(nRowOffset + 2, 4, "l"));
        panel.add((Component)this.mtxtShutdownPortTb, c.rc(nRowOffset + 4, 2, "l"));
        panel.add((Component)this.mtfShutdownPortTb, c.rc(nRowOffset + 4, 4, "l"));
        return panel;
    }

    private JPanel createButtonPanel() {
        JPanel panel = new JPanel();
        HIGConstraints c = new HIGConstraints();
        int[] widths = new int[]{-3, 0, -1};
        int[] heights = new int[]{0, 10};
        HIGLayout layoutPosTeileliste = new HIGLayout(widths, heights);
        layoutPosTeileliste.setColumnWeight(1, 1);
        layoutPosTeileliste.setColumnWeight(3, 1);
        layoutPosTeileliste.setRowWeight(2, 1);
        panel.setLayout(layoutPosTeileliste);
        panel.add((Component)this.mButtonUebernehmen, c.rc(1, 2, "lrtb"));
        this.mButtonUebernehmen.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AskPort.this.configTomcat();
                if (!AskPort.this.nurTomcatPort) {
                    AskPort.this.configTransbase();
                }
                AskPort.this.dispose();
            }
        });
        return panel;
    }

    private void configTomcat() {
        this.setCursor(Cursor.getPredefinedCursor(3));
        String sTomcatDir = this.mszTargetDir + "\\javaclient\\tomcat";
        String sConfigFile = sTomcatDir + "\\conf\\server.xml";
        String sTemplateFile = sTomcatDir + "\\conf\\dummy.xml";
        System.out.println("writing server.xml");
        try {
            BufferedReader in = new BufferedReader(new InputStreamReader(new FileInputStream(sTemplateFile)));
            BufferedWriter out = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(sConfigFile)));
            String szLine = "";
            while ((szLine = in.readLine()) != null) {
                szLine = AskPort.substituteStringStraight(szLine, "&shutdownport&", this.mtfShutdownPort.getText());
                szLine = AskPort.substituteStringStraight(szLine, "&connectorport&", this.mtfPort.getText());
                System.out.println(szLine);
                out.write(szLine + "\n");
            }
            in.close();
            out.close();
        }
        catch (IOException e) {
            e.printStackTrace();
            if (log != null) {
                log.error("FAILED! (server.xml)", e);
            }
            return;
        }
        Vector<String> aszZeilen = new Vector<String>();
        System.out.println("updating javaclient.properties");
        String sJavaClientPorpertiesFile = this.mszTargetDir + "\\javaclient\\classes\\javaclient.properties";
        try {
            BufferedReader in = new BufferedReader(new InputStreamReader(new FileInputStream(sJavaClientPorpertiesFile)));
            String szLine = "";
            while ((szLine = in.readLine()) != null) {
                if (szLine.startsWith("tomcat.port")) {
                    szLine = "tomcat.port = " + this.mtfPort.getText();
                } else if (szLine.startsWith("server.URL")) {
                    szLine = "server.URL = http://localhost:" + this.mtfPort.getText() + "/javaserver/rest";
                }
                aszZeilen.add(szLine);
            }
            in.close();
        }
        catch (IOException e) {
            e.printStackTrace();
            if (log != null) {
                log.error("FAILED! (javaclient.properties)", e);
            }
            return;
        }
        try {
            BufferedWriter out = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(sJavaClientPorpertiesFile)));
            Iterator iter = aszZeilen.iterator();
            while (iter.hasNext()) {
                out.write((String)iter.next() + System.getProperty("line.separator"));
            }
            out.close();
        }
        catch (IOException e) {
            e.printStackTrace();
            if (log != null) {
                log.error("FAILED! (javaclient.properties)", e);
            }
            return;
        }
        this.setCursor(Cursor.getPredefinedCursor(0));
    }

    private void configTransbase() {
        this.setCursor(Cursor.getPredefinedCursor(3));
        String sTransbaseDir = this.mszTargetDir + File.separator + "transbase";
        String sTbenvFile = sTransbaseDir + File.separator + "tbwin.ini";
        String sAdmintoolPropFile = this.mszTargetDir + File.separator + "admintool" + File.separator + "admintool.properties";
        String sMigrationPropFile = this.mszTargetDir + File.separator + "migration" + File.separator + "migration.properties";
        String sServerPropFile = this.mszTargetDir + File.separator + "javaclient" + File.separator + "tomcat" + File.separator + "webapps" + File.separator + "WEB-INF" + File.separator + "bmwetk.properties";
        Vector<String> aszZeilen = new Vector<String>();
        try {
            BufferedReader in = new BufferedReader(new InputStreamReader(new FileInputStream(sTbenvFile)));
            String szLine = "";
            while ((szLine = in.readLine()) != null) {
                if (szLine.startsWith("TRANSBASE_SERVICENAMES=")) {
                    szLine = "TRANSBASE_SERVICENAMES=" + this.mtfPortTb.getText() + ":" + this.mtfShutdownPortTb.getText();
                }
                aszZeilen.add(szLine);
            }
            in.close();
        }
        catch (IOException e) {
            e.printStackTrace();
            return;
        }
        try {
            BufferedWriter out = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(sTbenvFile)));
            Iterator iter = aszZeilen.iterator();
            while (iter.hasNext()) {
                out.write((String)iter.next() + System.getProperty("line.separator"));
            }
            out.close();
        }
        catch (IOException e) {
            e.printStackTrace();
            return;
        }
        this.replacePortInConnectString(sAdmintoolPropFile);
        this.replacePortInConnectString(sMigrationPropFile);
        this.replacePortInConnectString(sServerPropFile);
        this.updateJarFile();
        this.setCursor(Cursor.getPredefinedCursor(0));
    }

    private void replacePortInConnectString(String sFile) {
        Vector<String> aszZeilen = new Vector<String>();
        try {
            BufferedReader in = new BufferedReader(new InputStreamReader(new FileInputStream(sFile)));
            String szLine = "";
            while ((szLine = in.readLine()) != null) {
                szLine = AskPort.substituteStringStraight(szLine, "jdbc:transbase://localhost:2024", "jdbc:transbase://localhost:" + this.mtfPortTb.getText());
                aszZeilen.add(szLine);
            }
            in.close();
        }
        catch (IOException e) {
            e.printStackTrace();
            return;
        }
        try {
            BufferedWriter out = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(sFile)));
            Iterator iter = aszZeilen.iterator();
            while (iter.hasNext()) {
                out.write((String)iter.next() + System.getProperty("line.separator"));
            }
            out.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static String substituteStringStraight(String sSource, String sParam, String sSubst) {
        if (sSource == null || sParam == null) {
            return sSource;
        }
        if (sSubst == null) {
            sSubst = "";
        }
        int nIndex = sSource.indexOf(sParam);
        while (nIndex != -1) {
            String sNewString;
            sSource = sNewString = sSource.substring(0, nIndex) + sSubst + sSource.substring(nIndex + sParam.length(), sSource.length());
            nIndex = sSource.indexOf(sParam, nIndex + sSubst.length());
        }
        return sSource;
    }

    private void updateJarFile() {
        block8: {
            String szServerJarFile = this.mszTargetDir + File.separator + "javaclient" + File.separator + "tomcat" + File.separator + "webapps" + File.separator + "javaserver.war";
            String szBmwEtkPropertyFile = this.mszTargetDir + File.separator + "javaclient" + File.separator + "tomcat" + File.separator + "webapps" + File.separator + "WEB-INF" + File.separator + "bmwetk.properties";
            try {
                JarFile jarFile = new JarFile(szServerJarFile);
                JarOutputStream output = new JarOutputStream(new BufferedOutputStream(new FileOutputStream(szServerJarFile + "_out.war")));
                if (log != null) {
                    log.info("--> new from 2.0.39 always new jarentry to avoid zipexception");
                }
                Enumeration<JarEntry> jarEntries = jarFile.entries();
                while (jarEntries.hasMoreElements()) {
                    JarEntry entry = new JarEntry(jarEntries.nextElement().getName());
                    InputStream input = null;
                    boolean change = false;
                    if (entry.getName().equals("WEB-INF/bmwetk.properties")) {
                        input = new FileInputStream(szBmwEtkPropertyFile);
                        change = true;
                    } else {
                        input = jarFile.getInputStream(entry);
                    }
                    AskProperties.updateJarEntry(entry, output, new BufferedInputStream(input), change, this, log);
                }
                output.close();
                jarFile.close();
                File jarold = new File(szServerJarFile);
                File jarnew = new File(szServerJarFile + "_out.war");
                boolean bRet = jarold.delete();
                if (!bRet && log != null) {
                    log.error("*** error while deleting old jar file ***" + jarold.getAbsolutePath());
                }
                if (!(bRet = jarnew.renameTo(jarold)) && log != null) {
                    log.error("*** error while renaming new jar file ***" + jarnew.getAbsolutePath() + " -> " + jarold.getAbsolutePath());
                }
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(this, "*** error while updating jar file *** \n" + e.getMessage() + "\n" + e.getStackTrace(), "AskPort.updateJarFile()", 1);
                if (log == null) break block8;
                log.error("*** error while updating jar file ***", e);
            }
        }
    }
}

