/*
 * Decompiled with CFR 0.152.
 */
package org.nfunk.jep.function;

import java.util.Stack;
import org.nfunk.jep.Node;
import org.nfunk.jep.ParseException;
import org.nfunk.jep.ParserVisitor;
import org.nfunk.jep.function.PostfixMathCommand;
import org.nfunk.jep.function.SpecialEvaluationI;
import org.nfunk.jep.type.Complex;

public class If
extends PostfixMathCommand
implements SpecialEvaluationI {
    public If() {
        this.numberOfParameters = -1;
    }

    public Object evaluate(Node node, Object object, ParserVisitor parserVisitor, Stack stack) throws ParseException {
        double d;
        int n = node.jjtGetNumChildren();
        if (n < 3 || n > 4) {
            throw new ParseException("If operator must have 3 or 4 arguments.");
        }
        node.jjtGetChild(0).jjtAccept(parserVisitor, object);
        this.checkStack(stack);
        Object e = stack.pop();
        if (e instanceof Double) {
            d = (Double)e;
        } else if (e instanceof Complex) {
            d = ((Complex)e).re();
        } else {
            throw new ParseException("Condition in if operator must be double or complex");
        }
        if (d > 0.0) {
            node.jjtGetChild(1).jjtAccept(parserVisitor, object);
        } else if (n == 3 || d < 0.0) {
            node.jjtGetChild(2).jjtAccept(parserVisitor, object);
        } else {
            node.jjtGetChild(3).jjtAccept(parserVisitor, object);
        }
        return object;
    }
}

