/*
 * Decompiled with CFR 0.152.
 */
package com.bmw.etk.client.adapter.rest;

import com.bmw.etk.client.ProxySettings;
import com.sun.jersey.client.urlconnection.HttpURLConnectionFactory;
import java.io.IOException;
import java.net.Authenticator;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.PasswordAuthentication;
import java.net.Proxy;
import java.net.URL;

public class ConnectionFactory
implements HttpURLConnectionFactory {
    ProxySettings mProxySetting;
    Proxy mProxy;

    public ConnectionFactory(ProxySettings pProxySettings) {
        this.mProxySetting = pProxySettings;
        this.initializeProxy();
    }

    private void initializeProxy() {
        this.mProxy = new Proxy(Proxy.Type.HTTP, new InetSocketAddress(this.mProxySetting.getProxyName(), this.mProxySetting.getProxyPort()));
        if (this.mProxySetting.isUseAuthentication()) {
            final String user = this.mProxySetting.isUseNTLMAuthentication() ? this.mProxySetting.getProxyNtDomain() + "\\\\" + this.mProxySetting.getProxyUser() : this.mProxySetting.getProxyUser();
            Authenticator authenticator = new Authenticator(){

                @Override
                public PasswordAuthentication getPasswordAuthentication() {
                    return new PasswordAuthentication(user, ConnectionFactory.this.mProxySetting.getProxyPasswort().toCharArray());
                }
            };
            Authenticator.setDefault(authenticator);
        }
    }

    public HttpURLConnection getHttpURLConnection(URL url) throws IOException {
        String keepAliveValue;
        HttpURLConnection connection = (HttpURLConnection)url.openConnection(this.mProxy);
        String proxyConnection = "Proxy-Connection";
        String keepAlive = "Keep-Alive";
        if (this.mProxySetting.isUseAuthentication() && ((keepAliveValue = connection.getRequestProperty(proxyConnection)) == null || !keepAliveValue.equals(keepAlive))) {
            connection.setRequestProperty(proxyConnection, keepAlive);
        }
        return connection;
    }
}

