/*
 * Decompiled with CFR 0.152.
 */
package de.esg.commonclient;

import com.bmw.etk.client.ProxySettings;
import de.esg.commonclient.EtkData;
import de.esg.commonclient.GkiZugriff;
import de.esg.commonclient.GkiZugriffException;
import de.esg.commonclient.IEtkData;
import de.esg.commonclient.IIpacData;
import de.esg.commonclient.PropertyUtils;
import de.esg.tools.win32.registry.WindowsRegistry;
import java.awt.Cursor;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Locale;
import java.util.Properties;
import java.util.TreeSet;
import javax.swing.JOptionPane;
import org.apache.log4j.Logger;
import webetk.app.Bedingung;
import webetk.app.Bedingungsmenge;
import webetk.app.etktext.ETKTextZeile;
import webetk.app.etktext.ETKTexte;
import webetk.app.konfiguration.Konfiguration;
import webetk.communication.CommunicationException;
import webetk.communication.JavaFzgIdInfo;
import webetk.communication.JavaFzgSucheInfo;
import webetk.communication.LoginInfo;
import webetk.communication.transferables.AsapAuthenticationDecorator;
import webetk.communication.transferables.Command;
import webetk.communication.transferables.ServiceExecutor;
import webetk.communication.transferables.TrfHashMap;
import webetk.communication.transferables.TrfString;
import webetk.javaclient.dialog.login.AsapLoginControllerAdapter;
import webetk.javaclient.framework.MainView;
import webetk.javaclient.utils.CommunicationUtils;
import webetk.resources.Resource;

public class GlobalObjects {
    private static GlobalObjects mInstance;
    protected IIpacData mIpacData;
    protected IEtkData mEtkData;
    protected Properties appProperties = new Properties();
    protected Properties commonProperties = new Properties();
    private static Logger log;
    protected LoginInfo sessionInfo = new LoginInfo();
    protected JavaFzgIdInfo fzgIdInfo = null;
    protected String serverUrl = null;
    protected static String msPropertyFile;
    protected static String msDEBUGPropertyFileKommtVon;
    protected static String msDEBUGPropertyFileUpdateIn;
    private static boolean mIsIpac;
    private static boolean mScore;
    private ETKTexte mETKTexte;
    private String msHG = "";
    private Konfiguration config = null;
    private ServiceExecutor mServiceExecutor;

    protected GlobalObjects() {
    }

    protected void init() {
        this.mEtkData = new EtkData();
        if (!mScore) {
            try {
                this.mIpacData = GlobalObjects.createIpacDataInstance();
            }
            catch (ClassNotFoundException e) {
                Logger.getLogger(GlobalObjects.class).error((Object)"Klasse de.esg.zub.common.IpacData wurde nicht gefunden. ", (Throwable)e);
            }
            catch (InstantiationException e) {
                Logger.getLogger(GlobalObjects.class).error((Object)"Klasse de.esg.zub.common.IpacData konnte nicht instanziiert werden. ", (Throwable)e);
            }
            catch (IllegalAccessException e) {
                Logger.getLogger(GlobalObjects.class).error((Object)"Ung\u00fcltiges Argument. ", (Throwable)e);
            }
        }
        this.loadPropertyFile();
        this.initServiceExecutor();
        GlobalObjects.showDebugMessage("init(): nach initServiceExecutor()");
    }

    private void initServiceExecutor() {
        String serverUrl = this.getServerUrl();
        log.info((Object)("connection Rest API Client to server: " + serverUrl));
        this.mServiceExecutor = new ServiceExecutor();
        ProxySettings proxySettings = new ProxySettings(){

            @Override
            public String getProxyName() {
                return null;
            }

            @Override
            public void setProxyName(String proxyName) {
            }

            @Override
            public int getProxyPort() {
                return 0;
            }

            @Override
            public void setProxyPort(int proxyPort) {
            }

            @Override
            public String getProxyUser() {
                return null;
            }

            @Override
            public void setProxyUser(String proxyUser) {
            }

            @Override
            public String getProxyPasswort() {
                return null;
            }

            @Override
            public void setProxyPasswort(String proxyPasswort) {
            }

            @Override
            public String getProxyRealm() {
                return null;
            }

            @Override
            public void setProxyRealm(String proxyRealm) {
            }

            @Override
            public String getProxyNtHost() {
                return null;
            }

            @Override
            public void setProxyNtHost(String proxyNtHost) {
            }

            @Override
            public String getProxyNtDomain() {
                return null;
            }

            @Override
            public void setProxyNtDomain(String proxyNtDomain) {
            }

            @Override
            public boolean isUseProxy() {
                return false;
            }

            @Override
            public void setUseProxy(boolean useProxy) {
            }

            @Override
            public boolean isUseAuthentication() {
                return false;
            }

            @Override
            public void setUseAuthentication(boolean useAuthentication) {
            }

            @Override
            public boolean isUseNTLMAuthentication() {
                return false;
            }

            @Override
            public void setUseNTLMAuthentication(boolean useNTLMAuthentication) {
            }
        };
        this.mServiceExecutor.init(serverUrl, true, false, proxySettings);
        this.mServiceExecutor.addTransferableDecorator(new AsapAuthenticationDecorator(new AsapLoginControllerAdapter()));
        GlobalObjects.showDebugMessage("initServiceExecutor(): nach init(serverUrl)");
    }

    protected void loadPropertyFile() {
        msDEBUGPropertyFileKommtVon = "";
        try {
            if (msPropertyFile != null) {
                Logger.getLogger(GlobalObjects.class).info((Object)("Loading property file from option prop=" + msPropertyFile + " ..."));
                msDEBUGPropertyFileKommtVon = msDEBUGPropertyFileKommtVon + " ***001*** LogInfo aus GlobalObjects: Loading property file from option prop=" + msPropertyFile + " ...<br>";
                FileInputStream in = new FileInputStream(msPropertyFile);
                this.appProperties.load(in);
                Logger.getLogger(GlobalObjects.class).info((Object)"done loading from option value");
            } else {
                InputStream in = null;
                in = this.getClass().getResourceAsStream("/javaclient.properties");
                String path = this.getClass().getResource("/javaclient.properties").getPath();
                if (in == null) {
                    Logger.getLogger(GlobalObjects.class).error((Object)"Could not find property file: javaclient.properties");
                    msDEBUGPropertyFileKommtVon = msDEBUGPropertyFileKommtVon + " ***002*** LogInfo aus GlobalObjects: Could not find property file: javaclient.properties...<br>";
                } else {
                    msPropertyFile = "javaclient.properties";
                    Logger.getLogger(GlobalObjects.class).info((Object)("Loading property file <" + path + "> ..."));
                    msDEBUGPropertyFileKommtVon = msDEBUGPropertyFileKommtVon + " ***003*** LogInfo aus GlobalObjects: Loading property file <" + path + "> ... aus dem Classpath" + "...<br>";
                    this.appProperties.load(in);
                    Logger.getLogger(GlobalObjects.class).info((Object)"done.");
                }
                if (!this.getIstStandalone()) {
                    msDEBUGPropertyFileKommtVon = msDEBUGPropertyFileKommtVon + " ***004*** LogInfo aus GlobalObjects: keine Standalone installation: " + this.getIstStandalone() + "...<br>";
                    in = null;
                    String sPropertyFileName = this.readPropertyFileNameFromRegistry();
                    if (sPropertyFileName != null) {
                        Logger.getLogger(GlobalObjects.class).info((Object)"Found property file name in Registry: javaclient.properties");
                        msDEBUGPropertyFileKommtVon = msDEBUGPropertyFileKommtVon + " ***005*** LogInfo aus GlobalObjects: Found property file name in Registry: javaclient.properties...<br>";
                        in = new FileInputStream(sPropertyFileName);
                    }
                    if (in == null) {
                        Logger.getLogger(GlobalObjects.class).warn((Object)"Could not find property file in Registry.");
                        msDEBUGPropertyFileKommtVon = msDEBUGPropertyFileKommtVon + " ***006*** LogInfo aus GlobalObjects: Could not find property file in Registry....<br>";
                    } else {
                        msPropertyFile = sPropertyFileName;
                        Logger.getLogger(GlobalObjects.class).info((Object)"Loading property file from Registry");
                        msDEBUGPropertyFileKommtVon = msDEBUGPropertyFileKommtVon + " ***007*** LogInfo aus GlobalObjects: Loading property file from Registry...<br>";
                        this.appProperties.load(in);
                        Logger.getLogger(GlobalObjects.class).info((Object)"done.");
                        in.close();
                    }
                }
            }
        }
        catch (IOException e) {
            Logger.getLogger(GlobalObjects.class).fatal((Object)"FAILED!", (Throwable)e);
            System.exit(-3);
        }
    }

    public Konfiguration loadKonfiguration() {
        log.debug((Object)"Performing load Konfiguration");
        TrfHashMap trfKonfig = new TrfHashMap(null);
        if (this.config == null) {
            try {
                this.getServiceExecutor().executeService(trfKonfig, Command.LOAD_KONFIGURATION);
            }
            catch (CommunicationException ex) {
                log.error((Object)("Service: " + Command.LOAD_KONFIGURATION + " URL: " + GlobalObjects.getInstance().getServerUrl()), (Throwable)ex);
                MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
            }
            CommunicationUtils.checkError(trfKonfig, Resource.getInstance().getKonfiguration());
            this.config = (Konfiguration)trfKonfig.getValue("Haendler_Konfiguration");
        }
        return this.config;
    }

    public static GlobalObjects getInstance() {
        if (mInstance == null) {
            mInstance = new GlobalObjects();
            GlobalObjects.showDebugMessage("getInstance(): nach new GlobalObjects()");
            mInstance.init();
            GlobalObjects.showDebugMessage("getInstance(): nach mInstance.init()");
        }
        return mInstance;
    }

    public static void resetInstance() {
        mInstance = null;
    }

    public IEtkData getEtkData() {
        return this.mEtkData;
    }

    public IIpacData getIpacData() {
        return this.mIpacData;
    }

    public String getServerUrl() {
        if (this.serverUrl == null) {
            return this.appProperties.getProperty("server.URL");
        }
        return this.serverUrl;
    }

    public void setServerUrl(String url) {
        this.serverUrl = url;
    }

    public LoginInfo getSessionInfo() {
        return this.sessionInfo;
    }

    public String getSessionId() {
        return this.sessionInfo.getSession();
    }

    public void updateSessionInfo(LoginInfo sessInfo) {
        if (sessInfo == null) {
            Logger.getLogger(GlobalObjects.class).error((Object)"Attempt to update session informations with null!");
        } else {
            this.sessionInfo = sessInfo;
        }
    }

    public void resetFzgIdInfo() {
        this.fzgIdInfo = null;
    }

    public void setFzgIdInfo(JavaFzgIdInfo oFzgIdInfo) {
        this.fzgIdInfo = oFzgIdInfo;
    }

    public JavaFzgIdInfo getFzgIdInfo() {
        return this.fzgIdInfo;
    }

    public boolean getIstStandalone() {
        Logger.getLogger(GlobalObjects.class).info((Object)("Eintrage f\u00fcr standalone = " + this.appProperties.getProperty("standalone")));
        return this.appProperties.getProperty("standalone") != null && this.appProperties.getProperty("standalone").equals("1");
    }

    public String getTomcatPort() {
        return this.appProperties.getProperty("tomcat.port");
    }

    public boolean isKeyReaderAktiv() {
        if (GlobalObjects.isMSWindows()) {
            if (GkiZugriff.getInstance().isKeyreaderAktiv()) {
                return true;
            }
            String sHelp = WindowsRegistry.getValueAsString("HKEY_LOCAL_MACHINE\\SOFTWARE\\BMWgroup\\SAM", "Home");
            return sHelp != null && !sHelp.trim().equals("");
        }
        return false;
    }

    public String getKeyReaderFilename() {
        return this.appProperties.getProperty("keyreader.filename");
    }

    public boolean existiertKeyreaderFile() {
        if (GkiZugriff.getInstance().isKeyreaderAktiv()) {
            return true;
        }
        String sKeyReaderFilename = this.getKeyReaderFilename();
        if (sKeyReaderFilename == null || sKeyReaderFilename.equals("")) {
            return false;
        }
        try {
            FileReader filereader = new FileReader(sKeyReaderFilename);
            filereader.close();
        }
        catch (Exception ex) {
            return false;
        }
        return true;
    }

    public String retrieveVinFromKeyReader(StringBuffer codeLack, StringBuffer codeAF) throws GkiZugriffException {
        if (GkiZugriff.getInstance().isKeyreaderAktiv()) {
            String vin = GkiZugriff.getInstance().retrieveVin();
            return vin.substring(10);
        }
        String vin = null;
        String sKeyReaderFilename = this.getKeyReaderFilename();
        FileReader filereader = null;
        try {
            filereader = new FileReader(sKeyReaderFilename);
            BufferedReader bufreader = new BufferedReader(filereader);
            int nRow = 1;
            while (true) {
                String sZeile = bufreader.readLine();
                if (nRow == 5) {
                    if (sZeile.length() != 17) {
                        log.error((Object)(sKeyReaderFilename + Resource.getInstance().getKeyreaderFgstnrInkorrekt()));
                        throw new GkiZugriffException(sKeyReaderFilename + Resource.getInstance().getKeyreaderFgstnrInkorrekt());
                    }
                    vin = sZeile.substring(10);
                }
                if (sZeile == null) {
                    break;
                }
                if (nRow == 9 && codeLack != null) {
                    codeLack.append(sZeile.trim());
                }
                if (nRow == 10 && codeAF != null) {
                    codeAF.append(sZeile.trim());
                }
                if (nRow > 10) {
                    break;
                }
                ++nRow;
            }
        }
        catch (IOException ex) {
            log.error((Object)"IOException reading SAM File", (Throwable)ex);
            throw new GkiZugriffException(ex);
        }
        finally {
            try {
                if (filereader != null) {
                    filereader.close();
                }
            }
            catch (IOException ex) {
                log.error((Object)"IOException closing filereader", (Throwable)ex);
            }
        }
        return vin;
    }

    private String readPropertyFileNameFromRegistry() {
        String sHelp = WindowsRegistry.getValueAsString("HKEY_LOCAL_MACHINE\\SOFTWARE\\BMWgroup\\webetk", "Properties");
        return sHelp;
    }

    public boolean isDMSAktiv() {
        boolean bIsAngeschlossen = this.getSessionInfo().getDMSAngeschlossen();
        boolean bVerwenden = this.getSessionInfo().getDMSVerwenden();
        return bIsAngeschlossen && bVerwenden;
    }

    public boolean isVINSpecAktiv() {
        return this.getSessionInfo().getVINSpecAngeschlossen();
    }

    public boolean isIGDOMAktiv() {
        return this.getSessionInfo().getIGDOMAngeschlossen();
    }

    public boolean hasNetz() {
        String sNetz = this.getNetz();
        if (sNetz == null) {
            Logger.getLogger(GlobalObjects.class).debug((Object)"Kein Netz!");
            return false;
        }
        return true;
    }

    public String getNetz() {
        TrfString trf = new TrfString(null);
        try {
            GlobalObjects.getInstance().getServiceExecutor().executeService(trf, Command.LOAD_NETZ);
        }
        catch (CommunicationException ex) {
            MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
            JOptionPane.showMessageDialog(MainView.getInstance(), Resource.getInstance().getSonstigerFehler() + ": " + ex.getMessage(), Resource.getInstance().getSonstigerFehler(), 0);
            Logger.getLogger(GlobalObjects.class).error((Object)ex);
            return null;
        }
        if (trf.getError() != null) {
            MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
            JOptionPane.showMessageDialog(MainView.getInstance(), Resource.getInstance().getSonstigerFehler() + ": " + trf.getError().getMessage(), Resource.getInstance().getSonstigerFehler(), 0);
            Logger.getLogger(GlobalObjects.class).error((Object)trf.getError());
            return null;
        }
        return trf.getString();
    }

    public boolean usesInternet() {
        return "ANDERE".equals(this.getNetz());
    }

    public boolean usesExtranet() {
        return "EXTRANET".equals(this.getNetz());
    }

    public boolean usesSGate() {
        return "SGATE".equals(this.getNetz());
    }

    public boolean usesIntranet() {
        return "INTRANET".equals(this.getNetz());
    }

    public String getFirmaId() {
        return this.appProperties.getProperty("firma");
    }

    public String getLanguage() {
        if (this.sessionInfo != null && this.sessionInfo.getLanguage() != null && this.sessionInfo.getLanguage().length() > 0) {
            return this.sessionInfo.getLanguage();
        }
        String lan = this.appProperties.getProperty("language");
        if (lan == null || lan.length() == 0) {
            lan = Locale.getDefault().getLanguage();
            Logger.getLogger(GlobalObjects.class).debug((Object)("system default language is: " + lan));
            if (!"cs,de,el,en,enUS,es,fr,it,ja,ko,nl,pl,pt,ru,sv,th,tr,zh,zhTW".contains(lan)) {
                lan = "en";
            }
        }
        Logger.getLogger(GlobalObjects.class).debug((Object)("language: " + lan));
        return lan;
    }

    public String getSetupPath() {
        return this.appProperties.getProperty("setup.path");
    }

    public int getTimeoutSocket() {
        String sTimeout = this.appProperties.getProperty("timeout.socket", "600");
        if (sTimeout == null || sTimeout.length() < 1) {
            return 0;
        }
        return Integer.parseInt(sTimeout);
    }

    public int getTimeoutConnection() {
        String sTimeout = this.appProperties.getProperty("timeout.connection", "15");
        if (sTimeout == null || sTimeout.length() < 1) {
            return 0;
        }
        return Integer.parseInt(sTimeout);
    }

    public String getPropertyFile() {
        return msPropertyFile;
    }

    public Properties getAppProperties() {
        return this.appProperties;
    }

    public Properties getCommonProperties() {
        return this.commonProperties;
    }

    public static boolean isIpac() {
        return mIsIpac;
    }

    public static void setIpac(boolean isIpac) {
        mIsIpac = isIpac;
    }

    public static void setPropFileName(String setPropFileName) {
        msPropertyFile = setPropFileName;
    }

    public static String getPropFileName() {
        return msPropertyFile;
    }

    private static IIpacData createIpacDataInstance() throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        Class<?> cIpacData = GlobalObjects.getInstance().getClass().getClassLoader().loadClass("de.esg.zub.common.IpacData");
        Object newObject = cIpacData.newInstance();
        return (IIpacData)newObject;
    }

    public static void setScore(boolean score) {
        mScore = score;
    }

    public static boolean isScore() {
        return mScore;
    }

    public String getIsoCountryCode() {
        return this.appProperties.getProperty("wsm.isocountrycode", "");
    }

    public ETKTexte getETKTexte() {
        if (this.mETKTexte != null && this.mETKTexte.istGeladen()) {
            return this.mETKTexte;
        }
        MainView.getInstance().setCursor(Cursor.getPredefinedCursor(3));
        TrfHashMap trfHashMap = new TrfHashMap(null);
        try {
            GlobalObjects.getInstance().getServiceExecutor().executeService(trfHashMap, Command.LOAD_ETKTEXTE);
        }
        catch (CommunicationException e) {
            Logger.getLogger(GlobalObjects.class).error((Object)("getETKTexte: " + GlobalObjects.getInstance().getServerUrl()), (Throwable)e);
            MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
            JOptionPane.showMessageDialog(MainView.getInstance(), e.getMessage(), Resource.getInstance().getBildtafel(), 0);
            return null;
        }
        if (trfHashMap.getError() != null) {
            Logger.getLogger(GlobalObjects.class).error((Object)("getETKTexte: " + trfHashMap.getError().getMessage()));
            MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
            JOptionPane.showMessageDialog(MainView.getInstance(), trfHashMap.getError().getMessage(), Resource.getInstance().getBildtafel(), 0);
            return null;
        }
        this.mETKTexte = (ETKTexte)trfHashMap.getValue("etktexte");
        MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
        return this.mETKTexte;
    }

    public boolean hatETKTextZeilen(String sHG, String sFG, String sProduktart, boolean bIgnoreAngezeigt) {
        this.getETKTexte();
        ArrayList<Bedingung> oJaBed = this.getFzgBedingungen();
        return this.mETKTexte.hatETKTexte(sProduktart, sHG, sFG, oJaBed, bIgnoreAngezeigt);
    }

    public Collection<ETKTextZeile> evalETKTextZeilen(String sHG, String sFG, String sProduktart, boolean bIgnoreAngezeigt, boolean bSetAngezeigt) {
        this.getETKTexte();
        ArrayList<Bedingung> oJaBed = this.getFzgBedingungen();
        Collection cZeilen = this.mETKTexte.evalETKTexte(sProduktart, sHG, sFG, oJaBed, bIgnoreAngezeigt, bSetAngezeigt);
        return cZeilen;
    }

    private ArrayList<Bedingung> getFzgBedingungen() {
        ArrayList<Bedingung> oJaBed = new ArrayList<Bedingung>();
        JavaFzgSucheInfo fzgSucheInfo = GlobalObjects.getInstance().getEtkData().getFzgSucheInfo();
        if (fzgSucheInfo == null) {
            return oJaBed;
        }
        Bedingungsmenge bedmenge = fzgSucheInfo.getBedingungsMenge();
        TreeSet<Bedingung> sortedKeys = bedmenge.getSortedKeys();
        if (sortedKeys != null) {
            for (Bedingung bed : sortedKeys) {
                String wert = bedmenge.getBedWert(bed.getId());
                if (wert == null || !wert.equals("1")) continue;
                oJaBed.add(bed);
            }
        }
        return oJaBed;
    }

    public void resetETKTexte() {
        if (this.mETKTexte != null) {
            this.mETKTexte.resetAnzeigeKomplett();
        }
    }

    public void setAktuelleHG(String sHG) {
        this.msHG = sHG;
    }

    public String getAktuelleHG() {
        return this.msHG;
    }

    public boolean isIsisServer() {
        TrfString trf = new TrfString(null);
        try {
            GlobalObjects.getInstance().getServiceExecutor().executeService(trf, Command.CHECK_IS_ISIS);
        }
        catch (Exception ex) {
            log.error((Object)ex);
            JOptionPane.showMessageDialog(MainView.getInstance(), ex.toString(), "Could not connect to ETK-Server", 0);
            return false;
        }
        if (trf.getError() != null) {
            log.error((Object)Resource.getInstance().getSonstigerFehler(), (Throwable)trf.getError());
            JOptionPane.showMessageDialog(MainView.getInstance(), trf.getError().toString(), "Could not connect to ETK-Server", 0);
            return false;
        }
        String result = trf.getString();
        return result != null && result.equals("true");
    }

    public void setConfig(Konfiguration config) {
        this.config = config;
    }

    public Konfiguration getConfig() {
        if (this.config == null) {
            this.config = this.loadKonfiguration();
        }
        return this.config;
    }

    public static boolean isMSWindows() {
        String os = System.getProperty("os.name");
        if (os == null) {
            return false;
        }
        return os.startsWith("Windows");
    }

    public void updateAppProperties(Properties propsnew) {
        msDEBUGPropertyFileUpdateIn = "";
        PropertyUtils pu = new PropertyUtils();
        log.debug((Object)("*** updateAppProperties: " + this.getPropertyPath()));
        msDEBUGPropertyFileUpdateIn = msDEBUGPropertyFileUpdateIn + " ***010*** updateAppProperties: " + this.getPropertyPath() + "...<br>";
        Properties propsold = null;
        if (this.getPropertyPath() != null && !this.getPropertyPath().equals("")) {
            msDEBUGPropertyFileUpdateIn = msDEBUGPropertyFileUpdateIn + " ***011*** updateAppProperties: " + this.getPropertyPath() + " ist vorhanden ...<br>";
            propsold = pu.loadPropertyFile(this.getPropertyPath());
            if (propsold != null) {
                msDEBUGPropertyFileUpdateIn = msDEBUGPropertyFileUpdateIn + " ***012*** updateAppProperties: propsold ist vorhanden ...<br>";
                pu.updatePropertyFile(propsnew, propsold, this.getPropertyPath());
            }
        }
        if (this.isIsisServer()) {
            log.debug((Object)("*** updateAppProperties (for ISIS): " + this.getPropertyFile()));
            msDEBUGPropertyFileUpdateIn = msDEBUGPropertyFileUpdateIn + " ***020*** updateAppProperties (for ISIS): " + this.getPropertyFile() + "...<br>";
            propsold = pu.loadPropertyFile(this.getPropertyFile());
            if (propsold != null) {
                msDEBUGPropertyFileUpdateIn = msDEBUGPropertyFileUpdateIn + " ***021*** updateAppProperties: propsold ist vorhanden ...<br>";
                pu.updatePropertyFile(propsnew, propsold, this.getPropertyFile());
            }
        }
        if (!this.getIstStandalone()) {
            log.debug((Object)("*** updateAppProperties (for Windows/Linux Server Clients): " + this.getPropertyFile()));
            msDEBUGPropertyFileUpdateIn = msDEBUGPropertyFileUpdateIn + " ***030*** updateAppProperties (for Windows/Linux Server Clients): " + this.getPropertyFile() + "...<br>";
            propsold = pu.loadPropertyFile(this.getPropertyFile());
            if (propsold != null) {
                msDEBUGPropertyFileUpdateIn = msDEBUGPropertyFileUpdateIn + " ***031*** updateAppProperties: propsold ist vorhanden ...<br>";
                pu.updatePropertyFile(propsnew, propsold, this.getPropertyFile());
            }
        }
    }

    public String getPropertyPath() {
        String path = "";
        path = GlobalObjects.class.getProtectionDomain().getCodeSource().getLocation().getPath();
        path = path.substring(0, path.lastIndexOf("/"));
        path = path + "/javaclient.properties";
        log.debug((Object)("*** Pfad: " + path));
        return path;
    }

    public String getPropertyFileKommtVon() {
        return msDEBUGPropertyFileKommtVon;
    }

    public String getPropertyFileUpdateIn() {
        return msDEBUGPropertyFileUpdateIn;
    }

    public ServiceExecutor getServiceExecutor() {
        return this.mServiceExecutor;
    }

    private static void showDebugMessage(String string) {
        if ("true".equals(System.getProperty("debugETK"))) {
            JOptionPane.showConfirmDialog(null, string, "dubug GlobalObjects", 0);
        }
    }

    static {
        log = Logger.getLogger(GlobalObjects.class);
        msDEBUGPropertyFileKommtVon = "";
        msDEBUGPropertyFileUpdateIn = "";
        mIsIpac = false;
        mScore = false;
    }
}

