/*
 * Decompiled with CFR 0.152.
 */
package de.esg.commonclient;

import de.esg.tools.win32.registry.WindowsRegistry;
import java.io.File;
import org.apache.log4j.Appender;
import org.apache.log4j.FileAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.Logger;
import org.apache.log4j.PatternLayout;
import org.apache.log4j.RollingFileAppender;

public class InitLogging {
    public static void initLogging(String propFileName) {
        InitLogging.initLogging(propFileName, false);
    }

    public static void initLogging(String propFileName, boolean bIpac) {
        String usedPropFileName = propFileName;
        if (usedPropFileName == null) {
            String key = "HKEY_LOCAL_MACHINE\\SOFTWARE\\BMWgroup\\webetk";
            usedPropFileName = WindowsRegistry.getValueAsString(key, "Properties");
            System.out.println("Property File aus Registry (key: " + key + "): " + usedPropFileName);
        }
        if (usedPropFileName == null) {
            System.out.println("Warning: no property file name available. No logging to file");
            return;
        }
        Appender appender = Logger.getRootLogger().getAppender("file");
        FileAppender fileAppender = null;
        RollingFileAppender rollingFileAppender = null;
        if (appender != null) {
            if (appender instanceof RollingFileAppender) {
                fileAppender = (FileAppender)appender;
                rollingFileAppender = (RollingFileAppender)appender;
            } else if (appender instanceof FileAppender) {
                fileAppender = (FileAppender)appender;
            }
        }
        if (fileAppender == null && rollingFileAppender == null) {
            rollingFileAppender = new RollingFileAppender();
            rollingFileAppender.setAppend(true);
            rollingFileAppender.setLayout((Layout)new PatternLayout("<%d{dd.MM.yyyy HH:mm:ss,SSS}>%-5.5p [%-5.5t:%-50.20C{1}#%-30.20M](L%-4.4L) - %m%n"));
            rollingFileAppender.setMaxFileSize("128KB");
            rollingFileAppender.setMaxBackupIndex(1);
        }
        File propFile = new File(usedPropFileName);
        String logFileName = null;
        logFileName = bIpac ? propFile.getParent() + File.separator + "zub_client_" + System.getProperty("user.name") + ".log" : propFile.getParent() + File.separator + "etk_client_" + System.getProperty("user.name") + ".log";
        Logger rootLogger = Logger.getRootLogger();
        if (rollingFileAppender != null) {
            rollingFileAppender.setFile(logFileName);
            rollingFileAppender.activateOptions();
            rootLogger.addAppender((Appender)rollingFileAppender);
        }
        if (fileAppender != null) {
            fileAppender.setFile(logFileName);
            fileAppender.activateOptions();
            rootLogger.addAppender((Appender)fileAppender);
        }
        System.out.println("Logging to file " + logFileName);
    }
}

