/*
 * Decompiled with CFR 0.152.
 */
package de.esg.commonclient;

import de.esg.commonclient.GlobalObjects;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.util.Iterator;
import java.util.Vector;
import org.apache.log4j.Logger;

public class Login {
    private static Logger log = Logger.getLogger(Login.class);
    public static final String ETK = "ETK";
    public static final String ZUB = "ZUB";

    public static String readLoginName(String app) {
        if (app == null) {
            log.error((Object)"No app given!");
            return null;
        }
        String searchApp = null;
        if (app.equals(ETK)) {
            searchApp = ZUB;
        } else if (app.equals(ZUB)) {
            searchApp = ETK;
        } else {
            log.error((Object)"No valid app given!");
            return null;
        }
        String filename = Login.getLoginFileName();
        try {
            BufferedReader in = new BufferedReader(new InputStreamReader(new FileInputStream(filename)));
            String foundline = null;
            String line = in.readLine();
            while (line != null) {
                if (line.length() > 0) {
                    foundline = line;
                }
                line = in.readLine();
            }
            in.close();
            if (foundline != null && foundline.indexOf(searchApp) == 0) {
                log.info((Object)("found entry: " + foundline));
                log.info((Object)("using entry: " + foundline));
                String userid = foundline.substring(4);
                log.info((Object)("using userid: " + userid));
                return userid;
            }
        }
        catch (IOException ex) {
            log.info((Object)("Error reading file: " + filename));
        }
        return null;
    }

    public static void writeLoginName(String app, String name) {
        try {
            String filename = Login.getLoginFileName();
            BufferedWriter out = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(filename, true)));
            out.write(app + " " + name + System.getProperty("line.separator"));
            out.close();
        }
        catch (Exception ex) {
            log.error((Object)"Error writing file: ", (Throwable)ex);
        }
    }

    public static void deleteLoginName(String app, String name) {
        try {
            String filename = Login.getLoginFileName();
            BufferedReader in = new BufferedReader(new InputStreamReader(new FileInputStream(filename)));
            String line = in.readLine();
            boolean found = false;
            Vector<String> zeilen = new Vector<String>();
            while (line != null) {
                if (!found && line.indexOf(app + " " + name) == 0) {
                    found = true;
                    log.debug((Object)("removing entry: " + line));
                } else {
                    log.debug((Object)("keeping entry: " + line));
                    zeilen.add(line);
                }
                line = in.readLine();
            }
            in.close();
            BufferedWriter out = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(filename)));
            Iterator iter = zeilen.iterator();
            while (iter.hasNext()) {
                out.write((String)iter.next() + System.getProperty("line.separator"));
            }
            out.close();
        }
        catch (Exception ex) {
            log.error((Object)"Error deleting from file: ", (Throwable)ex);
        }
    }

    private static String getLoginFileName() {
        String help = GlobalObjects.getInstance().getPropertyFile();
        if (help == null) {
            log.error((Object)"Pfad zum Propertie-File nicht gefunden");
            return null;
        }
        help = help.replace("javaclient.properties", "etkzub.info");
        return help;
    }
}

