/*
 * Decompiled with CFR 0.152.
 */
package de.esg.commonclient.dialog;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;

public class EnhancedTextDocument
extends PlainDocument {
    private static final long serialVersionUID = -1926836379245491561L;
    public static final int ALL_CHARACTERS = 0;
    public static final int NUMBERS_ONLY = 1;
    public static final int NUMBERS_AND_STERN_ONLY = 2;
    public static final int NUMBERS_AND_STERN_AND_QUESTIONMARK_ONLY = 3;
    public static final int NUMBERS_AND_POINT_ONLY = 4;
    public static final int PRICE = 5;
    public static final int SIGNED_PRICE = 6;
    public static final int NO_NUMBERS = 7;
    private int maxChars = 0;
    private int mMaxBytes = 0;
    private int checks = 0;
    private Pattern mPattern = null;

    public EnhancedTextDocument(int maxCharacters) {
        this.maxChars = maxCharacters <= 0 ? 0 : maxCharacters;
        this.checks = 0;
    }

    public EnhancedTextDocument(int maxCharacters, int check) {
        int n = this.maxChars = maxCharacters <= 0 ? 0 : maxCharacters;
        if (check != 0 && check != 2 && check != 3 && check != 4 && check != 5 && check != 6 && check != 7 && check != 1) {
            check = 0;
            throw new IllegalArgumentException("Illegal check parameter: " + Integer.toString(check));
        }
        this.checks = check;
    }

    public EnhancedTextDocument(int maxCharacters, int check, int maxBytes) {
        int n = this.maxChars = maxCharacters <= 0 ? 0 : maxCharacters;
        if (check != 0 && check != 2 && check != 3 && check != 4 && check != 5 && check != 6 && check != 7 && check != 1) {
            check = 0;
            throw new IllegalArgumentException("Illegal check parameter: " + Integer.toString(check));
        }
        this.checks = check;
        this.mMaxBytes = maxBytes;
    }

    public EnhancedTextDocument(Pattern pattern) {
        this.mPattern = pattern;
    }

    @Override
    public void insertString(int offs, String str, AttributeSet a) throws BadLocationException {
        if (str == null) {
            return;
        }
        if (this.mPattern != null) {
            String sTest = super.getText(0, this.getLength());
            String sVorne = sTest.substring(0, offs);
            String sHinten = sTest.substring(offs);
            sTest = sVorne + str + sHinten;
            Matcher matcher = this.mPattern.matcher("");
            matcher.reset(sTest);
            if (matcher.matches()) {
                super.insertString(offs, str, a);
            }
            return;
        }
        if (this.checks == 6 || this.checks == 5) {
            String sTest = super.getText(0, this.getLength());
            String sVorne = sTest.substring(0, offs);
            String sHinten = sTest.substring(offs);
            sTest = sVorne + str + sHinten;
            if (this.checkPrice(sTest)) {
                super.insertString(offs, str, a);
            }
            return;
        }
        if (this.maxChars != 0 && this.getLength() >= this.maxChars) {
            return;
        }
        if (this.maxChars != 0 && this.getLength() + str.length() > this.maxChars) {
            str = str.substring(0, this.maxChars - this.getLength());
        }
        if (this.mMaxBytes != 0) {
            try {
                byte[] aBytesNew = str.getBytes("UTF-8");
                byte[] aBytesOld = this.getText(0, this.getLength()).getBytes("UTF-8");
                if (aBytesOld.length + aBytesNew.length > this.mMaxBytes) {
                    return;
                }
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        if (this.checks == 1 || this.checks == 2 || this.checks == 3 || this.checks == 4 || this.checks == 5 || this.checks == 6 || this.checks == 7) {
            char[] source = str.toCharArray();
            char[] result = new char[source.length];
            int j = 0;
            for (int i = 0; i < result.length; ++i) {
                if (!(Character.isDigit(source[i]) || Character.isLetter(source[i]) || source[i] == '*' && this.checks == 2 || source[i] == '*' && this.checks == 3 || source[i] == '?' && this.checks == 3) && (source[i] != '.' || this.checks != 4)) continue;
                result[j++] = source[i];
            }
            super.insertString(offs, new String(result, 0, j), a);
        } else {
            super.insertString(offs, str, a);
        }
    }

    @Override
    public void remove(int offs, int len) throws BadLocationException {
        if (this.mPattern != null) {
            String sTest = super.getText(0, this.getLength());
            String sVorne = sTest.substring(0, offs);
            String sHinten = sTest.substring(offs + len);
            sTest = sVorne + sHinten;
            Matcher matcher = this.mPattern.matcher("");
            matcher.reset(sTest);
            if (matcher.matches()) {
                super.remove(offs, len);
            }
            return;
        }
        if (this.checks == 6 || this.checks == 5) {
            String sTest = super.getText(0, this.getLength());
            String sVorne = sTest.substring(0, offs);
            String sHinten = sTest.substring(offs + len);
            sTest = sVorne + sHinten;
            if (!this.checkPrice(sTest)) {
                return;
            }
        }
        super.remove(offs, len);
    }

    protected boolean checkPrice(String sTest) {
        if (sTest.length() == 0) {
            return true;
        }
        if (sTest.length() == 1) {
            char chTest = sTest.charAt(0);
            return Character.isDigit(chTest) || chTest == '.' || this.checks == 6 && (chTest == '+' || chTest == '-');
        }
        if (this.checks != 6 && (sTest.lastIndexOf("+") > 0 || sTest.lastIndexOf("-") > 0)) {
            return false;
        }
        try {
            double dTest = Double.parseDouble(sTest);
            if (dTest == 0.0) {
                return true;
            }
            int nKommaPos = sTest.indexOf(".");
            if (nKommaPos > -1 && nKommaPos < sTest.length() - 3) {
                return false;
            }
            return !(this.checks == 6 && sTest.indexOf("+") < 0 && sTest.indexOf("-") < 0 ? nKommaPos > this.maxChars - 4 || nKommaPos < 0 && sTest.length() > this.maxChars - 4 : nKommaPos > this.maxChars - 3 || nKommaPos < 0 && sTest.length() > this.maxChars - 3);
        }
        catch (Exception ex) {
            return false;
        }
    }
}

