/*
 * Decompiled with CFR 0.152.
 */
package de.esg.commonclient.dialog;

import java.awt.Component;
import javax.swing.JList;
import javax.swing.plaf.basic.BasicComboBoxRenderer;

public class LimitedComboBoxRenderer
extends BasicComboBoxRenderer {
    private static final long serialVersionUID = -5036627686760732169L;
    private int maxZeichen = 30;

    public LimitedComboBoxRenderer(int maxZeichen) {
        this.maxZeichen = maxZeichen;
    }

    @Override
    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        String text;
        if (isSelected) {
            this.setBackground(list.getSelectionBackground());
            this.setForeground(list.getSelectionForeground());
            if (value != null) {
                text = value.toString();
                if (text.length() > this.maxZeichen) {
                    list.setToolTipText(text);
                } else {
                    list.setToolTipText(null);
                }
            } else {
                list.setToolTipText(null);
            }
        } else {
            this.setBackground(list.getBackground());
            this.setForeground(list.getForeground());
        }
        this.setFont(list.getFont());
        if (value != null) {
            text = value.toString();
            if (text.length() > this.maxZeichen) {
                this.setText(text.substring(0, this.maxZeichen) + "...");
            } else {
                this.setText(text);
            }
        } else {
            this.setText("");
        }
        return this;
    }
}

