/*
 * Decompiled with CFR 0.152.
 */
package de.esg.commonclient.dialog.extras.login;

import de.esg.commonclient.GlobalObjects;
import de.esg.commonclient.dialog.AbstractDialogViewController;
import de.esg.commonclient.dialog.DialogView;
import de.esg.commonclient.dialog.extras.login.DlgLoginModel;
import java.awt.Cursor;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import org.apache.log4j.Logger;
import webetk.app.konfiguration.Funktionsrecht;
import webetk.communication.CommunicationException;
import webetk.communication.LoginException;
import webetk.communication.LoginInfo;
import webetk.communication.transferables.Command;
import webetk.communication.transferables.TrfHashMap;
import webetk.javaclient.dialog.extras.login.DlgLoginView;
import webetk.javaclient.dialog.extras.verbautesala.DlgAusstattung;
import webetk.javaclient.dialog.hilfe.abkuerzungen.Abkuerzungen;
import webetk.javaclient.dialog.hilfe.polstercode.PolsterCode;
import webetk.javaclient.dialog.hilfe.sonderausstattung.Sonderausstattungen;
import webetk.javaclient.dialog.hilfe.tfattribute.TFAttribute;
import webetk.javaclient.dialog.hilfe.version.Version;
import webetk.javaclient.framework.MainView;
import webetk.javaclient.generictable.GenericTable;
import webetk.javaclient.lookandfeel.WebETKTheme;
import webetk.javaclient.utils.CommunicationUtils;
import webetk.javaclient.utils.LoginLogoutLogger;
import webetk.javaclient.workflow.WfFILoeschen;
import webetk.javaclient.workflow.WorkflowStateData;
import webetk.resources.Resource;

public class DlgLoginController
extends AbstractDialogViewController {
    private static Logger log = Logger.getLogger(DlgLoginController.class);
    private DlgLoginModel model = new DlgLoginModel();
    private JFrame mMainView = null;

    public boolean doLoginFilialeAendern(String userid) {
        boolean bNutzerDarfFilialeAendern = false;
        this.loadNutzerFunktionsrechte(GlobalObjects.getInstance().getFirmaId(), userid);
        for (Funktionsrecht funktionsrecht : this.model.getNutzerFunktionsrechte()) {
            String sNutzerBezeichnung = funktionsrecht.getBezeichnung();
            if (!sNutzerBezeichnung.equalsIgnoreCase("R_WEBETK_FILIALE_AENDERN")) continue;
            bNutzerDarfFilialeAendern = true;
        }
        if (bNutzerDarfFilialeAendern) {
            ArrayList<String> oFilialBezeichnungen = new ArrayList<String>();
            HashMap<String, String> oFilialMapping = new HashMap<String, String>();
            TrfHashMap oFilialen = this.model.getFilialen();
            if (oFilialen != null) {
                int i = 1;
                while (true) {
                    String sBezeichnung = (String)oFilialen.getValue(i + "benennung");
                    String sId = (String)oFilialen.getValue(i + "filialid");
                    if (sBezeichnung == null) break;
                    oFilialBezeichnungen.add(sBezeichnung);
                    oFilialMapping.put(sBezeichnung, sId);
                    ++i;
                }
            }
            Collections.sort(oFilialBezeichnungen);
            String s = (String)JOptionPane.showInputDialog(this.mMainView, Resource.getInstance().getGewuenschteFilialeAngeben() + ":", Resource.getInstance().getFilialauswahl(), 3, null, oFilialBezeichnungen.toArray(), this.model.getFilialeBezeichnung());
            if (s != null && s.length() > 0) {
                log.info((Object)("Filiale has changed to: " + (String)oFilialMapping.get(s)));
                this.model.setFilialeBezeichnung(s);
                this.model.setFiliale((String)oFilialMapping.get(s));
            }
        } else {
            JOptionPane.showMessageDialog(this.mMainView, Resource.getInstance().getNichtBerechtigtUmFilialeZuAendern(), Resource.getInstance().getAnmeldung(), 1);
        }
        return bNutzerDarfFilialeAendern;
    }

    public boolean performLogin(String sFirmaId, String sFilialId, String sUsername, String sPassword) {
        String sRegISO;
        String sISO;
        boolean bUseGrosseSchrift;
        LoginLogoutLogger.protokolliereLogout(GlobalObjects.getInstance().getSessionInfo().getFirmaId(), GlobalObjects.getInstance().getSessionInfo().getLogin());
        log.debug((Object)"Performing Login");
        TrfHashMap oFilialen = this.model.getFilialen();
        if (oFilialen == null) {
            this.loadFilialen(sFirmaId);
        }
        if ((oFilialen = this.model.getFilialen()) == null) {
            log.error((Object)("Keine Filialen zur Firma " + sFirmaId + " gefunden."));
            return false;
        }
        boolean bFound = false;
        int i = 1;
        while (true) {
            String sBezeichnung = (String)oFilialen.getValue(i + "benennung");
            String sId = (String)oFilialen.getValue(i + "filialid");
            if (sId != null && sId.equals(sFilialId)) {
                bFound = true;
                break;
            }
            if (sBezeichnung == null) break;
            ++i;
        }
        if (!bFound) {
            log.warn((Object)("Filiale " + sFilialId + " existiert nicht."));
            Object[] arguments = new Object[]{sFilialId};
            String sMsg = MessageFormat.format(Resource.getInstance().getMsgWrongFilialid(), arguments);
            this.mMainView.setCursor(Cursor.getPredefinedCursor(0));
            JOptionPane.showMessageDialog(this.mMainView, sMsg, Resource.getInstance().getAnmeldung(), 0);
            sFilialId = this.model.getFilialeAlt();
            log.warn((Object)("using id " + this.model.getFilialeAlt()));
        }
        String sAktSpracheOld = "";
        if (GlobalObjects.getInstance().getSessionInfo() != null) {
            String sISO2 = GlobalObjects.getInstance().getSessionInfo().getLanguage();
            String sRegISO2 = GlobalObjects.getInstance().getSessionInfo().getLangRegion();
            if (sISO2 == null) {
                sISO2 = "";
            }
            if (sRegISO2 == null) {
                sRegISO2 = "";
            }
            sAktSpracheOld = sISO2 + sRegISO2;
        }
        this.mMainView.setCursor(Cursor.getPredefinedCursor(3));
        TrfHashMap trfLogin = new TrfHashMap(null);
        trfLogin.setValue("firmaid", sFirmaId);
        trfLogin.setValue("filialid", sFilialId);
        trfLogin.setValue("filialid_alt", this.model.getFilialeAlt());
        trfLogin.setValue("username", sUsername);
        trfLogin.setValue("pwd", sPassword);
        String szUSFilename = GlobalObjects.getInstance().getEtkData().getUSDealerFilename();
        trfLogin.setValue("us_filename", szUSFilename);
        try {
            GlobalObjects.getInstance().getServiceExecutor().executeService(trfLogin, Command.LOGIN);
        }
        catch (CommunicationException ex) {
            log.error((Object)("Could not login server: " + GlobalObjects.getInstance().getServerUrl()), (Throwable)ex);
            this.mMainView.setCursor(Cursor.getPredefinedCursor(0));
            return false;
        }
        if (trfLogin.getError() != null) {
            if (trfLogin.getError() instanceof LoginException) {
                log.error((Object)"Login Failed!", (Throwable)trfLogin.getError());
                this.mMainView.setCursor(Cursor.getPredefinedCursor(0));
                JOptionPane.showMessageDialog(this.mMainView, Resource.getInstance().getAnmeldungFehlgeschlagenNutzernamePasswort(), Resource.getInstance().getAnmeldung(), 0);
                return false;
            }
            log.error((Object)"Connection Failed!", (Throwable)trfLogin.getError());
            this.mMainView.setCursor(Cursor.getPredefinedCursor(0));
            JOptionPane.showMessageDialog(this.mMainView, Resource.getInstance().getAnmeldungFehlgeschlagenKommunikationsproblem(), Resource.getInstance().getAnmeldung(), 0);
            return false;
        }
        try {
            this.model.storeSessionInfos(trfLogin);
        }
        catch (CommunicationException ex) {
            log.error((Object)"No valid login information");
            this.mMainView.setCursor(Cursor.getPredefinedCursor(0));
            JOptionPane.showMessageDialog(this.mMainView, Resource.getInstance().getAnmeldungFehlgeschlagenKommunikationsproblem(), Resource.getInstance().getAnmeldung(), 0);
            return false;
        }
        GlobalObjects.getInstance().updateSessionInfo(this.model.getSessionInfos());
        log.info((Object)("Login performed. Session ID: " + GlobalObjects.getInstance().getSessionId()));
        GlobalObjects.getInstance().getEtkData().setPasswort(sPassword);
        LoginInfo oLoginInfo = this.model.getSessionInfos();
        boolean bl = bUseGrosseSchrift = oLoginInfo.getSettings().getSchriftgroesse().equals("G");
        if (!GlobalObjects.isIpac()) {
            WebETKTheme.useGrosseSchriftart(bUseGrosseSchrift);
        }
        int nDefaultResizingMode = oLoginInfo.getSettings().getTabellenanzeige().equals("V") ? 1 : 2;
        GenericTable.setDefaultResizingMode(nDefaultResizingMode);
        if (this.mMainView instanceof MainView) {
            ((MainView)this.mMainView).initMenus();
        }
        this.mMainView.setCursor(Cursor.getPredefinedCursor(0));
        GlobalObjects.getInstance().resetFzgIdInfo();
        GlobalObjects.getInstance().getEtkData().resetSucheInfo();
        WfFILoeschen.resetFahrzeugidentifikation();
        String sAktSpracheNew = "";
        if (this.model.getSessionInfos() != null) {
            sISO = this.model.getSessionInfos().getLanguage();
            sRegISO = this.model.getSessionInfos().getLangRegion();
            if (sISO == null) {
                sISO = "";
            }
            if (sRegISO == null) {
                sRegISO = "";
            }
            sAktSpracheNew = sISO + sRegISO;
        }
        if (!sAktSpracheNew.equals(sAktSpracheOld) && !sAktSpracheOld.equals("")) {
            Abkuerzungen.resetInstance();
            PolsterCode.resetInstance();
            Sonderausstattungen.resetInstance();
            TFAttribute.resetInstance();
            Version.resetInstance();
            DlgAusstattung.resetInstance();
        }
        sISO = oLoginInfo.getSettings().getSprache();
        sRegISO = oLoginInfo.getSettings().getSpracheRegion();
        String string = sRegISO = sRegISO == null ? "" : sRegISO;
        if (sISO == null) {
            String language = GlobalObjects.getInstance().getLanguage();
            sISO = language.substring(0, 2);
            if (language.length() > 2) {
                sRegISO = language.substring(2, 4);
            }
        }
        String sSprache = sISO + sRegISO;
        Resource.setLanguage(sSprache.trim());
        if (!GlobalObjects.isIpac()) {
            WebETKTheme.changeFont(sSprache.substring(0, 2));
        }
        GlobalObjects.getInstance().getEtkData().setMainViewTitle();
        this.mMainView.setCursor(Cursor.getPredefinedCursor(0));
        if (this.model.getSessionInfos() != null) {
            GlobalObjects.getInstance().updateSessionInfo(this.model.getSessionInfos());
            if (this.mMainView instanceof MainView) {
                ((MainView)this.mMainView).initMenus();
            }
        }
        LoginLogoutLogger.protokolliereLogin(sFirmaId, sUsername);
        this.notifyAllExitListeners();
        return true;
    }

    @Override
    public void init(WorkflowStateData oWFStateData) {
        this.mMainView = MainView.getInstance();
        log.debug((Object)"Init");
        this.model.init(oWFStateData);
        this.dialogView = new DlgLoginView();
        this.dialogView.init(this.model, this);
    }

    public void init(DialogView view, String userid, JFrame mainView) {
        this.mMainView = mainView;
        log.debug((Object)"Init");
        WorkflowStateData oWFStateData = new WorkflowStateData();
        oWFStateData.setWert("NUTZER", userid);
        this.model.init(oWFStateData);
        view.init(this.model, this);
    }

    @Override
    public WorkflowStateData getExitData() {
        WorkflowStateData data = new WorkflowStateData();
        data.setWert("loginInfo", this.model.getSessionInfos());
        return data;
    }

    @Override
    public boolean skipToNextState() {
        log.debug((Object)"No next state.");
        return false;
    }

    public void loadFilialen(String sFirmaId) {
        log.debug((Object)"Performing Load Filialen");
        this.mMainView.setCursor(Cursor.getPredefinedCursor(3));
        TrfHashMap trfFilialen = new TrfHashMap(null);
        trfFilialen.setValue("firmaid", sFirmaId);
        CommunicationUtils.syncComm(trfFilialen, Command.LOAD_FILIALEN, Resource.getInstance().getAnmeldung());
        this.model.storeFilialen(trfFilialen);
        this.mMainView.setCursor(Cursor.getPredefinedCursor(0));
    }

    public boolean existiertNutzerId(String sFirmaId, String sNutzerId) {
        this.mMainView.setCursor(Cursor.getPredefinedCursor(3));
        TrfHashMap trfNutzer = new TrfHashMap(null);
        trfNutzer.setValue("firmaid", sFirmaId);
        trfNutzer.setValue("user_id", sNutzerId.toLowerCase());
        try {
            GlobalObjects.getInstance().getServiceExecutor().executeService(trfNutzer, Command.EXIST_USERID);
        }
        catch (CommunicationException ex) {
            log.error((Object)("DlgLoginController: " + GlobalObjects.getInstance().getServerUrl()), (Throwable)ex);
            this.mMainView.setCursor(Cursor.getPredefinedCursor(0));
            return false;
        }
        if (trfNutzer.getError() != null) {
            log.error((Object)Resource.getInstance().getSonstigerFehler(), (Throwable)trfNutzer.getError());
            this.mMainView.setCursor(Cursor.getPredefinedCursor(0));
            JOptionPane.showMessageDialog(this.mMainView, trfNutzer.getError().getMessage(), Resource.getInstance().getFilialverwaltung(), 0);
            return false;
        }
        this.mMainView.setCursor(Cursor.getPredefinedCursor(0));
        return (Boolean)trfNutzer.getValue("boolean");
    }

    public void loadDefaultFilialePasswort(String sFirmaId, String sNutzerId) {
        this.mMainView.setCursor(Cursor.getPredefinedCursor(3));
        TrfHashMap trfNutzer = new TrfHashMap(null);
        trfNutzer.setValue("firmaid", sFirmaId);
        trfNutzer.setValue("user_id", sNutzerId.toLowerCase());
        try {
            GlobalObjects.getInstance().getServiceExecutor().executeService(trfNutzer, Command.LOAD_DEFAULTFILIALE_PASSWORT);
        }
        catch (CommunicationException ex) {
            log.error((Object)("DlgNutzereinstellungenController: " + GlobalObjects.getInstance().getServerUrl()), (Throwable)ex);
            this.mMainView.setCursor(Cursor.getPredefinedCursor(0));
            return;
        }
        if (trfNutzer.getError() != null) {
            log.error((Object)Resource.getInstance().getSonstigerFehler(), (Throwable)trfNutzer.getError());
            this.mMainView.setCursor(Cursor.getPredefinedCursor(0));
            JOptionPane.showMessageDialog(this.mMainView, trfNutzer.getError().getMessage(), Resource.getInstance().getFilialverwaltung(), 0);
            return;
        }
        this.model.setFiliale(trfNutzer.getValue("filialid").toString());
        this.model.setFilialeAlt(trfNutzer.getValue("filialid").toString());
        this.model.setFilialeBezeichnung(trfNutzer.getValue("filiale").toString());
        this.model.setPasswort(trfNutzer.getValue("pwd").toString());
        this.model.setUserId(trfNutzer.getValue("user_id").toString());
        String sIso = trfNutzer.getValue("iso").toString();
        String sRegIso = trfNutzer.getValue("regiso").toString();
        if (sIso != null) {
            String sLanguage = sIso;
            if (sRegIso != null) {
                sLanguage = sLanguage + sRegIso;
            }
            this.model.setFilialeSprache(sLanguage);
        }
        this.mMainView.setCursor(Cursor.getPredefinedCursor(0));
    }

    public void loadNutzerFunktionsrechte(String sFirmaId, String sUserId) {
        log.debug((Object)"Performing Load Nutzer Funktionsrechte");
        this.mMainView.setCursor(Cursor.getPredefinedCursor(3));
        TrfHashMap trfFunktionsrechte = new TrfHashMap(null);
        trfFunktionsrechte.setValue("firmaid", sFirmaId);
        trfFunktionsrechte.setValue("user_id", sUserId);
        String sISO = GlobalObjects.getInstance().getSessionInfo().getLanguage();
        String sRegISO = GlobalObjects.getInstance().getSessionInfo().getLangRegion();
        String string = sRegISO = sRegISO == null ? "  " : sRegISO;
        if (sISO == null) {
            String language = GlobalObjects.getInstance().getLanguage();
            sISO = language.substring(0, 2);
            if (language.length() > 2) {
                sRegISO = language.substring(2, 4);
            }
        }
        trfFunktionsrechte.setValue("iso", sISO);
        trfFunktionsrechte.setValue("regiso", sRegISO);
        try {
            GlobalObjects.getInstance().getServiceExecutor().executeService(trfFunktionsrechte, Command.LOAD_NUTZER_FUNKTIONSRECHTE);
        }
        catch (CommunicationException ex) {
            log.error((Object)("DlgLoginController: " + GlobalObjects.getInstance().getServerUrl()), (Throwable)ex);
            this.mMainView.setCursor(Cursor.getPredefinedCursor(0));
            return;
        }
        if (trfFunktionsrechte.getError() != null) {
            log.error((Object)Resource.getInstance().getSonstigerFehler(), (Throwable)trfFunktionsrechte.getError());
            this.mMainView.setCursor(Cursor.getPredefinedCursor(0));
            JOptionPane.showMessageDialog(this.mMainView, trfFunktionsrechte.getError().getMessage(), Resource.getInstance().getBenutzerverwaltung(), 0);
            this.model.storeFilialen(null);
            return;
        }
        this.model.storeNutzerFunktionsrechte((List)trfFunktionsrechte.getValue("funktionsrecht_list"));
        this.mMainView.setCursor(Cursor.getPredefinedCursor(0));
    }

    public DlgLoginModel getModel() {
        return this.model;
    }

    public boolean existiertEineFirmaFilialeNutzer() {
        this.mMainView.setCursor(Cursor.getPredefinedCursor(3));
        ArrayList<String> aUserIdToIgnore = new ArrayList<String>();
        aUserIdToIgnore.add("score");
        TrfHashMap trfNutzer = new TrfHashMap(null);
        trfNutzer.setValue("userids_to_ignore", aUserIdToIgnore);
        try {
            GlobalObjects.getInstance().getServiceExecutor().executeService(trfNutzer, Command.EXIST_EINE_FIRMA_FILIALE_NUTZER);
        }
        catch (CommunicationException ex) {
            log.error((Object)("DlgLoginController: " + GlobalObjects.getInstance().getServerUrl()), (Throwable)ex);
            this.mMainView.setCursor(Cursor.getPredefinedCursor(0));
            return false;
        }
        if (trfNutzer.getError() != null) {
            log.error((Object)Resource.getInstance().getSonstigerFehler(), (Throwable)trfNutzer.getError());
            this.mMainView.setCursor(Cursor.getPredefinedCursor(0));
            JOptionPane.showMessageDialog(this.mMainView, trfNutzer.getError().getMessage(), Resource.getInstance().getFilialverwaltung(), 0);
            return false;
        }
        this.mMainView.setCursor(Cursor.getPredefinedCursor(0));
        return (Boolean)trfNutzer.getValue("boolean");
    }

    public JFrame getMainView() {
        return this.mMainView;
    }
}

