/*
 * Decompiled with CFR 0.152.
 */
package webetk;

import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public class LanguageUtils {
    private static Logger log = Logger.getLogger(LanguageUtils.class);

    public static String toLanguage(String sLangString) throws IllegalArgumentException {
        log.log((Priority)Level.ALL, (Object)("Trying to analyze: " + sLangString));
        if (sLangString == null || sLangString.length() < 2) {
            log.error((Object)("Fatal: The given String <" + sLangString + "> is no valid language string!"));
            throw new IllegalArgumentException(sLangString);
        }
        return sLangString.substring(0, 2);
    }

    public static String toRegion(String sLangString, boolean bSpaces) {
        log.log((Priority)Level.ALL, (Object)("Trying to analyze: " + sLangString));
        if (sLangString == null || sLangString.length() < 4) {
            return bSpaces ? "  " : null;
        }
        return sLangString.substring(2, 4);
    }

    public static String toCompoundLanguage(String sLang, String sRegion) throws IllegalArgumentException {
        log.log((Priority)Level.ALL, (Object)("Trying to combine (" + sLang + ", " + sRegion + ")"));
        if (sLang == null) {
            return null;
        }
        if (sLang.length() != 2 || sRegion != null && !sRegion.equalsIgnoreCase("") && sRegion.length() != 2) {
            log.error((Object)("Fatal: The given language <" + sLang + "> or region <" + sRegion + "> is no valid language or region string!"));
            throw new IllegalArgumentException(sLang + "/" + sRegion);
        }
        if (sRegion != null && (sRegion.equalsIgnoreCase("  ") || sRegion.equalsIgnoreCase(""))) {
            sRegion = null;
        }
        return sRegion != null ? sLang + sRegion : sLang;
    }
}

