/*
 * Decompiled with CFR 0.152.
 */
package webetk.app.asssuche;

import java.io.Serializable;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlType;
import org.apache.log4j.Logger;
import webetk.DatabaseBusyException;
import webetk.InvalidInitializationException;
import webetk.WebetkUtils;
import webetk.app.SearchBTETeile;
import webetk.app.ServerGlobalObjects;
import webetk.app.SucheInfo;
import webetk.app.asssuche.AssSucheInfo;
import webetk.app.basesuche.BaseBegriffSuche;
import webetk.db.dbaccess.TeileSucheAssDbAccess;
import webetk.framework.ServerSessionInfo;

@XmlRootElement(name="BegriffSucheAss")
@XmlType(name="webetk.app.asssuche.BegriffSuche")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class BegriffSuche
extends BaseBegriffSuche
implements Serializable {
    @XmlTransient
    private static final long serialVersionUID = 1L;
    @XmlTransient
    private static Logger log = Logger.getLogger(BegriffSuche.class);

    public BegriffSuche() {
    }

    public BegriffSuche(String sBegriff) throws InvalidInitializationException {
        super(sBegriff);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int performSearch(SucheInfo oSucheInfo, String sLang, ServerSessionInfo oServerSessionInfo) throws SQLException, DatabaseBusyException {
        ServerGlobalObjects gObj = ServerGlobalObjects.getInstance();
        if (!(oSucheInfo instanceof AssSucheInfo)) {
            log.error((Object)"oSucheInfo is no instance of AssSucheInfo!");
            return 4;
        }
        AssSucheInfo oAssSucheInfo = (AssSucheInfo)oSucheInfo;
        oSucheInfo.setSuchSuchbegriff(this.msSuchbegriff);
        boolean bIGDOM = oSucheInfo.isIGDOM();
        this.mcBTEs.clear();
        this.mcTeile.clear();
        Connection con = null;
        ResultSet res = null;
        try {
            SearchBTETeile.PartOrBTE obj;
            con = gObj.getDBConnection("BegriffSuche.performSearch");
            String sMarke = oAssSucheInfo.getMarke();
            String sProduktart = oAssSucheInfo.getProduktart();
            String sKatUmfang = oAssSucheInfo.getKatalogumfang();
            res = TeileSucheAssDbAccess.searchBildtafel_Begriff(con, this.mcBegriffePlus, this.mcBegriffeMinus, this.mcBegriffeOder, sLang, sMarke, sProduktart, sKatUmfang);
            while (res != null && res.next()) {
                obj = BegriffSuche.readResultIntoBte(res, sLang, sProduktart, null, bIGDOM);
                this.mcBTEs.add(obj);
            }
            WebetkUtils.closeQuery(res);
            res = TeileSucheAssDbAccess.searchSachnummern_Begriff(con, this.mcBegriffePlus, this.mcBegriffeMinus, this.mcBegriffeOder, sLang, sMarke, sProduktart, sKatUmfang);
            while (res != null && res.next()) {
                obj = BegriffSuche.readResultIntoPart(res);
                this.mcTeile.add(obj);
            }
        }
        catch (Throwable throwable) {
            WebetkUtils.closeQuery(res);
            gObj.freeDBConnection(con, "BegriffSuche.performSearch");
            throw throwable;
        }
        WebetkUtils.closeQuery(res);
        gObj.freeDBConnection(con, "BegriffSuche.performSearch");
        if (this.mcBTEs.size() == 0 && this.mcTeile.size() == 0) {
            return 4;
        }
        if (this.mcBTEs.size() != 0 && this.mcTeile.size() != 0) {
            return 3;
        }
        if (this.mcBTEs.size() != 0 && this.mcTeile.size() == 0) {
            return 1;
        }
        return 2;
    }
}

