/*
 * Decompiled with CFR 0.152.
 */
package webetk.app.asssuche;

import java.io.Serializable;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlType;
import org.apache.log4j.Logger;
import webetk.DatabaseBusyException;
import webetk.WebetkUtils;
import webetk.app.SearchBTETeile;
import webetk.app.ServerGlobalObjects;
import webetk.app.SucheInfo;
import webetk.app.asssuche.AssSucheInfo;
import webetk.db.dbaccess.TeileSucheAssDbAccess;
import webetk.framework.ServerSessionInfo;

@XmlRootElement(name="TeileSucheAss")
@XmlType(name="webetk.app.asssuche.TeileSuche")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class TeileSuche
extends SearchBTETeile
implements Serializable {
    @XmlTransient
    private static final long serialVersionUID = 1L;
    @XmlTransient
    private static Logger log = Logger.getLogger(TeileSuche.class);
    private Collection<String> mcSuchTeile = null;

    public TeileSuche() {
    }

    public TeileSuche(Collection<String> cTeile) {
        this.mcSuchTeile = cTeile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int performSearch(SucheInfo oSucheInfo, String sLang, ServerSessionInfo oServerSessionInfo) throws SQLException, DatabaseBusyException {
        ServerGlobalObjects gObj = ServerGlobalObjects.getInstance();
        if (!(oSucheInfo instanceof AssSucheInfo)) {
            log.error((Object)"oSucheInfo is no instance of AssSucheInfo!");
            return 4;
        }
        AssSucheInfo oAssSucheInfo = (AssSucheInfo)oSucheInfo;
        boolean bIGDOM = oSucheInfo.isIGDOM();
        this.mcBTEs.clear();
        this.mcTeile.clear();
        oSucheInfo.setSuchSachnummern(this.mcSuchTeile);
        Connection con = null;
        ResultSet res = null;
        try {
            con = gObj.getDBConnection("TeileSuche.performSearch");
            String sMarke = oAssSucheInfo.getMarke();
            String sProduktart = oAssSucheInfo.getProduktart();
            String sKatUmfang = oAssSucheInfo.getKatalogumfang();
            res = TeileSucheAssDbAccess.searchBildtafel_SNrs(con, this.mcSuchTeile, sLang, sMarke, sProduktart, sKatUmfang);
            while (res != null && res.next()) {
                SearchBTETeile.PartOrBTE obj = TeileSuche.readResultIntoBte(res, sLang, sProduktart, null, bIGDOM);
                this.mcBTEs.add(obj);
            }
        }
        catch (Throwable throwable) {
            WebetkUtils.closeQuery(res);
            gObj.freeDBConnection(con, "TeileSuche.performSearch");
            throw throwable;
        }
        WebetkUtils.closeQuery(res);
        gObj.freeDBConnection(con, "TeileSuche.performSearch");
        return this.mcBTEs.size() == 0 ? 4 : 1;
    }
}

