/*
 * Decompiled with CFR 0.152.
 */
package webetk.app.bteanzeige;

import java.io.Serializable;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Vector;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;
import webetk.WebetkUtils;
import webetk.app.bteanzeige.AbstractZeile;
import webetk.app.bteanzeige.Changepoint;
import webetk.app.bteanzeige.RawZeile;
import webetk.utils.StringUtils;

@XmlRootElement
@XmlAccessorType(value=XmlAccessType.FIELD)
public class Zeile
extends AbstractZeile
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String STECKER_FLAG = "#";
    public static final String SATZ_FLAG = "S";
    private long mlBlockNr = 0L;
    private long mlGruppeId = 0L;
    private int mnPos = 0;
    private String msId = null;
    private String msBildnummer = null;
    private boolean mbIsKomprimierungszeile = false;
    private boolean mbIsKomprimiert = false;
    private String msTeilebenennung = null;
    private String msKommentarTeilebenennung = null;
    private String msZusatz = null;
    private String msMenge = null;
    private String msEinsatz = null;
    private String msAuslauf = null;
    private String msKatalysator = null;
    private String msGetriebe = null;
    private String msLenkung = null;
    private String msSachnummer = null;
    private String msTeilenummer = null;
    private String msAEZeichen = null;
    private String msTechnischeInfo = null;
    private boolean mbPiVorhanden = false;
    private boolean mbTcVorhanden = false;
    private String msMMG = null;
    private String msEMG = null;
    private Collection<Changepoint> mcChangepoints = new Vector<Changepoint>();
    private String msSIDokArten = null;
    private String msGRPLeitAWs = null;
    private boolean mbIsSatzteil = false;
    private boolean mbIsReach = false;
    private boolean mbIsASPG = false;
    private boolean mbIsStecker = false;
    private boolean mbIsDiebstahlrelevant = false;
    private boolean mbIsSelected = false;
    private int mnAnkerPos = 0;

    public Zeile() {
    }

    public Zeile(RawZeile rawZeile) {
        this.mlBlockNr = rawZeile.getBlockNr();
        this.mlGruppeId = rawZeile.getGruppeId();
        this.mnPos = rawZeile.getPos();
        this.msId = rawZeile.getId();
        this.msBildnummer = rawZeile.getBildnummer();
        this.mbIsKomprimierungszeile = rawZeile.getIsKomprimierungszeile();
        this.mbIsKomprimiert = rawZeile.getIsKomprimiert();
        this.msTeilebenennung = rawZeile.getTeilebenennung();
        this.msKommentarTeilebenennung = rawZeile.getBenKommentar();
        this.msZusatz = rawZeile.getZusatz();
        this.msMenge = rawZeile.getMenge();
        this.mbIsReach = rawZeile.isTeilReach();
        this.mbIsASPG = rawZeile.isTeilASPG();
        this.mbIsStecker = rawZeile.isStecker();
        this.mbIsDiebstahlrelevant = rawZeile.isDiebstahlrelevant();
        this.mbIsSelected = rawZeile.isSelected();
        this.mnAnkerPos = rawZeile.getAnkerPos();
        String sEinsatz = rawZeile.getEinsatz();
        this.msEinsatz = sEinsatz == null || sEinsatz.equals("") ? "" : sEinsatz.substring(4, 6) + "/" + sEinsatz.substring(2, 4);
        String sAuslauf = rawZeile.getAuslauf();
        this.msAuslauf = sAuslauf == null || sAuslauf.equals("") ? "" : sAuslauf.substring(4, 6) + "/" + sAuslauf.substring(2, 4);
        this.msKatalysator = rawZeile.getKatalysator();
        this.msGetriebe = rawZeile.getGetriebe();
        this.msLenkung = rawZeile.getLenkung();
        this.msSachnummer = rawZeile.getSachnummer();
        this.msTeilenummer = rawZeile.getTeilenummer();
        this.msAEZeichen = rawZeile.getTeilAZeichen() + rawZeile.getTeilEZeichen();
        this.msMMG = rawZeile.getMMG();
        this.msEMG = rawZeile.getEMG();
        String sFlagI = rawZeile.getBenKommentarId() != 0L || rawZeile.getPIKommentarId() != 0L || rawZeile.getSIVorhanden() || this.mbIsReach ? "I" : "";
        String sFlagStecker = this.mbIsStecker ? STECKER_FLAG : "";
        String sFlagSatz = rawZeile.getSatzteilIndikator() ? SATZ_FLAG : "";
        String sFlagC = rawZeile.getTCVorhanden() ? "C" : "";
        String sFlagV = "";
        if (!rawZeile.isBtZAlter()) {
            sFlagV = rawZeile.getChangepoints().size() > 0 ? "V" : "";
        }
        String sFlagG = rawZeile.getGRPVorhanden() ? "G" : "";
        this.msTechnischeInfo = sFlagI + sFlagStecker + sFlagSatz + sFlagC + sFlagV + sFlagG;
        this.msSIDokArten = rawZeile.getSIDokArten();
        this.msGRPLeitAWs = rawZeile.getGRPLeitAWs();
        this.mbPiVorhanden = rawZeile.getPIKommentarId() != 0L;
        this.mbTcVorhanden = rawZeile.getTCVorhanden();
        this.mbIsSatzteil = rawZeile.getSatzteilIndikator();
        for (Changepoint oChangepoint : rawZeile.getChangepoints()) {
            this.addChangepoint(oChangepoint);
        }
    }

    public long getBlockNr() {
        return this.mlBlockNr;
    }

    public long getGruppeId() {
        return this.mlGruppeId;
    }

    public int getPos() {
        return this.mnPos;
    }

    public String getId() {
        return this.msId;
    }

    public String getBildnummer() {
        return this.msBildnummer;
    }

    public boolean isKomprimierungszeile() {
        return this.mbIsKomprimierungszeile;
    }

    public boolean isKomprimiert() {
        return this.mbIsKomprimiert;
    }

    public String getTeilebenennung() {
        return this.msTeilebenennung;
    }

    public String getKommentarTeilebenennung() {
        return this.msKommentarTeilebenennung;
    }

    public String getZusatz() {
        return this.msZusatz;
    }

    public String getMenge() {
        return this.msMenge;
    }

    public String getEinsatzdatum() {
        return this.msEinsatz;
    }

    public String getAuslaufdatum() {
        return this.msAuslauf;
    }

    public String getKatalysator() {
        return this.msKatalysator;
    }

    public String getGetriebe() {
        return this.msGetriebe;
    }

    public String getLenkung() {
        return this.msLenkung;
    }

    public String getTeilenummer(boolean bFormatiert) {
        if (this.msTeilenummer.equals("")) {
            return "";
        }
        if (!bFormatiert) {
            return this.msTeilenummer;
        }
        return WebetkUtils.formatiereTeilenummer(this.msTeilenummer).endsWith("1 234 567") ? "" : WebetkUtils.formatiereTeilenummer(this.msTeilenummer);
    }

    public String getSachnummer(boolean bFormatiert) {
        if (this.msSachnummer.equals("")) {
            return "";
        }
        if (!bFormatiert) {
            return this.msSachnummer;
        }
        return WebetkUtils.formatiereSachnummer(this.msSachnummer);
    }

    public String getAustausch() {
        return this.msAEZeichen;
    }

    public String getTechnischeInfo() {
        return this.msTechnischeInfo;
    }

    public String toString() {
        return " BNB: " + this.getBildnummer() + ", Teil: " + this.getTeilenummer(true);
    }

    public String getMMG() {
        return this.msMMG;
    }

    public String getEMG() {
        return this.msEMG;
    }

    public boolean getSatzteilIndikator() {
        return this.mbIsSatzteil;
    }

    public boolean isPiVorhanden() {
        return this.mbPiVorhanden;
    }

    public boolean isTeilReach() {
        return this.mbIsReach;
    }

    public boolean isTeilASPG() {
        return this.mbIsASPG;
    }

    public boolean isTeilStecker() {
        return this.mbIsStecker;
    }

    public boolean isTeilDiebstahlrelevant() {
        return this.mbIsDiebstahlrelevant;
    }

    public boolean isTcVorhanden() {
        return this.mbTcVorhanden;
    }

    public String getSIDokArten() {
        return this.msSIDokArten;
    }

    public String getGRPLeitAWs() {
        return this.msGRPLeitAWs;
    }

    public void addChangepoint(Changepoint oChangepoint) {
        this.mcChangepoints.add(oChangepoint);
    }

    public Collection<Changepoint> getChangepoints() {
        return this.mcChangepoints;
    }

    public boolean hatChangepoints() {
        return this.mcChangepoints.size() > 0;
    }

    public Collection<String> getChangepointString(String sVorlageAb, String sVorlageBis, String sUebGetriebenummer, String sUebMotornummer) {
        Vector<String> cResult = new Vector<String>();
        for (Changepoint oChangepoint : this.mcChangepoints) {
            String sZeile = null;
            sZeile = oChangepoint.getArt().equals("FROM") ? sVorlageAb : sVorlageBis;
            String sTyp = oChangepoint.getTyp();
            sZeile = StringUtils.substituteString(sZeile, "TYP", sTyp);
            String sWerk = oChangepoint.getWerk();
            sZeile = StringUtils.substituteString(sZeile, "WERK", sWerk);
            String sMerkmale = "";
            boolean bKomma = false;
            if (oChangepoint.getDatum() != null) {
                String sDatum;
                long lDatum = oChangepoint.getDatum().longValue();
                Date oDatum = StringUtils.getDateFromLong(lDatum);
                sMerkmale = sDatum = StringUtils.getStringFromDate(oDatum, "de", 2);
                bKomma = true;
            }
            if (oChangepoint.getVin() != null) {
                if (bKomma) {
                    sMerkmale = sMerkmale + ", ";
                }
                sMerkmale = sMerkmale + "VIN " + oChangepoint.getVin();
                bKomma = true;
            }
            if (oChangepoint.getArtNummer() != null) {
                if (bKomma) {
                    sMerkmale = sMerkmale + ", ";
                }
                sMerkmale = oChangepoint.getArtNummer().equals("G") ? sMerkmale + sUebGetriebenummer + " " + oChangepoint.getNummer() : sMerkmale + sUebMotornummer + " " + oChangepoint.getNummer();
            }
            sZeile = StringUtils.substituteString(sZeile, "MERKMALE", sMerkmale);
            cResult.add(sZeile);
        }
        return cResult;
    }

    public String generateTooltip(HashMap<String, String> uebersetzungen) {
        String sSIDokArten;
        String sGRPLeitAWs;
        String sVorlageAb = uebersetzungen.get("CP_VERBAUBAR_AB");
        String sVorlageBis = uebersetzungen.get("CP_VERBAUBAR_BIS");
        String sUebGetriebenummer = uebersetzungen.get("GETRIEBENUMMER");
        String sUebMotornummer = uebersetzungen.get("MOTORNUMMER");
        String sGrpInformation = uebersetzungen.get("GRP_INFORMATION");
        String sTeileclearingText1 = uebersetzungen.get("TEILECLEARING_TEXT_1");
        String sProduktinfo = uebersetzungen.get("PRODUKTINFO");
        String sTeileinfo = uebersetzungen.get("TEILEINFO");
        String sReach = "REACH";
        String sTooltipSteckerUndAnschlagteile = uebersetzungen.get("TOOLTIPSTECKERUNDANSCHLAGTEIL");
        StringBuffer sb = new StringBuffer();
        Collection<String> cCps = this.getChangepointString(sVorlageAb, sVorlageBis, sUebGetriebenummer, sUebMotornummer);
        if (cCps != null) {
            for (String changePoint : cCps) {
                if (sb.length() > 0) {
                    sb.append("<br>");
                }
                sb.append(changePoint);
            }
        }
        if ((sGRPLeitAWs = this.getGRPLeitAWs()) != null) {
            String sGRPText = sGrpInformation;
            if (sb.length() > 0) {
                sb.append("<br>");
            }
            sb.append(sGRPText + " " + sGRPLeitAWs);
        }
        if (this.isTcVorhanden()) {
            if (sb.length() > 0) {
                sb.append("<br>");
            }
            sb.append(sTeileclearingText1);
        }
        if (this.mbIsReach) {
            if (sb.length() > 0) {
                sb.append("<br>");
            }
            sb.append(sReach);
        }
        if (this.isPiVorhanden()) {
            if (sb.length() > 0) {
                sb.append("<br>");
            }
            sb.append(sProduktinfo);
        }
        if ((sSIDokArten = this.getSIDokArten()) != null) {
            if (sb.length() > 0) {
                sb.append("<br>");
            }
            sb.append(sSIDokArten);
        }
        if (this.isTeilStecker()) {
            if (sb.length() > 0) {
                sb.append("<br>");
            }
            sb.append(sTooltipSteckerUndAnschlagteile);
        }
        if (sb.toString().length() < 1) {
            return sTeileinfo;
        }
        return sb.toString();
    }

    public void setMbIsSelected(boolean mbIsSelected) {
        this.mbIsSelected = mbIsSelected;
    }

    public boolean isMbIsSelected() {
        return this.mbIsSelected;
    }

    public int getAnkerPos() {
        return this.mnAnkerPos;
    }

    public void setAnkerPos(int mnAnkerPos) {
        this.mnAnkerPos = mnAnkerPos;
    }
}

