/*
 * Decompiled with CFR 0.152.
 */
package webetk.app.changepoints;

import java.io.Serializable;
import java.util.Collection;
import java.util.Vector;
import webetk.app.bteanzeige.Changepoint;
import webetk.app.changepoints.ChangepointException;

public class BTEChangepointList
implements Serializable,
Comparable<BTEChangepointList> {
    private String msBteNummer = null;
    private Collection<Changepoint> mcChangepointList = null;
    private static final long serialVersionUID = 1L;

    public BTEChangepointList(String sBteNummer) throws ChangepointException {
        if (sBteNummer == null || sBteNummer.length() == 0) {
            String message = "Bte-Nummer ist nicht gesetzt oder leer!";
            throw new ChangepointException("Bte-Nummer ist nicht gesetzt oder leer!");
        }
        this.msBteNummer = sBteNummer;
        this.mcChangepointList = new Vector<Changepoint>();
    }

    @Override
    public int compareTo(BTEChangepointList oBteChangepointList) {
        return this.msBteNummer.compareTo(oBteChangepointList.msBteNummer);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.msBteNummer == null ? 0 : this.msBteNummer.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BTEChangepointList other = (BTEChangepointList)obj;
        return !(this.msBteNummer == null ? other.msBteNummer != null : !this.msBteNummer.equals(other.msBteNummer));
    }

    public String getBteNummer() {
        return this.msBteNummer;
    }

    public void clear() {
        if (this.mcChangepointList == null) {
            this.mcChangepointList = new Vector<Changepoint>();
        }
        this.mcChangepointList.clear();
    }

    public void addChangepoint(Changepoint oChangepoint) throws ChangepointException {
        if (oChangepoint == null) {
            String message = "Changepoint ist nich gesetzt!";
            throw new ChangepointException("Changepoint ist nich gesetzt!");
        }
        this.mcChangepointList.add(oChangepoint);
    }

    public Collection<Changepoint> getChangepoints() {
        return this.mcChangepointList;
    }
}

