/*
 * Decompiled with CFR 0.152.
 */
package webetk.app.changepoints;

import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import webetk.app.bteanzeige.Changepoint;
import webetk.app.changepoints.BTEChangepointList;
import webetk.app.changepoints.ChangepointException;

public class ChangepointList
implements Serializable,
Comparable<ChangepointList> {
    private String msFgstNummer = null;
    private Map<String, BTEChangepointList> mcBteMap = null;
    private static final long serialVersionUID = 1L;

    public ChangepointList(String sFgstNummer) {
        this.msFgstNummer = sFgstNummer;
        this.mcBteMap = new HashMap<String, BTEChangepointList>();
    }

    @Override
    public int compareTo(ChangepointList oChangepointList) {
        return this.msFgstNummer.compareTo(oChangepointList.msFgstNummer);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.msFgstNummer == null ? 0 : this.msFgstNummer.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ChangepointList other = (ChangepointList)obj;
        return !(this.msFgstNummer == null ? other.msFgstNummer != null : !this.msFgstNummer.equals(other.msFgstNummer));
    }

    public String getFgstNummer() {
        return this.msFgstNummer;
    }

    public void clear() {
        if (this.mcBteMap == null) {
            this.mcBteMap = new HashMap<String, BTEChangepointList>();
        }
        this.mcBteMap.clear();
    }

    public void resetBTEList(String sBteNummer) throws ChangepointException {
        BTEChangepointList bteChangepointList;
        if (sBteNummer == null || sBteNummer.length() == 0) {
            String message = "BTE-Nummer ist nicht gesetzt oder leer!";
            throw new ChangepointException("BTE-Nummer ist nicht gesetzt oder leer!");
        }
        BTEChangepointList bTEChangepointList = bteChangepointList = this.exists(sBteNummer) ? this.mcBteMap.get(sBteNummer) : new BTEChangepointList(sBteNummer);
        if (bteChangepointList == null) {
            String message = "Ermittlung oder Erzeugung einer BTE-Changepoint Liste fehlgeschlagen!";
            throw new ChangepointException("Ermittlung oder Erzeugung einer BTE-Changepoint Liste fehlgeschlagen!");
        }
        bteChangepointList.clear();
    }

    public boolean exists(String sBteNummer) throws ChangepointException {
        if (sBteNummer == null || sBteNummer.length() == 0) {
            String message = "BTE-Nummer ist nicht gesetzt oder leer!";
            throw new ChangepointException("BTE-Nummer ist nicht gesetzt oder leer!");
        }
        return this.mcBteMap.containsKey(sBteNummer);
    }

    public void addBTEChangepointList(String sBteNummer, BTEChangepointList oList) throws ChangepointException {
        if (sBteNummer == null || sBteNummer.length() == 0) {
            String message = "BTE-Nummer ist nicht gesetzt oder leer!";
            throw new ChangepointException("BTE-Nummer ist nicht gesetzt oder leer!");
        }
        if (oList == null) {
            String message = "Changepoint-Liste fuer BTE-Nummer " + sBteNummer + " ist nicht gesetzt!";
            throw new ChangepointException(message);
        }
        if (!sBteNummer.equals(oList.getBteNummer())) {
            String message = "BTE-Nummer und BTE-Nummer der Changepoint-Liste stimmen nich ueberein!";
            throw new ChangepointException("BTE-Nummer und BTE-Nummer der Changepoint-Liste stimmen nich ueberein!");
        }
        if (this.mcBteMap.containsKey(sBteNummer)) {
            String message = "Fuer BTE-Nummer " + sBteNummer + " existiert schon eine ChangepointListe!";
            throw new ChangepointException(message);
        }
        this.mcBteMap.put(sBteNummer, oList);
    }

    public BTEChangepointList removeBTEChangepointList(String sBteNummer) throws ChangepointException {
        if (sBteNummer == null || sBteNummer.length() == 0) {
            String message = "BTE-Nummer ist nicht gesetzt oder leer!";
            throw new ChangepointException("BTE-Nummer ist nicht gesetzt oder leer!");
        }
        if (!this.exists(sBteNummer)) {
            return null;
        }
        return this.mcBteMap.remove(sBteNummer);
    }

    public void addChangepoint(String sBteNummer, Changepoint oChangepoint) throws ChangepointException {
        BTEChangepointList oBteChangepointList;
        if (sBteNummer == null || sBteNummer.length() == 0) {
            String message = "BTE-Nummer ist nicht gesetzt oder leer!";
            throw new ChangepointException("BTE-Nummer ist nicht gesetzt oder leer!");
        }
        if (oChangepoint == null) {
            String message = "Changepoint-Objekt ist nicht gesetzt!";
            throw new ChangepointException("Changepoint-Objekt ist nicht gesetzt!");
        }
        if (!this.exists(sBteNummer)) {
            oBteChangepointList = new BTEChangepointList(sBteNummer);
            this.addBTEChangepointList(sBteNummer, oBteChangepointList);
        }
        if ((oBteChangepointList = this.mcBteMap.get(sBteNummer)) == null) {
            String message = "Changepoint-Liste fuer BTE " + sBteNummer + " nicht gefunden!";
            throw new ChangepointException(message);
        }
        oBteChangepointList.addChangepoint(oChangepoint);
    }

    public boolean isBTEValid(String sBteNummer, Long lTypProddatum) throws ChangepointException {
        if (sBteNummer == null || sBteNummer.length() == 0) {
            String message = "BTE-Nummer ist nicht gesetzt oder leer!";
            throw new ChangepointException("BTE-Nummer ist nicht gesetzt oder leer!");
        }
        BTEChangepointList changepoints = this.mcBteMap.get(sBteNummer);
        if (changepoints == null) {
            return true;
        }
        if (lTypProddatum == null) {
            return true;
        }
        Collection<Changepoint> cChangepoints = changepoints.getChangepoints();
        if (cChangepoints == null || cChangepoints.isEmpty()) {
            return true;
        }
        Iterator<Changepoint> iter = cChangepoints.iterator();
        boolean bIsValid = true;
        while (iter.hasNext() && bIsValid) {
            Changepoint changepoint = iter.next();
            bIsValid = changepoint.auswertenChangepointDatum(lTypProddatum);
        }
        return bIsValid;
    }
}

