/*
 * Decompiled with CFR 0.152.
 */
package webetk.app.federtabelle;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Vector;
import org.apache.log4j.Logger;
import webetk.DatabaseBusyException;
import webetk.InvalidDataException;
import webetk.InvalidInitializationException;
import webetk.app.Bedingungsmenge;
import webetk.app.SucheInfo;
import webetk.app.bteanzeige.CurrentBTE;
import webetk.app.bteanzeige.RawZeile;
import webetk.app.federtabelle.PGTeil;
import webetk.app.federtabelle.PunkteSala;
import webetk.app.fzgid.FzgIdInfo;
import webetk.app.fzgsuche.FzgSucheInfo;

public class PunkteTyp {
    private static Logger log = Logger.getLogger(PunkteTyp.class);
    private long mlFTId = 0L;
    private String msTyp = null;
    private int mnPunkteVA_links = 0;
    private int mnPunkteVA_rechts = 0;
    private int mnPunkteHA_links = 0;
    private int mnPunkteHA_rechts = 0;
    private String istASPG;
    private List aspgKit = new ArrayList();

    public String getIstASPG() {
        if (this.istASPG == null) {
            return "";
        }
        return this.istASPG;
    }

    public void setIstASPG(String istASPG) {
        this.istASPG = istASPG;
    }

    public List getAspgKit() {
        return this.aspgKit;
    }

    public void setAspgKit(List aspgKit) {
        this.aspgKit = aspgKit;
    }

    public PunkteTyp(long lFTId, String sTyp, int nGrundpunkteVA_links, int nGrundpunkteVA_rechts, int nGrundpunkteHA_links, int nGrundpunkteHA_rechts) {
        this.mlFTId = lFTId;
        this.msTyp = sTyp;
        this.mnPunkteVA_links = nGrundpunkteVA_links;
        this.mnPunkteVA_rechts = nGrundpunkteVA_rechts;
        this.mnPunkteHA_links = nGrundpunkteHA_links;
        this.mnPunkteHA_rechts = nGrundpunkteHA_rechts;
    }

    public long getFTId() {
        return this.mlFTId;
    }

    public String getTyp() {
        return this.msTyp;
    }

    public int getPunkteVA_links() {
        return this.mnPunkteVA_links;
    }

    public int getPunkteVA_rechts() {
        return this.mnPunkteVA_rechts;
    }

    public int getPunkteHA_links() {
        return this.mnPunkteHA_links;
    }

    public int getPunkteHA_rechts() {
        return this.mnPunkteHA_rechts;
    }

    public void adjustPunkte(PunkteSala oPunkteSala) {
        this.mnPunkteVA_links += oPunkteSala.getPunkteVA_links();
        this.mnPunkteVA_rechts += oPunkteSala.getPunkteVA_rechts();
        this.mnPunkteHA_links += oPunkteSala.getPunkteHA_links();
        this.mnPunkteHA_rechts += oPunkteSala.getPunkteHA_rechts();
    }

    public List getAspgKitByAchse(String achse, int sessionMospID, FzgIdInfo fzgIdInfo, SucheInfo sucheInfo, Collection<Object> cSalaIds) throws SQLException, DatabaseBusyException {
        ArrayList<PGTeil> res = new ArrayList<PGTeil>();
        for (PGTeil pgTeil : this.aspgKit) {
            if (!pgTeil.getAchse().equals(achse)) continue;
            if (pgTeil.getMospID() == 0) {
                res.add(pgTeil);
                continue;
            }
            if (pgTeil.getMospID() != sessionMospID) continue;
            if (pgTeil.getBtNR().equals("") || sucheInfo == null) {
                res.add(pgTeil);
                continue;
            }
            Collection c = this.getKitFromBTE(pgTeil, fzgIdInfo, sucheInfo, cSalaIds);
            res.addAll(c);
        }
        return res;
    }

    private Collection getKitFromBTE(PGTeil pgTeil, FzgIdInfo fzgIdInfo, SucheInfo sucheInfo, Collection<Object> cSalaIds) throws SQLException, DatabaseBusyException {
        Vector<PGTeil> res = new Vector<PGTeil>();
        res.add(pgTeil);
        Boolean bVinIdentif = Boolean.TRUE;
        Boolean bUSATyp = fzgIdInfo.getRegion().equals("USA") ? Boolean.TRUE : Boolean.FALSE;
        FzgSucheInfo fzgSucheInfo = (FzgSucheInfo)sucheInfo;
        Bedingungsmenge beds = fzgSucheInfo.getBedingungsMenge();
        try {
            CurrentBTE bte = new CurrentBTE(" ", pgTeil.getBtNR(), fzgSucheInfo.getMarke(), fzgSucheInfo.getProduktart(), fzgSucheInfo.getKatalogumfang(), pgTeil.getMospID(), "de", true, false, bUSATyp, bVinIdentif, beds, true, true);
            bte.getBedingungen().setWerte(cSalaIds);
            bte.aktualisierenZeilen(fzgSucheInfo, null, null, false);
            Vector<RawZeile> zeilen = bte.getRawZeilenTemp();
            res = new Vector();
            boolean gefunden = false;
            for (RawZeile zeile : zeilen) {
                if (!gefunden) {
                    if (!pgTeil.getTeileNummer().equals(zeile.getTeilenummer()) || zeile.getBildnummer().equals("--")) continue;
                    gefunden = true;
                    res.add(pgTeil);
                    continue;
                }
                if (zeile.getBildnummer().equals("--")) {
                    PGTeil pgTeilPlus = new PGTeil();
                    pgTeil.setTeileNummer(zeile.getTeilenummer());
                    pgTeil.setBtNR(pgTeil.getBtNR());
                    pgTeil.setMospID(pgTeil.getMospID());
                    pgTeil.setAchse(pgTeil.getAchse());
                    pgTeil.setDiebstahlrelevant(pgTeil.isDiebstahlrelevant());
                    res.add(pgTeilPlus);
                    continue;
                }
                break;
            }
        }
        catch (InvalidInitializationException e) {
            log.error((Object)("Initialization BTE Error, BTE : " + pgTeil.getBtNR()), (Throwable)e);
        }
        catch (IllegalArgumentException e) {
            log.error((Object)("IllegalArgument BTE Error, BTE : " + pgTeil.getBtNR()), (Throwable)e);
        }
        catch (InvalidDataException e) {
            log.error((Object)("InvalidData BTE Error, BTE : " + pgTeil.getBtNR()), (Throwable)e);
        }
        return res;
    }
}

