/*
 * Decompiled with CFR 0.152.
 */
package webetk.app.fuellmengen;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;
import webetk.DatabaseBusyException;
import webetk.NoDataFoundException;
import webetk.WebetkUtils;
import webetk.app.ServerGlobalObjects;
import webetk.app.fuellmengen.FMZeile;
import webetk.db.dbaccess.FuellmengenDbAccess;

@XmlRootElement
@XmlAccessorType(value=XmlAccessType.FIELD)
public class FMZeilen {
    @XmlTransient
    private static Logger log = Logger.getLogger(FMZeilen.class);
    private List<FMZeile> mcZeilen = new ArrayList<FMZeile>();
    @XmlTransient
    private Iterator miZeilen = null;
    @XmlTransient
    private FMZeile moZeile;

    public FMZeilen() {
    }

    public FMZeilen(String sLang, Collection cTypen, String sZulassungsmonat, String sBaujahr) throws SQLException, DatabaseBusyException, NoDataFoundException {
        this.mcZeilen.clear();
        this.miZeilen = null;
        this.moZeile = null;
        this.performLoad(sLang, cTypen, sZulassungsmonat, sBaujahr);
    }

    public void first() {
        if (this.mcZeilen != null) {
            this.miZeilen = this.mcZeilen.iterator();
            if (this.miZeilen.hasNext()) {
                try {
                    this.moZeile = (FMZeile)this.miZeilen.next();
                }
                catch (ClassCastException e) {
                    log.error((Object)"Store object in row collection is no FMZeile!", (Throwable)e);
                    this.moZeile = null;
                }
            } else {
                this.moZeile = null;
            }
        } else {
            this.miZeilen = null;
            this.moZeile = null;
        }
    }

    public void next() {
        if (this.miZeilen != null && this.miZeilen.hasNext()) {
            try {
                this.moZeile = (FMZeile)this.miZeilen.next();
            }
            catch (ClassCastException e) {
                log.error((Object)"Store object in row collection is no FMZeile!", (Throwable)e);
                this.moZeile = null;
            }
        } else {
            log.log((Priority)Level.ALL, (Object)"No more Zeilen.");
        }
    }

    public boolean hasNext() {
        return this.miZeilen != null && this.miZeilen.hasNext();
    }

    public boolean isEmpty() {
        return this.mcZeilen.isEmpty();
    }

    public boolean isValidPosition() {
        return this.mcZeilen == null || this.mcZeilen.size() == 0 || this.miZeilen == null || this.moZeile == null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void performLoad(String sLang, Collection cTypen, String sZulassungsmonat, String sBaujahr) throws SQLException, DatabaseBusyException, NoDataFoundException {
        ServerGlobalObjects gObj = ServerGlobalObjects.getInstance();
        Connection con = null;
        ResultSet res = null;
        try {
            con = gObj.getDBConnection("FMZeilen.performLoad");
            log.debug((Object)"Loading F\u00fcllmengen-Zeilen...");
            res = FuellmengenDbAccess.retrieveFuellmengen(con, sLang, cTypen, sZulassungsmonat, sBaujahr);
            while (res != null && res.next()) {
                String sTyp = res.getString("Typ");
                String sGetriebe = res.getString("Getriebe");
                String sMotor = res.getString("Motor");
                String sFMGetriebe = res.getString("FMGetriebe");
                String sFMMotor = res.getString("FMMotor");
                String sFMHinterachse = res.getString("FMHinterachse");
                String sFMKuehlmittelMitAC = res.getString("FMKuehlmittelMitAC");
                String sFMKuehlmittelOhneAC = res.getString("FMKuehlmittelOhneAC");
                String sFMBremse = res.getString("FMBremse");
                String sHinweis = res.getString("Hinweis");
                FMZeile oZeile = new FMZeile(sTyp, sGetriebe, sMotor, sFMGetriebe, sFMMotor, sFMHinterachse, sFMKuehlmittelMitAC, sFMKuehlmittelOhneAC, sFMBremse, sHinweis);
                this.mcZeilen.add(oZeile);
            }
        }
        catch (Throwable throwable) {
            WebetkUtils.closeQuery(res);
            gObj.freeDBConnection(con, "FMZeilen.performLoad");
            throw throwable;
        }
        WebetkUtils.closeQuery(res);
        gObj.freeDBConnection(con, "FMZeilen.performLoad");
    }

    public String getCurrentTyp() {
        if (this.moZeile == null) {
            return "";
        }
        return this.moZeile.getTyp();
    }

    public String getCurrentGetriebe() {
        if (this.moZeile == null) {
            return "";
        }
        return this.moZeile.getGetriebe();
    }

    public String getCurrentMotor() {
        if (this.moZeile == null) {
            return "";
        }
        return this.moZeile.getMotor();
    }

    public String getCurrentFMGetriebe() {
        if (this.moZeile == null) {
            return "";
        }
        return this.moZeile.getFMGetriebe();
    }

    public String getCurrentFMMotor() {
        if (this.moZeile == null) {
            return "";
        }
        return this.moZeile.getFMMotor();
    }

    public String getCurrentFMHinterachse() {
        if (this.moZeile == null) {
            return "";
        }
        return this.moZeile.getFMHinterachse();
    }

    public String getCurrentFMKuehlmittelMitAC() {
        if (this.moZeile == null) {
            return "";
        }
        return this.moZeile.getFMKuehlmittelMitAC();
    }

    public String getCurrentFMKuehlmittelOhneAC() {
        if (this.moZeile == null) {
            return "";
        }
        return this.moZeile.getFMKuehlmittelOhneAC();
    }

    public String getCurrentFMBremse() {
        if (this.moZeile == null) {
            return "";
        }
        return this.moZeile.getFMBremse();
    }

    public String getCurrentHinweis() {
        if (this.moZeile == null) {
            return "";
        }
        return this.moZeile.getHinweis();
    }

    public List<FMZeile> getZeilen() {
        return this.mcZeilen;
    }
}

