/*
 * Decompiled with CFR 0.152.
 */
package webetk.app.interpretation;

import java.io.Serializable;
import java.util.Collection;
import java.util.Vector;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import webetk.WebetkUtils;
import webetk.utils.StringUtils;

@XmlRootElement
@XmlAccessorType(value=XmlAccessType.FIELD)
public class IZeile
implements Serializable {
    @XmlTransient
    private static final long serialVersionUID = 1L;
    private String msSachnummer = null;
    private String msTeilenummer = null;
    private String msBenennung = null;
    private String msEntfallDatum = null;
    private boolean mbIstZuBestellen = false;
    private int mnStrukturnummer = -1;
    private boolean mbIstBlatt = false;
    private boolean mbIstVisible = true;
    private boolean mbIstExpandiert = true;
    private Collection<String> maMarke = new Vector<String>();
    private Double mdLagerbestand = null;

    public IZeile() {
        this.msSachnummer = "";
        this.msTeilenummer = "";
        this.msBenennung = "";
        this.msEntfallDatum = "";
        this.mbIstZuBestellen = false;
        this.mnStrukturnummer = -1;
        this.mbIstBlatt = false;
        this.mbIstExpandiert = true;
        this.mbIstVisible = true;
    }

    public IZeile(String sSachnummer, String sTeilenummer, String sBenennung, long lEntfallDatum, boolean bIstZuBestellen, String sMarke, int nStrukturnummer) {
        this.msSachnummer = sSachnummer;
        this.msTeilenummer = sTeilenummer.equalsIgnoreCase("") ? sTeilenummer : (sTeilenummer.length() == 11 ? WebetkUtils.formatiereTeilenummer(sTeilenummer) : sTeilenummer);
        this.msBenennung = sBenennung;
        this.msEntfallDatum = lEntfallDatum == 0L ? "" : WebetkUtils.getStringFromDate(WebetkUtils.getDateFromLong(lEntfallDatum), "de", 2);
        this.mbIstZuBestellen = bIstZuBestellen;
        this.mnStrukturnummer = nStrukturnummer;
        this.mbIstBlatt = false;
        this.mbIstExpandiert = true;
        this.mbIstVisible = true;
        this.appendMarke(sMarke);
    }

    public String getSachnummer(boolean bFormatiert) {
        if (this.msSachnummer == null || this.msSachnummer.equalsIgnoreCase("")) {
            return "";
        }
        if (!bFormatiert) {
            return this.msSachnummer;
        }
        return this.msSachnummer.substring(0, 1) + " " + this.msSachnummer.substring(1, 4) + " " + this.msSachnummer.substring(4, 7);
    }

    public String getTeilenummer() {
        if (this.msTeilenummer == null || this.msTeilenummer.equalsIgnoreCase("")) {
            return "";
        }
        return this.msTeilenummer;
    }

    public String getTeilenummerUnformatiert() {
        if (this.msTeilenummer == null) {
            return "";
        }
        return StringUtils.substituteStringStraight(this.msTeilenummer, " ", "");
    }

    public String getBenennung() {
        if (this.msBenennung == null || this.msBenennung.equalsIgnoreCase("")) {
            return "";
        }
        return this.msBenennung;
    }

    public String getTooltip() {
        String sTooltip = this.getBenennung();
        if (!this.getEntfallDatum().equals("")) {
            sTooltip = sTooltip + " " + this.getEntfallDatum();
        }
        return sTooltip;
    }

    public String getEntfallDatum() {
        if (this.msEntfallDatum == null || this.msEntfallDatum.equalsIgnoreCase("")) {
            return "";
        }
        return this.msEntfallDatum;
    }

    public boolean istZuBestellen() {
        return this.mbIstZuBestellen;
    }

    public int getStrukturnummer() {
        return this.mnStrukturnummer;
    }

    public boolean istBlatt() {
        return this.mbIstBlatt;
    }

    public void istBlatt(boolean bIstBlatt) {
        this.mbIstBlatt = bIstBlatt;
    }

    public boolean istVisible() {
        return this.mbIstVisible;
    }

    public void istVisible(boolean bIstVisible) {
        this.mbIstVisible = bIstVisible;
    }

    public boolean istExpandiert() {
        return this.mbIstExpandiert;
    }

    public void istExpandiert(boolean bIstExpandiert) {
        this.mbIstExpandiert = bIstExpandiert;
    }

    public String getInterneId() {
        return this.toString();
    }

    public String getLagerbestand() {
        if (this.mdLagerbestand == null) {
            return "";
        }
        return this.mdLagerbestand.toString();
    }

    public void setLagerbestand(Double dLagerbestand) {
        this.mdLagerbestand = dLagerbestand;
    }

    public void appendMarke(String sMarke) {
        if (this.maMarke == null) {
            this.maMarke = new Vector<String>();
            this.maMarke.add(sMarke);
            return;
        }
        for (String elem : this.maMarke) {
            if (!sMarke.equalsIgnoreCase(elem)) continue;
            return;
        }
        this.maMarke.add(sMarke);
    }

    public Collection<String> getMarken() {
        return this.maMarke;
    }
}

