/*
 * Decompiled with CFR 0.152.
 */
package webetk.app.interpretation;

import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import java.util.Vector;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;
import webetk.app.interpretation.IZeile;

@XmlRootElement
@XmlAccessorType(value=XmlAccessType.FIELD)
public class IZeilen
implements Serializable {
    @XmlTransient
    private static final long serialVersionUID = 1L;
    private Collection<IZeile> mcZeilen = new Vector<IZeile>();
    private transient Iterator<IZeile> miZeilen = null;
    private IZeile moZeile;
    private int mnTitelCounter = 0;
    @XmlTransient
    private static Logger log = Logger.getLogger(IZeilen.class);

    public IZeilen() {
    }

    public IZeilen(Collection<IZeile> cZeilen) {
        this.mcZeilen = cZeilen;
    }

    public void first() {
        if (this.mcZeilen != null) {
            this.miZeilen = this.mcZeilen.iterator();
            if (this.miZeilen.hasNext()) {
                try {
                    this.moZeile = this.miZeilen.next();
                }
                catch (ClassCastException e) {
                    log.error((Object)"Store object in row collection is no IZeile!", (Throwable)e);
                    this.moZeile = null;
                }
            } else {
                this.moZeile = null;
            }
        } else {
            this.miZeilen = null;
            this.moZeile = null;
        }
        this.mnTitelCounter = 0;
    }

    public void reset() {
        if (this.mcZeilen != null) {
            this.miZeilen = this.mcZeilen.iterator();
            this.moZeile = null;
        } else {
            this.miZeilen = null;
            this.moZeile = null;
        }
        this.mnTitelCounter = 0;
    }

    public void next() {
        if (this.miZeilen != null && this.miZeilen.hasNext()) {
            try {
                this.moZeile = this.miZeilen.next();
            }
            catch (ClassCastException e) {
                log.error((Object)"Store object in row collection is no IZeile!", (Throwable)e);
                this.moZeile = null;
                return;
            }
            if (++this.mnTitelCounter == 15) {
                this.mnTitelCounter = 0;
            }
        } else {
            log.log((Priority)Level.ALL, (Object)"No more Zeilen.");
        }
    }

    public boolean hasNext() {
        return this.miZeilen != null && this.miZeilen.hasNext();
    }

    public boolean isEmpty() {
        return this.mcZeilen == null || this.mcZeilen.size() == 0;
    }

    public boolean isValidPosition() {
        return this.mcZeilen == null || this.mcZeilen.size() == 0 || this.miZeilen == null || this.moZeile == null;
    }

    public boolean isTitel() {
        return this.mnTitelCounter == 0;
    }

    public String getCurrentSachnummer(boolean bFormatiert) {
        if (this.moZeile == null) {
            return "";
        }
        return this.moZeile.getSachnummer(bFormatiert);
    }

    public String getCurrentTeilenummer() {
        if (this.moZeile == null) {
            return "";
        }
        return this.moZeile.getTeilenummer();
    }

    public String getTeilenummerUnformatiert() {
        if (this.moZeile == null) {
            return "";
        }
        return this.moZeile.getTeilenummerUnformatiert();
    }

    public String getCurrentBenennung() {
        if (this.moZeile == null) {
            return "";
        }
        return this.moZeile.getBenennung();
    }

    public String getCurrentTooltip() {
        if (this.moZeile == null) {
            return "";
        }
        return this.moZeile.getTooltip();
    }

    public String getCurrentEntfallDatum() {
        if (this.moZeile == null) {
            return "";
        }
        return this.moZeile.getEntfallDatum();
    }

    public int getCurrentStrukturnummer() {
        if (this.moZeile == null) {
            return -1;
        }
        return this.moZeile.getStrukturnummer();
    }

    public int getCurrentBestand() {
        if (this.moZeile == null) {
            return -1;
        }
        return Integer.parseInt(this.moZeile.getLagerbestand());
    }

    public boolean istCurrentZuBestellen() {
        if (this.moZeile == null) {
            return false;
        }
        return this.moZeile.istZuBestellen();
    }

    public boolean istCurrentBlatt() {
        if (this.moZeile == null) {
            return false;
        }
        return this.moZeile.istBlatt();
    }

    public boolean istCurrentExpandiert() {
        if (this.moZeile == null) {
            return false;
        }
        return this.moZeile.istExpandiert();
    }

    public boolean istCurrentVisible() {
        if (this.moZeile == null) {
            return false;
        }
        return this.moZeile.istVisible();
    }

    public String getCurrentInterneId() {
        if (this.moZeile == null) {
            return "";
        }
        return this.moZeile.getInterneId();
    }

    public String getMarke() {
        if (this.moZeile == null) {
            return "";
        }
        Collection<String> cMarken = this.moZeile.getMarken();
        if (cMarken.size() >= 1) {
            return (String)cMarken.toArray()[0];
        }
        return "";
    }

    public String getLagerbestand() {
        if (this.moZeile == null) {
            return "";
        }
        return this.moZeile.getLagerbestand();
    }

    public void setLagerbestand(Double dLagerbestand) {
        if (this.moZeile != null) {
            this.moZeile.setLagerbestand(dLagerbestand);
        }
    }

    public void insertFirst(IZeile oZeile) {
        Vector<IZeile> cCopy = new Vector<IZeile>(this.mcZeilen);
        this.mcZeilen.clear();
        this.mcZeilen.add(oZeile);
        this.mcZeilen.addAll(cCopy);
    }
}

