/*
 * Decompiled with CFR 0.152.
 */
package webetk.app.konfiguration;

import java.io.Serializable;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import org.apache.log4j.Logger;
import webetk.DatabaseBusyException;
import webetk.InvalidDataException;
import webetk.WebetkUtils;
import webetk.app.ServerGlobalObjects;
import webetk.db.dbaccess.KonfigurationDbAccess;

@XmlRootElement
@XmlAccessorType(value=XmlAccessType.FIELD)
public class Filiale
implements Serializable {
    @XmlTransient
    private static final long serialVersionUID = 1L;
    @XmlTransient
    private static Logger log = Logger.getLogger(Filiale.class);
    private String msId = null;
    protected String msBezeichnung = null;
    private String msIdFirma = null;
    private String msBezeichnungFirma = null;
    private String msISO = null;
    private String msRegISO = null;
    private Boolean mbIsSingleFiliale = null;

    public Filiale() {
    }

    public Filiale(String sId, String sBezeichnung, String sFirmaId) {
        this.msId = sId;
        this.msBezeichnung = sBezeichnung;
        this.msIdFirma = sFirmaId;
    }

    public Filiale(String sFilialId, String sFirmaId) {
        this.msId = sFilialId;
        this.msIdFirma = sFirmaId;
    }

    public Filiale(String sId, String sBezeichnung, String sFirmaId, String sIso, String sRegiso) {
        this.msId = sId;
        this.msBezeichnung = sBezeichnung;
        this.msIdFirma = sFirmaId;
        this.msISO = sIso;
        this.msRegISO = sRegiso;
    }

    public String getId() {
        return this.msId;
    }

    public String getBezeichnung() {
        return this.msBezeichnung;
    }

    public String getIdFirma() {
        return this.msIdFirma;
    }

    public String getBezeichnungFirma() {
        return this.msBezeichnungFirma;
    }

    public String getISO() {
        return this.msISO;
    }

    public String getRegISO() {
        return this.msRegISO;
    }

    public Boolean isSingleFiliale() {
        return this.mbIsSingleFiliale;
    }

    public void writeToDB(Connection con) throws SQLException, DatabaseBusyException {
        log.info((Object)("Creating new Filiale: " + this.msBezeichnung));
        KonfigurationDbAccess.createFiliale(con, this.msId, this.msBezeichnung, this.msIdFirma, this.msISO, this.msRegISO);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delete() throws SQLException, DatabaseBusyException {
        ServerGlobalObjects gObj = ServerGlobalObjects.getInstance();
        log.info((Object)("Deleting Filiale: " + this.msId));
        Connection con = null;
        try {
            con = gObj.getDBConnectionNutzer("Filiale.delete");
            KonfigurationDbAccess.deleteFiliale(con, this.msId, this.msIdFirma);
        }
        finally {
            ServerGlobalObjects.getInstance().freeDBConnectionNutzer(con, "Filiale.delete");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update() throws SQLException, DatabaseBusyException {
        ServerGlobalObjects gObj = ServerGlobalObjects.getInstance();
        log.info((Object)("Updating Filiale: " + this.msBezeichnung));
        Connection con = null;
        try {
            con = gObj.getDBConnectionNutzer("Filiale.update");
            KonfigurationDbAccess.updateFiliale(con, this.msId, this.msBezeichnung, this.msIdFirma, this.msISO, this.msRegISO);
        }
        finally {
            gObj.freeDBConnectionNutzer(con, "Filiale.update");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load() throws InvalidDataException, SQLException, DatabaseBusyException {
        if (this.msIdFirma == null || this.msId == null) {
            throw new InvalidDataException("keine Firma oder Filiale vorhanden");
        }
        ServerGlobalObjects gObj = ServerGlobalObjects.getInstance();
        log.info((Object)("Load Filiale: " + this.msId + " zu Firma " + this.msIdFirma));
        Connection con = null;
        ResultSet res = null;
        try {
            con = gObj.getDBConnectionNutzer("Filiale.load");
            res = KonfigurationDbAccess.getFilialeInfo(con, this.msIdFirma, this.msId);
            if (res.next()) {
                this.msBezeichnungFirma = res.getString("FirmaBezeichnung");
                this.msBezeichnung = res.getString("FilialeBezeichnung");
                this.msISO = res.getString("SpracheISO");
                this.msRegISO = res.getString("SpracheRegISO");
            }
            this.mbIsSingleFiliale = new Boolean(KonfigurationDbAccess.hatFirmaNurEineFiliale(con, this.msIdFirma));
        }
        catch (Throwable throwable) {
            WebetkUtils.closeQuery(res);
            gObj.freeDBConnectionNutzer(con, "Filiale.load");
            throw throwable;
        }
        WebetkUtils.closeQuery(res);
        gObj.freeDBConnectionNutzer(con, "Filiale.load");
    }
}

