/*
 * Decompiled with CFR 0.152.
 */
package webetk.app.lagerzeit;

import java.io.Serializable;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.apache.log4j.Logger;
import webetk.DatabaseBusyException;
import webetk.NoDataFoundException;
import webetk.WebetkUtils;
import webetk.app.BlaetternButton;
import webetk.app.ComplexTypeAdapter;
import webetk.app.GenericTeil;
import webetk.app.ServerGlobalObjects;
import webetk.db.dbaccess.LagerzeitDbAccess;

@XmlRootElement
@XmlAccessorType(value=XmlAccessType.FIELD)
public class Lagerzeit
implements Serializable {
    @XmlTransient
    private static final long serialVersionUID = 1L;
    @XmlTransient
    private static Logger log = Logger.getLogger(Lagerzeit.class);
    private int mnIndexAkt = -1;
    private String msAktHG;
    private String msMarke;
    private String msBisHG;
    private String msTeileUebernehmen;
    private String msProduktart;
    private String msAbHG;
    @XmlJavaTypeAdapter(value=ComplexTypeAdapter.class)
    private Vector mcHGs = new Vector();
    @XmlJavaTypeAdapter(value=ComplexTypeAdapter.class)
    private Vector mcTeile = new Vector();
    private int mnAnzahl = 0;
    private Collection<BlaetternButton> mcBlaetterButtonInfo = new Vector<BlaetternButton>();

    public String getAktHG() {
        return this.msAktHG;
    }

    public void setAktHG(String sAktHG) {
        this.msAktHG = sAktHG;
    }

    public String getMarke() {
        return this.msMarke;
    }

    public void setMarke(String sMarke) {
        this.msMarke = sMarke;
    }

    public Collection getTeile(int nIndex) {
        if (nIndex < 0 || nIndex >= this.mcTeile.size()) {
            return new Vector();
        }
        return (Collection)this.mcTeile.get(nIndex);
    }

    public Collection getTeile() {
        return this.getTeile(this.mnIndexAkt);
    }

    public void setTeile(Vector cTeile) {
        this.mcTeile = cTeile;
    }

    public Vector getHGs() {
        return this.mcHGs;
    }

    public void setHGs(Vector cHGs) {
        this.mcHGs = cHGs;
    }

    public Collection getHGHashtables() {
        Vector cHGHashtables = new Vector();
        Iterator iter = this.mcHGs.iterator();
        int nLfdNr = 0;
        while (iter.hasNext()) {
            Hashtable<String, String> objHashtable = new Hashtable<String, String>();
            String sLfdNr = String.valueOf(++nLfdNr);
            objHashtable.put("LfdNr", sLfdNr);
            objHashtable.put("HG", (String)iter.next());
            cHGHashtables.add(objHashtable);
        }
        return cHGHashtables;
    }

    public Collection getTeileHashtableCollection(int nIndex) {
        Vector<Hashtable<String, String>> cTeile = new Vector<Hashtable<String, String>>();
        Collection cTeileSrc = this.getTeile(nIndex);
        Iterator iter = cTeileSrc.iterator();
        int nLfdNr = 0;
        while (iter.hasNext()) {
            GenericTeil objTeil = (GenericTeil)iter.next();
            Hashtable<String, String> objHashtable = objTeil.getHashtable();
            String sLfdNr = String.valueOf(++nLfdNr);
            objHashtable.put("LfdNr", sLfdNr);
            if ((nLfdNr - 1) % 15 == 0) {
                objHashtable.put("hatUeberschrift", "J");
            }
            cTeile.add(objHashtable);
        }
        return cTeile;
    }

    public Collection getTeileHashtableCollection() {
        return this.getTeileHashtableCollection(this.mnIndexAkt);
    }

    public String getTeileUebernehmen() {
        return this.msTeileUebernehmen;
    }

    public void setTeileUebernehmen(String sTeileUebernehmen) {
        this.msTeileUebernehmen = sTeileUebernehmen;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> loadHGs(String sHGVon, String sHGBis, String sMarke, String sProduktart) throws NoDataFoundException, SQLException, DatabaseBusyException {
        ArrayList<String> arrayList;
        ServerGlobalObjects globs = ServerGlobalObjects.getInstance();
        log.debug((Object)"Accessing database ...");
        Connection con = null;
        ResultSet res = null;
        try {
            con = globs.getDBConnection("Lagerzeit.loadHGs");
            log.debug((Object)"Executing query ...");
            res = LagerzeitDbAccess.selectHGs(con, sHGVon, sHGBis, sMarke, sProduktart);
            ArrayList<String> retval = new ArrayList<String>();
            if (res == null || !res.next()) {
                throw new NoDataFoundException("No values found");
            }
            while (res != null) {
                String sValue = res.getString("HG");
                retval.add(sValue);
                if (res.next()) continue;
                break;
            }
            arrayList = retval;
        }
        catch (Throwable throwable) {
            WebetkUtils.closeQuery(res);
            globs.freeDBConnection(con, "Lagerzeit.loadHGs");
            throw throwable;
        }
        WebetkUtils.closeQuery(res);
        globs.freeDBConnection(con, "Lagerzeit.loadHGs");
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadTeile(String sSprache, String sHG, String sMarke, String sProduktart, String sUserKatalogumfang, String sLandkuerzel) throws SQLException, DatabaseBusyException {
        ServerGlobalObjects globs = ServerGlobalObjects.getInstance();
        log.debug((Object)"Accessing database ...");
        Connection con = null;
        ResultSet res = null;
        try {
            con = globs.getDBConnection("Lagerzeit.loadTeile");
            log.debug((Object)"Executing query ...");
            res = LagerzeitDbAccess.selectTeile(con, sSprache, sHG, sMarke, sProduktart, sUserKatalogumfang, sLandkuerzel);
            int nCounter = 0;
            this.mnAnzahl = 0;
            Vector<GenericTeil> cTeile = null;
            while (res != null && res.next()) {
                String sC;
                GenericTeil objTeil = new GenericTeil();
                ++this.mnAnzahl;
                String sValue = res.getString("HG");
                objTeil.setHG(sValue);
                sValue = res.getString("UG");
                objTeil.setUG(sValue);
                sValue = res.getString("SACHNR");
                objTeil.setSachnummer(sValue);
                sValue = res.getString("BENENNUNG");
                objTeil.setBenennung(sValue);
                sValue = res.getString("ZUSATZ");
                if (sValue == null) {
                    sValue = "";
                }
                objTeil.setZusatz(sValue);
                String sSi = res.getString("SI");
                String sPi = res.getString("PI");
                String sIdKommentar = res.getString("BENKOMMENTARID");
                boolean bIsReach = res.getString("REACH") != null && res.getString("REACH").equals("J");
                boolean bIsAspg = res.getString("ASPG") != null && res.getString("ASPG").equals("J");
                String sI = "";
                if (sSi != null && sSi.equals("J") || sIdKommentar != null && !sIdKommentar.equals("0") || sPi != null || bIsReach) {
                    sI = "I";
                }
                sC = (sC = res.getString("TC")) != null && sC.equals("C") ? "C" : "";
                objTeil.setZI(sI + sC);
                if (res.getString("Teil_Diebstahlrelevant") != null) {
                    objTeil.setIsTeilDiebstahlrelevant(res.getString("Teil_Diebstahlrelevant"));
                } else {
                    objTeil.setIsTeilDiebstahlrelevant("N");
                }
                if (nCounter == 0) {
                    cTeile = new Vector<GenericTeil>();
                    this.mcTeile.add(cTeile);
                }
                cTeile.add(objTeil);
                if (++nCounter != 100) continue;
                nCounter = 0;
            }
        }
        catch (Throwable throwable) {
            WebetkUtils.closeQuery(res);
            globs.freeDBConnection(con, "Lagerzeit.loadTeile");
            throw throwable;
        }
        WebetkUtils.closeQuery(res);
        globs.freeDBConnection(con, "Lagerzeit.loadTeile");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean checkNoHG() throws SQLException, DatabaseBusyException {
        ResultSet res;
        Connection con;
        ServerGlobalObjects globs;
        block4: {
            boolean bl;
            globs = ServerGlobalObjects.getInstance();
            if (this.msAbHG.length() == 0 || !this.msAbHG.equals(this.msBisHG)) {
                return false;
            }
            con = null;
            res = null;
            try {
                con = globs.getDBConnection("Lagerzeit.checkNoHG");
                log.debug((Object)"Executing query ...");
                res = LagerzeitDbAccess.findHG(con, this.msAbHG);
                if (res != null && res.next()) break block4;
                bl = true;
            }
            catch (Throwable throwable) {
                WebetkUtils.closeQuery(res);
                globs.freeDBConnection(con, "Lagerzeit.loadTeile");
                throw throwable;
            }
            WebetkUtils.closeQuery(res);
            globs.freeDBConnection(con, "Lagerzeit.loadTeile");
            return bl;
        }
        boolean bl = false;
        WebetkUtils.closeQuery(res);
        globs.freeDBConnection(con, "Lagerzeit.loadTeile");
        return bl;
    }

    public String getAbHG() {
        return this.msAbHG;
    }

    public void setAbHG(String sAbHG) {
        this.msAbHG = sAbHG;
    }

    public String getBisHG() {
        return this.msBisHG;
    }

    public void setBisHG(String sBisHG) {
        this.msBisHG = sBisHG;
    }

    public String getProduktart() {
        return this.msProduktart;
    }

    public void setProduktart(String sProduktart) {
        this.msProduktart = sProduktart;
    }

    public void setAktuellenIndex(int nIndex) {
        this.mnIndexAkt = nIndex;
    }

    public int getAnzahlTeile() {
        return this.mnAnzahl;
    }

    public int getAnzahlPakete() {
        return this.mcTeile.size();
    }

    public void setBlaetterButtonInfo(Collection cBlaetterButtonInfo) {
        this.mcBlaetterButtonInfo = cBlaetterButtonInfo;
    }

    public Collection getBlaetterButtonInfo() {
        return this.mcBlaetterButtonInfo;
    }

    public Collection getBlaetterButtonCollection() {
        Vector cButtonInfo = new Vector();
        for (BlaetternButton oButton : this.mcBlaetterButtonInfo) {
            if (oButton == null) continue;
            Hashtable<String, String> oHashtable = new Hashtable<String, String>();
            oHashtable.put("Index", Integer.toString(oButton.getIndex()));
            oHashtable.put("Beschriftung", oButton.getBeschriftung());
            if (oButton.isSensitiv()) {
                oHashtable.put("isSensitiv", "J");
            }
            cButtonInfo.add(oHashtable);
        }
        return cButtonInfo;
    }
}

