/*
 * Decompiled with CFR 0.152.
 */
package webetk.app.normteile;

import java.io.Serializable;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Vector;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.apache.log4j.Logger;
import webetk.DatabaseBusyException;
import webetk.NoDataFoundException;
import webetk.WebetkUtils;
import webetk.app.ServerGlobalObjects;
import webetk.app.normteile.Grafik;
import webetk.app.normteile.Teil;
import webetk.app.normteile.VectorHashtableAdapter;
import webetk.db.dbaccess.NormteileDbAccess;
import webetk.framework.ServerUserInfo;

@XmlRootElement
@XmlAccessorType(value=XmlAccessType.FIELD)
public class Normteile
implements Serializable {
    @XmlTransient
    private static final long serialVersionUID = 1L;
    @XmlTransient
    private static Logger log = Logger.getLogger(Normteile.class);
    private String msMarke;
    private String msProduktart;
    private String msSprache;
    private boolean mbGrafikenSindGruppen = true;
    @XmlJavaTypeAdapter(value=VectorHashtableAdapter.class)
    private Vector<Hashtable<String, String>> mcNormteilebenennungen = new Vector();
    private Vector<Grafik> mcGrafiken = new Vector();
    @XmlJavaTypeAdapter(value=VectorHashtableAdapter.class)
    private Vector<Hashtable<String, String>> mcTeile = new Vector();

    public Normteile() {
    }

    public Normteile(String sMarke, String sProduktart, String sSprache) {
        this.msMarke = sMarke;
        this.msProduktart = sProduktart;
        this.msSprache = sSprache;
        this.mbGrafikenSindGruppen = true;
        this.mcNormteilebenennungen = null;
        this.mcGrafiken = null;
        this.mcTeile = null;
    }

    public Normteile(ServerUserInfo objUserInfo, String sSprache) {
        this.msMarke = objUserInfo.getMarke();
        this.msProduktart = objUserInfo.getProduktart();
        this.msSprache = sSprache;
        this.mbGrafikenSindGruppen = true;
        this.mcNormteilebenennungen = null;
        this.mcGrafiken = null;
        this.mcTeile = null;
    }

    public String getMarke() {
        return this.msMarke;
    }

    public String getProduktart() {
        return this.msProduktart;
    }

    public Collection getNormteileBenennungen() {
        return this.mcNormteilebenennungen;
    }

    public Collection getGrafiken() {
        return this.mcGrafiken;
    }

    public Collection getTeile() {
        return this.mcTeile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadNormteilebenennungen() throws SQLException, DatabaseBusyException {
        ResultSet res;
        Connection con;
        ServerGlobalObjects globs;
        block10: {
            globs = ServerGlobalObjects.getInstance();
            log.debug((Object)"Accessing database ...");
            con = null;
            res = null;
            con = globs.getDBConnection("Normteile.loadNormteilebenennungen");
            log.debug((Object)"Executing query ...");
            res = NormteileDbAccess.loadNormteileBenennungen(con, this.msMarke, this.msProduktart, this.msSprache);
            this.mcNormteilebenennungen = new Vector();
            if (res != null && res.next()) break block10;
            WebetkUtils.closeQuery(res);
            globs.freeDBConnection(con, "Normteile.loadNormteilebenennungen");
            return;
        }
        try {
            int nLfdNr = 0;
            String sLastBen = "";
            String sBenIDs = "";
            Hashtable<String, String> objHashtable = null;
            while (res != null) {
                String sBen = res.getString("BENENNUNG");
                long lID = res.getLong("TEXTCODE");
                String sID = String.valueOf(lID);
                if (!sBen.equals(sLastBen)) {
                    sLastBen = sBen;
                    ++nLfdNr;
                    if (objHashtable != null) {
                        objHashtable.put("BenIDs", sBenIDs);
                        this.mcNormteilebenennungen.add(objHashtable);
                    }
                    objHashtable = new Hashtable<String, String>();
                    sBenIDs = "";
                    if ((nLfdNr - 1) % 15 == 0) {
                        objHashtable.put("hatUeberschrift", "J");
                    }
                    objHashtable.put("Benennung", sBen);
                    sBenIDs = sBenIDs + sID + "_";
                } else {
                    sBenIDs = sBenIDs + sID + "_";
                }
                if (res.next()) continue;
                if (objHashtable != null) {
                    objHashtable.put("BenIDs", sBenIDs);
                }
                if ((++nLfdNr - 1) % 15 == 0) {
                    objHashtable.put("hatUeberschrift", "J");
                }
                this.mcNormteilebenennungen.add(objHashtable);
            }
        }
        catch (Throwable throwable) {
            WebetkUtils.closeQuery(res);
            globs.freeDBConnection(con, "Normteile.loadNormteilebenennungen");
            throw throwable;
        }
        WebetkUtils.closeQuery(res);
        globs.freeDBConnection(con, "Normteile.loadNormteilebenennungen");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadGrafiken(String sNormnummernGruppe) throws SQLException, DatabaseBusyException {
        ResultSet res;
        Connection con;
        ServerGlobalObjects globs;
        block6: {
            globs = ServerGlobalObjects.getInstance();
            log.debug((Object)"Accessing database ...");
            this.mbGrafikenSindGruppen = sNormnummernGruppe == null;
            con = null;
            res = null;
            con = globs.getDBConnection("Normteile.loadGrafiken");
            log.debug((Object)"Executing query ...");
            res = NormteileDbAccess.loadGrafikInfos(con, this.msMarke, this.msProduktart, sNormnummernGruppe);
            this.mcGrafiken = new Vector();
            if (res != null && res.next()) break block6;
            WebetkUtils.closeQuery(res);
            globs.freeDBConnection(con, "Normteile.loadNormteile");
            return;
        }
        try {
            while (res != null) {
                String sNummer = res.getString("NUMMER");
                String sID = res.getString("GRAFIKID");
                String sAltText = "";
                if (sNormnummernGruppe != null) {
                    String sArt = res.getString("ART");
                    sAltText = sArt + " " + sNummer;
                } else {
                    sAltText = sNummer;
                }
                long lTimestamp = res.getLong("TS");
                Grafik objGrafik = new Grafik(sID, sNummer, sAltText, lTimestamp);
                this.mcGrafiken.add(objGrafik);
                if (res.next()) continue;
            }
        }
        catch (Throwable throwable) {
            WebetkUtils.closeQuery(res);
            globs.freeDBConnection(con, "Normteile.loadNormteile");
            throw throwable;
        }
        WebetkUtils.closeQuery(res);
        globs.freeDBConnection(con, "Normteile.loadNormteile");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadNormteile(String sNormnummer, Vector aBenIDs) throws SQLException, DatabaseBusyException, NoDataFoundException {
        ServerGlobalObjects globs = ServerGlobalObjects.getInstance();
        log.debug((Object)"Accessing database ...");
        Connection con = null;
        ResultSet res = null;
        try {
            con = globs.getDBConnection("Normteile.loadNormteile");
            log.debug((Object)"Executing query ...");
            res = NormteileDbAccess.loadNormteile(con, this.msMarke, this.msProduktart, this.msSprache, sNormnummer, aBenIDs);
            this.mcTeile = new Vector();
            if (res == null || !res.next()) {
                throw new NoDataFoundException();
            }
            int nLfdNr = 0;
            while (res != null) {
                ++nLfdNr;
                Teil objTeil = new Teil();
                String sValue = res.getString("MARKE");
                objTeil.setMarke(sValue);
                sValue = res.getString("PRODUKTART");
                objTeil.setProduktart(sValue);
                sValue = res.getString("HG");
                objTeil.setHG(sValue);
                sValue = res.getString("UG");
                objTeil.setUG(sValue);
                sValue = res.getString("SACHNUMMER");
                objTeil.setSachnummer(sValue);
                sValue = res.getString("BENENNUNG");
                objTeil.setBenennung(sValue);
                sValue = res.getString("ZUSATZ");
                if (sValue == null) {
                    sValue = "";
                }
                objTeil.setZusatz(sValue);
                sValue = res.getString("NORMART");
                if (sValue == null) {
                    sValue = "";
                }
                objTeil.setNormart(sValue);
                sValue = res.getString("NORMNUMMER");
                if (sValue == null) {
                    sValue = "";
                }
                objTeil.setNormnummer(sValue);
                if (res.getString("Teil_Diebstahlrelevant") != null) {
                    objTeil.setIsTeilDiebstahlrelevant(res.getString("Teil_Diebstahlrelevant"));
                } else {
                    objTeil.setIsTeilDiebstahlrelevant("N");
                }
                Hashtable<String, String> objHashtable = objTeil.getHashtable();
                String sLfdNr = String.valueOf(nLfdNr);
                objHashtable.put("LfdNr", sLfdNr);
                if ((nLfdNr - 1) % 15 == 0) {
                    objHashtable.put("hatUeberschrift", "J");
                }
                this.mcTeile.add(objHashtable);
                if (res.next()) continue;
            }
        }
        catch (Throwable throwable) {
            WebetkUtils.closeQuery(res);
            globs.freeDBConnection(con, "Normteile.loadNormteile");
            throw throwable;
        }
        WebetkUtils.closeQuery(res);
        globs.freeDBConnection(con, "Normteile.loadNormteile");
    }

    public boolean getGrafikenSindGruppen() {
        return this.mbGrafikenSindGruppen;
    }
}

