/*
 * Decompiled with CFR 0.152.
 */
package webetk.app.teilevwdgben;

import java.io.Serializable;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.apache.log4j.Logger;
import webetk.DatabaseBusyException;
import webetk.WebetkUtils;
import webetk.app.SearchBTETeile;
import webetk.app.ServerGlobalObjects;
import webetk.app.SucheInfo;
import webetk.app.asssuche.AssSucheInfo;
import webetk.db.dbaccess.TeileVwdgBenDbAccess;
import webetk.framework.ServerSessionInfo;

@XmlRootElement
@XmlType(name="webetk.app.teilevwdgben.BTESuche")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class BTESuche
extends SearchBTETeile
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static Logger log = Logger.getLogger(BTESuche.class);
    private Collection mcSuchTeile = null;
    private Collection mcRegionen = null;

    public BTESuche() {
    }

    public BTESuche(Collection cTeile, Collection cRegionen) {
        this.mcSuchTeile = cTeile;
        this.mcRegionen = cRegionen;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int performSearch(SucheInfo oSucheInfo, String sLang, ServerSessionInfo oServerSessionInfo) throws SQLException, DatabaseBusyException {
        ServerGlobalObjects gObj = ServerGlobalObjects.getInstance();
        if (!(oSucheInfo instanceof AssSucheInfo)) {
            log.error((Object)"oSucheInfo is no instance of AssSucheInfo!");
            return 4;
        }
        AssSucheInfo oAssSucheInfo = (AssSucheInfo)oSucheInfo;
        boolean bIGDOM = oSucheInfo.isIGDOM();
        this.mcBTEs.clear();
        this.mcTeile.clear();
        oSucheInfo.setSuchSachnummern(this.mcSuchTeile);
        Connection con = null;
        ResultSet res = null;
        try {
            con = gObj.getDBConnection("TeileSuche.performSearch");
            String sMarke = oAssSucheInfo.getMarke();
            String sProduktart = oAssSucheInfo.getProduktart();
            String sKatalogumfang = oAssSucheInfo.getKatalogumfang();
            res = TeileVwdgBenDbAccess.searchBildtafel_SNrs(con, this.mcSuchTeile, sLang, sMarke, sProduktart, sKatalogumfang, this.mcRegionen);
            while (res != null && res.next()) {
                SearchBTETeile.PartOrBTE obj = BTESuche.readResultIntoBte(res, sLang, sProduktart, null, bIGDOM);
                this.mcBTEs.add(obj);
            }
        }
        catch (Throwable throwable) {
            WebetkUtils.closeQuery(res);
            gObj.freeDBConnection(con, "TeileSuche.performSearch");
            throw throwable;
        }
        WebetkUtils.closeQuery(res);
        gObj.freeDBConnection(con, "TeileSuche.performSearch");
        return this.mcBTEs.size() == 0 ? 4 : 1;
    }
}

