/*
 * Decompiled with CFR 0.152.
 */
package webetk.app.teilevwdgben;

import java.io.Serializable;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.apache.log4j.Logger;
import webetk.DatabaseBusyException;
import webetk.WebetkUtils;
import webetk.app.SearchBTETeile;
import webetk.app.ServerGlobalObjects;
import webetk.app.SucheInfo;
import webetk.app.asssuche.AssSucheInfo;
import webetk.db.dbaccess.TeileVwdgBenDbAccess;
import webetk.framework.ServerSessionInfo;

@XmlRootElement
@XmlType(name="webetk.app.teilevwdgben.TVBenennungSuche")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class TVBenennungSuche
extends SearchBTETeile
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static Logger log = Logger.getLogger(TVBenennungSuche.class);
    private String msBenennungInit;
    private String msBenennung;

    public TVBenennungSuche() {
    }

    public TVBenennungSuche(String sBenennung) {
        this.msBenennungInit = sBenennung;
        if (sBenennung.charAt(sBenennung.length() - 1) != '*') {
            sBenennung = sBenennung + "*";
        }
        this.msBenennung = sBenennung;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int performSearch(SucheInfo oSucheInfo, String sLang, ServerSessionInfo oServerSessionInfo) throws SQLException, DatabaseBusyException {
        ServerGlobalObjects gObj = ServerGlobalObjects.getInstance();
        if (!(oSucheInfo instanceof AssSucheInfo)) {
            log.error((Object)"oSucheInfo is no instance of AssSucheInfo!");
            return 4;
        }
        AssSucheInfo oAssSucheInfo = (AssSucheInfo)oSucheInfo;
        oSucheInfo.setSuchBenennung(this.msBenennungInit);
        this.mcBTEs.clear();
        this.mcTeile.clear();
        Connection con = null;
        ResultSet res = null;
        try {
            con = gObj.getDBConnection("BenennungSuche.performSearch");
            String sMarke = oAssSucheInfo.getMarke();
            String sProduktart = oAssSucheInfo.getProduktart();
            String sKatUmfang = oAssSucheInfo.getKatalogumfang();
            res = TeileVwdgBenDbAccess.searchSachnummern_TVBenennung(con, this.msBenennung, sLang, sMarke, sProduktart, sKatUmfang);
            while (res != null && res.next()) {
                String sHG = res.getString("Hauptgruppe");
                String sUG = res.getString("Untergruppe");
                String sSachnummer = res.getString("Sachnummer");
                String sTeilenummer = sHG + sUG + sSachnummer;
                String sBenennung = res.getString("Benennung");
                String sZusatz = res.getString("Zusatz");
                String sBenennungKommentar = res.getString("BenennungKommentar");
                String sDiebstahlrelevant = res.getString("Teil_Diebstahlrelevant");
                SearchBTETeile.PartOrBTE obj = new SearchBTETeile.PartOrBTE(sTeilenummer, sBenennung, sZusatz, sBenennungKommentar, sDiebstahlrelevant);
                this.mcTeile.add(obj);
            }
        }
        catch (Throwable throwable) {
            WebetkUtils.closeQuery(res);
            gObj.freeDBConnection(con, "BenennungSuche.performSearch");
            throw throwable;
        }
        WebetkUtils.closeQuery(res);
        gObj.freeDBConnection(con, "BenennungSuche.performSearch");
        if (this.mcBTEs.size() == 0 && this.mcTeile.size() == 0) {
            return 4;
        }
        if (this.mcBTEs.size() != 0 && this.mcTeile.size() != 0) {
            return 3;
        }
        if (this.mcBTEs.size() != 0 && this.mcTeile.size() == 0) {
            return 1;
        }
        return 2;
    }
}

