/*
 * Decompiled with CFR 0.152.
 */
package webetk.app.teilevwdgben;

import java.io.Serializable;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;
import webetk.DatabaseBusyException;
import webetk.NoDataFoundException;
import webetk.WebetkUtils;
import webetk.app.ComplexTypeAdapter;
import webetk.app.ServerGlobalObjects;
import webetk.app.teilevwdgteil.Baureihe;
import webetk.app.teilevwdgteil.Modellspalte;
import webetk.app.teilevwdgteil.Teilevwdgteil;
import webetk.db.dbaccess.TeileVwdgBenDbAccess;
import webetk.framework.ServerUserInfo;
import webetk.mrkprd.Produkte;

@XmlRootElement
@XmlAccessorType(value=XmlAccessType.FIELD)
public class Teilevwdgben
implements Serializable {
    @XmlTransient
    private static final long serialVersionUID = 1L;
    @XmlTransient
    private static Logger log = Logger.getLogger(Teilevwdgteil.class);
    private String msMarke = null;
    private String msProduktart = null;
    private String msKatalogumfang = null;
    private String msModellspaltenIDs = null;
    private String msSuchbegriff = null;
    @XmlJavaTypeAdapter(value=ComplexTypeAdapter.class)
    private Vector mZeilen = null;
    private List<Baureihe> mBaureihen = new ArrayList<Baureihe>();
    @XmlJavaTypeAdapter(value=ComplexTypeAdapter.class)
    private Vector mMospZeilenUngefiltert = null;
    private List<String> mcSachnummern = new ArrayList<String>();
    private String mSelPrimaerMarktIso;
    @XmlJavaTypeAdapter(value=ComplexTypeAdapter.class)
    private Collection mSelSonstigeMaerkteIsos;

    public Teilevwdgben() {
    }

    public Teilevwdgben(String sUserId, String sMarke, String sProduktart, String sKatalogumfang, String sSuchbegriff, List<String> cSachnummer) {
        this.msMarke = sMarke;
        this.msProduktart = sProduktart;
        this.msKatalogumfang = sKatalogumfang;
        this.mcSachnummern = cSachnummer;
        this.msModellspaltenIDs = null;
        this.msSuchbegriff = sSuchbegriff;
        this.mcSachnummern = cSachnummer;
        this.mBaureihen = new ArrayList<Baureihe>();
    }

    public Teilevwdgben(String sFirmaId, String sUserId, String sMarke, String sProduktart, String sKatalogumfang, String sModellspaltenIDs, String sSuchbegriff, List<String> cSachnummer) {
        this.msMarke = sMarke;
        this.msProduktart = sProduktart;
        this.msKatalogumfang = sKatalogumfang;
        this.msSuchbegriff = sSuchbegriff;
        this.msModellspaltenIDs = sModellspaltenIDs;
        this.mcSachnummern = cSachnummer;
        this.mBaureihen = new ArrayList<Baureihe>();
    }

    public Teilevwdgben(ServerUserInfo userInfo) {
        log.log((Priority)Level.ALL, (Object)("Initializing Teilevwdgteil with defaults from: " + userInfo.toString()));
        this.msMarke = userInfo.getMarke();
        this.msProduktart = userInfo.getProduktart();
        this.msKatalogumfang = userInfo.getKatalogumfang();
        this.mBaureihen = new ArrayList<Baureihe>();
    }

    public String getMarke() {
        return this.msMarke;
    }

    public String getProduktart() {
        return this.msProduktart;
    }

    public String getKatalogumfang() {
        return this.msKatalogumfang;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadBaureihen(String sExpBaureihe, String sSprache, Collection<String> cRegionen) throws SQLException, DatabaseBusyException, NoDataFoundException {
        ServerGlobalObjects globs = ServerGlobalObjects.getInstance();
        log.debug((Object)"Accessing database ...");
        Connection con = null;
        ResultSet resBR = null;
        ResultSet resMosp = null;
        Vector<Baureihe> cBaureihen = new Vector<Baureihe>();
        Vector<Modellspalte> cModellspalten = new Vector<Modellspalte>();
        try {
            con = globs.getDBConnection("Teilevwdgteil.loadBaureihen");
            String sExpExtBaureihe = null;
            if (this.msSuchbegriff != null) {
                resBR = TeileVwdgBenDbAccess.loadBaureihen(con, this.msSuchbegriff, this.msMarke, this.msProduktart, this.msKatalogumfang, sSprache, cRegionen);
            }
            if (this.mcSachnummern != null) {
                resBR = TeileVwdgBenDbAccess.loadBaureihenTNR(con, this.mcSachnummern, this.msModellspaltenIDs, this.msMarke, this.msProduktart, this.msKatalogumfang, sSprache, cRegionen);
            }
            if (resBR == null || !resBR.next()) {
                throw new NoDataFoundException();
            }
            while (resBR != null) {
                String sBaureihe = resBR.getString("BAUREIHE");
                String sExtBaureihe = resBR.getString("EXT_BAUREIHE");
                boolean bExpandiert = false;
                if (sBaureihe.equals(sExpBaureihe)) {
                    bExpandiert = true;
                    sExpExtBaureihe = sExtBaureihe;
                }
                Baureihe objBaureihe = new Baureihe(sBaureihe, sExtBaureihe, bExpandiert);
                cBaureihen.add(objBaureihe);
                if (resBR.next()) continue;
                break;
            }
            if (sExpBaureihe != null && !sExpBaureihe.equals("")) {
                if (this.msSuchbegriff != null) {
                    resMosp = TeileVwdgBenDbAccess.loadModellspalten(con, this.msSuchbegriff, this.msModellspaltenIDs, sExpBaureihe, this.msMarke, this.msProduktart, this.msKatalogumfang, sSprache, cRegionen);
                }
                if (this.mcSachnummern != null) {
                    resMosp = TeileVwdgBenDbAccess.loadModellspaltenTNR(con, this.mcSachnummern, this.msModellspaltenIDs, sExpBaureihe, this.msMarke, this.msProduktart, this.msKatalogumfang, sSprache, cRegionen);
                }
                if (resMosp == null || !resMosp.next()) {
                    throw new NoDataFoundException();
                }
                while (resMosp != null) {
                    Object[] aModellspalten;
                    Object objPrevZeile;
                    Modellspalte objPrevMosp;
                    Modellspalte objModellspalte = new Modellspalte();
                    objModellspalte.setBaureihe(sExpExtBaureihe);
                    objModellspalte.setBaureiheID(sExpBaureihe);
                    String sValue = resMosp.getString("MODELL");
                    objModellspalte.setModell(sValue);
                    sValue = resMosp.getString("KAROSSERIE");
                    objModellspalte.setKarosserie(sValue);
                    sValue = this.msProduktart.equals(Produkte.getInstance().getProdukt("AUTO").getBerechtigung()) ? resMosp.getString("KAROSSERIE_ID") : resMosp.getString("BAUART");
                    objModellspalte.setBauartKarosserieID(sValue);
                    sValue = resMosp.getString("REGION");
                    objModellspalte.setRegion(sValue);
                    sValue = resMosp.getString("BTNR");
                    objModellspalte.setBTNummer(sValue);
                    sValue = resMosp.getString("BTUEBERSCHRIFT");
                    objModellspalte.setBTUeberschrift(sValue);
                    String sKommentar = resMosp.getString("Kommentar");
                    String sCPVorhanden = resMosp.getString("CPVorhanden");
                    boolean bCPVorhanden = sCPVorhanden.equals("J");
                    String sBedignungKZ = resMosp.getString("BedingungKZ");
                    boolean bHasInfo = sKommentar != null || bCPVorhanden || sBedignungKZ != null;
                    objModellspalte.hasBtInfo(bHasInfo);
                    String sMarktIso = resMosp.getString("MarktIso");
                    objModellspalte.setMarkt(sMarktIso);
                    if (this.mcSachnummern != null) {
                        String sMenge = resMosp.getString("MENGE");
                        objModellspalte.setMenge(sMenge);
                    }
                    boolean bAddZeile = true;
                    if (!cModellspalten.isEmpty() && (objPrevMosp = (Modellspalte)(objPrevZeile = (aModellspalten = cModellspalten.toArray())[aModellspalten.length - 1])).equalsIgnoreMenge(objModellspalte)) {
                        objPrevMosp.setMenge("*");
                        bAddZeile = false;
                    }
                    if (bAddZeile) {
                        cModellspalten.add(objModellspalte);
                    }
                    if (resMosp.next()) continue;
                    break;
                }
            }
            this.mZeilen = new Vector();
            this.mMospZeilenUngefiltert = new Vector();
            for (Baureihe oBaureihe : cBaureihen) {
                String sBaureihe = (String)oBaureihe.getHashtable().get("ID");
                this.mZeilen.add(oBaureihe);
                this.mBaureihen.add(oBaureihe);
                if (!sBaureihe.equals(sExpBaureihe)) continue;
                for (Modellspalte mosp : cModellspalten) {
                    this.mZeilen.add(mosp);
                    oBaureihe.addModellspalte(mosp);
                    this.mMospZeilenUngefiltert.add(mosp);
                }
            }
        }
        catch (Throwable throwable) {
            WebetkUtils.closeQuery(resBR);
            WebetkUtils.closeQuery(resMosp);
            globs.freeDBConnection(con, "Teilevwdgteil.loadTeil");
            throw throwable;
        }
        WebetkUtils.closeQuery(resBR);
        WebetkUtils.closeQuery(resMosp);
        globs.freeDBConnection(con, "Teilevwdgteil.loadTeil");
    }

    public String getSuchbegriff() {
        if (this.msSuchbegriff != null) {
            return this.msSuchbegriff;
        }
        return "";
    }

    public Collection getModellspaltenZeilen() {
        Vector cZeilen = new Vector();
        if (this.mZeilen != null) {
            for (Object objZeile : this.mZeilen) {
                if (!(objZeile instanceof Modellspalte)) continue;
                cZeilen.add(objZeile);
            }
        }
        return cZeilen;
    }

    public Collection getModellspaltenZeilenUngefiltert() {
        return this.mMospZeilenUngefiltert;
    }

    public void setModellspaltenZeilen(Collection<?> cZeilen) {
        int nIndexAkt = -1;
        int nIndexFirstMosp = -1;
        Vector toRemove = new Vector();
        if (this.mZeilen != null) {
            Iterator iter = this.mZeilen.iterator();
            while (iter.hasNext()) {
                ++nIndexAkt;
                Object objZeile = iter.next();
                if (objZeile instanceof Baureihe) {
                    Baureihe br = (Baureihe)objZeile;
                    if (!br.getExpandiert()) continue;
                    nIndexFirstMosp = nIndexAkt + 1;
                    continue;
                }
                if (!(objZeile instanceof Modellspalte)) continue;
                toRemove.add(objZeile);
            }
            this.mZeilen.removeAll(toRemove);
            this.mZeilen.addAll(nIndexFirstMosp, cZeilen);
        }
    }

    public Collection getZeilenHashtableCollection() {
        Vector<Hashtable<String, String>> cZeilen = new Vector<Hashtable<String, String>>();
        if (this.mZeilen != null) {
            Iterator iter = this.mZeilen.iterator();
            int nLfdNr = 0;
            while (iter.hasNext()) {
                ++nLfdNr;
                Hashtable<String, String> objHashtable = null;
                Object objZeile = iter.next();
                if (objZeile instanceof Baureihe) {
                    Baureihe objBaureihe = (Baureihe)objZeile;
                    objHashtable = objBaureihe.getHashtable();
                    objHashtable.put("istBaureihe", "J");
                } else {
                    if (!(objZeile instanceof Modellspalte)) continue;
                    Modellspalte objModellspalte = (Modellspalte)objZeile;
                    objHashtable = objModellspalte.getHashtable();
                    objHashtable.put("istModellspalte", "J");
                }
                String sLfdNr = String.valueOf(nLfdNr);
                objHashtable.put("LfdNr", sLfdNr);
                if ((nLfdNr - 1) % 15 == 0) {
                    objHashtable.put("hatUeberschrift", "J");
                }
                cZeilen.add(objHashtable);
            }
        }
        return cZeilen;
    }

    public List<Baureihe> getBaureihen() {
        return this.mBaureihen;
    }

    public String getSelPrimaerMarktIso() {
        return this.mSelPrimaerMarktIso;
    }

    public void setSelPrimaerMarktIso(String selPrimaerMarktIso) {
        this.mSelPrimaerMarktIso = selPrimaerMarktIso;
    }

    public Collection getSelSonstigeMaerkteIsos() {
        return this.mSelSonstigeMaerkteIsos;
    }

    public void setSelSonstigeMaerkteIsos(Collection selSonstigeMaerkteIsos) {
        this.mSelSonstigeMaerkteIsos = selSonstigeMaerkteIsos;
    }

    public boolean habenBildtafelnLokaleMaerkte() {
        return this.mZeilen != null;
    }
}

