/*
 * Decompiled with CFR 0.152.
 */
package webetk.app.zub.marketing;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import webetk.app.ComplexTypeAdapter;
import webetk.app.bteinfo.Info;
import webetk.app.zub.common.BaseMarketingProdukt;
import webetk.app.zub.common.Preise;
import webetk.app.zub.common.Zubehoergrafik;
import webetk.app.zub.suche.Bnb;
import webetk.app.zub.suche.HitListenUnterkategorie;
import webetk.app.zub.suche.ProduktListenElement;
import webetk.app.zub.suche.Variante;

@XmlRootElement
@XmlAccessorType(value=XmlAccessType.FIELD)
public class MarketingProdukt
extends BaseMarketingProdukt
implements Serializable,
Comparable<Object>,
Cloneable {
    @XmlTransient
    private static final long serialVersionUID = 1L;
    List<Bnb> mBestandTeile = new ArrayList<Bnb>();
    List<Bnb> mAlternativen = new ArrayList<Bnb>();
    List<Bnb> mEinzelteile = new ArrayList<Bnb>();
    List<Variante> mVarianten = new ArrayList<Variante>();
    @XmlJavaTypeAdapter(value=ComplexTypeAdapter.class)
    HashMap mVariantenZuAlternativen = new HashMap();
    @XmlJavaTypeAdapter(value=ComplexTypeAdapter.class)
    HashMap mVariantenZuBestandteile = new HashMap();
    @XmlJavaTypeAdapter(value=ComplexTypeAdapter.class)
    HashMap mVariantenZuEinzelteile = new HashMap();
    @XmlJavaTypeAdapter(value=ComplexTypeAdapter.class)
    Hashtable<String, ArrayList<Integer>> mVariantenZuRelevantenBildposNr = new Hashtable();
    @XmlJavaTypeAdapter(value=ComplexTypeAdapter.class)
    List mZusatzProdukte = new ArrayList();
    ArrayList<Bnb> selectedBnbsMitVarianten = new ArrayList();
    @XmlJavaTypeAdapter(value=ComplexTypeAdapter.class)
    List mHilfsBetriebsStoffe = new ArrayList();
    List<Zubehoergrafik> mImages = new ArrayList<Zubehoergrafik>();
    Zubehoergrafik mThumbnail = null;
    boolean mFahrzeugUngebunden;
    Info bteKommentar;
    String mSelectedAlternativeId;
    String mSelectedVariantenId;
    HitListenUnterkategorie unterkategorie;

    public List<Bnb> getAlternativen() {
        return this.mAlternativen;
    }

    public void setAlternativen(List<Bnb> alternativen) {
        this.mAlternativen = alternativen;
    }

    public List<Bnb> getBestandTeile() {
        return this.mBestandTeile;
    }

    public void setBestandTeile(List<Bnb> bestandTeile) {
        this.mBestandTeile = bestandTeile;
    }

    public List<Zubehoergrafik> getImages() {
        return this.mImages;
    }

    public void setImages(List images) {
        this.mImages = images;
    }

    public Zubehoergrafik getThumbnail() {
        return this.mThumbnail;
    }

    public void setThumbnail(Zubehoergrafik thumbnail) {
        this.mThumbnail = thumbnail;
    }

    public void setVarianten(List<Variante> varianten) {
        this.mVarianten = varianten;
    }

    public List getZusatzProdukte() {
        return this.mZusatzProdukte;
    }

    public void setZusatzProdukte(List zusatzProdukte) {
        this.mZusatzProdukte = zusatzProdukte;
    }

    @Override
    public int hashCode() {
        int PRIME = 31;
        int result = 1;
        result = 31 * result + this.getBteNr().hashCode();
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MarketingProdukt other = (MarketingProdukt)obj;
        if (this.mBteNr != null) {
            if (other.mBteNr == null) {
                return false;
            }
            if (!this.mBteNr.equals(other.mBteNr)) {
                return false;
            }
        }
        return true;
    }

    public MarketingProdukt() {
    }

    public MarketingProdukt(BaseMarketingProdukt baseProdukt) {
        super(baseProdukt.getBteNr(), baseProdukt.getProduktName(), baseProdukt.getNavigationName(), baseProdukt.getTeaser(), baseProdukt.getDetailText());
    }

    @Override
    public int compareTo(Object object) {
        if (object instanceof MarketingProdukt) {
            return this.getBteNr().compareTo(((MarketingProdukt)object).getBteNr());
        }
        if (object instanceof String) {
            return this.getBteNr().compareTo(object.toString());
        }
        return 0;
    }

    public Collection<String> getRelevanteBildposNr() {
        Bnb oBnb;
        int i;
        this.mVariantenZuRelevantenBildposNr = new Hashtable();
        Vector<String> aRelevantBildposNr = new Vector<String>();
        for (i = 0; i < this.selectedBnbsMitVarianten.size(); ++i) {
            oBnb = this.selectedBnbsMitVarianten.get(i);
            String bildPosNr = oBnb.getBildPos();
            if (!aRelevantBildposNr.contains(bildPosNr)) {
                aRelevantBildposNr.add(oBnb.getBildPos());
            }
            if (oBnb.getSelectedVariante() == null || oBnb.getSelectedVariante().getVarianteId() == 0) continue;
            if (this.mVariantenZuRelevantenBildposNr.get(oBnb.getBildPos()) == null) {
                ArrayList<Integer> varList = new ArrayList<Integer>();
                varList.add(new Integer(oBnb.getSelectedVariante().getVarianteId()));
                this.mVariantenZuRelevantenBildposNr.put(bildPosNr, varList);
                continue;
            }
            this.mVariantenZuRelevantenBildposNr.get(bildPosNr).add(new Integer(oBnb.getSelectedVariante().getVarianteId()));
        }
        if (this.mHilfsBetriebsStoffe != null) {
            for (i = 0; i < this.mHilfsBetriebsStoffe.size(); ++i) {
                oBnb = (Bnb)this.mHilfsBetriebsStoffe.get(i);
                aRelevantBildposNr.add(oBnb.getBildPos());
            }
        }
        return aRelevantBildposNr;
    }

    public Hashtable<String, ArrayList<Integer>> getVariantenZuRelevantenBildposNr() {
        return this.mVariantenZuRelevantenBildposNr;
    }

    public Object clone() throws CloneNotSupportedException {
        MarketingProdukt produkt = new MarketingProdukt();
        produkt.setBildPosNr(this.getBildPosNr());
        produkt.setBteNr(this.getBteNr());
        produkt.setDetailText(this.getDetailText());
        produkt.setNavigationName(this.getNavigationName());
        produkt.setProduktName(this.getProduktName());
        produkt.setTeaser(this.getTeaser());
        produkt.setFahrzeugUngebunden(this.isFahrzeugUngebunden());
        produkt.setNutzen(this.getNutzen());
        produkt.setPiasZusatzProdukte(this.getPiasZusatzProdukte());
        produkt.setTippsUndTricks(this.getTippsUndTricks());
        produkt.setWeitergehendeInformationen(this.getWeitergehendeInformationen());
        produkt.setWettbewerb(this.getWettbewerb());
        produkt.setZusatzNutzen(this.getZusatzNutzen());
        produkt.setKundeninformationen(this.getKundeninformationen());
        produkt.setWerbungAktionen(this.getWerbungAktionen());
        produkt.setShopDisplaysUndAndere(this.getShopDisplaysUndAndere());
        produkt.setRestriktionen(this.getRestriktionen());
        produkt.setPiasKommentar(this.getPiasKommentar());
        ArrayList<Bnb> alternativen = new ArrayList<Bnb>();
        for (Bnb bnb : this.getAlternativen()) {
            alternativen.add((Bnb)bnb.clone());
        }
        produkt.setAlternativen(alternativen);
        ArrayList<Bnb> bestandTeile = new ArrayList<Bnb>();
        for (Bnb bnb : this.getBestandTeile()) {
            bestandTeile.add((Bnb)bnb.clone());
        }
        produkt.setBestandTeile(bestandTeile);
        ArrayList<Zubehoergrafik> images = new ArrayList<Zubehoergrafik>();
        for (Zubehoergrafik grafik : this.getImages()) {
            images.add((Zubehoergrafik)grafik.clone());
        }
        ArrayList<Bnb> bnbVarianten = new ArrayList<Bnb>();
        for (Bnb bnb : this.getSelectedBnbsMitVarianten()) {
            bnbVarianten.add((Bnb)bnb.clone());
        }
        return super.clone();
    }

    public boolean isFahrzeugUngebunden() {
        return this.mFahrzeugUngebunden;
    }

    public void setFahrzeugUngebunden(boolean fahrzeugUngebunden) {
        this.mFahrzeugUngebunden = fahrzeugUngebunden;
    }

    public List getHilfsBetriebsStoffe() {
        return this.mHilfsBetriebsStoffe;
    }

    public void setHilfsBetriebsStoffe(List hilfsBetriebsStoffe) {
        this.mHilfsBetriebsStoffe = hilfsBetriebsStoffe;
    }

    public Info getBteKommentar() {
        return this.bteKommentar;
    }

    public void setBteKommentar(Info bteKommentar) {
        this.bteKommentar = bteKommentar;
    }

    public HashMap getVariantenZuAlternativen() {
        return this.mVariantenZuAlternativen;
    }

    public void setVariantenZuAlternativen(HashMap variantenZuAlternativen) {
        this.mVariantenZuAlternativen = variantenZuAlternativen;
    }

    public HashMap getVariantenZuBestandteile() {
        return this.mVariantenZuBestandteile;
    }

    public void setVariantenZuBestandteile(HashMap variantenZuBestandteile) {
        this.mVariantenZuBestandteile = variantenZuBestandteile;
    }

    public void ermittlePreiseZusatzprodukte(Preise preise) {
        if (preise != null) {
            for (ProduktListenElement el : this.mZusatzProdukte) {
                el.setPrice(preise.getAbPreis(el.getBildPosNr(), null));
            }
        }
    }

    public List<Variante> getAlleVarianten() {
        return this.mVarianten;
    }

    public List getVariantenZuSelectedAlter() {
        List varianten = new ArrayList();
        if (this.mVariantenZuAlternativen != null && this.mVariantenZuAlternativen.size() > 0 && this.mSelectedAlternativeId != null && this.mSelectedAlternativeId != "") {
            varianten = (List)this.mVariantenZuAlternativen.get(this.mSelectedAlternativeId);
        }
        return varianten;
    }

    public String getSelectedAlternativeId() {
        return this.mSelectedAlternativeId;
    }

    public void setSelectedAlternativeId(String selectedAlternativeId) {
        this.mSelectedAlternativeId = selectedAlternativeId;
    }

    public String getSelectedVariantenId() {
        return this.mSelectedVariantenId;
    }

    public void setSelectedVariantenId(String selectedVariantenId) {
        this.mSelectedVariantenId = selectedVariantenId;
    }

    public ArrayList<Bnb> getSelectedBnbsMitVarianten() {
        return this.selectedBnbsMitVarianten;
    }

    public void setSelectedBnbsMitVarianten(ArrayList<Bnb> selectedBnbVarianten) {
        this.selectedBnbsMitVarianten = selectedBnbVarianten;
    }

    public HitListenUnterkategorie getUnterkategorie() {
        return this.unterkategorie;
    }

    public void setUnterkategorie(HitListenUnterkategorie unterkategorie) {
        this.unterkategorie = unterkategorie;
    }

    public List<Bnb> getEinzelteile() {
        return this.mEinzelteile;
    }

    public void setEinzelteile(List<Bnb> einzelteile) {
        this.mEinzelteile = einzelteile;
    }

    public HashMap getVariantenZuEinzelteile() {
        return this.mVariantenZuEinzelteile;
    }

    public void setVariantenZuEinzelteile(HashMap variantenZuEinzelteile) {
        this.mVariantenZuEinzelteile = variantenZuEinzelteile;
    }
}

