/*
 * Decompiled with CFR 0.152.
 */
package webetk.app.zub.technisch;

import java.io.Serializable;
import java.util.ArrayList;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import webetk.app.zub.technisch.EinbauInfo;
import webetk.app.zub.technisch.NPZ;

@XmlRootElement
@XmlAccessorType(value=XmlAccessType.FIELD)
public class Bauteil
implements Serializable,
Comparable,
Cloneable {
    @XmlTransient
    static final long serialVersionUID = 1L;
    String mTeilenummer;
    String mPos;
    String mElementArt;
    String mBenennung;
    String mBemerkung;
    int mMenge;
    int mBestand;
    Double mEinzelPreis;
    float mMwStSatz;
    boolean mKommentarVorhanden;
    boolean mBteBauteil;
    boolean mAktiv;
    EinbauInfo mEinbauInfo;
    int mPosIntern;
    String mBuendelung;
    String mArt;
    int mVerweisNr;
    ArrayList<NPZ> npzListe = new ArrayList();
    String npzText = null;
    Integer zeilePos = new Integer(-1);

    public Bauteil(String teilenummer, String elementArt, String art, int verweisNr, String buendelung, String benennung, int menge, int bestand, Double einzelPreis, float mwStSatz, boolean kommentarVorhanden, String bemerkung, EinbauInfo einbauInfo, boolean bteBauteil, boolean aktiv, Integer pos) {
        this.mTeilenummer = teilenummer;
        this.mElementArt = elementArt;
        this.mBenennung = benennung;
        this.mMenge = menge;
        this.mBestand = bestand;
        this.mEinzelPreis = einzelPreis;
        this.mMwStSatz = mwStSatz;
        this.mKommentarVorhanden = kommentarVorhanden;
        this.mBemerkung = bemerkung;
        this.mEinbauInfo = einbauInfo;
        this.mBteBauteil = bteBauteil;
        this.mAktiv = aktiv;
        this.mBuendelung = buendelung;
        this.mArt = art;
        this.mVerweisNr = verweisNr;
        this.zeilePos = pos;
    }

    public Bauteil() {
    }

    public ArrayList<NPZ> getNpzListe() {
        return this.npzListe;
    }

    public void setNpzListe(ArrayList<NPZ> npz) {
        this.npzListe = npz;
    }

    public int hashCode() {
        int PRIME = 31;
        int result = 1;
        result = 31 * result + (this.mTeilenummer == null ? 0 : this.mTeilenummer.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Bauteil other = (Bauteil)obj;
        return !(this.mTeilenummer == null ? other.mTeilenummer != null : !this.mTeilenummer.equals(other.mTeilenummer));
    }

    public int compareTo(Object arg0) {
        if (arg0 instanceof Bauteil) {
            Bauteil bauteil = (Bauteil)arg0;
            if (this.getTeilenummer() == null || bauteil.getTeilenummer() == null) {
                return 0;
            }
            return this.getTeilenummer().compareTo(bauteil.getTeilenummer());
        }
        return 0;
    }

    public String getBenennung() {
        return this.mBenennung;
    }

    public void setBenennung(String benennung) {
        this.mBenennung = benennung;
    }

    public int getBestand() {
        return this.mBestand;
    }

    public void setBestand(int bestand) {
        this.mBestand = bestand;
    }

    public Double getEinzelPreis() {
        return this.mEinzelPreis;
    }

    public void setEinzelPreis(Double einzelPreis) {
        this.mEinzelPreis = einzelPreis;
    }

    public Double getGesamtPreis() {
        if (this.mEinzelPreis == null) {
            return null;
        }
        return new Double(Math.floor(this.mEinzelPreis * (double)this.mMenge * 100.0 + 0.5) / 100.0);
    }

    public boolean isKommentarVorhanden() {
        return this.mKommentarVorhanden;
    }

    public void setKommentarVorhanden(boolean kommentarVorhanden) {
        this.mKommentarVorhanden = kommentarVorhanden;
    }

    public int getMenge() {
        return this.mMenge;
    }

    public void setMenge(int menge) {
        this.mMenge = menge;
    }

    public String getTeilenummer() {
        return this.mTeilenummer;
    }

    public String getBuendelung() {
        return this.mBuendelung;
    }

    public String getArt() {
        return this.mArt;
    }

    public int getVerweisNr() {
        return this.mVerweisNr;
    }

    public void setTeilenummer(String teilenummer) {
        this.mTeilenummer = teilenummer;
    }

    public void setBuendelung(String buendelung) {
        this.mBuendelung = buendelung;
    }

    public void setArt(String art) {
        this.mArt = art;
    }

    public void setVerweisNr(int verweisNr) {
        this.mVerweisNr = verweisNr;
    }

    public String getElementArt() {
        return this.mElementArt;
    }

    public void setElementArt(String elementArt) {
        this.mElementArt = elementArt;
    }

    public Bauteil(String teilenummer) {
        this.mTeilenummer = teilenummer;
    }

    public EinbauInfo getEinbauInfo() {
        return this.mEinbauInfo;
    }

    public void setEinbauInfo(EinbauInfo einbauInfo) {
        this.mEinbauInfo = einbauInfo;
    }

    public boolean isBTEBauteil() {
        return this.mBteBauteil;
    }

    public void setBTEBauteil(boolean flag) {
        this.mBteBauteil = flag;
    }

    public boolean isAktiv() {
        return this.mAktiv;
    }

    public void setAktiv(boolean aktiv) {
        this.mAktiv = aktiv;
    }

    public String getPos() {
        return this.mPos;
    }

    public void setPos(String pos) {
        this.mPos = pos;
    }

    public Object clone() throws CloneNotSupportedException {
        Bauteil bauteil = new Bauteil(this.getTeilenummer());
        bauteil.setAktiv(this.isAktiv());
        bauteil.setBenennung(this.getBenennung());
        bauteil.setBestand(this.getBestand());
        bauteil.setBTEBauteil(this.isBTEBauteil());
        if (this.getEinbauInfo() != null) {
            bauteil.setEinbauInfo((EinbauInfo)this.getEinbauInfo().clone());
        }
        bauteil.setEinzelPreis(this.getEinzelPreis());
        bauteil.setMwStSatz(this.getMwStSatz());
        bauteil.setElementArt(this.getElementArt());
        bauteil.setKommentarVorhanden(this.isKommentarVorhanden());
        bauteil.setMenge(this.getMenge());
        bauteil.setPos(this.getPos());
        bauteil.setBemerkung(this.getBemerkung());
        return bauteil;
    }

    public int getPosIntern() {
        return this.mPosIntern;
    }

    public void setPosIntern(int posIntern) {
        this.mPosIntern = posIntern;
    }

    public float getMwStSatz() {
        return this.mMwStSatz;
    }

    public void setMwStSatz(float mwStSatz) {
        this.mMwStSatz = mwStSatz;
    }

    public String getBemerkung() {
        return this.mBemerkung;
    }

    public void setBemerkung(String bemerkung) {
        this.mBemerkung = bemerkung;
    }

    public boolean isBemerkungVorhanden() {
        return this.getBemerkung() != null && !this.getBemerkung().equals("");
    }

    public void setPos(Integer pos) {
        this.zeilePos = pos;
    }

    public String getNpzText() {
        return this.npzText;
    }

    public void setNpzText(String npzText) {
        this.npzText = npzText;
    }

    public Integer getZeilePos() {
        return this.zeilePos;
    }

    public void setZeilePos(Integer zeilePos) {
        this.zeilePos = zeilePos;
    }
}

