/*
 * Decompiled with CFR 0.152.
 */
package webetk.app.zub.technisch;

import java.io.Serializable;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.apache.log4j.Logger;
import webetk.DatabaseBusyException;
import webetk.InvalidDataException;
import webetk.InvalidInitializationException;
import webetk.WebetkUtils;
import webetk.app.BTEBedingungsmenge;
import webetk.app.Bedingungsmenge;
import webetk.app.ServerGlobalObjects;
import webetk.app.SucheInfo;
import webetk.app.bteanzeige.AbstractZeile;
import webetk.app.bteanzeige.Bedingung;
import webetk.app.bteanzeige.Element;
import webetk.app.bteanzeige.Obergruppe;
import webetk.app.fzgsuche.FzgSucheInfo;
import webetk.app.zub.technisch.Bauteil;
import webetk.app.zub.technisch.EinbauInfo;
import webetk.app.zub.technisch.NPZ;
import webetk.app.zub.technisch.RawZeile;
import webetk.app.zub.technisch.TechnikInfo;
import webetk.app.zub.technisch.TechnischerBnb;
import webetk.app.zub.technisch.Zeile;
import webetk.db.zub.dbaccess.AllgemeinDbAccess;
import webetk.db.zub.dbaccess.TechnischDbAccess;
import webetk.utils.StringUtils;

public class CurrentBTE
extends webetk.app.bteanzeige.CurrentBTE
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static Logger log = Logger.getLogger(CurrentBTE.class);
    protected String msBildPosNr = null;
    protected Long mlVarianteId = null;
    protected Collection<String> mcRelevanteBildposNr = new Vector<String>();
    protected Hashtable<String, ArrayList<Integer>> mVariantenZuRelevantenBildposNr = new Hashtable();

    public CurrentBTE(String sBTENr, Collection<String> cRelevanteBildposNr, Long lVarianteId, long lModellspalte, String sSprache, boolean bIGDOM) {
        super(bIGDOM);
        this.mbExpandBNB = true;
        this.mbNachruestRelevant = true;
        this.mlModellspalte = lModellspalte;
        this.msBTENummer = sBTENr;
        this.mcRelevanteBildposNr = cRelevanteBildposNr;
        this.mlVarianteId = lVarianteId;
        this.msSprache = sSprache;
        this.msBTEType = "FZG";
    }

    public CurrentBTE(String sBTENr, Collection<String> cRelevanteBildposNr, Hashtable<String, ArrayList<Integer>> hVariantenZuBildpos, long lModellspalte, String sSprache, boolean bIGDOM) {
        super(bIGDOM);
        this.mbExpandBNB = true;
        this.mbNachruestRelevant = true;
        this.mlModellspalte = lModellspalte;
        this.msBTENummer = sBTENr;
        this.mcRelevanteBildposNr = cRelevanteBildposNr;
        this.msSprache = sSprache;
        this.msBTEType = "FZG";
        this.mVariantenZuRelevantenBildposNr = hVariantenZuBildpos;
    }

    public CurrentBTE(String sBTENr, Collection<String> cRelevanteBildposNr, Long lVarianteId, String sMarke, String sProduktart, String sKatalogumfang, String sSprache, boolean bLoad, boolean bIGDOM) throws SQLException, DatabaseBusyException, InvalidInitializationException {
        super(bIGDOM);
        this.mbExpandBNB = true;
        this.mbNachruestRelevant = true;
        this.msBTENummer = sBTENr;
        this.msSprache = sSprache;
        this.msMarke = sMarke;
        this.msProduktart = sProduktart;
        this.msKatalogumfang = sKatalogumfang;
        this.mlVarianteId = lVarianteId;
        this.mcRelevanteBildposNr = cRelevanteBildposNr;
        this.msBTEType = "ASS";
    }

    public CurrentBTE(String sBTENr, Collection<String> cRelevanteBildposNr, Hashtable<String, ArrayList<Integer>> hVariantenZuBildpos, String sMarke, String sProduktart, String sKatalogumfang, String sSprache, boolean bLoad, boolean bIGDOM) throws SQLException, DatabaseBusyException, InvalidInitializationException {
        super(bIGDOM);
        this.mbExpandBNB = true;
        this.mbNachruestRelevant = true;
        this.msBTENummer = sBTENr;
        this.msSprache = sSprache;
        this.msMarke = sMarke;
        this.msProduktart = sProduktart;
        this.msKatalogumfang = sKatalogumfang;
        this.mVariantenZuRelevantenBildposNr = hVariantenZuBildpos;
        this.mcRelevanteBildposNr = cRelevanteBildposNr;
        this.msBTEType = "ASS";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean loadStammdaten(Bedingungsmenge oBeds) throws SQLException, DatabaseBusyException {
        ResultSet res;
        Connection con;
        ServerGlobalObjects globs;
        block11: {
            block10: {
                block9: {
                    block8: {
                        boolean bl;
                        globs = ServerGlobalObjects.getInstance();
                        con = null;
                        res = null;
                        try {
                            con = globs.getDBConnection("CurrentBTE.loadZubehoer");
                            log.debug((Object)("Loading Zubeh\u00f6r-BTE <" + this.msBTENummer + "> ..."));
                            res = TechnischDbAccess.loadZubBildtafelStammdaten(con, this.msBTENummer, this.msSprache);
                            if (res != null && res.next()) break block8;
                            bl = false;
                        }
                        catch (Throwable throwable) {
                            WebetkUtils.closeQuery(res);
                            globs.freeDBConnection(con, "CurrentBTE.loadZubehoer");
                            throw throwable;
                        }
                        WebetkUtils.closeQuery(res);
                        globs.freeDBConnection(con, "CurrentBTE.loadZubehoer");
                        return bl;
                    }
                    this.msBTENummer = res.getString("BildtafelNr");
                    if (!res.wasNull()) break block9;
                    log.error((Object)("Loading error: BTE number is not retrieved for: " + this.msBTENummer));
                    boolean bl = false;
                    WebetkUtils.closeQuery(res);
                    globs.freeDBConnection(con, "CurrentBTE.loadZubehoer");
                    return bl;
                }
                this.msBTEUeberschrift = res.getString("Benennung");
                if (!res.wasNull()) break block10;
                log.error((Object)("Loading error: BTE \u00dcberschrift is not retrieved for: " + this.msBTENummer));
                boolean bl = false;
                WebetkUtils.closeQuery(res);
                globs.freeDBConnection(con, "CurrentBTE.loadZubehoer");
                return bl;
            }
            this.msBTEBedKuerzel = res.getString("BedKuerzel");
            this.mlBildID = res.getLong("GrafikId");
            if (!res.wasNull()) break block11;
            log.error((Object)("Loading error: ID of BTE picture is not retrieved for: " + this.msBTENummer));
            boolean bl = false;
            WebetkUtils.closeQuery(res);
            globs.freeDBConnection(con, "CurrentBTE.loadZubehoer");
            return bl;
        }
        this.msImageTimestamp = res.getString("ModStamp");
        if (res.wasNull()) {
            log.warn((Object)("Loading warning: The timestamp of the BTE picture is null! Images will not be cached for: " + this.msBTENummer));
        }
        if (this.msBTEType.equals("FZG")) {
            this.mBedingungen = new BTEBedingungsmenge(this.msBTENummer, this.mcRelevanteBildposNr, this.mVariantenZuRelevantenBildposNr, this.mlModellspalte, oBeds);
            this.mBedingungen.load(this.msSprache, this.mbNachruestRelevant, this.isIGDOMaktiv(), this.mbUSATyp, this.mbVinIdentif);
        }
        this.mbBildZoomed = false;
        boolean bl = true;
        WebetkUtils.closeQuery(res);
        globs.freeDBConnection(con, "CurrentBTE.loadZubehoer");
        return bl;
    }

    @Override
    public void clear() {
        super.clear();
        this.mlVarianteId = null;
        this.msBildPosNr = null;
        this.mcRelevanteBildposNr.clear();
    }

    public void ladenZubBildtafelZeilen(FzgSucheInfo oFzgSucheInfo) throws SQLException, DatabaseBusyException, InvalidDataException {
        if (oFzgSucheInfo != null) {
            this.ladenBedingungenZuZubFzgBildtafel();
            this.ladenZeilenZuZubFzgBildtafelAusDB();
        } else {
            this.ladenZeilenZuZubUgbBildtafelAusDB();
        }
        if (oFzgSucheInfo != null) {
            String sFgstnr = oFzgSucheInfo.getFahrgestellnummer();
            boolean bIdentifiedByFgstnr = sFgstnr != null && !sFgstnr.equals("");
            this.auswertenEinschraenkungFzg(oFzgSucheInfo.getLenkung(), oFzgSucheInfo.getGetriebe(), oFzgSucheInfo.getBaujahr(), oFzgSucheInfo.getZulassungsmonat(), bIdentifiedByFgstnr);
        }
        this.copyRawZeilenToTemp(false);
        this.auswertenBedingungen();
        this.setzenAZWZeichenBAP(oFzgSucheInfo);
        this.erzeugenErgebnisZeilen();
    }

    @Override
    protected void auswertenBedingungen() {
        if (this.mcBedingungen == null || this.mcBedingungen.isEmpty()) {
            return;
        }
        if (this.msBTEType.equals("ASS") || !this.mbFiltern) {
            return;
        }
        this.mcBedingungen = this.setzenAusweisungenElemente(this.mcBedingungen);
        this.mhBedingungen = this.auswertenAusweisungen(this.mcBedingungen);
        this.mcRawZeilenTemp = this.removeZeilenNichtRelevant(this.mcRawZeilenTemp, this.mhBedingungen, this.mhUeberBedingungen);
    }

    @Override
    protected Vector<webetk.app.bteanzeige.RawZeile> removeZeilenNichtRelevant(Vector<webetk.app.bteanzeige.RawZeile> cZeilen, Hashtable<String, Boolean> hBedingungen, Hashtable<String, Vector<String>> hUeberBedingungen) {
        if (this.msBTEBedKuerzel != null && (hBedingungen == null || this.copyBedingungenOhneRegelnummer(hBedingungen).get(this.msBTEBedKuerzel) == null)) {
            cZeilen.clear();
        }
        Vector<Long> cBlocknr = new Vector<Long>();
        this.removeZeilenNichtRelevantByBed(cZeilen, hBedingungen, cBlocknr);
        this.removeZeilenNichtRelevantOhneBed(cZeilen, (Hashtable)hBedingungen, cBlocknr);
        this.removeZeilenNichtRelevantByUeberBed(cZeilen, hBedingungen, hUeberBedingungen, cBlocknr);
        this.checkZeilenByBlockNr(cZeilen, cBlocknr);
        return cZeilen;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void ladenZeilenZuZubUgbBildtafelAusDB() throws SQLException, DatabaseBusyException {
        if (this.mcRawZeilen != null) {
            return;
        }
        if (this.mcExpandedZeilen == null) {
            this.mcExpandedZeilen = new Vector();
        } else {
            this.mcExpandedZeilen.clear();
        }
        this.mcRawZeilen = new Vector();
        HashMap<Integer, String> hRelevanteZeilenBzglVariante = null;
        if (this.mVariantenZuRelevantenBildposNr != null && this.mVariantenZuRelevantenBildposNr.size() > 0) {
            hRelevanteZeilenBzglVariante = this.ladenZeilenZuZubUgbBzglVariante();
        }
        ServerGlobalObjects gObj = ServerGlobalObjects.getInstance();
        Connection con = null;
        ResultSet res = null;
        try {
            con = gObj.getDBConnection("CurrentBTE.ladenZeilenUgbDB");
            String bildPos2 = null;
            if (this.mcRelevanteBildposNr != null) {
                for (String bildPos2 : this.mcRelevanteBildposNr) {
                    res = TechnischDbAccess.loadZeilenUgb(con, this.msBTENummer, bildPos2, this.getMarke(), this.getProduktart(), this.getKatalogumfang(), this.msSprache);
                    int nBildnummerMerk = 0;
                    while (res != null && res.next()) {
                        long lGruppeId = res.getLong("GruppeId");
                        RawZeile Zeile2 = new RawZeile(false, lGruppeId);
                        String sBildnummer = res.getString("Bildnummer");
                        if (sBildnummer != null) {
                            if (!sBildnummer.equals("--")) {
                                nBildnummerMerk = res.getInt("Bildnummer");
                                if (this.mbExpandBNB && !this.mcExpandedZeilen.contains(sBildnummer)) {
                                    this.mcExpandedZeilen.add(sBildnummer);
                                }
                            }
                        } else {
                            nBildnummerMerk = 0;
                        }
                        int nPos = res.getInt("ZubPos");
                        boolean bZeileIstRelevant = true;
                        if (hRelevanteZeilenBzglVariante != null && hRelevanteZeilenBzglVariante.get(new Integer(nPos)) == null) {
                            bZeileIstRelevant = false;
                        }
                        if (!bZeileIstRelevant) continue;
                        Zeile2.setBildnummer(sBildnummer, nBildnummerMerk);
                        String sSatzSachnummer = res.getString("Satz_Sachnummer");
                        boolean bIstSatz = sSatzSachnummer != null;
                        String sReach = res.getString("Teil_Reach");
                        String sAspg = res.getString("Teil_Aspg");
                        String sStecker = res.getString("Teil_Stecker");
                        String sDiebstahlrelevant = res.getString("Teil_Diebstahlrelevant");
                        Zeile2.setTeil(res.getString("Teil_HG"), res.getString("Teil_UG"), res.getString("Teil_Sachnummer"), res.getString("Teil_Benennung"), res.getString("Teil_Zusatz"), res.getString("Teil_Entfall"), res.getLong("Teil_Kommentar_Id"), null, res.getLong("Teil_Komm_PI"), res.getString("Teil_SI"), res.getString("Teil_TC"), bIstSatz, null, sReach, sAspg, sStecker, sDiebstahlrelevant);
                        Zeile2.setMenge(res.getString("Menge"));
                        Zeile2.setMengenAss(res.getString("MMG"), res.getString("EMG"));
                        Zeile2.setEinsatzAuslauf(res.getString("Einsatz"), res.getString("Auslauf"));
                        Zeile2.setKommentare(res.getLong("KommBT"), res.getLong("KommVor"), res.getLong("KommNach"));
                        String sElementart = res.getString("ZubElementart");
                        int nGehoertZuPos = res.getInt("ZubGehoertZuPos");
                        String sArt = res.getString("ZubArt");
                        int nVerweisNr = res.getInt("ZubVerweis");
                        String sBuendelung = res.getString("ZubBuendelung");
                        Zeile2.setZubehoerInfo(sElementart, nPos, nGehoertZuPos, sArt, nVerweisNr, sBuendelung);
                        this.mcRawZeilen.add(Zeile2);
                    }
                }
            }
        }
        finally {
            WebetkUtils.closeQuery(res);
            gObj.freeDBConnection(con, "CurrentBTE.ladenZeilenUgbDB");
        }
    }

    @Override
    protected void loadTextteilFromDBUgb(SucheInfo oSucheInfo, String sLandkuerzel) throws SQLException, DatabaseBusyException {
        this.ladenKommentareUgb();
        this.ladenBTVerweiseUgbDB();
        this.ladenZeilenUgbDB(oSucheInfo.getProduktart(), sLandkuerzel);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void ladenBedingungenZuZubFzgBildtafel() throws SQLException, DatabaseBusyException {
        if (this.mcRawZeilen != null) {
            return;
        }
        if (this.mcBedingungen == null) {
            this.mcBedingungen = new Vector();
        } else {
            this.mcBedingungen.clear();
        }
        if (this.mhUeberBedingungen == null) {
            this.mhUeberBedingungen = new Hashtable();
        } else {
            this.mhUeberBedingungen.clear();
        }
        ServerGlobalObjects gObj = ServerGlobalObjects.getInstance();
        Connection con = null;
        ResultSet res = null;
        try {
            con = gObj.getDBConnection("CurrentBTE.ladenBedingungenFzg");
            res = TechnischDbAccess.loadZubBedingungenFzg(con, this.msBTENummer, this.mcRelevanteBildposNr, this.mlVarianteId, this.mlModellspalte);
            Bedingung Bed = null;
            Obergruppe OG = null;
            Element Elem = null;
            String sKuerzelMerk = "";
            String sOgIdMerk = "";
            String sGesamtterm_VZ = null;
            String sGesamtterm = null;
            String sFZeile = null;
            int nPos = 0;
            boolean bET = false;
            while (res != null && res.next()) {
                String sOgId;
                String sKuerzel = res.getString("Kuerzel");
                if (!sKuerzelMerk.equals(sKuerzel)) {
                    sGesamtterm_VZ = res.getString("GesamttermVZ");
                    sGesamtterm = res.getString("Gesamtterm");
                    Bed = new Bedingung(sKuerzel, sGesamtterm_VZ, sGesamtterm);
                    this.mcBedingungen.add(Bed);
                    sKuerzelMerk = sKuerzel;
                    sOgIdMerk = "";
                }
                if (!sOgIdMerk.equals(sOgId = res.getString("OG"))) {
                    String sVArt = res.getString("VArt");
                    sFZeile = res.getString("FZeile");
                    OG = new Obergruppe(sOgId, sVArt, sFZeile);
                    bET = sVArt.equals("E") || sVArt.equals("B");
                    nPos = 1;
                    if (bET) {
                        Bed.setAusweisung(OG.getAusweisung());
                    }
                    Bed.appendObergruppe(OG);
                    sOgIdMerk = sOgId;
                }
                String sAusweisung = " ";
                String sRegelzeile = null;
                if (bET) {
                    sAusweisung = sFZeile;
                    if (sGesamtterm_VZ.equals("+")) {
                        sAusweisung = StringUtils.substituteStringStraight(sAusweisung, "X", " ");
                        sAusweisung = StringUtils.substituteStringStraight(sAusweisung, "0", "-");
                    } else {
                        sAusweisung = StringUtils.substituteStringStraight(sAusweisung, "X", "-");
                        sAusweisung = StringUtils.substituteStringStraight(sAusweisung, "0", " ");
                    }
                    int nLength = sFZeile.length();
                    sRegelzeile = "";
                    int nGrenzeA = (int)Math.pow(2.0, nPos - 1);
                    for (int i = 1; i <= nGrenzeA; ++i) {
                        int j;
                        int nPow = (int)Math.pow(2.0, nPos);
                        int nGrenzeB = nLength / nPow;
                        for (j = 1; j <= nGrenzeB; ++j) {
                            sRegelzeile = sRegelzeile + "X";
                        }
                        for (j = 1; j <= nGrenzeB; ++j) {
                            sRegelzeile = sRegelzeile + "0";
                        }
                    }
                    ++nPos;
                }
                String sElementVZ = res.getString("ElementVZ");
                long lElementId = res.getLong("ElementId");
                Elem = new Element(sElementVZ, lElementId, sRegelzeile, sAusweisung);
                OG.appendElement(Elem);
            }
            Iterator iterator = this.mcBedingungen.iterator();
            while (iterator.hasNext()) {
                log.debug((Object)("Zeile: " + ((Bedingung)iterator.next()).toString()));
            }
            res = TechnischDbAccess.loadZubUeberbedingungenFzg(con, this.msBTENummer, this.mlModellspalte);
            sKuerzelMerk = "";
            Vector<String> cUeberBed = null;
            while (res != null && res.next()) {
                String sKuerzel = res.getString("Kuerzel");
                String sKuerzelUeber = res.getString("KuerzelUeber");
                if (!sKuerzelMerk.equals(sKuerzel)) {
                    cUeberBed = new Vector<String>();
                    cUeberBed.add(sKuerzelUeber);
                    this.mhUeberBedingungen.put(sKuerzel, cUeberBed);
                    sKuerzelMerk = sKuerzel;
                    continue;
                }
                cUeberBed.add(sKuerzelUeber);
            }
        }
        catch (Throwable throwable) {
            WebetkUtils.closeQuery(res);
            gObj.freeDBConnection(con, "CurrentBTE.ladenBedingungenFzg");
            throw throwable;
        }
        WebetkUtils.closeQuery(res);
        gObj.freeDBConnection(con, "CurrentBTE.ladenBedingungenFzg");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void ladenZeilenZuZubFzgBildtafelAusDB() throws SQLException, DatabaseBusyException {
        if (this.mcRawZeilen != null) {
            return;
        }
        if (this.mcExpandedZeilen == null) {
            this.mcExpandedZeilen = new Vector();
        } else {
            this.mcExpandedZeilen.clear();
        }
        this.mcRawZeilen = new Vector();
        HashMap<Integer, String> hRelevanteZeilenBzglVariante = null;
        if (this.mVariantenZuRelevantenBildposNr != null && this.mVariantenZuRelevantenBildposNr.size() > 0) {
            hRelevanteZeilenBzglVariante = this.ladenZeilenZuZubFzgBzglVariante();
        }
        ServerGlobalObjects gObj = ServerGlobalObjects.getInstance();
        Connection con = null;
        ResultSet res = null;
        try {
            con = gObj.getDBConnection("CurrentBTE.ladenZeilenZuZubFzgBildtafelAusDB");
            res = TechnischDbAccess.loadZeilenZuZubFzgBildtafel(con, this.msBTENummer, this.mcRelevanteBildposNr, this.mlModellspalte, this.msSprache);
            int nBildnummerMerk = 0;
            while (res != null && res.next()) {
                long lGruppeId = res.getLong("GruppeId");
                RawZeile Zeile2 = new RawZeile(true, lGruppeId);
                String sBildnummer = res.getString("Bildnummer");
                if (sBildnummer != null) {
                    if (!sBildnummer.equals("--")) {
                        nBildnummerMerk = res.getInt("Bildnummer");
                        if (this.mbExpandBNB && !this.mcExpandedZeilen.contains(sBildnummer)) {
                            this.mcExpandedZeilen.add(sBildnummer);
                        }
                    }
                } else {
                    nBildnummerMerk = 0;
                }
                int nPos = res.getInt("ZubPos");
                boolean bZeileIstRelevant = true;
                if (hRelevanteZeilenBzglVariante != null && hRelevanteZeilenBzglVariante.get(new Integer(nPos)) == null) {
                    bZeileIstRelevant = false;
                }
                if (!bZeileIstRelevant) continue;
                Zeile2.setBildnummer(sBildnummer, nBildnummerMerk);
                String sReach = res.getString("Teil_Reach");
                String sAspg = res.getString("Teil_Aspg");
                String sStecker = res.getString("Teil_Stecker");
                String sDiebstahlrelevant = res.getString("Teil_Diebstahlrelevant");
                Zeile2.setTeil(res.getString("Teil_HG"), res.getString("Teil_UG"), res.getString("Teil_Sachnummer"), res.getString("Teil_Benennung"), res.getString("Teil_Zusatz"), res.getString("Teil_Entfall"), res.getLong("Teil_Kommentar_Id"), null, res.getLong("Teil_Komm_PI"), res.getString("Teil_SI"), res.getString("Teil_TC"), false, null, sReach, sAspg, sStecker, sDiebstahlrelevant);
                Zeile2.setMenge(res.getString("Menge"));
                Zeile2.setAusweisungen(res.getString("Kat_KZ"), res.getString("Lenkung_KZ"), res.getString("Getriebe_KZ"));
                Zeile2.setEinsatzAuslauf(res.getString("Einsatz"), res.getString("Auslauf"));
                Zeile2.setBedingungKZ(res.getString("Bedingung_KZ"));
                Zeile2.setKommentare(res.getLong("KommBT"), res.getLong("KommVor"), res.getLong("KommNach"));
                String sElementart = res.getString("ZubElementart");
                int nGehoertZuPos = res.getInt("ZubGehoertZuPos");
                String sArt = res.getString("ZubArt");
                int nVerweisNr = res.getInt("ZubVerweis");
                String sBuendelung = res.getString("ZubBuendelung");
                Zeile2.setZubehoerInfo(sElementart, nPos, nGehoertZuPos, sArt, nVerweisNr, sBuendelung);
                this.mcRawZeilen.add(Zeile2);
            }
        }
        catch (Throwable throwable) {
            WebetkUtils.closeQuery(res);
            gObj.freeDBConnection(con, "CurrentBTE.ladenZeilenZuZubFzgBildtafelAusDB");
            throw throwable;
        }
        WebetkUtils.closeQuery(res);
        gObj.freeDBConnection(con, "CurrentBTE.ladenZeilenZuZubFzgBildtafelAusDB");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected HashMap<Integer, String> ladenZeilenZuZubFzgBzglVariante() throws SQLException, DatabaseBusyException {
        HashMap<Integer, String> hashMap;
        if (this.mVariantenZuRelevantenBildposNr == null || this.mVariantenZuRelevantenBildposNr.size() == 0) {
            return null;
        }
        HashMap<Integer, String> hResult = new HashMap<Integer, String>();
        ServerGlobalObjects gObj = ServerGlobalObjects.getInstance();
        Connection con = null;
        ResultSet res = null;
        try {
            con = gObj.getDBConnection("CurrentBTE.anpassenZeilenZuZubFzgBzglVariante");
            res = TechnischDbAccess.loadZeilenZuZubFzgRelevantBzglVariante(con, this.msBTENummer, this.mcRelevanteBildposNr, this.mVariantenZuRelevantenBildposNr);
            while (res != null && res.next()) {
                int nPos = res.getInt("ZubPos");
                hResult.put(new Integer(nPos), "Relevant");
            }
            hashMap = hResult;
        }
        catch (Throwable throwable) {
            WebetkUtils.closeQuery(res);
            gObj.freeDBConnection(con, "CurrentBTE.anpassenZeilenZuZubFzgBzglVariante");
            throw throwable;
        }
        WebetkUtils.closeQuery(res);
        gObj.freeDBConnection(con, "CurrentBTE.anpassenZeilenZuZubFzgBzglVariante");
        return hashMap;
    }

    public String getVariantenIDtoString() {
        String bui = "";
        Enumeration<ArrayList<Integer>> en = this.mVariantenZuRelevantenBildposNr.elements();
        while (en.hasMoreElements()) {
            ArrayList<Integer> varList = en.nextElement();
            for (int i = 0; i < varList.size(); ++i) {
                bui = bui + new Integer(varList.get(i).toString());
                if (i >= varList.size()) continue;
                bui = bui + ",";
            }
        }
        return bui.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected HashMap<Integer, String> ladenZeilenZuZubUgbBzglVariante() throws SQLException, DatabaseBusyException {
        HashMap<Integer, String> hashMap;
        if (this.mVariantenZuRelevantenBildposNr == null || this.mVariantenZuRelevantenBildposNr.size() == 0) {
            return null;
        }
        HashMap<Integer, String> hResult = new HashMap<Integer, String>();
        ServerGlobalObjects gObj = ServerGlobalObjects.getInstance();
        Connection con = null;
        ResultSet res = null;
        try {
            con = gObj.getDBConnection("CurrentBTE.anpassenZeilenZuZubFzgBzglVariante");
            res = TechnischDbAccess.loadZeilenZuZubUgbRelevantBzglVariante(con, this.msBTENummer, this.mcRelevanteBildposNr, this.mVariantenZuRelevantenBildposNr);
            while (res != null && res.next()) {
                int nPos = res.getInt("ZubPos");
                hResult.put(new Integer(nPos), "Relevant");
            }
            hashMap = hResult;
        }
        catch (Throwable throwable) {
            WebetkUtils.closeQuery(res);
            gObj.freeDBConnection(con, "CurrentBTE.anpassenZeilenZuZubFzgBzglVariante");
            throw throwable;
        }
        WebetkUtils.closeQuery(res);
        gObj.freeDBConnection(con, "CurrentBTE.anpassenZeilenZuZubFzgBzglVariante");
        return hashMap;
    }

    public void erzeugenErgebnisZeilen() throws InvalidDataException {
        this.getNewZeilen();
        if (this.getRawZeilen() == null) {
            log.error((Object)"The internal rows for the BTE are not loaded!!");
            throw new InvalidDataException("mcRawZeilen is null!!");
        }
        if (this.mcRawZeilen != null) {
            this.mcRawZeilen.clear();
        }
        for (int i = 0; i < this.mcRawZeilenTemp.size(); ++i) {
            RawZeile oZeileSrc = (RawZeile)this.mcRawZeilenTemp.get(i);
            Zeile oZeileDest = new Zeile(oZeileSrc);
            this.mcZeilen.add(oZeileDest);
        }
    }

    public List<TechnischerBnb> getZubBnbsBauteile(String sBtnr, String sModus) {
        ArrayList<TechnischerBnb> aBnbsBauteile = new ArrayList<TechnischerBnb>();
        ArrayList<Bauteil> aBauteile = null;
        HashMap npzHash = new HashMap();
        String sBildposnrMerk = "";
        TechnischerBnb oBnb = null;
        Vector<AbstractZeile> cZeilen = this.getZeilen();
        for (int i = 0; i < cZeilen.size(); ++i) {
            Zeile oZeile = (Zeile)cZeilen.get(i);
            String sElementart = oZeile.getElementart();
            if (sModus.equals("Kernprodukt") && !sElementart.equals("HP_OBLIGAT") && !sElementart.equals("HP_PAKET") && !sElementart.equals("HP_ALTERNATIV") && !sElementart.equals("HP_EINZELTEIL") || sModus.equals("Hilfsstoffe") && !sElementart.equals("HILFSSTOFFE") || sModus.equals("Zusatz") && !sElementart.equals("OPTIONAL")) continue;
            if (!sBildposnrMerk.equals(oZeile.getBildnummer())) {
                oBnb = new TechnischerBnb();
                oBnb.setBildPos(oZeile.getBildnummer());
                oBnb.setBteNr(sBtnr);
                oBnb.setElementArt(sElementart);
                try {
                    TechnikInfo technikInfo = new TechnikInfo(sBtnr, oBnb.getBildPos(), oZeile.getPos(), this.msProduktart, this.msSprache);
                    if (technikInfo != null && technikInfo.getHinweise() != null && technikInfo.getHinweise().size() > 0 && !technikInfo.getHinweise().isEmpty()) {
                        oBnb.setTechnischerKommentar(technikInfo);
                    }
                }
                catch (DatabaseBusyException e) {
                    log.error((Object)"DatabaseBusyException: ", (Throwable)e);
                    e.printStackTrace();
                }
                catch (SQLException e) {
                    log.error((Object)"SQLException: ", (Throwable)e);
                    e.printStackTrace();
                }
                sBildposnrMerk = oZeile.getBildnummer();
                aBnbsBauteile.add(oBnb);
                aBauteile = new ArrayList<Bauteil>();
                oBnb.setBauteile(aBauteile);
            }
            String sSachnr = oZeile.getSachnummer(true);
            String sTeilenr = oZeile.getTeilenummer(true);
            String sBenennung = oZeile.getTeilebenennung();
            String sZusatz = oZeile.getZusatz();
            if (sZusatz != null && !sZusatz.equals("")) {
                sBenennung = sBenennung + "/" + sZusatz;
            }
            int nMenge = 99;
            if (!oZeile.getMenge().equals("X")) {
                nMenge = Integer.parseInt(oZeile.getMenge());
            }
            int nBestand = 0;
            Double dEinzelPreis = null;
            float fMwStSatz = 0.0f;
            boolean bKommentarVorhanden = false;
            EinbauInfo oEinbauInfo = null;
            boolean bBTEBauteil = true;
            boolean bAktiv = true;
            String sBuendlung = oZeile.getBuendelung();
            String sArt = oZeile.getArt();
            int nVerweisNr = oZeile.getVerweisNr();
            Integer pos = new Integer(oZeile.getPos());
            Integer gehoertZuPos = new Integer(oZeile.getGehoertZuPos());
            if (sArt.indexOf("NPZ") <= -1) {
                Bauteil oBauteil = new Bauteil(sSachnr, sElementart, sArt, nVerweisNr, sBuendlung, sBenennung, nMenge, nBestand, dEinzelPreis, fMwStSatz, bKommentarVorhanden, null, oEinbauInfo, bBTEBauteil, bAktiv, pos);
                aBauteile.add(oBauteil);
                continue;
            }
            NPZ npz = new NPZ(sSachnr, sTeilenr, sBenennung, sArt.indexOf("-") > -1 ? "-" : "+");
            if (npzHash.containsKey(gehoertZuPos)) {
                ((ArrayList)npzHash.get(gehoertZuPos)).add(npz);
                continue;
            }
            ArrayList<NPZ> npzList = new ArrayList<NPZ>();
            npzList.add(npz);
            npzHash.put(gehoertZuPos, npzList);
        }
        String nurPassendZu = null;
        String nichtPassendZu = null;
        try {
            nurPassendZu = AllgemeinDbAccess.ermittleTextNachId(500000001, this.msSprache);
            nichtPassendZu = AllgemeinDbAccess.ermittleTextNachId(500000002, this.msSprache);
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        catch (DatabaseBusyException e) {
            e.printStackTrace();
        }
        for (int n = 0; n < aBnbsBauteile.size(); ++n) {
            List<Bauteil> bauteile = ((TechnischerBnb)aBnbsBauteile.get(n)).getBauteile();
            for (int k = 0; k < bauteile.size(); ++k) {
                Bauteil bauteil = bauteile.get(k);
                if (npzHash.get(bauteil.getZeilePos()) == null) continue;
                ArrayList npzs = (ArrayList)npzHash.get(bauteil.getZeilePos());
                bauteil.setNpzListe(npzs);
                if (((NPZ)npzs.get(0)).getZeichen().equals("+")) {
                    bauteil.setNpzText(nurPassendZu);
                    continue;
                }
                bauteil.setNpzText(nichtPassendZu);
            }
        }
        return aBnbsBauteile;
    }

    protected void removeZeilenNichtRelevantOhneBed(Collection cZeilen, Hashtable hBedingungen, Collection cBlocknr) {
        if (hBedingungen == null || hBedingungen.size() == 0) {
            return;
        }
        Vector<String> cBildposNrVerweisMitVollstaendigerBedingung = new Vector<String>();
        for (RawZeile Zeile2 : cZeilen) {
            Boolean Vollstaendig;
            boolean bVollstaendig;
            String sKuerzel = Zeile2.getBedingungKZ();
            if (sKuerzel == null || hBedingungen.get(sKuerzel) == null || !(bVollstaendig = (Vollstaendig = (Boolean)hBedingungen.get(sKuerzel)).booleanValue())) continue;
            String sString = Zeile2.getBildnummer() + "#" + Zeile2.getVerweisNr();
            this.addString(cBildposNrVerweisMitVollstaendigerBedingung, sString);
            this.addLong(cBlocknr, Zeile2.getBlockNr());
        }
        for (String sString : cBildposNrVerweisMitVollstaendigerBedingung) {
            int nPos = sString.indexOf(35);
            int nBildPosNr = Integer.parseInt(sString.substring(0, nPos));
            int nVerweisNr = Integer.parseInt(sString.substring(nPos + 1));
            this.removeAlleZeilenOhneBedingung(cZeilen, nBildPosNr, nVerweisNr);
        }
    }

    public void removeAlleZeilenOhneBedingung(Collection cZeilen, int nBildPos, int nVerweisNr) {
        Iterator iterator = cZeilen.iterator();
        while (iterator.hasNext()) {
            String sKuerzel;
            RawZeile Zeile2 = (RawZeile)iterator.next();
            if (Zeile2.getBildnummerInt() != nBildPos || Zeile2.getVerweisNr() != nVerweisNr || (sKuerzel = Zeile2.getBedingungKZ()) != null) continue;
            iterator.remove();
        }
    }
}

