/*
 * Decompiled with CFR 0.152.
 */
package webetk.app.zub.technisch;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import webetk.app.bteinfo.Info;
import webetk.app.zub.suche.Bnb;
import webetk.app.zub.technisch.Bauteil;
import webetk.app.zub.technisch.EinbauInfo;

@XmlRootElement
@XmlAccessorType(value=XmlAccessType.FIELD)
public class TechnischerBnb
extends Bnb
implements Serializable {
    @XmlTransient
    private static final long serialVersionUID = 1L;
    List<EinbauInfo> mEinbauInfo = new ArrayList<EinbauInfo>();
    List<Bauteil> mBauteile = new ArrayList<Bauteil>();
    boolean mHinzugefuegt;
    Info mTechnischerKommentar;

    public TechnischerBnb() {
    }

    public TechnischerBnb(String bteNr, String bildPos, String elementArt) {
        super(bteNr, bildPos, elementArt);
    }

    public List<Bauteil> getBauteile() {
        return this.mBauteile;
    }

    public List getBauteileNormal(int nVerweisNr) {
        ArrayList<Bauteil> ergebnis = new ArrayList<Bauteil>();
        for (int i = 0; i < this.mBauteile.size(); ++i) {
            Bauteil oBauteil = this.mBauteile.get(i);
            if (!oBauteil.getArt().equals("NORMAL") || oBauteil.getVerweisNr() != nVerweisNr) continue;
            ergebnis.add(oBauteil);
        }
        return ergebnis;
    }

    public void setBauteile(List<Bauteil> bauteile) {
        this.mBauteile = bauteile;
    }

    public List<EinbauInfo> getEinbauInfo() {
        return this.mEinbauInfo;
    }

    public void setEinbauInfo(List<EinbauInfo> einbauInfo) {
        this.mEinbauInfo = einbauInfo;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        TechnischerBnb bnb = new TechnischerBnb();
        bnb.setBildPos(this.getBildPos());
        bnb.setBteNr(this.getBteNr());
        bnb.setBnbName(this.getBnbName());
        bnb.setElementArt(this.getElementArt());
        if (this.getEinbauInfo() != null) {
            ArrayList<EinbauInfo> einbauInfos = new ArrayList<EinbauInfo>();
            for (EinbauInfo info : this.getEinbauInfo()) {
                einbauInfos.add((EinbauInfo)info.clone());
            }
            bnb.setEinbauInfo(einbauInfos);
        }
        if (this.getBauteile() != null) {
            ArrayList<Bauteil> bauteile = new ArrayList<Bauteil>();
            for (Bauteil bauteil : this.getBauteile()) {
                bauteile.add((Bauteil)bauteil.clone());
            }
            bnb.setBauteile(bauteile);
        }
        return bnb;
    }

    public boolean isHinzugefuegt() {
        return this.mHinzugefuegt;
    }

    public void setHinzugefuegt(boolean hinzugefuegt) {
        this.mHinzugefuegt = hinzugefuegt;
    }

    public Info getTechnischerKommentar() {
        return this.mTechnischerKommentar;
    }

    public void setTechnischerKommentar(Info technischerKommentar) {
        this.mTechnischerKommentar = technischerKommentar;
    }

    public List getAlleVerweisNr() {
        ArrayList<Integer> ergebnis = new ArrayList<Integer>();
        int nVerweisNrMerk = -1;
        for (int i = 0; i < this.mBauteile.size(); ++i) {
            Bauteil oBauteil = this.mBauteile.get(i);
            int nVerweisNr = oBauteil.getVerweisNr();
            if (nVerweisNrMerk != nVerweisNr) {
                ergebnis.add(new Integer(nVerweisNr));
            }
            nVerweisNrMerk = nVerweisNr;
        }
        return ergebnis;
    }
}

