/*
 * Decompiled with CFR 0.152.
 */
package webetk.communication.transferables;

import com.bmw.etk.client.ProxySettings;
import com.bmw.etk.client.adapter.rest.ClientException;
import com.bmw.etk.client.adapter.rest.ETKRestApiClient;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JOptionPane;
import org.apache.log4j.Logger;
import webetk.communication.CommunicationException;
import webetk.communication.transferables.Command;
import webetk.communication.transferables.Transferable;
import webetk.communication.transferables.TransferableDecorator;
import webetk.communication.transferables.TrfAdminTool;
import webetk.communication.transferables.TrfDatei;
import webetk.communication.transferables.TrfFahrzeugId;
import webetk.communication.transferables.TrfHashMap;
import webetk.communication.transferables.TrfImage;
import webetk.communication.transferables.TrfMisc;
import webetk.communication.transferables.TrfString;
import webetk.communication.transferables.TrfTeileliste;
import webetk.communication.transferables.TrfTeilesuche;
import webetk.communication.transferables.TrfZubMarketing;
import webetk.communication.transferables.TrfZubMisc;
import webetk.communication.transferables.TrfZubSuche;
import webetk.communication.transferables.TrfZubTechnisch;
import webetk.communication.transferables.TrfZubVerwaltung;

public class ServiceExecutor {
    private static Logger log = Logger.getLogger(ServiceExecutor.class);
    private Map<Class<? extends Transferable>, String> mPathMap;
    private ETKRestApiClient mEtkRestApiClient;
    private String mServerUrl;
    private List<TransferableDecorator> mTransferableDecorators = new ArrayList<TransferableDecorator>();

    public void init(String pServerUrl, boolean pEnableCockieHandling, boolean pAddAsapAuthenticationToHeader, ProxySettings pProxySettings) {
        this.mServerUrl = pServerUrl;
        this.createPathMap();
        ServiceExecutor.debugMessage("init: nach createPathMap()");
        this.createRestApiClient(pServerUrl, pEnableCockieHandling, pAddAsapAuthenticationToHeader, pProxySettings);
        ServiceExecutor.debugMessage("init: nach createRestApiClient(pServerUrl)");
    }

    public void addTransferableDecorator(TransferableDecorator pTransferableDecorator) {
        log.debug((Object)("adding and registering " + TransferableDecorator.class.getName() + " " + pTransferableDecorator.getClass().getName() + " with " + ServiceExecutor.class.getName()));
        this.mTransferableDecorators.add(pTransferableDecorator);
    }

    public void removeTransferableDecorator() {
        log.debug((Object)"remove all decorators");
        this.mTransferableDecorators.clear();
    }

    public String getServerUrl() {
        return this.mServerUrl;
    }

    private void createPathMap() {
        this.mPathMap = new HashMap<Class<? extends Transferable>, String>();
        this.mPathMap.put(TrfAdminTool.class, "/etk_webservices/trf_admin_tool");
        this.mPathMap.put(TrfDatei.class, "/etk_webservices/trf_datei");
        this.mPathMap.put(TrfFahrzeugId.class, "/etk_webservices/trf_fahrzeug_id");
        this.mPathMap.put(TrfHashMap.class, "/etk_webservices/trf_hash_map");
        this.mPathMap.put(TrfImage.class, "/etk_webservices/trf_image");
        this.mPathMap.put(TrfMisc.class, "/etk_webservices/trf_misc");
        this.mPathMap.put(TrfString.class, "/etk_webservices/trf_string");
        this.mPathMap.put(TrfTeileliste.class, "/etk_webservices/trf_teileliste");
        this.mPathMap.put(TrfTeilesuche.class, "/etk_webservices/trf_teilesuche");
        this.mPathMap.put(TrfZubMarketing.class, "/etk_webservices/trf_zub_marketing");
        this.mPathMap.put(TrfZubMisc.class, "/etk_webservices/trf_zub_misc");
        this.mPathMap.put(TrfZubTechnisch.class, "/etk_webservices/trf_zub_technisch");
        this.mPathMap.put(TrfZubVerwaltung.class, "/etk_webservices/trf_zub_verwaltung");
        this.mPathMap.put(TrfZubSuche.class, "/etk_webservices/trf_zub_suche");
    }

    private void createRestApiClient(String pServerUrl, boolean pEnableCockieHandling, boolean pAddAsapAuthenticationToHeader, ProxySettings pProxySettings) {
        ServiceExecutor.debugMessage("createRestApiClient: vor new ETKRestApiClient(pServerUrl)");
        this.mEtkRestApiClient = new ETKRestApiClient(pServerUrl, pEnableCockieHandling, pAddAsapAuthenticationToHeader, pProxySettings);
        ServiceExecutor.debugMessage("createRestApiClient: nach new ETKRestApiClient(pServerUrl)");
    }

    public boolean isInitialized() {
        return this.mEtkRestApiClient != null;
    }

    public <T extends Transferable> void executeService(T pTransferable, Command pCommand) throws CommunicationException {
        pTransferable.setCommand(pCommand);
        for (TransferableDecorator transferableDecorator : this.mTransferableDecorators) {
            transferableDecorator.decorate(pTransferable);
        }
        String path = this.getPath(pTransferable);
        if (path == null) {
            throw new CommunicationException("no path registered for " + Transferable.class.getName() + " implementation " + pTransferable.getClass().getName() + " commandID:" + pCommand);
        }
        try {
            log.debug((Object)("Command: " + pCommand + " " + pTransferable.getClass().getSimpleName()));
            Transferable retVal = this.mEtkRestApiClient.executeService(pTransferable, path);
            pTransferable.copyData(retVal);
        }
        catch (ClientException e) {
            pTransferable.setError(e);
        }
    }

    private String getPath(Transferable pTransferable) {
        return this.mPathMap.get(pTransferable.getClass());
    }

    private static void debugMessage(String string) {
        if ("true".equals(System.getProperty("debugETK"))) {
            log.error((Object)string);
            JOptionPane.showConfirmDialog(null, string, "dubug ServiceExecutor", 0);
        }
    }
}

