/*
 * Decompiled with CFR 0.152.
 */
package webetk.db.dbaccess;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collection;
import java.util.Iterator;
import java.util.Vector;
import org.apache.log4j.Logger;
import webetk.WebetkUtils;
import webetk.app.ValueAndNameSupport;
import webetk.db.SQLStatements;
import webetk.utils.StringUtils;
import webetk.utils.communication.HtmlUtils;

public class AllgemeinDbAccess {
    private static Logger log = Logger.getLogger(AllgemeinDbAccess.class);

    public static Vector<String> retrieveBMWSachnummern(Connection con, String sSachnummerFremd) throws SQLException {
        if (HtmlUtils.isConnectionSourceOracle(con)) {
            Vector<String> aSachnummern = new Vector<String>();
            String sSQLStatement = SQLStatements.Allgemein.instance.RETRIEVE_BMWSACHNUMMER_FOR_FREMDESACHNUMMER();
            sSachnummerFremd = sSachnummerFremd.toUpperCase();
            PreparedStatement ps = con.prepareStatement(sSQLStatement);
            ps.setString(1, sSachnummerFremd);
            log.debug((Object)("Executing: " + sSQLStatement));
            ResultSet res = ps.executeQuery();
            while (res != null && res.next()) {
                String sSachnummer = res.getString("Sachnummer");
                aSachnummern.add(sSachnummer);
            }
            WebetkUtils.closeQuery(res);
            return aSachnummern;
        }
        Vector<String> aSachnummern = new Vector<String>();
        String sSQLStatement = SQLStatements.Allgemein.instance.RETRIEVE_BMWSACHNUMMER_FOR_FREMDESACHNUMMER();
        sSachnummerFremd = sSachnummerFremd.toUpperCase();
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "SACHNUMMER_FREMD", sSachnummerFremd);
        log.debug((Object)("Executing: " + sSQLStatement));
        Statement stmt = con.createStatement();
        ResultSet res = stmt.executeQuery(sSQLStatement);
        while (res != null && res.next()) {
            String sSachnummer = res.getString("Sachnummer");
            aSachnummern.add(sSachnummer);
        }
        WebetkUtils.closeQuery(res);
        return aSachnummern;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Collection<ValueAndNameSupport> selectWertebereich(Connection con, String sArt, String sLang, String sCountry) throws SQLException {
        if (HtmlUtils.isConnectionSourceOracle(con)) {
            String sSql = SQLStatements.Wertebereiche.instance.RETRIEVE_WERTEBEREICH();
            PreparedStatement ps = con.prepareStatement(sSql);
            ps.setString(3, sArt);
            ps.setString(1, sLang);
            if (sCountry == null || sCountry.equals("")) {
                ps.setString(2, "  ");
            } else {
                ps.setString(2, sCountry);
            }
            log.debug((Object)("Executing: " + sSql));
            ResultSet res = ps.executeQuery();
            try {
                if (res != null) {
                    Object sValue;
                    Vector<ValueAndNameSupport> objResult = new Vector<ValueAndNameSupport>();
                    while (res.next()) {
                        sValue = res.getString("Value");
                        String sName = res.getString("Name");
                        ValueAndNameSupport objValName = new ValueAndNameSupport((String)sValue, sName);
                        objResult.add(objValName);
                    }
                    WebetkUtils.closeQuery(res);
                    sValue = objResult;
                    return sValue;
                }
                log.info((Object)("No message found for: " + sArt + "(" + sLang + "/" + sCountry + ")"));
                Collection<ValueAndNameSupport> objResult = null;
                return objResult;
            }
            finally {
                WebetkUtils.closeQuery(res);
            }
        }
        String sSql = SQLStatements.Wertebereiche.instance.RETRIEVE_WERTEBEREICH();
        sSql = StringUtils.substituteString(sSql, "ART", sArt);
        sSql = StringUtils.substituteString(sSql, "ISO", sLang);
        sSql = sCountry == null || sCountry.equals("") ? StringUtils.substituteString(sSql, "REGISO", "  ") : StringUtils.substituteString(sSql, "REGISO", sCountry);
        Statement stmt = con.createStatement(1003, 1007);
        log.debug((Object)("Executing: " + sSql));
        ResultSet res = stmt.executeQuery(sSql);
        try {
            if (res != null) {
                Vector<ValueAndNameSupport> objResult = new Vector<ValueAndNameSupport>();
                while (res.next()) {
                    String sValue = res.getString("Value");
                    String sName = res.getString("Name");
                    ValueAndNameSupport objValName = new ValueAndNameSupport(sValue, sName);
                    objResult.add(objValName);
                }
                WebetkUtils.closeQuery(res);
                Vector<ValueAndNameSupport> vector = objResult;
                return vector;
            }
            log.info((Object)("No message found for: " + sArt + "(" + sLang + "/" + sCountry + ")"));
            Collection<ValueAndNameSupport> collection = null;
            return collection;
        }
        finally {
            WebetkUtils.closeQuery(res);
        }
    }

    public static ResultSet loadGrafik(Connection con, long lGrafikId, String sArt) throws SQLException {
        if (HtmlUtils.isConnectionSourceOracle(con)) {
            String sSQLStatement = SQLStatements.Allgemein.instance.LOAD_GRAFIK();
            String sGrafikId = Long.toString(lGrafikId);
            PreparedStatement ps = con.prepareStatement(sSQLStatement);
            ps.setString(1, sGrafikId);
            ps.setString(2, sArt);
            log.debug((Object)("Executing: " + sSQLStatement));
            ResultSet res = ps.executeQuery();
            return res;
        }
        String sSQLStatement = SQLStatements.Allgemein.instance.LOAD_GRAFIK();
        String sGrafikId = Long.toString(lGrafikId);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "GRAFIKID", sGrafikId);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "ART", sArt);
        log.debug((Object)("Executing: " + sSQLStatement));
        Statement stmt = con.createStatement();
        ResultSet res = stmt.executeQuery(sSQLStatement);
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String retrieveUrl(Connection con, String sTyp, String sIso, String sRegIso, String sMarke) throws SQLException {
        String sUrl;
        ResultSet res;
        block9: {
            String string;
            res = null;
            sUrl = null;
            try {
                if (!HtmlUtils.isConnectionSourceOracle(con)) break block9;
                String sSQLStatement = SQLStatements.Allgemein.instance.RETRIEVE_URLS();
                sTyp = sTyp.toUpperCase();
                sIso = sIso.toUpperCase();
                sRegIso = sRegIso.toUpperCase();
                sMarke = sMarke.toUpperCase();
                PreparedStatement ps = con.prepareStatement(sSQLStatement);
                ps.setString(1, sTyp);
                ps.setString(2, sIso);
                ps.setString(3, sRegIso);
                ps.setString(4, sMarke);
                log.debug((Object)("Executing: " + sSQLStatement));
                res = ps.executeQuery();
                String sParams = "Typ: " + sTyp + ", Language: " + sIso + sRegIso + ", Marke: " + sMarke;
                if (!res.next()) {
                    log.error((Object)("No URL found for Parameters: " + sParams));
                } else {
                    sUrl = res.getString("URL");
                    if (res.next()) {
                        log.error((Object)("More than on URL found for Parameters: " + sParams));
                        sUrl = null;
                    }
                }
                string = sUrl;
            }
            catch (Throwable throwable) {
                WebetkUtils.closeQuery(res);
                throw throwable;
            }
            WebetkUtils.closeQuery(res);
            return string;
        }
        String sSQLStatement = SQLStatements.Allgemein.instance.RETRIEVE_URLS();
        sTyp = sTyp.toUpperCase();
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "TYPE", sTyp);
        sIso = sIso.toUpperCase();
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "ISO", sIso);
        sRegIso = sRegIso.toUpperCase();
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "REGISO", sRegIso);
        sMarke = sMarke.toUpperCase();
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "MARKE", sMarke);
        log.debug((Object)("Executing: " + sSQLStatement));
        Statement stmt = con.createStatement();
        res = stmt.executeQuery(sSQLStatement);
        String sParams = "Typ: " + sTyp + ", Language: " + sIso + sRegIso + ", Marke: " + sMarke;
        if (!res.next()) {
            log.error((Object)("No URL found for Parameters: " + sParams));
        } else {
            sUrl = res.getString("URL");
            if (res.next()) {
                log.error((Object)("More than on URL found for Parameters: " + sParams));
                sUrl = null;
            }
        }
        String string = sUrl;
        WebetkUtils.closeQuery(res);
        return string;
    }

    public static String erzeugeSuchbegriffBen(Collection<String> cBegriffePlus, Collection<String> cBegriffeMinus, Collection<String> cBegriffeOder, String sSprache) {
        String sBegriff;
        Iterator<String> iterator;
        boolean bFirst;
        String sResult = null;
        if (cBegriffePlus.size() == 0 && cBegriffeMinus.size() == 0 && cBegriffeOder.size() == 0) {
            return null;
        }
        boolean bAndSchreiben = false;
        sResult = "(";
        if (cBegriffePlus.size() > 0) {
            bFirst = true;
            sResult = sResult + "(";
            iterator = cBegriffePlus.iterator();
            while (iterator.hasNext()) {
                sBegriff = AllgemeinDbAccess.prepareString(iterator.next());
                if (!bFirst) {
                    sResult = sResult + " and";
                }
                sResult = sSprache.equals("tr") ? sResult + SQLStatements.Allgemein.instance.getLikeTr("ben_text", sBegriff, true) : sResult + SQLStatements.Allgemein.instance.getLikeInsensitive("ben_text", sBegriff, true);
                bFirst = false;
            }
            sResult = sResult + ")";
            bAndSchreiben = true;
        }
        if (cBegriffeMinus.size() > 0) {
            if (bAndSchreiben) {
                sResult = sResult + " and";
            }
            bFirst = true;
            sResult = sResult + "(";
            iterator = cBegriffeMinus.iterator();
            while (iterator.hasNext()) {
                sBegriff = AllgemeinDbAccess.prepareString(iterator.next());
                if (!bFirst) {
                    sResult = sResult + " or";
                }
                sResult = sSprache.equals("tr") ? sResult + SQLStatements.Allgemein.instance.getNotLikeTr("ben_text", sBegriff, true) : sResult + SQLStatements.Allgemein.instance.getNotLikeInsensitive("ben_text", sBegriff, true);
                bFirst = false;
            }
            sResult = sResult + ")";
            bAndSchreiben = true;
        }
        if (cBegriffeOder.size() > 0) {
            if (bAndSchreiben) {
                sResult = sResult + " and";
            }
            bFirst = true;
            sResult = sResult + "(";
            iterator = cBegriffeOder.iterator();
            while (iterator.hasNext()) {
                sBegriff = AllgemeinDbAccess.prepareString(iterator.next());
                if (!bFirst) {
                    sResult = sResult + " or";
                }
                sResult = sSprache.equals("tr") ? sResult + SQLStatements.Allgemein.instance.getLikeTr("ben_text", sBegriff, true) : sResult + SQLStatements.Allgemein.instance.getLikeInsensitive("ben_text", sBegriff, true);
                bFirst = false;
            }
            sResult = sResult + ")";
            bAndSchreiben = true;
        }
        sResult = sResult + ")";
        return sResult;
    }

    public static String erzeugeSuchbegriffBenKomm(Collection<String> cBegriffePlus, Collection<String> cBegriffeMinus, Collection<String> cBegriffeOder, String sSprache) {
        String sBegriff;
        Iterator<String> iterator;
        boolean bFirst;
        String sResult = null;
        if (cBegriffePlus.size() == 0 && cBegriffeMinus.size() == 0 && cBegriffeOder.size() == 0) {
            return null;
        }
        boolean bAndSchreiben = false;
        sResult = "(";
        if (cBegriffePlus.size() > 0) {
            bFirst = true;
            sResult = sResult + "(";
            iterator = cBegriffePlus.iterator();
            while (iterator.hasNext()) {
                sBegriff = AllgemeinDbAccess.prepareString(iterator.next());
                if (!bFirst) {
                    sResult = sResult + " and";
                }
                sResult = sSprache.equals("tr") ? sResult + SQLStatements.Allgemein.instance.getLikeTr("ben_komm.ben_text", sBegriff, true) : sResult + SQLStatements.Allgemein.instance.getLikeInsensitive("ben_komm.ben_text", sBegriff, true);
                bFirst = false;
            }
            sResult = sResult + ")";
            bAndSchreiben = true;
        }
        if (cBegriffeMinus.size() > 0) {
            if (bAndSchreiben) {
                sResult = sResult + " and";
            }
            bFirst = true;
            sResult = sResult + "(";
            iterator = cBegriffeMinus.iterator();
            while (iterator.hasNext()) {
                sBegriff = AllgemeinDbAccess.prepareString(iterator.next());
                if (!bFirst) {
                    sResult = sResult + " or";
                }
                sResult = sSprache.equals("tr") ? sResult + SQLStatements.Allgemein.instance.getNotLikeTr("ben_komm.ben_text", sBegriff, true) : sResult + SQLStatements.Allgemein.instance.getNotLikeInsensitive("ben_komm.ben_text", sBegriff, true);
                bFirst = false;
            }
            sResult = sResult + ")";
            bAndSchreiben = true;
        }
        if (cBegriffeOder.size() > 0) {
            if (bAndSchreiben) {
                sResult = sResult + " and";
            }
            bFirst = true;
            sResult = sResult + "(";
            iterator = cBegriffeOder.iterator();
            while (iterator.hasNext()) {
                sBegriff = AllgemeinDbAccess.prepareString(iterator.next());
                if (!bFirst) {
                    sResult = sResult + " or";
                }
                sResult = sSprache.equals("tr") ? sResult + SQLStatements.Allgemein.instance.getLikeTr("ben_komm.ben_text", sBegriff, true) : sResult + SQLStatements.Allgemein.instance.getLikeInsensitive("ben_komm.ben_text", sBegriff, true);
                bFirst = false;
            }
            sResult = sResult + ")";
            bAndSchreiben = true;
        }
        sResult = sResult + ")";
        return sResult;
    }

    public static String erzeugeSuchbegriffBenTeil(Collection<String> cBegriffePlus, Collection<String> cBegriffeMinus, Collection<String> cBegriffeOder, String sSprache) {
        String sBegriff;
        Iterator<String> iterator;
        boolean bFirst;
        String sResult = null;
        if (cBegriffePlus.size() == 0 && cBegriffeMinus.size() == 0 && cBegriffeOder.size() == 0) {
            return null;
        }
        boolean bAndSchreiben = false;
        sResult = "(";
        if (cBegriffePlus.size() > 0) {
            bFirst = true;
            sResult = sResult + "(";
            iterator = cBegriffePlus.iterator();
            while (iterator.hasNext()) {
                sBegriff = AllgemeinDbAccess.prepareString(iterator.next());
                if (!bFirst) {
                    sResult = sResult + " and";
                }
                if (sSprache.equals("tr")) {
                    sResult = sResult + " (" + SQLStatements.Allgemein.instance.getLikeTr("ben_teil.ben_text", sBegriff, true) + " or";
                    sResult = sResult + " teil_benennzus is not null and " + SQLStatements.Allgemein.instance.getLikeTr("teil_benennzus", sBegriff, false) + ")";
                } else {
                    sResult = sResult + " (" + SQLStatements.Allgemein.instance.getLikeInsensitive("ben_teil.ben_text", sBegriff, true) + " or";
                    sResult = sResult + " teil_benennzus is not null and " + SQLStatements.Allgemein.instance.getLikeInsensitive("teil_benennzus", sBegriff, false) + ")";
                }
                bFirst = false;
            }
            sResult = sResult + ")";
            bAndSchreiben = true;
        }
        if (cBegriffeMinus.size() > 0) {
            if (bAndSchreiben) {
                sResult = sResult + " and";
            }
            bFirst = true;
            sResult = sResult + "(";
            iterator = cBegriffeMinus.iterator();
            while (iterator.hasNext()) {
                sBegriff = AllgemeinDbAccess.prepareString(iterator.next());
                if (!bFirst) {
                    sResult = sResult + " or";
                }
                if (sSprache.equals("tr")) {
                    sResult = sResult + " (" + SQLStatements.Allgemein.instance.getNotLikeTr("ben_teil.ben_text", sBegriff, true) + " and ";
                    sResult = sResult + " (teil_benennzus is null or " + SQLStatements.Allgemein.instance.getNotLikeTr("teil_benennzus", sBegriff, false) + "))";
                } else {
                    sResult = sResult + " (" + SQLStatements.Allgemein.instance.getNotLikeInsensitive("ben_teil.ben_text", sBegriff, true) + " and ";
                    sResult = sResult + " (teil_benennzus is null or " + SQLStatements.Allgemein.instance.getNotLikeInsensitive("teil_benennzus", sBegriff, false) + "))";
                }
                bFirst = false;
            }
            sResult = sResult + ")";
            bAndSchreiben = true;
        }
        if (cBegriffeOder.size() > 0) {
            if (bAndSchreiben) {
                sResult = sResult + " and";
            }
            bFirst = true;
            sResult = sResult + "(";
            iterator = cBegriffeOder.iterator();
            while (iterator.hasNext()) {
                sBegriff = AllgemeinDbAccess.prepareString(iterator.next());
                if (!bFirst) {
                    sResult = sResult + " or";
                }
                if (sSprache.equals("tr")) {
                    sResult = sResult + " (" + SQLStatements.Allgemein.instance.getLikeTr("ben_teil.ben_text", sBegriff, true) + " or";
                    sResult = sResult + " teil_benennzus is not null and " + SQLStatements.Allgemein.instance.getLikeTr("teil_benennzus", sBegriff, false) + ")";
                } else {
                    sResult = sResult + " (" + SQLStatements.Allgemein.instance.getLikeInsensitive("ben_teil.ben_text", sBegriff, true) + " or";
                    sResult = sResult + " teil_benennzus is not null and " + SQLStatements.Allgemein.instance.getLikeInsensitive("teil_benennzus", sBegriff, false) + ")";
                }
                bFirst = false;
            }
            sResult = sResult + ")";
            bAndSchreiben = true;
        }
        sResult = sResult + ")";
        return sResult;
    }

    public static String erzeugeSuchbegriffBenTeilKomm(Collection<String> cBegriffePlus, Collection<String> cBegriffeMinus, Collection<String> cBegriffeOder, String sISO) {
        String sBegriff;
        Iterator<String> iterator;
        boolean bFirst;
        String sResult = null;
        if (cBegriffePlus.size() == 0 && cBegriffeMinus.size() == 0 && cBegriffeOder.size() == 0) {
            return null;
        }
        boolean bAndSchreiben = false;
        sResult = "(";
        if (cBegriffePlus.size() > 0) {
            bFirst = true;
            sResult = sResult + "(";
            iterator = cBegriffePlus.iterator();
            while (iterator.hasNext()) {
                sBegriff = AllgemeinDbAccess.prepareString(iterator.next());
                if (!bFirst) {
                    sResult = sResult + " and";
                }
                sResult = sISO.equals("tr") ? sResult + " ( " + SQLStatements.Allgemein.instance.getLikeTr("ben_komm.ben_text", sBegriff, true) + ")" : sResult + " ( " + SQLStatements.Allgemein.instance.getLikeInsensitive("ben_komm.ben_text", sBegriff, true) + ")";
                bFirst = false;
            }
            sResult = sResult + ")";
            bAndSchreiben = true;
        }
        if (cBegriffeMinus.size() > 0) {
            if (bAndSchreiben) {
                sResult = sResult + " and";
            }
            bFirst = true;
            sResult = sResult + "(";
            iterator = cBegriffeMinus.iterator();
            while (iterator.hasNext()) {
                sBegriff = AllgemeinDbAccess.prepareString(iterator.next());
                if (!bFirst) {
                    sResult = sResult + " or";
                }
                sResult = sISO.equals("tr") ? sResult + " ( " + SQLStatements.Allgemein.instance.getNotLikeTr("ben_komm.ben_text", sBegriff, true) + ")" : sResult + " ( " + SQLStatements.Allgemein.instance.getNotLikeInsensitive("ben_komm.ben_text", sBegriff, true) + ")";
                bFirst = false;
            }
            sResult = sResult + ")";
            bAndSchreiben = true;
        }
        if (cBegriffeOder.size() > 0) {
            if (bAndSchreiben) {
                sResult = sResult + " and";
            }
            bFirst = true;
            sResult = sResult + "(";
            iterator = cBegriffeOder.iterator();
            while (iterator.hasNext()) {
                sBegriff = AllgemeinDbAccess.prepareString(iterator.next());
                if (!bFirst) {
                    sResult = sResult + " or";
                }
                sResult = sISO.equals("tr") ? sResult + " ( " + SQLStatements.Allgemein.instance.getLikeTr("ben_komm.ben_text", sBegriff, true) + ")" : sResult + " ( " + SQLStatements.Allgemein.instance.getLikeInsensitive("ben_komm.ben_text", sBegriff, true) + ")";
                bFirst = false;
            }
            sResult = sResult + ")";
            bAndSchreiben = true;
        }
        sResult = sResult + ")";
        return sResult;
    }

    private static String prepareString(String sString) {
        if (sString == null) {
            return null;
        }
        sString = StringUtils.substituteStringStraight(sString, "*", "%");
        sString = StringUtils.maskiereHochkommaFuerDb(sString);
        return sString;
    }

    public static ResultSet loadBmwNetzNutzer(Connection con) throws SQLException {
        ResultSet res = null;
        String sSQLStatement = SQLStatements.Allgemein.instance.RETRIEVE_BMW_NETZ();
        log.debug((Object)("Executing: " + sSQLStatement));
        Statement stmt = con.createStatement();
        res = stmt.executeQuery(sSQLStatement);
        return res;
    }

    public static ResultSet loadBmwNetzPubl(Connection con, String sNetz, String sKrit) throws SQLException {
        ResultSet res = null;
        if (HtmlUtils.isConnectionSourceOracle(con)) {
            String sSQLStatement = SQLStatements.Allgemein.instance.RETRIEVE_BMW_NETZURL();
            PreparedStatement ps = con.prepareStatement(sSQLStatement);
            ps.setString(1, sNetz);
            ps.setString(2, sKrit);
            log.debug((Object)("Executing: " + sSQLStatement));
            res = ps.executeQuery();
            return res;
        }
        String sSQLStatement = SQLStatements.Allgemein.instance.RETRIEVE_BMW_NETZURL();
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "NETZ", sNetz);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "KRIT", sKrit);
        log.debug((Object)("Executing: " + sSQLStatement));
        Statement stmt = con.createStatement();
        res = stmt.executeQuery(sSQLStatement);
        return res;
    }

    public static ResultSet loadAllBmwNetzPubl(Connection con) throws SQLException {
        ResultSet res = null;
        String sSQLStatement = SQLStatements.Allgemein.instance.RETRIEVE_ALL_BMW_NETZURL();
        log.debug((Object)("Executing: " + sSQLStatement));
        Statement stmt = con.createStatement();
        res = stmt.executeQuery(sSQLStatement);
        return res;
    }

    public static ResultSet loadBmwProxy(Connection con) throws SQLException {
        ResultSet res = null;
        String sSQLStatement = SQLStatements.Allgemein.instance.RETRIEVE_BMW_PROXY();
        log.debug((Object)("Executing: " + sSQLStatement));
        Statement stmt = con.createStatement();
        res = stmt.executeQuery(sSQLStatement);
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int[] loadMarktAndDealer(Connection con) throws SQLException {
        ResultSet res;
        int[] data;
        block3: {
            int[] nArray;
            data = new int[2];
            res = null;
            String sSQLStatement = "SELECT markt_id, dealer_type FROM w_dealer_type WHERE id=1";
            log.debug((Object)("Executing: " + sSQLStatement));
            try {
                Statement stmt = con.createStatement();
                res = stmt.executeQuery(sSQLStatement);
                if (res != null && res.next()) break block3;
                log.info((Object)"res = null");
                nArray = null;
            }
            catch (Throwable throwable) {
                WebetkUtils.closeQuery(res);
                throw throwable;
            }
            WebetkUtils.closeQuery(res);
            return nArray;
        }
        data[0] = res.getInt("markt_id");
        data[1] = res.getInt("dealer_type");
        WebetkUtils.closeQuery(res);
        return data;
    }

    public static String concatStrings(String[] asString, boolean bHochkomma) {
        String sResult = null;
        for (int i = 0; i < asString.length; ++i) {
            String sEintrag = asString[i];
            if (bHochkomma) {
                sEintrag = "'" + sEintrag + "'";
            }
            sResult = sResult == null ? sEintrag : sResult + "," + sEintrag;
        }
        return sResult;
    }
}

