/*
 * Decompiled with CFR 0.152.
 */
package webetk.db.dbaccess;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.log4j.Logger;
import webetk.LanguageUtils;
import webetk.db.SQLStatements;
import webetk.utils.StringUtils;
import webetk.utils.communication.HtmlUtils;

public class BedAuswertungDbAccess {
    private static Logger log = Logger.getLogger(BedAuswertungDbAccess.class);

    public static ResultSet loadBTE(Connection con, String sBildtafelNr, String sSprache) throws SQLException {
        if (HtmlUtils.isConnectionSourceOracle(con)) {
            String sSQLStatement = SQLStatements.BedAuswertung.instance.LOAD_BT_STAMM();
            String sISO = LanguageUtils.toLanguage(sSprache);
            String sRegISO = LanguageUtils.toRegion(sSprache, true);
            PreparedStatement ps = con.prepareStatement(sSQLStatement);
            ps.setString(2, sISO);
            ps.setString(3, sRegISO);
            ps.setString(1, sBildtafelNr);
            log.debug((Object)("Executing: " + sSQLStatement));
            ResultSet res = ps.executeQuery();
            return res;
        }
        String sSQLStatement = SQLStatements.BedAuswertung.instance.LOAD_BT_STAMM();
        String sISO = LanguageUtils.toLanguage(sSprache);
        String sRegISO = LanguageUtils.toRegion(sSprache, true);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "ISO", sISO);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "REGISO", sRegISO);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "BTNR", sBildtafelNr);
        log.debug((Object)("Executing: " + sSQLStatement));
        Statement stmt = con.createStatement();
        ResultSet res = stmt.executeQuery(sSQLStatement);
        return res;
    }

    public static ResultSet loadBTEChangepoints(Connection con, String sBildtafelNr) throws SQLException {
        if (HtmlUtils.isConnectionSourceOracle(con)) {
            String sSQLStatement = SQLStatements.BedAuswertung.instance.LOAD_BT_STAMM_CP();
            PreparedStatement ps = con.prepareStatement(sSQLStatement);
            ps.setString(1, sBildtafelNr);
            log.debug((Object)("Executing: " + sSQLStatement));
            ResultSet res = ps.executeQuery();
            return res;
        }
        String sSQLStatement = SQLStatements.BedAuswertung.instance.LOAD_BT_STAMM_CP();
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "BTNR", sBildtafelNr);
        log.debug((Object)("Executing: " + sSQLStatement));
        Statement stmt = con.createStatement();
        ResultSet res = stmt.executeQuery(sSQLStatement);
        return res;
    }

    public static ResultSet loadBTEBedingungenSala(Connection con, String sBildtafelNr, long lModellspalte, String sSprache) throws SQLException {
        if (HtmlUtils.isConnectionSourceOracle(con)) {
            String sSQLStatement = SQLStatements.BedAuswertung.instance.LOAD_BT_BEDINGUNGEN_SALA();
            PreparedStatement ps = con.prepareStatement(sSQLStatement);
            String sISO = LanguageUtils.toLanguage(sSprache);
            String sRegISO = LanguageUtils.toRegion(sSprache, true);
            ps.setString(3, sISO);
            ps.setString(4, sRegISO);
            ps.setString(1, sBildtafelNr);
            String sModellspalte = Long.toString(lModellspalte);
            ps.setString(2, sModellspalte);
            ps.setString(5, sBildtafelNr);
            ps.setString(6, sISO);
            ps.setString(7, sRegISO);
            log.debug((Object)("Executing: " + sSQLStatement));
            ResultSet res = ps.executeQuery();
            return res;
        }
        String sSQLStatement = SQLStatements.BedAuswertung.instance.LOAD_BT_BEDINGUNGEN_SALA();
        String sISO = LanguageUtils.toLanguage(sSprache);
        String sRegISO = LanguageUtils.toRegion(sSprache, true);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "ISO", sISO);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "REGISO", sRegISO);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "BTNR", sBildtafelNr);
        String sModellspalte = Long.toString(lModellspalte);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "MOSP", sModellspalte);
        log.debug((Object)("Executing: " + sSQLStatement));
        Statement stmt = con.createStatement();
        ResultSet res = stmt.executeQuery(sSQLStatement);
        return res;
    }

    public static ResultSet loadBTEBedingungenAFL(Connection con, String sBildtafelNr, long lModellspalte, String sSprache) throws SQLException {
        if (HtmlUtils.isConnectionSourceOracle(con)) {
            String sSQLStatement = SQLStatements.BedAuswertung.instance.LOAD_BT_BEDINGUNGEN_AFL();
            PreparedStatement ps = con.prepareStatement(sSQLStatement);
            String sISO = LanguageUtils.toLanguage(sSprache);
            String sRegISO = LanguageUtils.toRegion(sSprache, true);
            ps.setString(3, sISO);
            ps.setString(4, sRegISO);
            ps.setString(1, sBildtafelNr);
            String sModellspalte = Long.toString(lModellspalte);
            ps.setString(2, sModellspalte);
            ps.setString(5, sBildtafelNr);
            ps.setString(6, sISO);
            ps.setString(7, sRegISO);
            log.debug((Object)("Executing: " + sSQLStatement));
            ResultSet res = ps.executeQuery();
            return res;
        }
        String sSQLStatement = SQLStatements.BedAuswertung.instance.LOAD_BT_BEDINGUNGEN_AFL();
        String sISO = LanguageUtils.toLanguage(sSprache);
        String sRegISO = LanguageUtils.toRegion(sSprache, true);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "ISO", sISO);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "REGISO", sRegISO);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "BTNR", sBildtafelNr);
        String sModellspalte = Long.toString(lModellspalte);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "MOSP", sModellspalte);
        log.debug((Object)("Executing: " + sSQLStatement));
        Statement stmt = con.createStatement();
        ResultSet res = stmt.executeQuery(sSQLStatement);
        return res;
    }

    public static ResultSet loadBTEBedingungenText(Connection con, String sBildtafelNr, long lModellspalte, String sSprache) throws SQLException {
        if (HtmlUtils.isConnectionSourceOracle(con)) {
            String sSQLStatement = SQLStatements.BedAuswertung.instance.LOAD_BT_BEDINGUNGEN_TEXT();
            PreparedStatement ps = con.prepareStatement(sSQLStatement);
            int index = 0;
            String sISO = LanguageUtils.toLanguage(sSprache);
            String sRegISO = LanguageUtils.toRegion(sSprache, true);
            ps.setString(++index, sBildtafelNr);
            String sModellspalte = Long.toString(lModellspalte);
            ps.setString(++index, sModellspalte);
            ps.setString(++index, "TEXT");
            ps.setString(++index, sISO);
            ps.setString(++index, sRegISO);
            ps.setString(++index, sBildtafelNr);
            ps.setString(++index, "TEXT");
            ps.setString(++index, sISO);
            ps.setString(++index, sRegISO);
            log.debug((Object)("Executing: " + sSQLStatement));
            ResultSet res = ps.executeQuery();
            return res;
        }
        String sSQLStatement = SQLStatements.BedAuswertung.instance.LOAD_BT_BEDINGUNGEN_TEXT();
        String sISO = LanguageUtils.toLanguage(sSprache);
        String sRegISO = LanguageUtils.toRegion(sSprache, true);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "ISO", sISO);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "REGISO", sRegISO);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "BTNR", sBildtafelNr);
        String sModellspalte = Long.toString(lModellspalte);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "MOSP", sModellspalte);
        log.debug((Object)("Executing: " + sSQLStatement));
        Statement stmt = con.createStatement();
        ResultSet res = stmt.executeQuery(sSQLStatement);
        return res;
    }
}

