/*
 * Decompiled with CFR 0.152.
 */
package webetk.db.dbaccess;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.log4j.Logger;
import webetk.LanguageUtils;
import webetk.db.SQLStatements;
import webetk.utils.StringUtils;
import webetk.utils.communication.HtmlUtils;

public class BteInfoDbAccess {
    private static Logger log = Logger.getLogger(BteInfoDbAccess.class);

    public static ResultSet loadBTEInfo(Connection con, String sBTENr, String sProduktart, String sSprache) throws SQLException {
        if (HtmlUtils.isConnectionSourceOracle(con)) {
            ResultSet res = null;
            String sSQLStatement = SQLStatements.BTEInfo.instance.RETRIEVE_BTEINFO();
            PreparedStatement ps = con.prepareStatement(sSQLStatement);
            int index = 0;
            ps.setString(++index, sBTENr);
            ps.setString(++index, sProduktart);
            String sISO = LanguageUtils.toLanguage(sSprache);
            ps.setString(++index, sISO);
            String sRegISO = LanguageUtils.toRegion(sSprache, true);
            ps.setString(++index, sRegISO);
            log.debug((Object)("Executing: " + sSQLStatement));
            res = ps.executeQuery();
            return res;
        }
        ResultSet res = null;
        String sSQLStatement = SQLStatements.BTEInfo.instance.RETRIEVE_BTEINFO();
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "BTENR", sBTENr);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "PRODUKTART", sProduktart);
        String sISO = LanguageUtils.toLanguage(sSprache);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "ISO", sISO);
        String sRegISO = LanguageUtils.toRegion(sSprache, true);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "REGISO", sRegISO);
        log.debug((Object)("Executing: " + sSQLStatement));
        Statement stmt = con.createStatement();
        res = stmt.executeQuery(sSQLStatement);
        return res;
    }

    public static ResultSet loadBTEKommentar(Connection con, String sBTENr, String sSprache) throws SQLException {
        if (HtmlUtils.isConnectionSourceOracle(con)) {
            String sSQLStatement = SQLStatements.BTEInfo.instance.RETRIEVE_BTEKOMMENTAR();
            PreparedStatement ps = con.prepareStatement(sSQLStatement);
            int index = 0;
            ps.setString(++index, sBTENr);
            String sISO = LanguageUtils.toLanguage(sSprache);
            String sRegISO = LanguageUtils.toRegion(sSprache, true);
            ps.setString(++index, sISO);
            ps.setString(++index, sRegISO);
            log.debug((Object)("Executing: " + sSQLStatement));
            ResultSet res = ps.executeQuery();
            return res;
        }
        String sSQLStatement = SQLStatements.BTEInfo.instance.RETRIEVE_BTEKOMMENTAR();
        String sISO = LanguageUtils.toLanguage(sSprache);
        String sRegISO = LanguageUtils.toRegion(sSprache, true);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "ISO", sISO);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "REGISO", sRegISO);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "BTNR", sBTENr);
        log.debug((Object)("Executing: " + sSQLStatement));
        Statement stmt = con.createStatement();
        ResultSet res = stmt.executeQuery(sSQLStatement);
        return res;
    }
}

