/*
 * Decompiled with CFR 0.152.
 */
package webetk.db.dbaccess;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collection;
import java.util.Iterator;
import org.apache.log4j.Logger;
import webetk.LanguageUtils;
import webetk.WebetkUtils;
import webetk.app.ValueAndName;
import webetk.db.SQLStatements;
import webetk.utils.StringUtils;
import webetk.utils.communication.HtmlUtils;

public class TeileErsetzungDbAccess {
    private static Logger log = Logger.getLogger(TeileErsetzungDbAccess.class);

    public static ResultSet selectHGs(Connection con, String sHGVon, String sHGBis, long lDatumAb, String sMospIDs, String sLenkung) throws SQLException {
        String sSQLStatement = SQLStatements.Teileersetzung.instance.RETRIEVE_HGS();
        if (HtmlUtils.isConnectionSourceOracle(con)) {
            int index = 0;
            String[] aMospIDs = sMospIDs.split(",");
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "IN", StringUtils.preparePlaceHolders(aMospIDs.length));
            for (int i = 0; i < aMospIDs.length; ++i) {
                StringUtils.setPreparedStatementParams(++index, aMospIDs[i]);
            }
            if (sHGVon == null || sHGVon.length() == 0) {
                sHGVon = "11";
            }
            StringUtils.setPreparedStatementParams(++index, sHGVon);
            if (sHGBis == null || sHGBis.length() == 0) {
                sSQLStatement = StringUtils.substituteString(sSQLStatement, "HGBIS_STMT", "");
            } else {
                sSQLStatement = StringUtils.substituteString(sSQLStatement, "HGBIS_STMT", SQLStatements.Teileersetzung.instance.HG_BIS_STMT());
                StringUtils.setPreparedStatementParams(++index, sHGBis);
            }
            if (sLenkung == null || sLenkung.length() == 0) {
                sSQLStatement = StringUtils.substituteString(sSQLStatement, "LENKUNG_STMT", "");
            } else {
                sSQLStatement = StringUtils.substituteString(sSQLStatement, "LENKUNG_STMT", SQLStatements.Teileersetzung.instance.HG_LENKUNG_STMT());
                StringUtils.setPreparedStatementParams(++index, sLenkung);
            }
            if (lDatumAb == 0L) {
                sSQLStatement = StringUtils.substituteString(sSQLStatement, "DATSERIE_STMT", "");
            } else {
                sSQLStatement = StringUtils.substituteString(sSQLStatement, "DATSERIE_STMT", SQLStatements.Teileersetzung.instance.HG_DAT_SERIE_STMT());
                String sDatumAb = String.valueOf(lDatumAb);
                StringUtils.setPreparedStatementParams(++index, sDatumAb);
            }
            PreparedStatement ps = con.prepareStatement(sSQLStatement);
            ps = StringUtils.setParameters(ps);
            log.debug((Object)("Executing: " + sSQLStatement));
            ResultSet res = ps.executeQuery();
            return res;
        }
        if (sLenkung == null || sLenkung.length() == 0) {
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "LENKUNG_STMT", "");
        } else {
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "LENKUNG_STMT", SQLStatements.Teileersetzung.instance.HG_LENKUNG_STMT());
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "LENKUNG", sLenkung);
        }
        if (sHGVon == null || sHGVon.length() == 0) {
            sHGVon = "11";
        }
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "HGAB", sHGVon);
        if (sHGBis == null || sHGBis.length() == 0) {
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "HGBIS_STMT", "");
        } else {
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "HGBIS_STMT", SQLStatements.Teileersetzung.instance.HG_BIS_STMT());
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "HGBIS", sHGBis);
        }
        if (lDatumAb == 0L) {
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "DATSERIE_STMT", "");
        } else {
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "DATSERIE_STMT", SQLStatements.Teileersetzung.instance.HG_DAT_SERIE_STMT());
            String sDatumAb = String.valueOf(lDatumAb);
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "DATUMAB", sDatumAb);
        }
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "MOSPIDS", sMospIDs);
        log.debug((Object)("Executing: " + sSQLStatement));
        Statement stmt = con.createStatement();
        ResultSet res = stmt.executeQuery(sSQLStatement);
        return res;
    }

    public static ResultSet findHG(Connection con, String sHG) throws SQLException {
        String sSQLStatement = SQLStatements.Teileersetzung.instance.FIND_HG();
        if (HtmlUtils.isConnectionSourceOracle(con)) {
            PreparedStatement ps = con.prepareStatement(sSQLStatement);
            ps.setString(1, sHG);
            log.debug((Object)("Executing: " + sSQLStatement));
            ResultSet res = ps.executeQuery();
            return res;
        }
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "HG", sHG);
        log.debug((Object)("Executing: " + sSQLStatement));
        Statement stmt = con.createStatement();
        ResultSet res = stmt.executeQuery(sSQLStatement);
        return res;
    }

    public static ResultSet selectTeile(Connection con, String sSprache, String sHG, long lDatumAb, String sMospIDs, String sLenkung, String sLandkuerzel) throws SQLException {
        String sSQLStatement = SQLStatements.Teileersetzung.instance.RETRIEVE_TEILE();
        if (HtmlUtils.isConnectionSourceOracle(con)) {
            int index = 0;
            String sISO = LanguageUtils.toLanguage(sSprache);
            String sRegISO = LanguageUtils.toRegion(sSprache, true);
            StringUtils.setPreparedStatementParams(++index, sISO);
            StringUtils.setPreparedStatementParams(++index, sRegISO);
            String[] aMospIDs = sMospIDs.split(",");
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "IN", StringUtils.preparePlaceHolders(aMospIDs.length));
            for (int i = 0; i < aMospIDs.length; ++i) {
                StringUtils.setPreparedStatementParams(++index, aMospIDs[i]);
            }
            if (sLandkuerzel != null && !sLandkuerzel.trim().equals("")) {
                sSQLStatement = StringUtils.substituteString(sSQLStatement, "TC_CHECK_LANDKUERZEL", SQLStatements.Teileersetzung.instance.TC_CHECK_LANDKUERZEL());
                StringUtils.setPreparedStatementParams(++index, sLandkuerzel);
            } else {
                sSQLStatement = StringUtils.substituteString(sSQLStatement, "TC_CHECK_LANDKUERZEL", "");
            }
            String sToday = WebetkUtils.getTodayYYYYMMDD();
            StringUtils.setPreparedStatementParams(++index, sToday);
            StringUtils.setPreparedStatementParams(++index, sToday);
            StringUtils.setPreparedStatementParams(++index, sHG);
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "MOSPIDS", sMospIDs);
            if (sLenkung == null || sLenkung.length() == 0) {
                sSQLStatement = StringUtils.substituteString(sSQLStatement, "LENKUNG_STMT", "");
            } else {
                sSQLStatement = StringUtils.substituteString(sSQLStatement, "LENKUNG_STMT", SQLStatements.Teileersetzung.instance.TEIL_LENKUNG_STMT());
                StringUtils.setPreparedStatementParams(++index, sLenkung);
            }
            if (lDatumAb == 0L) {
                sSQLStatement = StringUtils.substituteString(sSQLStatement, "DATSERIE_STMT", "");
            } else {
                sSQLStatement = StringUtils.substituteString(sSQLStatement, "DATSERIE_STMT", SQLStatements.Teileersetzung.instance.TEIL_DAT_SERIE_STMT());
                String sDatumAb = String.valueOf(lDatumAb);
                StringUtils.setPreparedStatementParams(++index, sDatumAb);
            }
            PreparedStatement ps = con.prepareStatement(sSQLStatement);
            ps = StringUtils.setParameters(ps);
            log.debug((Object)("Executing: " + sSQLStatement));
            ResultSet res = ps.executeQuery();
            return res;
        }
        if (sLenkung == null || sLenkung.length() == 0) {
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "LENKUNG_STMT", "");
        } else {
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "LENKUNG_STMT", SQLStatements.Teileersetzung.instance.TEIL_LENKUNG_STMT());
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "LENKUNG", sLenkung);
        }
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "HG", sHG);
        if (lDatumAb == 0L) {
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "DATSERIE_STMT", "");
        } else {
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "DATSERIE_STMT", SQLStatements.Teileersetzung.instance.TEIL_DAT_SERIE_STMT());
            String sDatumAb = String.valueOf(lDatumAb);
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "DATUMAB", sDatumAb);
        }
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "MOSPIDS", sMospIDs);
        String sISO = LanguageUtils.toLanguage(sSprache);
        String sRegISO = LanguageUtils.toRegion(sSprache, true);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "ISO", sISO);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "REGISO", sRegISO);
        String sToday = WebetkUtils.getTodayYYYYMMDD();
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "DATUM", sToday);
        if (sLandkuerzel != null && !sLandkuerzel.trim().equals("")) {
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "TC_CHECK_LANDKUERZEL", SQLStatements.Teileersetzung.instance.TC_CHECK_LANDKUERZEL());
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "LANDKUERZEL", sLandkuerzel);
        } else {
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "TC_CHECK_LANDKUERZEL", "");
        }
        log.debug((Object)("Executing: " + sSQLStatement));
        Statement stmt = con.createStatement();
        ResultSet res = stmt.executeQuery(sSQLStatement);
        return res;
    }

    static String concatCollection(Collection cCollection) {
        String sString = "";
        if (cCollection == null) {
            return sString;
        }
        Iterator iterator = cCollection.iterator();
        while (iterator.hasNext()) {
            Object nextValue;
            if (sString.length() > 0) {
                sString = sString + ", ";
            }
            if ((nextValue = iterator.next()) instanceof String) {
                sString = sString + "'" + (String)nextValue + "'";
                continue;
            }
            if (!(nextValue instanceof ValueAndName)) continue;
            ValueAndName objValueAndName = (ValueAndName)nextValue;
            sString = sString + "'" + objValueAndName.getValue() + "'";
        }
        return sString;
    }
}

