/*
 * Decompiled with CFR 0.152.
 */
package webetk.db.zub.dbaccess;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.apache.log4j.Logger;
import webetk.DatabaseBusyException;
import webetk.InvalidDataException;
import webetk.InvalidInitializationException;
import webetk.LanguageUtils;
import webetk.WebetkUtils;
import webetk.app.BTEBedingungsmenge;
import webetk.app.Bedingungsmenge;
import webetk.app.ServerGlobalObjects;
import webetk.app.fzgsuche.FzgSucheInfo;
import webetk.app.zub.common.Zubehoergrafik;
import webetk.app.zub.marketing.MarketingProdukt;
import webetk.app.zub.suche.Bnb;
import webetk.app.zub.suche.ProduktListenElement;
import webetk.app.zub.technisch.CurrentBTE;
import webetk.app.zub.technisch.EinbauInfo;
import webetk.app.zub.technisch.RefaArbeit;
import webetk.app.zub.technisch.TechnischerBnb;
import webetk.app.zub.technisch.TechnischesProdukt;
import webetk.app.zub.verwaltung.Fahrzeug;
import webetk.db.zub.SQLStatements;
import webetk.mrkprd.Produkte;
import webetk.utils.StringUtils;
import webetk.utils.communication.HtmlUtils;

public class TechnischDbAccess {
    private static Logger log = Logger.getLogger(TechnischDbAccess.class);

    public static TechnischesProdukt getTechnischesProduktFzg(MarketingProdukt mprodukt, long mospId, String iso, String regIso, Fahrzeug fahrzeug, int marktId, boolean bIGDOM) throws InvalidInitializationException, SQLException, InvalidDataException, DatabaseBusyException {
        String sBildtafelNr = mprodukt.getBteNr();
        String sProduktart = fahrzeug.getProduktart();
        String typschl = fahrzeug.getTypschluessel();
        Collection<String> cRelevanteBildposNr = mprodukt.getRelevanteBildposNr();
        String sSprache = iso;
        if (regIso != null) {
            sSprache = sSprache + regIso;
        }
        CurrentBTE oBildtafel = new CurrentBTE(sBildtafelNr, cRelevanteBildposNr, mprodukt.getVariantenZuRelevantenBildposNr(), mospId, sSprache, bIGDOM);
        oBildtafel.loadStammdaten(fahrzeug.getBedingungsMenge());
        oBildtafel.ladenZubBildtafelZeilen(fahrzeug);
        String sProduktName = mprodukt.getProduktName();
        List<Zubehoergrafik> aImages = Arrays.asList(new Zubehoergrafik());
        List<TechnischerBnb> aBauteileKern = oBildtafel.getZubBnbsBauteile(sBildtafelNr, "Kernprodukt");
        List<TechnischerBnb> aBauteileZusatz = oBildtafel.getZubBnbsBauteile(sBildtafelNr, "Zusatz");
        List<TechnischerBnb> aBauteileHilf = oBildtafel.getZubBnbsBauteile(sBildtafelNr, "Hilfsstoffe");
        TechnischesProdukt oTechnischesProdukt = new TechnischesProdukt(sBildtafelNr, (int)mospId, sProduktName, aImages, aBauteileKern, aBauteileZusatz, aBauteileHilf);
        String sBaureihe = fahrzeug.getBaureihe();
        if (sBaureihe == null) {
            log.error((Object)"Baureihe is null!!!!");
            throw new InvalidInitializationException();
        }
        if (mprodukt.getBildPosNr() == null) {
            List aEinbauinfoBildatel = null;
            if (sProduktart.equals(Produkte.getInstance().getProdukt("MOTORRAD").getBerechtigung())) {
                aEinbauinfoBildatel = TechnischDbAccess.ermittleRefaArbeitBte(mprodukt.getBteNr(), (int)mospId, typschl, iso, regIso);
            }
            if (aEinbauinfoBildatel == null) {
                aEinbauinfoBildatel = TechnischDbAccess.getEinbauInfoProdukt(mprodukt, sBaureihe, iso, regIso, marktId, sProduktart);
            }
            oTechnischesProdukt.setEinbauInfoProdukt(aEinbauinfoBildatel);
        }
        if (mprodukt.getVariantenZuRelevantenBildposNr() != null && mprodukt.getVariantenZuRelevantenBildposNr().size() > 0) {
            List aEinbauinfoVariante = TechnischDbAccess.getEinbauInfoVariante(mprodukt, sBaureihe, iso, regIso, marktId, sProduktart);
            oTechnischesProdukt.setEinbauInfoVariante(aEinbauinfoVariante);
        }
        List aTechnischeBnbs = null;
        if (sProduktart.equals(Produkte.getInstance().getProdukt("MOTORRAD").getBerechtigung())) {
            aTechnischeBnbs = TechnischDbAccess.ermittleRefaArbeitBnb(mprodukt.getBteNr(), (int)mospId, typschl, iso, regIso);
        }
        if (aTechnischeBnbs == null) {
            aTechnischeBnbs = TechnischDbAccess.getEinbauInfoBnb(mprodukt, sBaureihe, marktId, sProduktart);
        }
        for (int i = 0; i < aTechnischeBnbs.size(); ++i) {
            TechnischerBnb oBnb;
            TechnischerBnb oBnbHelp = (TechnischerBnb)aTechnischeBnbs.get(i);
            if (oBnbHelp.getEinbauInfo().size() == 0 || (oBnb = oTechnischesProdukt.findTechnischenBnb(oBnbHelp)) == null) continue;
            oBnb.setEinbauInfo(oBnbHelp.getEinbauInfo());
        }
        List images = TechnischDbAccess.ermittleExplosionsGrafik(mprodukt.getBteNr());
        oTechnischesProdukt.setImages(images);
        return oTechnischesProdukt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List ermittleRefaArbeitBte(String bteNr, int mospid, String typschl, String iso, String regIso) throws SQLException, DatabaseBusyException {
        Connection con = null;
        ServerGlobalObjects globs = ServerGlobalObjects.getInstance();
        try {
            con = globs.getDBConnection("webetk.db.zub.technisch.getRefaArbeitBte");
            List list = TechnischDbAccess.ermittleRefaArbeitBteInternal(con, bteNr, mospid, typschl, iso, regIso, new ArrayList());
            return list;
        }
        finally {
            if (con != null) {
                globs.freeDBConnection(con, "webetk.db.zub.technisch.getRefaArbeitBte");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List ermittleRefaArbeitBnb(String bteNr, int mospid, String typschl, String iso, String regIso) throws SQLException, DatabaseBusyException {
        Connection con = null;
        ServerGlobalObjects globs = ServerGlobalObjects.getInstance();
        try {
            con = globs.getDBConnection("webetk.db.zub.technisch.getRefaArbeitBte");
            ArrayList arrayList = TechnischDbAccess.ermittleRefaArbeitenBnbInternal(con, bteNr, typschl, mospid, iso, regIso);
            return arrayList;
        }
        finally {
            if (con != null) {
                globs.freeDBConnection(con, "webetk.db.zub.technisch.getRefaArbeitBte");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List ermittleExplosionsGrafik(String bteNr) throws SQLException, DatabaseBusyException {
        ArrayList<Zubehoergrafik> arrayList;
        ResultSet rs;
        Statement ps;
        block10: {
            ps = null;
            rs = null;
            ServerGlobalObjects globs = ServerGlobalObjects.getInstance();
            Connection con = null;
            try {
                con = globs.getDBConnection("ermittleExplosionsGrafik");
                String statement = SQLStatements.TechnischeSicht.instance.LOAD_EXPLOSIONSGRAFIKEN();
                ps = con.prepareStatement(statement);
                ps.setString(1, bteNr);
                ps.setString(2, "Z");
                ArrayList<Zubehoergrafik> images = new ArrayList<Zubehoergrafik>();
                rs = ps.executeQuery();
                while (rs.next()) {
                    byte[] blob = rs.getBytes("bild");
                    String format = rs.getString("format");
                    Zubehoergrafik grafik = new Zubehoergrafik(blob);
                    grafik.setDateiTyp(format.toUpperCase());
                    images.add(grafik);
                }
                arrayList = images;
                if (con == null) break block10;
            }
            catch (Throwable throwable) {
                if (con != null) {
                    globs.freeDBConnection(con, "ermittleExplosionsGrafik");
                }
                if (rs != null) {
                    WebetkUtils.closeQuery(rs);
                } else if (ps != null) {
                    ps.close();
                }
                throw throwable;
            }
            globs.freeDBConnection(con, "ermittleExplosionsGrafik");
        }
        if (rs != null) {
            WebetkUtils.closeQuery(rs);
        } else if (ps != null) {
            ps.close();
        }
        return arrayList;
    }

    public static BTEBedingungsmenge evalBedingungenTechnischesProdukt(MarketingProdukt mprodukt, long mospId, String iso, String regIso, FzgSucheInfo oFzgSucheInfo, boolean bIGDOM) throws InvalidInitializationException, SQLException, InvalidDataException, DatabaseBusyException {
        String sBildtafelNr = mprodukt.getBteNr();
        String sSprache = iso;
        if (regIso != null) {
            sSprache = sSprache + regIso;
        }
        Collection<String> cRelevanteBildposNr = mprodukt.getRelevanteBildposNr();
        Bedingungsmenge oBeds = oFzgSucheInfo.getBedingungsMenge();
        if (oBeds == null) {
            log.error((Object)"Bedingungsmenge is null");
        }
        CurrentBTE oBildtafel = new CurrentBTE(sBildtafelNr, cRelevanteBildposNr, mprodukt.getVariantenZuRelevantenBildposNr(), mospId, sSprache, bIGDOM);
        oBildtafel.loadStammdaten(oFzgSucheInfo.getBedingungsMenge());
        return oBildtafel.getBedingungen();
    }

    public static TechnischesProdukt getTechnischesProduktUgb(MarketingProdukt mprodukt, String sMarke, String sProduktart, String katalogUmfang, String iso, String regIso, int marktId, boolean bIGDOM) throws InvalidInitializationException, SQLException, InvalidDataException, DatabaseBusyException {
        String sBildtafelNr = mprodukt.getBteNr();
        Collection<String> cRelevanteBildposNr = mprodukt.getRelevanteBildposNr();
        String sSprache = iso;
        if (regIso != null) {
            sSprache = sSprache + regIso;
        }
        CurrentBTE oBildtafel = new CurrentBTE(sBildtafelNr, cRelevanteBildposNr, mprodukt.getVariantenZuRelevantenBildposNr(), sMarke, sProduktart, katalogUmfang, sSprache, true, bIGDOM);
        oBildtafel.loadStammdaten(null);
        oBildtafel.ladenZubBildtafelZeilen(null);
        String sProduktName = mprodukt.getProduktName();
        List<Zubehoergrafik> aImages = Arrays.asList(new Zubehoergrafik());
        List<TechnischerBnb> aBauteileKern = oBildtafel.getZubBnbsBauteile(sBildtafelNr, "Kernprodukt");
        List<TechnischerBnb> aBauteileZusatz = oBildtafel.getZubBnbsBauteile(sBildtafelNr, "Zusatz");
        List<TechnischerBnb> aBauteileHilf = oBildtafel.getZubBnbsBauteile(sBildtafelNr, "Hilfsstoffe");
        TechnischesProdukt oTechnischesProdukt = new TechnischesProdukt(sBildtafelNr, -1, sProduktName, aImages, aBauteileKern, aBauteileZusatz, aBauteileHilf);
        String sBaureihe = "";
        if (mprodukt.getBildPosNr() == null) {
            List aEinbauinfoBildatel = TechnischDbAccess.getEinbauInfoProdukt(mprodukt, sBaureihe, iso, regIso, marktId, sProduktart);
            oTechnischesProdukt.setEinbauInfoProdukt(aEinbauinfoBildatel);
        }
        if (mprodukt.getVariantenZuRelevantenBildposNr() != null && mprodukt.getVariantenZuRelevantenBildposNr().size() > 0) {
            List aEinbauinfoVariante = TechnischDbAccess.getEinbauInfoVariante(mprodukt, sBaureihe, iso, regIso, marktId, sProduktart);
            oTechnischesProdukt.setEinbauInfoVariante(aEinbauinfoVariante);
        }
        List aTechnischeBnbs = TechnischDbAccess.getEinbauInfoBnb(mprodukt, sBaureihe, marktId, sProduktart);
        for (int i = 0; i < aTechnischeBnbs.size(); ++i) {
            TechnischerBnb oBnb;
            TechnischerBnb oBnbHelp = (TechnischerBnb)aTechnischeBnbs.get(i);
            if (oBnbHelp.getEinbauInfo().size() == 0 || (oBnb = oTechnischesProdukt.findTechnischenBnb(oBnbHelp)) == null) continue;
            oBnb.setEinbauInfo(oBnbHelp.getEinbauInfo());
        }
        oTechnischesProdukt.setImages(TechnischDbAccess.ermittleExplosionsGrafik(mprodukt.getBteNr()));
        return oTechnischesProdukt;
    }

    public static ResultSet loadZubBildtafelStammdaten(Connection con, String sBildtafelNr, String sSprache) throws SQLException {
        String sSQLStatement = SQLStatements.TechnischeSicht.instance.LOAD_ZUBBT_STAMM();
        PreparedStatement stat = con.prepareStatement(sSQLStatement);
        String sISO = LanguageUtils.toLanguage(sSprache);
        String sRegISO = LanguageUtils.toRegion(sSprache, true);
        stat.setString(1, sISO);
        stat.setString(2, sRegISO);
        stat.setString(3, sBildtafelNr);
        ResultSet res = stat.executeQuery();
        return res;
    }

    public static ResultSet loadZubBildtafelBedingungenSala(Connection con, String sBildtafelNr, Collection<String> cRelevanteBildPosNr, long lModellspalte, String sSprache) throws SQLException {
        String sSQLStatement = SQLStatements.TechnischeSicht.instance.LOAD_ZUBBT_BEDELEM_SALA();
        String sRelevanteBildposnr = TechnischDbAccess.getConcatString(cRelevanteBildPosNr, true);
        sSQLStatement = sRelevanteBildposnr != null && sRelevanteBildposnr.length() > 0 ? StringUtils.substituteString(sSQLStatement, "BILDPOSNR", sRelevanteBildposnr) : StringUtils.substituteStringStraight(sSQLStatement, "&BILDPOSNR&", "NULL");
        PreparedStatement stat = con.prepareStatement(sSQLStatement);
        String sISO = LanguageUtils.toLanguage(sSprache);
        String sRegISO = LanguageUtils.toRegion(sSprache, true);
        stat.setString(1, sBildtafelNr);
        stat.setLong(2, lModellspalte);
        stat.setString(3, sISO);
        stat.setString(4, sRegISO);
        stat.setString(5, sBildtafelNr);
        stat.setString(6, sISO);
        stat.setString(7, sRegISO);
        ResultSet res = stat.executeQuery();
        return res;
    }

    public static ResultSet loadZubBildtafelBedingungenText(Connection con, String sBildtafelNr, Collection<String> cRelevanteBildPosNr, long lModellspalte, String sSprache) throws SQLException {
        String sSQLStatement = SQLStatements.TechnischeSicht.instance.LOAD_ZUBBT_BEDELEM_TEXT();
        String sRelevanteBildposnr = TechnischDbAccess.getConcatString(cRelevanteBildPosNr, true);
        sSQLStatement = sRelevanteBildposnr != null && sRelevanteBildposnr.length() > 0 ? StringUtils.substituteString(sSQLStatement, "BILDPOSNR", sRelevanteBildposnr) : StringUtils.substituteStringStraight(sSQLStatement, "&BILDPOSNR&", "NULL");
        PreparedStatement stat = con.prepareStatement(sSQLStatement);
        String sISO = LanguageUtils.toLanguage(sSprache);
        String sRegISO = LanguageUtils.toRegion(sSprache, true);
        stat.setString(1, sBildtafelNr);
        stat.setLong(2, lModellspalte);
        stat.setString(3, sISO);
        stat.setString(4, sRegISO);
        stat.setString(5, sBildtafelNr);
        stat.setString(6, sISO);
        stat.setString(7, sRegISO);
        ResultSet res = stat.executeQuery();
        return res;
    }

    public static ResultSet loadZubBedingungenFzg(Connection con, String sBildtafelNr, Collection<String> cRelevanteBildPosNr, Long lVarianteId, long lModellspalte) throws SQLException {
        String sSQLStatement = SQLStatements.TechnischeSicht.instance.LOAD_ZUBBT_BEDINGUNGEN_FZG();
        String sRelevanteBildposnr = TechnischDbAccess.getConcatString(cRelevanteBildPosNr, true);
        sSQLStatement = sRelevanteBildposnr != null && sRelevanteBildposnr.length() > 0 ? StringUtils.substituteString(sSQLStatement, "BILDPOSNR", sRelevanteBildposnr) : StringUtils.substituteStringStraight(sSQLStatement, "&BILDPOSNR&", "NULL");
        PreparedStatement stat = con.prepareStatement(sSQLStatement);
        stat.setString(1, sBildtafelNr);
        stat.setLong(2, lModellspalte);
        stat.setString(3, sBildtafelNr);
        ResultSet res = stat.executeQuery();
        return res;
    }

    public static ResultSet loadZubUeberbedingungenFzg(Connection con, String sBildtafelNr, long lModellspalte) throws SQLException {
        String sSQLStatement = SQLStatements.TechnischeSicht.instance.LOAD_ZUBBT_UEBERBEDINGUNGEN_FZG();
        PreparedStatement stat = con.prepareStatement(sSQLStatement);
        stat.setString(1, sBildtafelNr);
        ResultSet res = stat.executeQuery();
        return res;
    }

    public static ResultSet loadZeilenUgb(Connection con, String sBildtafelNr, String sBildPosNr, String sMarke, String sProduktart, String sKatalogumfang, String sSprache) throws SQLException {
        String sSQLStatement = SQLStatements.TechnischeSicht.instance.LOAD_BTZEILEN_UGB();
        if (HtmlUtils.isConnectionSourceOracle(con)) {
            PreparedStatement ps = con.prepareStatement(sSQLStatement);
            String sISO = LanguageUtils.toLanguage(sSprache);
            String sRegISO = LanguageUtils.toRegion(sSprache, true);
            String bildPosNr = "NULL";
            if (sBildPosNr != null) {
                bildPosNr = StringUtils.maskiereHochkommaFuerDb(sBildPosNr);
                bildPosNr = "'" + bildPosNr + "'";
            }
            ps.setString(6, bildPosNr);
            ps.setString(1, sISO);
            ps.setString(2, sRegISO);
            ps.setString(5, sBildtafelNr);
            ps.setString(3, sMarke);
            String sToday = WebetkUtils.getTodayYYYYMMDD();
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "DATUM", sToday);
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "MARKE", sMarke);
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "PRODUKTART", sProduktart);
            sSQLStatement = StringUtils.substituteString(sSQLStatement, "VBEREICH", sKatalogumfang);
            ps.setString(4, sMarke);
            log.debug((Object)("Executing: " + sSQLStatement));
            ResultSet res = ps.executeQuery();
            return res;
        }
        String sISO = LanguageUtils.toLanguage(sSprache);
        String sRegISO = LanguageUtils.toRegion(sSprache, true);
        String bildPosNr = "NULL";
        if (sBildPosNr != null) {
            bildPosNr = StringUtils.maskiereHochkommaFuerDb(sBildPosNr);
            bildPosNr = "'" + bildPosNr + "'";
        }
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "BILDPOS", bildPosNr);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "ISO", sISO);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "REGISO", sRegISO);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "BTNR", sBildtafelNr);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "MARKE", sMarke);
        String sToday = WebetkUtils.getTodayYYYYMMDD();
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "DATUM", sToday);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "MARKE", sMarke);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "PRODUKTART", sProduktart);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "VBEREICH", sKatalogumfang);
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "MARKE", sMarke);
        log.debug((Object)("Executing: " + sSQLStatement));
        Statement stmt = con.createStatement();
        ResultSet res = stmt.executeQuery(sSQLStatement);
        return res;
    }

    public static ResultSet loadZeilenZuZubFzgBildtafel(Connection con, String sBildtafelNr, Collection<String> cRelevanteBildPosNr, long lModellspalte, String sSprache) throws SQLException {
        if (HtmlUtils.isConnectionSourceOracle(con)) {
            String sSQLStatement = SQLStatements.TechnischeSicht.instance.LOAD_BTZEILEN_FZG();
            PreparedStatement stat = con.prepareStatement(sSQLStatement);
            String sRelevanteBildposnr = TechnischDbAccess.getConcatString(cRelevanteBildPosNr, true);
            if (sRelevanteBildposnr != null && sRelevanteBildposnr.length() > 0) {
                stat.setString(1, sRelevanteBildposnr);
            } else {
                stat.setString(1, "NULL");
            }
            String sISO = LanguageUtils.toLanguage(sSprache);
            String sRegISO = LanguageUtils.toRegion(sSprache, true);
            stat.setString(2, sISO);
            stat.setString(3, sRegISO);
            stat.setLong(4, lModellspalte);
            stat.setString(5, sBildtafelNr);
            ResultSet res = stat.executeQuery();
            return res;
        }
        String sSQLStatement = SQLStatements.TechnischeSicht.instance.LOAD_BTZEILEN_FZG();
        String sRelevanteBildposnr = TechnischDbAccess.getConcatString(cRelevanteBildPosNr, true);
        sSQLStatement = sRelevanteBildposnr != null && sRelevanteBildposnr.length() > 0 ? StringUtils.substituteString(sSQLStatement, "BILDPOSNR", sRelevanteBildposnr) : StringUtils.substituteStringStraight(sSQLStatement, "&BILDPOSNR&", "NULL");
        PreparedStatement stat = con.prepareStatement(sSQLStatement);
        String sISO = LanguageUtils.toLanguage(sSprache);
        String sRegISO = LanguageUtils.toRegion(sSprache, true);
        stat.setString(1, sISO);
        stat.setString(2, sRegISO);
        stat.setLong(3, lModellspalte);
        stat.setString(4, sBildtafelNr);
        ResultSet res = stat.executeQuery();
        return res;
    }

    public static ResultSet loadZeilenZuZubFzgRelevantBzglVariante(Connection con, String sBildtafelNr, Collection<String> cRelevanteBildPosNr, Hashtable hVariantenZuRelevantenBildposNr) throws SQLException {
        if (hVariantenZuRelevantenBildposNr == null || hVariantenZuRelevantenBildposNr.size() == 0) {
            return null;
        }
        String sSQLStatement = SQLStatements.TechnischeSicht.instance.LOAD_BTZEILEN_FZG_RELEVANT_BZGL_VARIANTE();
        String sRelevanteBildposnr = TechnischDbAccess.getConcatString(cRelevanteBildPosNr, true);
        sSQLStatement = sRelevanteBildposnr != null && sRelevanteBildposnr.length() > 0 ? StringUtils.substituteString(sSQLStatement, "BILDPOSNR", sRelevanteBildposnr) : StringUtils.substituteStringStraight(sSQLStatement, "&BILDPOSNR&", "NULL");
        Iterator<String> relBildPosIter = cRelevanteBildPosNr.iterator();
        String sSQLVariantenAlleBNB = "";
        String sSQLVariantenProBNB = "";
        String bildPosNr = "0";
        int variantenID = 0;
        while (relBildPosIter.hasNext()) {
            ArrayList varList = null;
            bildPosNr = relBildPosIter.next().toString();
            if (hVariantenZuRelevantenBildposNr.get(bildPosNr) != null) {
                varList = (ArrayList)hVariantenZuRelevantenBildposNr.get(bildPosNr);
            }
            if (varList == null) continue;
            for (int i = 0; i < varList.size(); ++i) {
                variantenID = Integer.parseInt(varList.get(i).toString());
                sSQLVariantenProBNB = SQLStatements.TechnischeSicht.instance.LOAD_BTZEILEN_FZG_RELEVANT_BZGL_VARIANTE_PRO_BNB();
                sSQLVariantenProBNB = StringUtils.substituteString(sSQLVariantenProBNB, "BTENR", sBildtafelNr);
                sSQLVariantenProBNB = StringUtils.substituteString(sSQLVariantenProBNB, "BILDPOSNR", bildPosNr);
                sSQLVariantenProBNB = StringUtils.substituteString(sSQLVariantenProBNB, "VARIANTENID", Integer.toString(variantenID));
                sSQLVariantenAlleBNB = sSQLVariantenAlleBNB + " union " + sSQLVariantenProBNB;
            }
        }
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "LOAD_BTZEILEN_FZG_RELEVANT_BZGL_VARIANTE_PRO_BNB", sSQLVariantenAlleBNB);
        PreparedStatement stat = con.prepareStatement(sSQLStatement);
        stat.setString(1, sBildtafelNr);
        stat.setString(2, sBildtafelNr);
        ResultSet res = stat.executeQuery();
        return res;
    }

    public static ResultSet loadZeilenZuZubUgbRelevantBzglVariante(Connection con, String sBildtafelNr, Collection<String> cRelevanteBildPosNr, Hashtable hVariantenZuRelevantenBildposNr) throws SQLException {
        if (hVariantenZuRelevantenBildposNr == null || hVariantenZuRelevantenBildposNr.size() == 0) {
            return null;
        }
        Vector<String> cRelevanteBildPosNrTemp = new Vector<String>();
        for (String sRelBildPos : cRelevanteBildPosNr) {
            if (hVariantenZuRelevantenBildposNr == null || hVariantenZuRelevantenBildposNr.containsKey(sRelBildPos)) continue;
            cRelevanteBildPosNrTemp.add(sRelBildPos);
        }
        String sSQLStatement = SQLStatements.TechnischeSicht.instance.LOAD_BTZEILEN_UGB_BZGL_VARIANTE();
        String sRelevanteBildposnr = TechnischDbAccess.getConcatString(cRelevanteBildPosNrTemp, true);
        if (sRelevanteBildposnr.equals("")) {
            sRelevanteBildposnr = "'XX'";
        }
        sSQLStatement = sRelevanteBildposnr != null && sRelevanteBildposnr.length() > 0 ? StringUtils.substituteString(sSQLStatement, "BILDPOSNR", sRelevanteBildposnr) : StringUtils.substituteStringStraight(sSQLStatement, "&BILDPOSNR&", "NULL");
        Iterator<String> relBildPosIter = cRelevanteBildPosNr.iterator();
        String sSQLVariantenAlleBNB = "";
        String sSQLVariantenProBNB = "";
        String bildPosNr = "0";
        int variantenID = 0;
        while (relBildPosIter.hasNext()) {
            bildPosNr = relBildPosIter.next().toString();
            ArrayList varList = (ArrayList)hVariantenZuRelevantenBildposNr.get(bildPosNr);
            if (varList == null) continue;
            for (int i = 0; i < varList.size(); ++i) {
                variantenID = Integer.parseInt(varList.get(i).toString());
                sSQLVariantenProBNB = SQLStatements.TechnischeSicht.instance.LOAD_BTZEILEN_FZGUGB_RELEVANT_BZGL_VARIANTE_PRO_BNB();
                sSQLVariantenProBNB = StringUtils.substituteString(sSQLVariantenProBNB, "BTENR", sBildtafelNr);
                sSQLVariantenProBNB = StringUtils.substituteString(sSQLVariantenProBNB, "BILDPOSNR", bildPosNr);
                sSQLVariantenProBNB = StringUtils.substituteString(sSQLVariantenProBNB, "VARIANTENID", Integer.toString(variantenID));
                sSQLVariantenAlleBNB = sSQLVariantenAlleBNB + " union " + sSQLVariantenProBNB;
            }
        }
        sSQLStatement = StringUtils.substituteString(sSQLStatement, "LOAD_BTZEILEN_FZGUGB_RELEVANT_BZGL_VARIANTE_PRO_BNB", sSQLVariantenAlleBNB);
        PreparedStatement stat = con.prepareStatement(sSQLStatement);
        stat.setString(1, sBildtafelNr);
        stat.setString(2, sBildtafelNr);
        ResultSet res = stat.executeQuery();
        return res;
    }

    private static String getConcatString(Collection<String> aStrings, boolean bMitTuettel) {
        String sString = "";
        for (int i = 0; i < aStrings.size(); ++i) {
            String sHelp = (String)aStrings.toArray()[i];
            if (i != 0) {
                sString = sString + ",";
            }
            sString = bMitTuettel ? sString + "'" + sHelp + "'" : sString + sHelp;
        }
        return sString;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List getEinbauInfoProdukt(MarketingProdukt mprodukt, String baureihe, String iso, String regIso, int marktId, String produktart) throws SQLException, DatabaseBusyException {
        Connection con = null;
        ServerGlobalObjects globs = ServerGlobalObjects.getInstance();
        try {
            List<EinbauInfo> infos;
            con = globs.getDBConnection("webetk.db.zub.technisch.getEinbauInfosProdukt");
            List<EinbauInfo> list = infos = TechnischDbAccess.ermittleEinbauInfosInternal(con, mprodukt.getBteNr(), mprodukt.getBteNr(), "BTE", baureihe, iso, regIso, marktId, produktart);
            return list;
        }
        finally {
            if (con != null) {
                globs.freeDBConnection(con, "webetk.db.zub.technisch.getEinbauInfosProdukt");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List getEinbauInfoVariante(MarketingProdukt mprodukt, String baureihe, String iso, String regIso, int marktId, String produktart) throws SQLException, DatabaseBusyException {
        Connection con = null;
        ServerGlobalObjects globs = ServerGlobalObjects.getInstance();
        try {
            con = globs.getDBConnection("webetk.db.zub.technisch.getEinbauInfosProdukt");
            ArrayList<EinbauInfo> infoAll = new ArrayList<EinbauInfo>();
            List<EinbauInfo> info = null;
            if (mprodukt.getVariantenZuRelevantenBildposNr() != null && mprodukt.getVariantenZuRelevantenBildposNr().size() > 0) {
                Hashtable<String, ArrayList<Integer>> variantenZuRelvantenBildPosNr = mprodukt.getVariantenZuRelevantenBildposNr();
                Enumeration<ArrayList<Integer>> varListEnum = variantenZuRelvantenBildPosNr.elements();
                while (varListEnum.hasMoreElements()) {
                    ArrayList<Integer> varList = varListEnum.nextElement();
                    for (int i = 0; i < varList.size(); ++i) {
                        int var = Integer.parseInt(((Object)varList.get(i)).toString());
                        info = TechnischDbAccess.ermittleEinbauInfosInternal(con, mprodukt.getBteNr(), Integer.toString(var), "VAR", baureihe, iso, regIso, marktId, produktart);
                        infoAll.addAll(info);
                    }
                }
            }
            ArrayList<EinbauInfo> arrayList = infoAll;
            return arrayList;
        }
        finally {
            if (con != null) {
                globs.freeDBConnection(con, "webetk.db.zub.technisch.getEinbauInfosProdukt");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List getEinbauInfoBnb(MarketingProdukt mprodukt, String baureihe, int marktId, String produktart) throws SQLException, DatabaseBusyException {
        Connection con = null;
        ServerGlobalObjects globs = ServerGlobalObjects.getInstance();
        try {
            con = globs.getDBConnection("webetk.db.zub.technisch.getEinbauInfosProdukt");
            List list = TechnischDbAccess.ermittleEinbauInfosInternalBnb(con, mprodukt.getBteNr(), "BNB", baureihe, marktId, produktart);
            return list;
        }
        finally {
            if (con != null) {
                globs.freeDBConnection(con, "webetk.db.zub.technisch.getEinbauInfosProdukt");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<EinbauInfo> ermittleEinbauInfosInternal(Connection con, String bteNr, String id, String art, String baureihe, String iso, String regIso, int marktId, String produktart) throws SQLException {
        ArrayList<EinbauInfo> arrayList;
        block8: {
            PreparedStatement einfoPs;
            block7: {
                einfoPs = null;
                ResultSet einfoRs = null;
                ArrayList<EinbauInfo> einbauInfos = new ArrayList<EinbauInfo>();
                try {
                    einfoPs = con.prepareStatement(SQLStatements.TechnischeSicht.instance.ERMITTLE_EINBAUINFO_ZU_BTE());
                    einfoPs.setString(1, iso);
                    einfoPs.setString(2, regIso == null ? " " : regIso);
                    einfoPs.setInt(3, marktId);
                    einfoPs.setString(4, bteNr);
                    einfoPs.setString(5, id);
                    einfoPs.setString(6, art);
                    einfoPs.setString(7, baureihe);
                    einfoRs = einfoPs.executeQuery();
                    EinbauInfo info = null;
                    while (einfoRs.next()) {
                        info = TechnischDbAccess.ermittleEinbauInfoAusResultSet(einfoRs, produktart);
                        einbauInfos.add(info);
                    }
                    arrayList = einbauInfos;
                    if (einfoRs == null) break block7;
                }
                catch (Throwable throwable) {
                    if (einfoRs != null) {
                        WebetkUtils.closeQuery(einfoRs);
                    } else if (einfoPs != null) {
                        einfoPs.close();
                    }
                    throw throwable;
                }
                WebetkUtils.closeQuery(einfoRs);
                break block8;
            }
            if (einfoPs != null) {
                einfoPs.close();
            }
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List ermittleRefaArbeitBteInternal(Connection con, String bteNr, int mospid, String typschl, String iso, String regIso, List einbauInfos) throws SQLException, DatabaseBusyException {
        List list;
        block19: {
            Statement refaPs;
            block17: {
                ResultSet refaRs;
                block15: {
                    List list2;
                    block18: {
                        block16: {
                            refaPs = null;
                            refaRs = null;
                            String sSQLStatement = "";
                            try {
                                sSQLStatement = SQLStatements.TechnischeSicht.instance.ERMITTLE_REFA_ARBEIT_ZU_BTE();
                                if (typschl != null) {
                                    sSQLStatement = StringUtils.substituteString(sSQLStatement, "TYP_FEST", SQLStatements.TechnischeSicht.instance.TYP_FEST());
                                    sSQLStatement = StringUtils.substituteString(sSQLStatement, "TYP_BESTIMMEN", "");
                                } else {
                                    sSQLStatement = StringUtils.substituteString(sSQLStatement, "TYP_FEST", "");
                                    sSQLStatement = StringUtils.substituteString(sSQLStatement, "TYP_BESTIMMEN", SQLStatements.TechnischeSicht.instance.TYP_BESTIMMEN());
                                }
                                refaPs = con.prepareStatement(sSQLStatement);
                                refaPs.setString(1, bteNr);
                                refaPs.setInt(2, mospid);
                                if (typschl != null) {
                                    refaPs.setString(3, typschl);
                                } else {
                                    refaPs.setInt(3, mospid);
                                }
                                refaRs = refaPs.executeQuery();
                                EinbauInfo info = new EinbauInfo();
                                ArrayList<RefaArbeit> refaList = new ArrayList<RefaArbeit>();
                                String refaBen = "";
                                while (refaRs.next()) {
                                    int refaId = refaRs.getInt(1);
                                    String awnummer = refaRs.getString(2);
                                    int komm_id = refaRs.getInt(3);
                                    int menge = refaRs.getInt(4);
                                    if (komm_id != 0) {
                                        refaBen = TechnischDbAccess.ermittleRefaBenennung(iso, regIso, komm_id);
                                    }
                                    RefaArbeit refa = new RefaArbeit(refaId, awnummer, refaBen, menge);
                                    Iterator iter = refaList.iterator();
                                    while (iter.hasNext()) {
                                        if (((RefaArbeit)iter.next()).getMenge() >= menge) continue;
                                        iter.remove();
                                    }
                                    if (refaList.size() != 0) continue;
                                    refaList.add(refa);
                                }
                                if (refaList.size() == 0) break block15;
                                info.setRefaArbeitenList(refaList);
                                einbauInfos.add(info);
                                list2 = einbauInfos;
                                if (refaRs == null) break block16;
                            }
                            catch (Throwable throwable) {
                                if (refaRs != null) {
                                    WebetkUtils.closeQuery(refaRs);
                                } else if (refaPs != null) {
                                    refaPs.close();
                                }
                                throw throwable;
                            }
                            WebetkUtils.closeQuery(refaRs);
                            break block18;
                        }
                        if (refaPs != null) {
                            refaPs.close();
                        }
                    }
                    return list2;
                }
                list = null;
                if (refaRs == null) break block17;
                WebetkUtils.closeQuery(refaRs);
                break block19;
            }
            if (refaPs != null) {
                refaPs.close();
            }
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String ermittleRefaBenennung(String iso, String regionIso, int kommid) throws SQLException, DatabaseBusyException {
        String string;
        ServerGlobalObjects globs;
        Connection con;
        block11: {
            PreparedStatement stat;
            block10: {
                con = null;
                globs = ServerGlobalObjects.getInstance();
                stat = null;
                ResultSet rs = null;
                String statement = SQLStatements.TechnischeSicht.instance.ERMITTLE_REFA_BENENNUNG();
                String refaBen = "";
                try {
                    con = globs.getDBConnection("webetk.db.zub.technisch.ermittleRefaArbeitenBnb");
                    stat = con.prepareStatement(statement);
                    stat.setInt(1, kommid);
                    stat.setString(2, iso == null ? "" : iso);
                    stat.setString(3, regionIso == null ? "" : regionIso);
                    rs = stat.executeQuery();
                    while (rs.next()) {
                        if (rs.getString(2).equals("*****")) continue;
                        if (refaBen.equals("")) {
                            refaBen = rs.getString(2);
                            continue;
                        }
                        refaBen = refaBen + " " + rs.getString(2);
                    }
                    string = refaBen;
                    if (rs == null) break block10;
                }
                catch (Throwable throwable) {
                    if (rs != null) {
                        WebetkUtils.closeQuery(rs);
                    } else if (stat != null) {
                        stat.close();
                    }
                    if (con != null) {
                        globs.freeDBConnection(con, "webetk.db.zub.technisch.ermittleRefaArbeitenBnb");
                    }
                    throw throwable;
                }
                WebetkUtils.closeQuery(rs);
                break block11;
            }
            if (stat != null) {
                stat.close();
            }
        }
        if (con != null) {
            globs.freeDBConnection(con, "webetk.db.zub.technisch.ermittleRefaArbeitenBnb");
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List ermittleEinbauInfosInternalBnb(Connection con, String bteNr, String art, String baureihe, int marktId, String produktart) throws SQLException, DatabaseBusyException {
        ArrayList<TechnischerBnb> arrayList;
        block10: {
            PreparedStatement einfoPs;
            block9: {
                einfoPs = null;
                ResultSet einfoRs = null;
                try {
                    einfoPs = con.prepareStatement(SQLStatements.TechnischeSicht.instance.ERMITTLE_EINBAUINFO_ZU_BNB());
                    einfoPs.setInt(1, marktId);
                    einfoPs.setString(2, bteNr);
                    einfoPs.setString(3, art);
                    einfoPs.setString(4, baureihe);
                    einfoRs = einfoPs.executeQuery();
                    ArrayList<TechnischerBnb> list = new ArrayList<TechnischerBnb>();
                    EinbauInfo info = null;
                    while (einfoRs.next()) {
                        String bildPosNr = einfoRs.getString(1);
                        info = TechnischDbAccess.ermittleEinbauInfoAusResultSet(einfoRs, produktart);
                        TechnischerBnb bnb = new TechnischerBnb(bteNr, bildPosNr, "nicht relevant");
                        if (!list.contains(bnb)) {
                            list.add(bnb);
                        }
                        if ((bnb = (TechnischerBnb)list.get(list.indexOf(bnb))).getEinbauInfo() == null) {
                            bnb.setEinbauInfo(new ArrayList<EinbauInfo>());
                        }
                        bnb.getEinbauInfo().add(info);
                    }
                    arrayList = list;
                    if (einfoRs == null) break block9;
                }
                catch (Throwable throwable) {
                    if (einfoRs != null) {
                        WebetkUtils.closeQuery(einfoRs);
                    } else if (einfoPs != null) {
                        einfoPs.close();
                    }
                    throw throwable;
                }
                WebetkUtils.closeQuery(einfoRs);
                break block10;
            }
            if (einfoPs != null) {
                einfoPs.close();
            }
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ArrayList ermittleRefaArbeitenBnbInternal(Connection con, String bteNr, String typschl, int mospid, String iso, String regIso) throws SQLException, DatabaseBusyException {
        ArrayList<TechnischerBnb> arrayList;
        block22: {
            Statement refaPs;
            block20: {
                ResultSet refaRs;
                block18: {
                    block21: {
                        block19: {
                            refaPs = null;
                            refaRs = null;
                            String sSQLStatement = "";
                            ArrayList<TechnischerBnb> bnbList = new ArrayList<TechnischerBnb>();
                            try {
                                sSQLStatement = SQLStatements.TechnischeSicht.instance.ERMITTLE_REFA_ARBEIT_ZU_BNB();
                                if (typschl != null) {
                                    sSQLStatement = StringUtils.substituteString(sSQLStatement, "TYP_FEST_BNB", SQLStatements.TechnischeSicht.instance.TYP_FEST_BNB());
                                    sSQLStatement = StringUtils.substituteString(sSQLStatement, "TYP_BESTIMMEN_BNB", "");
                                } else {
                                    sSQLStatement = StringUtils.substituteString(sSQLStatement, "TYP_FEST_BNB", "");
                                    sSQLStatement = StringUtils.substituteString(sSQLStatement, "TYP_BESTIMMEN_BNB", SQLStatements.TechnischeSicht.instance.TYP_BESTIMMEN_BNB());
                                }
                                refaPs = con.prepareStatement(sSQLStatement);
                                refaPs.setString(1, bteNr);
                                refaPs.setInt(2, mospid);
                                if (typschl != null) {
                                    refaPs.setString(3, typschl);
                                } else {
                                    refaPs.setInt(3, mospid);
                                }
                                refaRs = refaPs.executeQuery();
                                EinbauInfo info = null;
                                String refaBen = "";
                                while (refaRs.next()) {
                                    String bildPosNr = refaRs.getString(1);
                                    int refaId = refaRs.getInt(2);
                                    String awnummer = refaRs.getString(3);
                                    int komm_id = refaRs.getInt(4);
                                    int menge = refaRs.getInt(5);
                                    TechnischerBnb bnb = new TechnischerBnb(bteNr, bildPosNr, "nicht relevant");
                                    if (!bnbList.contains(bnb)) {
                                        bnbList.add(bnb);
                                    }
                                    if ((bnb = (TechnischerBnb)bnbList.get(bnbList.indexOf(bnb))).getEinbauInfo() == null) {
                                        bnb.setEinbauInfo(new ArrayList<EinbauInfo>());
                                    }
                                    info = new EinbauInfo();
                                    if (komm_id != 0) {
                                        refaBen = TechnischDbAccess.ermittleRefaBenennung(iso, regIso, komm_id);
                                    }
                                    RefaArbeit refa = new RefaArbeit(refaId, awnummer, refaBen, menge);
                                    Iterator<RefaArbeit> iter = info.getRefaArbeitenList().iterator();
                                    while (iter.hasNext()) {
                                        if (iter.next().getMenge() >= menge) continue;
                                        iter.remove();
                                    }
                                    if (info.getRefaArbeitenList().size() == 0) {
                                        info.getRefaArbeitenList().add(refa);
                                    }
                                    bnb.getEinbauInfo().add(info);
                                }
                                if (bnbList.size() == 0) break block18;
                                arrayList = bnbList;
                                if (refaRs == null) break block19;
                            }
                            catch (Throwable throwable) {
                                if (refaRs != null) {
                                    WebetkUtils.closeQuery(refaRs);
                                } else if (refaPs != null) {
                                    refaPs.close();
                                }
                                throw throwable;
                            }
                            WebetkUtils.closeQuery(refaRs);
                            break block21;
                        }
                        if (refaPs != null) {
                            refaPs.close();
                        }
                    }
                    return arrayList;
                }
                arrayList = null;
                if (refaRs == null) break block20;
                WebetkUtils.closeQuery(refaRs);
                break block22;
            }
            if (refaPs != null) {
                refaPs.close();
            }
        }
        return arrayList;
    }

    private static EinbauInfo ermittleEinbauInfoAusResultSet(ResultSet rs, String produktart) throws SQLException {
        int einbauId = rs.getInt(2);
        String komplexitaet = rs.getString(3);
        String lesart = rs.getString(4);
        float mechArbeit = TechnischDbAccess.getAufwand(rs, 5);
        float elekArbeit = TechnischDbAccess.getAufwand(rs, 6);
        float programmierung = TechnischDbAccess.getAufwand(rs, 7);
        float lackierung = TechnischDbAccess.getAufwand(rs, 8);
        float gesamt = TechnischDbAccess.getAufwand(rs, 9);
        if (produktart.equals("P")) {
            return new EinbauInfo(einbauId, komplexitaet, lesart, mechArbeit, elekArbeit, programmierung, lackierung, 0.0f, gesamt);
        }
        return new EinbauInfo(einbauId, komplexitaet, lesart, 0.0f, 0.0f, 0.0f, 0.0f, gesamt, gesamt);
    }

    private static float getAufwand(ResultSet res, int column) throws SQLException {
        String aufwand = res.getString(column);
        if (aufwand == null) {
            return 0.0f;
        }
        aufwand = aufwand.replaceAll(",", ".");
        return Float.parseFloat(aufwand);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<Integer> ermittleVerbauteVarianten(MarketingProdukt prod, FzgSucheInfo fahrzeug) throws SQLException, DatabaseBusyException {
        Statement einfoPs = null;
        ResultSet einfoRs = null;
        Connection con = null;
        ServerGlobalObjects globs = ServerGlobalObjects.getInstance();
        ArrayList<Integer> variantenIds = new ArrayList<Integer>();
        try {
            con = globs.getDBConnection("ermittleVerbauteVarianten");
            einfoPs = con.prepareStatement(SQLStatements.TechnischeSicht.instance.PRUEFE_VARIANTENAUSWAHL_FUER_FAHRZEUG());
            einfoPs.setLong(1, fahrzeug.getModellspalte());
            einfoPs.setString(2, prod.getBteNr());
            if (prod.getBildPosNr() != null && prod.getBildPosNr().length() > 0) {
                einfoPs.setString(3, prod.getBildPosNr());
            } else {
                einfoPs.setNull(3, 12);
            }
            einfoRs = einfoPs.executeQuery();
            while (einfoRs.next()) {
                variantenIds.add(new Integer(einfoRs.getInt(1)));
            }
            ArrayList<Integer> arrayList = variantenIds;
            return arrayList;
        }
        finally {
            if (einfoPs != null) {
                einfoPs.close();
            }
            if (con != null) {
                globs.freeDBConnection(con, "ermittleVerbauteVarianten");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<Bnb> ermittleVerbauteAlternativen(MarketingProdukt prod, FzgSucheInfo fahrzeug) throws SQLException, DatabaseBusyException {
        Statement einfoPs = null;
        ResultSet einfoRs = null;
        Connection con = null;
        ServerGlobalObjects globs = ServerGlobalObjects.getInstance();
        ArrayList<Bnb> alternativen = new ArrayList<Bnb>();
        try {
            con = globs.getDBConnection("ermittleVerbauteAlternativen");
            einfoPs = con.prepareStatement(SQLStatements.TechnischeSicht.instance.PRUEFE_ALTERNATIVENAUSWAHL_FUER_FAHRZEUG());
            einfoPs.setLong(1, fahrzeug.getModellspalte());
            einfoPs.setString(2, prod.getBteNr());
            einfoPs.setString(3, "HP_ALTERNATIV");
            if (prod.getBildPosNr() != null && prod.getBildPosNr().length() > 0) {
                einfoPs.setString(4, prod.getBildPosNr());
            } else {
                einfoPs.setNull(4, 12);
            }
            einfoRs = einfoPs.executeQuery();
            while (einfoRs.next()) {
                boolean noAuslauf = false;
                String bte = einfoRs.getString(1);
                String pos = einfoRs.getString(2);
                long auslauf = einfoRs.getLong(3);
                if (einfoRs.wasNull()) {
                    noAuslauf = true;
                }
                Bnb bnb = new Bnb(bte, pos, "HP_ALTERNATIV");
                if (!noAuslauf && !TechnischDbAccess.isAktuell(fahrzeug, auslauf) || alternativen.contains(bnb)) continue;
                alternativen.add(bnb);
            }
            ArrayList<Bnb> arrayList = alternativen;
            return arrayList;
        }
        finally {
            if (einfoPs != null) {
                einfoPs.close();
            }
            if (con != null) {
                globs.freeDBConnection(con, "ermittleVerbauteAlternativen");
            }
        }
    }

    private static boolean isAktuell(FzgSucheInfo fahrzeug, long auslaufDatum) {
        String sMonat = fahrzeug.getZulassungsmonat() == null || fahrzeug.getZulassungsmonat().length() == 0 ? "01" : fahrzeug.getZulassungsmonat();
        String sFgstnr = fahrzeug.getFahrgestellnummer();
        boolean bIdentifiedByFgstnr = sFgstnr != null && !sFgstnr.equals("");
        int nMonat = bIdentifiedByFgstnr ? 1 : -1;
        String sProdDatum = WebetkUtils.modifyDate(fahrzeug.getBaujahr(), sMonat, nMonat);
        long lProdDatum = Long.decode(sProdDatum);
        return auslaufDatum >= lProdDatum;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<ProduktListenElement> ermittleVerbauteZubehoerProdukte(MarketingProdukt prod, FzgSucheInfo fahrzeug) throws SQLException, DatabaseBusyException {
        Statement einfoPs = null;
        ResultSet einfoRs = null;
        Connection con = null;
        ServerGlobalObjects globs = ServerGlobalObjects.getInstance();
        ArrayList<ProduktListenElement> zubehoerprodukte = new ArrayList<ProduktListenElement>();
        try {
            con = globs.getDBConnection("ermittleVerbauteZubehoerProdukte");
            einfoPs = con.prepareStatement(SQLStatements.TechnischeSicht.instance.PRUEFE_ZUBEHOERAUSWAHL_FUER_FAHRZEUG());
            einfoPs.setLong(1, fahrzeug.getModellspalte());
            einfoPs.setString(2, prod.getBteNr());
            einfoPs.setString(3, "OPTIONAL");
            if (prod.getBildPosNr() != null && prod.getBildPosNr().length() > 0) {
                einfoPs.setString(4, prod.getBildPosNr());
            } else {
                einfoPs.setNull(4, 12);
            }
            einfoRs = einfoPs.executeQuery();
            while (einfoRs.next()) {
                boolean noAuslauf = false;
                String bte = einfoRs.getString(1);
                String pos = einfoRs.getString(2);
                long auslauf = einfoRs.getLong(3);
                if (einfoRs.wasNull()) {
                    noAuslauf = true;
                }
                String lenk = einfoRs.getString(4);
                String einsatz = Long.toString(einfoRs.getLong(5));
                if (einfoRs.wasNull()) {
                    einsatz = null;
                }
                String getriebe = einfoRs.getString(6);
                boolean auswertungFzg = true;
                try {
                    auswertungFzg = TechnischDbAccess.auswertenEinschraenkungFzg(fahrzeug, lenk, einsatz, getriebe);
                }
                catch (InvalidDataException e) {
                    log.error((Object)"Fehler bei auswertenEinschraenkungFzg", (Throwable)e);
                }
                ProduktListenElement el = new ProduktListenElement();
                el.setBteNr(bte);
                el.setBildPosNr(pos);
                if (!noAuslauf && !TechnischDbAccess.isAktuell(fahrzeug, auslauf) || zubehoerprodukte.contains(el) || !auswertungFzg) continue;
                zubehoerprodukte.add(el);
            }
            ArrayList<ProduktListenElement> arrayList = zubehoerprodukte;
            return arrayList;
        }
        finally {
            if (einfoPs != null) {
                einfoPs.close();
            }
            if (con != null) {
                globs.freeDBConnection(con, "ermittleVerbauteZubehoerProdukte");
            }
        }
    }

    private static boolean auswertenEinschraenkungFzg(FzgSucheInfo fahrzeug, String zLenkung, String zEinsatz, String zGetriebe) throws InvalidDataException {
        String sLenkung = fahrzeug.getLenkung();
        String sGetriebe = fahrzeug.getGetriebe();
        String sBaujahr = fahrzeug.getBaujahr();
        String sZulassungsmonat = fahrzeug.getZulassungsmonat();
        boolean bIdentifiedByFgstnr = fahrzeug.getFahrgestellnummer() != null && !fahrzeug.getFahrgestellnummer().equals("");
        if (sLenkung == null) {
            sLenkung = "kA";
        }
        if (sGetriebe == null) {
            sGetriebe = "kA";
        }
        if (sBaujahr == null) {
            sBaujahr = "kA";
        }
        if (sZulassungsmonat == null) {
            sZulassungsmonat = "kA";
        }
        if (sLenkung.equals("kA") && sGetriebe.equals("kA") && sBaujahr.equals("kA") && sZulassungsmonat.equals("kA")) {
            return true;
        }
        String sProdDatumEinsatzComp = "";
        long lProdDatumEinsatzComp = 0L;
        if (!sBaujahr.equals("kA")) {
            sProdDatumEinsatzComp = sZulassungsmonat.equals("kA") ? sBaujahr + "12" + "00" : sBaujahr + sZulassungsmonat + "00";
            lProdDatumEinsatzComp = Long.decode(sProdDatumEinsatzComp);
        }
        if (!sLenkung.equals("kA")) {
            String sLenkungZeile = zLenkung;
            if (sLenkungZeile != null) {
                String string = sLenkungZeile = sLenkungZeile.equals("") ? null : sLenkungZeile;
            }
            if (sLenkungZeile != null && !sLenkungZeile.equals(sLenkung)) {
                return false;
            }
        }
        if (!sGetriebe.equals("kA")) {
            String sGetriebeZeile = zGetriebe;
            if (sGetriebeZeile != null) {
                String string = sGetriebeZeile = sGetriebeZeile.equals("") ? null : sGetriebeZeile;
            }
            if (sGetriebeZeile != null && !sGetriebeZeile.equals(sGetriebe)) {
                return false;
            }
        }
        if (!sBaujahr.equals("kA")) {
            String sEinsatzZeile = zEinsatz;
            if (sEinsatzZeile != null) {
                String string = sEinsatzZeile = sEinsatzZeile.equals("") ? null : sEinsatzZeile;
            }
            if (sEinsatzZeile != null) {
                int nMonat;
                String sMonat = sEinsatzZeile.substring(4, 6);
                String sJahr = sEinsatzZeile.substring(0, 4);
                String sZeileEinsatzComp = WebetkUtils.modifyDate(sJahr, sMonat, nMonat = bIdentifiedByFgstnr ? 0 : -2);
                long lZeileEinsatzComp = Long.decode(sZeileEinsatzComp);
                if (lProdDatumEinsatzComp < lZeileEinsatzComp) {
                    return false;
                }
            }
        }
        return true;
    }

    public static ResultSet loadBTEKommentarZub(Connection con, String sBTENr, String sBildPos, int posZeile, String sSprache, String typ) throws SQLException {
        if (sBildPos == null || sBildPos.length() == 0) {
            String sSQLStatement = SQLStatements.TechnischeSicht.instance.RETRIEVE_BTEKOMMENTAR();
            String sISO = LanguageUtils.toLanguage(sSprache);
            String sRegISO = LanguageUtils.toRegion(sSprache, true);
            PreparedStatement stmt = con.prepareStatement(sSQLStatement);
            stmt.setString(1, sBTENr);
            stmt.setString(2, typ);
            stmt.setString(3, sISO);
            stmt.setString(4, sRegISO);
            ResultSet res = stmt.executeQuery();
            return res;
        }
        String sSQLStatement = SQLStatements.MarketingSicht.instance.RETRIEVE_BTEKOMMENTAR_BNB();
        String sISO = LanguageUtils.toLanguage(sSprache);
        String sRegISO = LanguageUtils.toRegion(sSprache, true);
        PreparedStatement stmt = con.prepareStatement(sSQLStatement);
        stmt.setString(1, sBTENr);
        stmt.setString(2, typ);
        stmt.setString(3, sBildPos);
        stmt.setString(4, sISO);
        stmt.setString(5, sRegISO);
        if (posZeile <= 0) {
            stmt.setNull(6, 4);
        } else {
            stmt.setInt(6, posZeile);
        }
        ResultSet res = stmt.executeQuery();
        return res;
    }
}

