/*
 * Decompiled with CFR 0.152.
 */
package webetk.framework;

import java.io.Serializable;
import java.sql.SQLException;
import java.util.Collection;
import java.util.List;
import java.util.Vector;
import org.apache.log4j.Logger;
import webetk.DatabaseBusyException;
import webetk.app.ServerGlobalObjects;
import webetk.app.konfiguration.Berechtigungen;
import webetk.app.konfiguration.Funktionsrecht;
import webetk.app.konfiguration.Funktionsrechte;
import webetk.app.settings.Einstellungen;
import webetk.app.zub.suche.ProduktId;
import webetk.fix.Constants;

public class ServerUserInfo
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String NOT_INITIALIZED = "not set";
    private static Logger log = Logger.getLogger(ServerUserInfo.class);
    protected String msID = "not set";
    protected String msFilialeID = "not set";
    protected String msFirmaID = "not set";
    protected Collection<String> mcRechte = null;
    protected Einstellungen mSettings = new Einstellungen();
    private boolean mbEinstellungenDisharmonie = false;
    protected List<ProduktId> mBteResults;

    public String toString() {
        return "User (" + this.msID + "): " + this.mSettings.toString();
    }

    public String getID() {
        return this.msID;
    }

    public String getFirmaID() {
        return this.msFirmaID;
    }

    public String getFilialeID() {
        return this.msFilialeID;
    }

    public boolean initWithID(String sID) throws SQLException, DatabaseBusyException {
        log.info((Object)("Initializing user object with ID: " + sID));
        if (this.msID.equals(sID)) {
            log.debug((Object)"User is already current. User access granted.");
            return true;
        }
        log.debug((Object)"Loading Settings for user ...");
        boolean bResult = this.loadSettings(sID, null);
        this.msID = sID;
        this.mcRechte = null;
        log.info((Object)("User has been initialized. User is " + (bResult ? "EXITENT" : "NEW")));
        return bResult;
    }

    public boolean initWithID(String sFirmaID, String sFilialID, String sID) throws SQLException, DatabaseBusyException {
        log.info((Object)("Initializing user object with ID: " + sID));
        if (this.msID.equals(sID)) {
            log.debug((Object)"User is already current. User access granted.");
            return true;
        }
        log.debug((Object)"Loading Settings for user ...");
        boolean bResult = this.loadSettings(sID, sFirmaID);
        if (bResult) {
            this.setEinstellungenDisharmonie(this.adjustSettings(sFirmaID, sID, "de", "  "));
        } else {
            this.setEinstellungenDisharmonie(true);
        }
        this.msID = sID;
        this.msFirmaID = sFirmaID;
        this.msFilialeID = sFilialID;
        this.mcRechte = null;
        log.info((Object)("User has been initialized. User is " + (bResult ? "EXISTENT" : "NEW")));
        return bResult;
    }

    protected boolean loadSettings(String sID, String sFirmaID) throws SQLException, DatabaseBusyException {
        log.debug((Object)("Loading Settings for user with ID: " + sID));
        Einstellungen settings = new Einstellungen();
        boolean bResult = settings.load(sID, sFirmaID);
        if (!bResult) {
            log.debug((Object)"No settings found. Gathering of setting information is required.");
        } else {
            log.debug((Object)"Settings loaded.");
        }
        this.mSettings = settings;
        return bResult;
    }

    public Einstellungen getSettings() {
        return this.mSettings;
    }

    public void setSettings(Einstellungen oSettings) {
        this.mSettings = oSettings;
    }

    public String getSprache() {
        if (this.mSettings == null) {
            return null;
        }
        return this.mSettings.getSprache();
    }

    public void setSprache(String sLang) {
        if (this.mSettings != null) {
            this.mSettings.setSprache(sLang);
        }
    }

    public String getSpracheRegion() {
        if (this.mSettings == null) {
            return null;
        }
        return this.mSettings.getSpracheRegion();
    }

    public void setSpracheRegion(String sLangReg) {
        this.mSettings.setSpracheRegion(sLangReg);
    }

    public void setMarke(String sMarke) throws IllegalArgumentException {
        this.mSettings.setMarke(sMarke);
    }

    public String getMarke() {
        return this.mSettings.getMarke();
    }

    public void setProduktart(String sProduktart) throws IllegalArgumentException {
        this.mSettings.setProduktart(sProduktart);
    }

    public String getProduktart() {
        return this.mSettings.getProduktart();
    }

    public void setKatalogumfang(String sKatalogumfang) throws IllegalArgumentException {
        this.mSettings.setKatalogumfang(sKatalogumfang);
    }

    public String getKatalogumfang() {
        return this.mSettings.getKatalogumfang();
    }

    public void setDarstellungBNB(boolean bValue) {
        this.mSettings.setDarstellungBN(bValue);
    }

    public boolean getDarstellungBNB() {
        return this.mSettings.getDarstellungBN();
    }

    public void setSuchwegVerkuerzen(boolean bValue) {
        this.mSettings.setSuchwegVerkuerzen(bValue);
    }

    public boolean getSuchwegVerkuerzen() {
        return this.mSettings.getSuchwegVerkuerzen();
    }

    public boolean getNachruestungenRelevant() {
        return this.mSettings.getNachruestungenRelevant();
    }

    public void setNachruestungenRelevant(boolean bNachruestungenRelevant) {
        this.mSettings.setNachruestungenRelevant(bNachruestungenRelevant);
    }

    public void setTabellenazeige(String sTabellenazeige) {
        this.mSettings.setTabellenanzeige(sTabellenazeige);
    }

    public String getTabellenanzeige() {
        return this.mSettings.getTabellenanzeige();
    }

    public void setSchriftgroesse(String sSchriftgroesse) {
        this.mSettings.setSchriftgroesse(sSchriftgroesse);
    }

    public String getSchriftgroesse() {
        return this.mSettings.getSchriftgroesse();
    }

    public void setSuchraum(String sSuchraum) {
        this.mSettings.setSuchraum(sSuchraum);
    }

    public String getSuchraum() {
        return this.mSettings.getSuchraum();
    }

    public Vector<String> getRegionen() {
        return this.mSettings.getRegionen();
    }

    public String getLenkung() {
        return this.mSettings.getLenkung();
    }

    public void setLenkung(String sLenkung) throws IllegalArgumentException {
        this.mSettings.setLenkung(sLenkung);
    }

    public boolean isInitialized() {
        return this.msID != null && !this.msID.equalsIgnoreCase("") && !this.msID.equalsIgnoreCase(NOT_INITIALIZED) && this.mSettings != null;
    }

    public Boolean getAlwaysDisplayProduktDate() {
        return this.mSettings.getAlwaysDisplayProduktDate();
    }

    public Collection<String> getRechte() {
        return this.mcRechte;
    }

    public boolean hasRecht(String sRecht) {
        if (sRecht == null) {
            return false;
        }
        if (this.mcRechte == null) {
            if (Constants.Funktionsrechte.isAdminRecht(sRecht)) {
                return false;
            }
            return !sRecht.startsWith("R_WEBETK_SAMMEL_");
        }
        if (sRecht.startsWith("R_WEBETK_SAMMEL_")) {
            if (this.mcRechte.isEmpty()) {
                return false;
            }
            for (String sUserRecht : this.mcRechte) {
                if (!sUserRecht.startsWith(sRecht)) continue;
                return true;
            }
            return false;
        }
        return this.mcRechte.contains(sRecht);
    }

    public void setRechte(Collection<String> cRechte) {
        this.mcRechte = cRechte;
    }

    protected boolean adjustSettings(String sFirmaId, String sNutzerId, String sIso, String sRegIso) throws SQLException, DatabaseBusyException {
        boolean bResult = false;
        Berechtigungen berechtigungen = new Berechtigungen(sFirmaId, sNutzerId);
        berechtigungen.loadNutzerBerechtigungen();
        Vector<Funktionsrecht> cFunktionsrechte = new Vector<Funktionsrecht>();
        Funktionsrechte oFunktionsrechte = new Funktionsrechte(sFirmaId, sNutzerId, cFunktionsrechte, sIso, sRegIso);
        oFunktionsrechte.loadNutzerFunktionsrechte();
        boolean bRechtPreiseAnzeigen = oFunktionsrechte.hatFunktionsrecht("R_WEBETK_PREISE_ANZEIGEN");
        if (this.mSettings.getLenkung() == null || this.mSettings.getRegionen() == null || this.mSettings.getSchriftgroesse() == null || this.mSettings.getSprache() == null || this.mSettings.getTabellenanzeige() == null || this.mSettings.getSuchraum() == null) {
            bResult = true;
        }
        if (this.mSettings.getMarke() == null) {
            bResult = true;
        } else if (!berechtigungen.getMarkenBerechtigungen().get(this.mSettings.getMarke()).booleanValue()) {
            this.mSettings.setMarke(null);
            for (String sKeyMarkenBerechtigung : berechtigungen.getMarkenBerechtigungen().keySet()) {
                if (!berechtigungen.getMarkenBerechtigungen().get(sKeyMarkenBerechtigung).booleanValue()) continue;
                this.mSettings.setMarke(sKeyMarkenBerechtigung);
            }
            bResult = true;
        }
        if (this.mSettings.getProduktart() == null) {
            bResult = true;
        } else if (!berechtigungen.getProdukteBerechtigungen().get(this.mSettings.getProduktart()).booleanValue()) {
            this.mSettings.setProduktart(null);
            for (String sKeyProduktBerechtigung : berechtigungen.getProdukteBerechtigungen().keySet()) {
                if (!berechtigungen.getProdukteBerechtigungen().get(sKeyProduktBerechtigung).booleanValue()) continue;
                this.mSettings.setProduktart(sKeyProduktBerechtigung);
            }
            bResult = true;
        }
        if (this.mSettings.getKatalogumfang() == null) {
            bResult = true;
        } else if (this.mSettings.getKatalogumfang().equalsIgnoreCase("VT") && !berechtigungen.isKatalogumfangVT().booleanValue()) {
            if (berechtigungen.isKatalogumfangST().booleanValue()) {
                this.mSettings.setKatalogumfang("ST");
            } else {
                this.mSettings.setKatalogumfang(null);
            }
            bResult = true;
        } else if (this.mSettings.getKatalogumfang().equalsIgnoreCase("ST") && !berechtigungen.isKatalogumfangST().booleanValue()) {
            if (berechtigungen.isKatalogumfangVT().booleanValue()) {
                this.mSettings.setKatalogumfang("VT");
            } else {
                this.mSettings.setKatalogumfang(null);
            }
            bResult = true;
        }
        if (this.mSettings.getAlwaysDisplayProduktDate() == null && berechtigungen.isProdDatum().booleanValue()) {
            bResult = true;
        }
        if (this.mSettings.getAlwaysDisplayProduktDate() != null && !berechtigungen.isProdDatum().booleanValue()) {
            this.mSettings.setAlwaysDisplayProduktDate(null);
            bResult = true;
        }
        if (this.mSettings.getDisplayPreise() == null && bRechtPreiseAnzeigen) {
            bResult = true;
        }
        if (this.mSettings.getDisplayPreise() != null && !bRechtPreiseAnzeigen) {
            this.mSettings.setDisplayPreise(null);
            bResult = true;
        }
        return bResult;
    }

    public boolean getEinstellungenDisharmonie() {
        return this.mbEinstellungenDisharmonie;
    }

    public void setEinstellungenDisharmonie(boolean bEinstellungenDisharmonie) {
        this.mbEinstellungenDisharmonie = bEinstellungenDisharmonie;
    }

    public List<ProduktId> getBteResults() {
        return this.mBteResults;
    }

    public void setBteResults(List<ProduktId> bteResults) {
        this.mBteResults = bteResults;
    }

    public int getMarktId() {
        return this.mSettings.getMarktId();
    }

    public void setMarktId(int marktId) throws SQLException, DatabaseBusyException {
        this.mSettings.setMarktId(marktId);
    }

    public boolean hasRechteIGDOM() {
        if (this.mcRechte == null || this.mcRechte.isEmpty()) {
            return true;
        }
        List<String> sammelUserRestriction = ServerGlobalObjects.getInstance().getSammelUserRestriction();
        if (sammelUserRestriction != null) {
            for (String role : sammelUserRestriction) {
                if (!this.mcRechte.contains(role)) continue;
                log.info((Object)("W_SAMMELUSER_RESTR - User " + this.msID + " hat keine Rechte f\u00fcr IGDOM und SOWU. Rolle: " + role));
                return false;
            }
        } else {
            log.error((Object)"Fehler bei der Ermittlung von W_SAMMELUSER_RESTR ");
        }
        return true;
    }
}

