/*
 * Decompiled with CFR 0.152.
 */
package webetk.javaclient;

import de.esg.commonclient.GlobalObjects;
import java.awt.Cursor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Vector;
import javax.swing.JOptionPane;
import org.apache.log4j.Logger;
import webetk.NoDataFoundException;
import webetk.app.Markt;
import webetk.communication.CommunicationException;
import webetk.communication.transferables.Command;
import webetk.communication.transferables.TrfHashMap;
import webetk.javaclient.framework.MainView;
import webetk.resources.Resource;

public class MarktDaten {
    private static Logger log = Logger.getLogger(MarktDaten.class);
    private ArrayList<Markt> mAuswahlPrimaerMarkt;
    private Markt mSelPrimaerMarkt;
    private Vector<Markt> mAuswahlSonstigeMaerkte;
    private Collection<Markt> mSelSonstigeMaerkte;
    private Markt mMarktAlle = new Markt(-1, Resource.getInstance().getAlle(), "");
    private Markt mMarktKeineSelektion = new Markt(0, Resource.getInstance().getKeineSelektion(), "");
    private Collection<Markt> mMaerkteAusDb;

    public Markt getSelPrimaerMarkt() {
        return this.mSelPrimaerMarkt;
    }

    public void setSelPrimaerMarkt(Markt selPrimaerMarkt) {
        this.mSelPrimaerMarkt = selPrimaerMarkt;
    }

    public void setSelSonstigeMaerkte(Collection<Markt> selSonstigeMaerkte) {
        this.mSelSonstigeMaerkte = new Vector<Markt>();
        if (selSonstigeMaerkte == null) {
            return;
        }
        for (Markt markt : selSonstigeMaerkte) {
            this.mSelSonstigeMaerkte.add(new Markt(markt));
        }
    }

    public void setSelSonstigeMaerkte(int[] selIndices) {
        this.mSelSonstigeMaerkte.clear();
        for (int ii = 0; ii < selIndices.length; ++ii) {
            int selInd = selIndices[ii];
            Markt selMarkt = this.mAuswahlSonstigeMaerkte.get(selInd);
            this.mSelSonstigeMaerkte.add(selMarkt);
        }
    }

    public int[] getIndicesSelSonstigeMaerkte() {
        if (this.mSelSonstigeMaerkte == null || this.mAuswahlSonstigeMaerkte == null) {
            return null;
        }
        int[] aSelIndizes = new int[this.mSelSonstigeMaerkte.size()];
        int indSel = 0;
        for (Markt selWeitererMarkt : this.mSelSonstigeMaerkte) {
            int indAuswahl = 0;
            for (Markt actMarkt : this.mAuswahlSonstigeMaerkte) {
                if (actMarkt.equals(selWeitererMarkt)) {
                    aSelIndizes[indSel++] = indAuswahl;
                }
                ++indAuswahl;
            }
        }
        return aSelIndizes;
    }

    public boolean containSelSonstigeMaerkteMarktIso(String marktIso) {
        if (marktIso == null) {
            return false;
        }
        for (Markt selMarkt : this.mSelSonstigeMaerkte) {
            if (marktIso.equals(selMarkt.getKuerzel())) {
                return true;
            }
            if (!selMarkt.equals(this.mMarktAlle)) continue;
            return true;
        }
        return false;
    }

    public void loadMaerkteandFillListen() {
        ArrayList<Markt> maerkte = this.loadMaerkte();
        this.fillAuswahlPrimaerMarkt(maerkte);
        this.fillAuswahlSonstigeMaerkte(maerkte);
    }

    private ArrayList<Markt> loadMaerkte() {
        MainView.getInstance().setCursor(Cursor.getPredefinedCursor(3));
        ArrayList maerkte = new ArrayList();
        TrfHashMap trfEinstellungen = new TrfHashMap(null);
        String sprache = GlobalObjects.getInstance().getLanguage();
        trfEinstellungen.setValue("sprache", sprache);
        try {
            GlobalObjects.getInstance().getServiceExecutor().executeService(trfEinstellungen, Command.LADE_MAERKTE_ETK_LOKALE_PRODUKTE);
        }
        catch (CommunicationException ex) {
            log.error((Object)("DlgEinstellungenController: " + GlobalObjects.getInstance().getServerUrl()), (Throwable)ex);
            MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
            return maerkte;
        }
        MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
        if (trfEinstellungen.getError() != null && !(trfEinstellungen.getError() instanceof NoDataFoundException)) {
            log.error((Object)Resource.getInstance().getSonstigerFehler(), (Throwable)trfEinstellungen.getError());
            MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
            JOptionPane.showMessageDialog(MainView.getInstance(), trfEinstellungen.getError().getMessage(), Resource.getInstance().getEinstellungen(), 0);
        }
        if ((maerkte = (ArrayList)trfEinstellungen.getValue("marktListe")) == null) {
            maerkte = new ArrayList();
        }
        return maerkte;
    }

    public Collection<Markt> getAuswahlPrimaerMarkt() {
        return this.mAuswahlPrimaerMarkt;
    }

    public void fillAuswahlPrimaerMarkt(Collection<Markt> maerkteAusDb) {
        if (maerkteAusDb == null) {
            maerkteAusDb = this.mMaerkteAusDb;
        } else {
            this.mMaerkteAusDb = maerkteAusDb;
        }
        this.mAuswahlPrimaerMarkt = new ArrayList<Markt>(maerkteAusDb);
        this.mAuswahlPrimaerMarkt.add(0, this.mMarktKeineSelektion);
        if (this.mSelPrimaerMarkt != null && !this.mAuswahlPrimaerMarkt.contains(this.mSelPrimaerMarkt)) {
            this.mAuswahlPrimaerMarkt.add(this.mSelPrimaerMarkt);
        }
    }

    public Vector<Markt> getAuswahlSonstigeMaerkte() {
        return this.mAuswahlSonstigeMaerkte;
    }

    public void fillAuswahlSonstigeMaerkte(Collection<Markt> maerkteAusDb) {
        if (maerkteAusDb == null) {
            maerkteAusDb = this.mMaerkteAusDb;
        } else {
            this.mMaerkteAusDb = maerkteAusDb;
        }
        this.mAuswahlSonstigeMaerkte = new Vector<Markt>(maerkteAusDb);
        this.mAuswahlSonstigeMaerkte.add(0, this.mMarktAlle);
        if (this.mSelSonstigeMaerkte != null) {
            for (Markt marktNutzer : this.mSelSonstigeMaerkte) {
                if (this.mAuswahlSonstigeMaerkte.contains(marktNutzer)) continue;
                this.mAuswahlSonstigeMaerkte.add(marktNutzer);
            }
        }
        this.removePrioMarktFromSonstigen();
    }

    public void removePrioMarktFromSonstigen() {
        if (this.mSelPrimaerMarkt != null) {
            if (this.mAuswahlSonstigeMaerkte != null) {
                this.mAuswahlSonstigeMaerkte.remove(this.mSelPrimaerMarkt);
            }
            if (this.mSelSonstigeMaerkte != null) {
                this.mSelSonstigeMaerkte.remove(this.mSelPrimaerMarkt);
            }
        }
    }

    public void addMarktToSonstige(Markt markt) {
        if (markt != null && !this.mAuswahlSonstigeMaerkte.contains(markt)) {
            this.mAuswahlSonstigeMaerkte.add(markt);
        }
    }

    public void changePrioMarkt(Markt newPrioMarkt) {
        Markt marktKeineSelektion = new Markt(0, Resource.getInstance().getKeineSelektion(), "");
        if (!marktKeineSelektion.equals(this.mSelPrimaerMarkt)) {
            this.addMarktToSonstige(this.mSelPrimaerMarkt);
        }
        this.mSelPrimaerMarkt = newPrioMarkt;
        this.removePrioMarktFromSonstigen();
    }
}

