/*
 * Decompiled with CFR 0.152.
 */
package webetk.javaclient.communication.login;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.ConnectException;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.Proxy;
import java.net.URL;
import java.util.List;
import java.util.Map;
import javax.net.ssl.HttpsURLConnection;
import org.apache.log4j.Logger;
import webetk.javaclient.communication.login.CommonLogin;
import webetk.utils.communication.CertTrustUtils;
import webetk.utils.communication.ProxyAuthentication;

public class AsapLogin
extends CommonLogin {
    private static final Logger log = Logger.getLogger(AsapLogin.class);
    private String dealerNo = null;
    private String userNo = null;
    private URL url = null;
    private Proxy proxy = null;
    private ProxyAuthentication proxyAuth = null;
    private HttpsURLConnection con = null;
    private String cookie1 = null;

    public static void main(String[] args) throws Exception {
        AsapLogin login = new AsapLogin();
        login.setNetzUrl("https://www.partsi-n.bmwgroup.com/tetis/index.jsp?DOMAIN=Internet");
        login.setProxyAdress("proxy.msg.de");
        login.setProxyPort(3128);
        login.setUserAndPassword("????????", "????????");
        login.setUserAndPassword("oh008605", "asap1move");
        login.login();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Status Code : " + login.getStatusCode()));
            log.debug((Object)("Status Msg  : " + login.getStatusMsg()));
        }
    }

    public AsapLogin() {
    }

    public AsapLogin(String proxyAdress, int proxyPort, String proxyUser, String proxyPassword, String netzUrl, String userID, String dealerNo, String userNo, String password) {
        this.setProxyAdress(proxyAdress);
        this.setProxyPort(proxyPort);
        this.setProxyUser(proxyUser);
        this.setProxyPassword(proxyPassword);
        this.setNetzUrl(netzUrl);
        this.setUserID(userID);
        this.setDealerNo(dealerNo);
        this.setUserNo(userNo);
        this.setPassword(password);
    }

    @Override
    public void login() throws IOException {
        System.setProperty("jsse.enableSNIExtension", "false");
        CertTrustUtils.setTrustManager();
        if (log.isDebugEnabled()) {
            log.debug((Object)("0. Request mit URL : " + this.getNetzUrl()));
        }
        this.con = this.openConnection(this.getNetzUrl());
        try {
            this.con.connect();
        }
        catch (ConnectException conExc) {
            log.error((Object)conExc.getMessage());
            this.setStatusCode(99);
            this.setStatusMsg("login to ASAP portal not successful. Can not connect!");
            return;
        }
        catch (IOException ioExc) {
            log.error((Object)("*** 0. Request: Fehler beim Verbinden ***" + ioExc.getMessage()), (Throwable)ioExc);
            throw ioExc;
        }
        StringBuilder answer0 = new StringBuilder();
        BufferedReader in = null;
        try {
            String inputLine;
            in = new BufferedReader(new InputStreamReader(this.con.getInputStream()));
            while ((inputLine = in.readLine()) != null) {
                answer0.append(inputLine);
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("Response 0. Request : " + answer0.toString()));
            }
        }
        catch (IOException ioExc) {
            log.error((Object)("*** 0. Request: Fehler beim Lesen der Anwort ***" + ioExc.getMessage()), (Throwable)ioExc);
            throw ioExc;
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException e) {
                log.error((Object)"could not close BufferedReader.", (Throwable)e);
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("1. Request mit URL : " + this.getNetzUrlAsapStart(answer0.toString())));
        }
        this.con = this.openConnection(this.getNetzUrlAsapStart(answer0.toString()));
        try {
            this.con.connect();
        }
        catch (ConnectException conExc) {
            log.error((Object)conExc.getMessage());
            this.setStatusCode(99);
            this.setStatusMsg("login to ASAP portal not successful. Can not connect!");
            return;
        }
        catch (IOException ioExc) {
            log.error((Object)("*** 1. Request: Fehler beim Verbinden ***" + ioExc.getMessage()), (Throwable)ioExc);
            throw ioExc;
        }
        String cookie = this.getHeaderCookieField(this.con).get(0);
        this.cookie1 = cookie.substring(0, cookie.indexOf(";"));
        if (log.isDebugEnabled()) {
            log.debug((Object)("cookie 1 : " + this.cookie1));
        }
        this.closeConnection(this.con);
        if (log.isDebugEnabled()) {
            log.debug((Object)("2. Request mit URL : " + this.getNetzUrlAsapLogin()));
        }
        this.con = this.openConnection(this.getNetzUrlAsapLogin());
        this.con.setRequestProperty("Cookie", this.cookie1);
        this.con.setDoOutput(true);
        try {
            String loginParam;
            OutputStreamWriter writer = new OutputStreamWriter(this.con.getOutputStream());
            if (this.getUserAndPassword() != null) {
                loginParam = this.getUserAndPassword();
                this.setAsapUserId(this.getUserID());
            } else {
                loginParam = this.getDealerUserAndPassword();
                this.setAsapUserId(this.getDealerNo());
            }
            writer.write(loginParam);
            writer.flush();
        }
        catch (IOException ioExc) {
            log.error((Object)("*** 2. Request: Fehler bei der Anmeldung ***" + ioExc.getMessage()), (Throwable)ioExc);
            throw ioExc;
        }
        List<String> cookies = this.getHeaderCookieField(this.con);
        for (String elem : cookies) {
            if (!log.isDebugEnabled()) continue;
            log.debug((Object)("Cookie : " + elem));
        }
        this.setAsapSessionId(this.cookie1.substring(this.cookie1.indexOf("=") + 1));
        if (log.isDebugEnabled()) {
            log.debug((Object)("asapSessionId : " + this.getAsapSessionId()));
        }
        this.closeConnection(this.con);
        if (log.isDebugEnabled()) {
            log.debug((Object)("3. Request mit URL : " + this.getNetzUrlStartWebETK()));
        }
        this.con = this.openConnection(this.getNetzUrlStartWebETK());
        String multiCookie = this.cookie1.concat("; ");
        for (String cks : cookies) {
            if (cks.indexOf("ASAP_FAILOVER_DOMAIN_KEY") == -1 && cks.indexOf("ASAP_FAILOVER_SESSION_ID") == -1) continue;
            multiCookie = multiCookie + cks.concat("; ");
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("ist : " + multiCookie));
        }
        this.con.setRequestProperty("Cookie", multiCookie);
        try {
            this.con.connect();
        }
        catch (IOException ioExc) {
            log.error((Object)("*** 3. Request: Fehler beim Start WebETK ***" + ioExc.getMessage()), (Throwable)ioExc);
            throw ioExc;
        }
        StringBuilder answer3 = new StringBuilder();
        BufferedReader in2 = null;
        try {
            String inputLine;
            in2 = new BufferedReader(new InputStreamReader(this.con.getInputStream()));
            while ((inputLine = in2.readLine()) != null) {
                answer3.append(inputLine);
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("Response 3. Request : " + answer3.toString()));
            }
            if (answer3.indexOf(this.getAsapSessionIdWithoutIndex()) != -1) {
                this.setStatusCode(0);
                this.setStatusMsg("Successfully login to ASAP portal.");
            } else {
                String commonStatusMsg = "login to ASAP portal not successful. ";
                if (answer3.indexOf("If you don't have an ASAP logon ID please contact your BMW dealer to obtain access.") != -1) {
                    this.setStatusCode(10);
                    this.setStatusMsg(commonStatusMsg + "Unknown or invalid login information!");
                } else if (answer3.indexOf("Your session is invalid.") != -1 && answer3.indexOf("Please log in again.") != -1) {
                    this.setStatusCode(20);
                    this.setStatusMsg(commonStatusMsg + "Miscellaneous problem during login routine for ASAP login!");
                } else {
                    this.setStatusCode(30);
                    this.setStatusMsg(commonStatusMsg + "Unforeseen other problem during login routine for ASAP login!");
                }
                log.error((Object)("Fehler im Response ASAP Login - status code : " + this.getStatusCode() + " status msg : " + this.getStatusMsg() + " last ASAP response msg : \n" + this.formatString(answer3.toString())));
            }
        }
        catch (IOException ioExc) {
            log.error((Object)("*** 3. Request: Fehler beim Lesen der Anwort ***" + ioExc.getMessage()), (Throwable)ioExc);
            throw ioExc;
        }
        finally {
            try {
                if (in2 != null) {
                    in2.close();
                }
            }
            catch (IOException e) {
                log.error((Object)"could not close BufferedReader.", (Throwable)e);
            }
        }
        this.closeConnection(this.con);
    }

    private String formatString(String sString) {
        ByteArrayInputStream in = new ByteArrayInputStream(sString.getBytes());
        byte[] buffer = new byte[160];
        StringBuffer sStringReturn = new StringBuffer();
        try {
            while (in.read(buffer) > 0) {
                sStringReturn.append(new String(buffer) + " \n");
            }
        }
        catch (IOException ioExc) {
            log.error((Object)("Fehler beim Aufbereiten der Status Message (" + sString + ") zur Anzeige : "), (Throwable)ioExc);
        }
        return sStringReturn.toString();
    }

    private List<String> getHeaderCookieField(HttpsURLConnection con) {
        Map<String, List<String>> headerFields = con.getHeaderFields();
        for (Map.Entry<String, List<String>> entry : headerFields.entrySet()) {
            System.out.println("Key: " + entry.getKey() + " Value: " + entry.getValue());
            if (entry.getKey() == null || !entry.getKey().equals("Set-Cookie")) continue;
            return entry.getValue();
        }
        return null;
    }

    private HttpsURLConnection openConnection(String httpsUrl) throws IOException {
        HttpsURLConnection con = null;
        try {
            this.url = new URL(httpsUrl);
            if (this.getProxyAdress() != null && this.getProxyAdress().length() > 0) {
                this.proxy = new Proxy(Proxy.Type.HTTP, new InetSocketAddress(this.getProxyAdress(), this.getProxyPort()));
                if (this.getProxyUser() != null && this.getProxyUser().length() > 0) {
                    this.proxyAuth = new ProxyAuthentication(this.getProxyUser(), this.getProxyPassword());
                    this.proxyAuth.initProxyAuthentication();
                }
                con = (HttpsURLConnection)this.url.openConnection(this.proxy);
            } else {
                con = (HttpsURLConnection)this.url.openConnection();
            }
        }
        catch (MalformedURLException urlExc) {
            throw urlExc;
        }
        catch (IOException ioExc) {
            throw ioExc;
        }
        return con;
    }

    private void closeConnection(HttpsURLConnection con) {
        con.disconnect();
        if (this.proxyAuth != null) {
            this.proxyAuth.resetProxyAuthentication();
        }
    }

    private String getUserAndPassword() {
        if (this.getUserID() == null) {
            return null;
        }
        return "LOGON_USERID=" + this.getUserID() + '&' + "LOGON_PASSWD=" + this.getPassword();
    }

    private String getDealerUserAndPassword() {
        if (this.getDealerNo() == null) {
            return null;
        }
        return "LOGIN_DEALERNR=" + this.getDealerNo() + '&' + "LOGIN_USERNR=" + this.getUserNo() + '&' + "LOGIN_PASSWD=" + this.getPassword();
    }

    private void setUserAndPassword(String user, String pwd) {
        this.setUserID(user);
        this.setPassword(pwd);
    }

    private String getNetzUrlAsapStart(String answer) {
        return this.getNetzUrl().substring(0, this.getNetzUrl().lastIndexOf("tetis/")) + answer.substring(answer.lastIndexOf("open(\"/") + 7, answer.indexOf("\",\"TeTIS\",windowProperties);"));
    }

    private String getNetzUrlAsapLogin() {
        return this.getNetzUrl().substring(0, this.getNetzUrl().lastIndexOf("tetis/")) + "tetis/startTetisAction.do";
    }

    private String getNetzUrlStartWebETK() {
        return this.getNetzUrl().substring(0, this.getNetzUrl().lastIndexOf("tetis/")) + "tetis/starteApplikationAction.do?ENTRY_ID=WebETK_START";
    }

    public String getDealerNo() {
        return this.dealerNo;
    }

    public void setDealerNo(String dealerNo) {
        this.dealerNo = dealerNo;
    }

    public String getUserNo() {
        return this.userNo;
    }

    public void setUserNo(String userNo) {
        this.userNo = userNo;
    }
}

