/*
 * Decompiled with CFR 0.152.
 */
package webetk.javaclient.dialog;

import de.esg.commonclient.GlobalObjects;
import de.esg.commonclient.dialog.AbstractDialogModel;
import de.esg.commonclient.dialog.AbstractDialogView;
import de.esg.commonclient.dialog.DialogViewController;
import de.esg.commonclient.dialog.JButtonEx;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collection;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import org.apache.log4j.Logger;
import webetk.app.GenericTeil;
import webetk.app.teileliste.ComboTeilelisteItem;
import webetk.communication.LoginInfo;
import webetk.communication.transferables.TrfHashMap;
import webetk.javaclient.dialog.AbstractDlgMitTLController;
import webetk.javaclient.dialog.AbstractDlgMitTLModel;
import webetk.javaclient.dialog.ImageCache;
import webetk.javaclient.dialog.extras.teileliste.DlgTeilelisteController;
import webetk.javaclient.framework.MainView;
import webetk.resources.Resource;

public abstract class AbstractDlgMitTLView
extends AbstractDialogView {
    private static Logger log = Logger.getLogger(AbstractDlgMitTLView.class);
    private AbstractDlgMitTLController controller;
    private AbstractDlgMitTLModel model;
    protected JLabel labTeileliste = null;
    protected JComboBox comboTeileliste = null;
    protected JButtonEx buttonUebernehmen = null;
    protected JButtonEx buttonUeberpruefen = null;
    protected JButtonEx buttonZurueck = null;
    protected boolean mbSuppressComboActionListener = true;
    protected ComboTeilelisteItem moSelTeileliste = null;

    @Override
    public void init(AbstractDialogModel oDlgModel, DialogViewController oDlgController) {
        log.debug((Object)"init");
        this.model = (AbstractDlgMitTLModel)oDlgModel;
        this.controller = (AbstractDlgMitTLController)oDlgController;
    }

    protected void initComponents() {
        this.labTeileliste = new JLabel(Resource.getInstance().getInTeileliste());
        this.comboTeileliste = new JComboBox();
        this.labTeileliste.setLabelFor(this.comboTeileliste);
        this.comboTeileliste.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                AbstractDlgMitTLView.this.kannSelektierteTeilelisteWechseln();
            }
        });
        this.buttonUebernehmen = new JButtonEx(Resource.getInstance().getUebernehmen(), ImageCache.getInstance().getIcon("ok.gif"));
        this.buttonUeberpruefen = new JButtonEx(Resource.getInstance().getUeberpruefen(), ImageCache.getInstance().getIcon("ueberpruefen.png"));
        this.buttonUeberpruefen.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AbstractDlgMitTLView.this.ueberpruefenTeileliste();
            }
        });
        this.buttonZurueck = new JButtonEx(Resource.getInstance().getZurueck(), ImageCache.getInstance().getIcon("back.gif"));
    }

    protected void uebernehmenInTeileliste(Collection cTeile, boolean bReplaceMenge) {
        int nSelIndex = this.comboTeileliste.getSelectedIndex();
        ComboTeilelisteItem oTeilelisteItem = this.model.getTeileliste(nSelIndex);
        String sTeilelisteID = oTeilelisteItem.getID();
        String sEigentuemer = oTeilelisteItem.getEigentuemer();
        DlgTeilelisteController ctrl = new DlgTeilelisteController();
        ctrl.uebernehmeTeile(MainView.getInstance(), oTeilelisteItem, this.model.getMarke(), cTeile, false);
        if (!sTeilelisteID.equals(oTeilelisteItem.getID()) || !sEigentuemer.equals(oTeilelisteItem.getEigentuemer())) {
            this.controller.loadTeilelistenIDs();
            this.updateTeilelisten();
        }
    }

    protected void uebernehmenInTeileListe(Collection<GenericTeil> cTeile, boolean replaceMenge) {
        int nSelIndex = this.comboTeileliste.getSelectedIndex();
        ComboTeilelisteItem oTeilelisteItem = this.model.getTeileliste(nSelIndex);
        String sTeilelisteID = oTeilelisteItem.getID();
        String sEigentuemer = oTeilelisteItem.getEigentuemer();
        DlgTeilelisteController ctrl = new DlgTeilelisteController();
        ctrl.uebernehmeTeile(MainView.getInstance(), oTeilelisteItem, this.model.getMarke(), cTeile, false);
        if (!sTeilelisteID.equals(oTeilelisteItem.getID()) || !sEigentuemer.equals(oTeilelisteItem.getEigentuemer())) {
            this.controller.loadTeilelistenIDs();
            this.updateTeilelisten();
        }
    }

    protected void uebernehmenInTeilelisteMitFIS(Collection cTeile, boolean bReplaceMenge) {
        int nSelIndex = this.comboTeileliste.getSelectedIndex();
        ComboTeilelisteItem oTeilelisteItem = this.model.getTeileliste(nSelIndex);
        String sTeilelisteID = oTeilelisteItem.getID();
        String sEigentuemer = oTeilelisteItem.getEigentuemer();
        DlgTeilelisteController ctrl = new DlgTeilelisteController();
        ctrl.uebernehmeTeile(MainView.getInstance(), oTeilelisteItem, this.model.getMarke(), cTeile, true);
        if (!sTeilelisteID.equals(oTeilelisteItem.getID()) || !sEigentuemer.equals(oTeilelisteItem.getEigentuemer())) {
            this.controller.loadTeilelistenIDs();
            this.updateTeilelisten();
        }
    }

    public void updateTeilelisten() {
        TrfHashMap oTeilelistenIDs = this.model.getTeilelistenIDs();
        this.mbSuppressComboActionListener = true;
        this.comboTeileliste.removeAllItems();
        if (oTeilelistenIDs != null) {
            ComboTeilelisteItem oTeilelisteItem;
            int i = 1;
            while ((oTeilelisteItem = (ComboTeilelisteItem)oTeilelistenIDs.getValue(i + "teilelisteid")) != null) {
                this.comboTeileliste.addItem(oTeilelisteItem);
                ++i;
            }
            ComboTeilelisteItem oItem = DlgTeilelisteController.ermittleSelTL(this.model.getTeilelistenCollection(), true);
            this.comboTeileliste.setSelectedItem(oItem);
            this.moSelTeileliste = oItem;
            LoginInfo oLoginInfo = GlobalObjects.getInstance().getSessionInfo();
            oLoginInfo.setAktuelleTeileliste(oItem);
            this.buttonUeberpruefen.setEnabled(this.moSelTeileliste != null && this.moSelTeileliste.getID() != null && this.moSelTeileliste.getID().length() > 0 && !this.moSelTeileliste.getID().equals(Resource.getInstance().getNeueListe()));
        }
        this.mbSuppressComboActionListener = false;
    }

    public AbstractDlgMitTLController getController() {
        return this.controller;
    }

    protected void kannSelektierteTeilelisteWechseln() {
        if (this.mbSuppressComboActionListener) {
            return;
        }
        LoginInfo oLoginInfo = GlobalObjects.getInstance().getSessionInfo();
        if (oLoginInfo.getAktuelleTeileliste() == null) {
            oLoginInfo.setAktuelleTeileliste(this.moSelTeileliste);
        }
        ComboTeilelisteItem oAktTLOld = oLoginInfo.getAktuelleTeileliste();
        int nSelIndex = this.comboTeileliste.getSelectedIndex();
        ComboTeilelisteItem oTeilelisteItem = this.model.getTeileliste(nSelIndex);
        if (!DlgTeilelisteController.kannSelektionWechseln(oTeilelisteItem, this.moSelTeileliste)) {
            this.mbSuppressComboActionListener = true;
            this.comboTeileliste.setSelectedItem(this.moSelTeileliste);
            this.mbSuppressComboActionListener = false;
        } else {
            if (this.moSelTeileliste.getID().equals(oAktTLOld.getID()) && !oLoginInfo.getLogin().equals(oAktTLOld.getEigentuemer())) {
                DlgTeilelisteController.removeListe(this.moSelTeileliste, this.model.getTeilelistenIDs());
                this.updateTeilelisten();
            }
            this.moSelTeileliste = (ComboTeilelisteItem)this.comboTeileliste.getSelectedItem();
            this.buttonUeberpruefen.setEnabled(this.moSelTeileliste != null && this.moSelTeileliste.getID() != null && this.moSelTeileliste.getID().length() > 0 && !this.moSelTeileliste.getID().equals(Resource.getInstance().getNeueListe()));
        }
    }

    protected void ueberpruefenTeileliste() {
        int nSelIndex = this.comboTeileliste.getSelectedIndex();
        ComboTeilelisteItem oTeilelisteItem = this.model.getTeileliste(nSelIndex);
        String sTeilelisteID = oTeilelisteItem.getID();
        String sEigentuemer = oTeilelisteItem.getEigentuemer();
        DlgTeilelisteController.showKleineListe(oTeilelisteItem);
        if (!sTeilelisteID.equals(oTeilelisteItem.getID()) || !sEigentuemer.equals(oTeilelisteItem.getEigentuemer())) {
            this.controller.loadTeilelistenIDs();
            this.updateTeilelisten();
        }
    }
}

