/*
 * Decompiled with CFR 0.152.
 */
package webetk.javaclient.dialog;

import cz.autel.dmi.HIGConstraints;
import cz.autel.dmi.HIGLayout;
import java.awt.Component;
import java.awt.Font;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JTextArea;
import org.apache.log4j.Logger;
import webetk.javaclient.dialog.TitledPanel;
import webetk.javaclient.lookandfeel.UIHelper;

public class ChoicePanel
extends TitledPanel {
    private static final long serialVersionUID = -3912160898528392818L;
    public static final int ORIENTATION_HORIZONTAL = 1;
    public static final int ORIENTATION_VERTICAL = 2;
    protected Logger log = Logger.getLogger(ChoicePanel.class);
    protected ButtonGroup bg = new ButtonGroup();
    protected AbstractButton[] items;
    private String text = null;

    public ChoicePanel(String title, AbstractButton[] items, int selectedIndex, int orientation) {
        super(title);
        this.createChoicePanel(null, items, selectedIndex, orientation);
    }

    public ChoicePanel(String title, AbstractButton[] items, int selectedIndex) {
        super(title);
        this.createChoicePanel(null, items, selectedIndex, 2);
    }

    public ChoicePanel(String title, String titleZweiteZeile, AbstractButton[] items, int selectedIndex) {
        super(title);
        this.createChoicePanel(titleZweiteZeile, items, selectedIndex, 2);
    }

    public ChoicePanel(String title, String titleZweiteZeile, AbstractButton[] items, int index, String txt) {
        super(title);
        this.text = txt;
        this.createChoicePanel(titleZweiteZeile, items, index, 2);
    }

    protected void createChoicePanel(String titleZweiteZeile, AbstractButton[] items, int selectedIndex, int orientation) throws IllegalArgumentException {
        this.items = items;
        switch (orientation) {
            case 1: {
                this.createChoicePanelHorizontal(items, selectedIndex);
                break;
            }
            case 2: {
                this.createChoicePanelVertical(titleZweiteZeile, items, selectedIndex);
                break;
            }
            default: {
                throw new IllegalArgumentException("ChoicePanel: Parameter orientation mu\u00df entweder ORIENTATION_HORIZONTAL oder ORIENTATION_VERTICAL sein");
            }
        }
    }

    protected void createChoicePanelVertical(String titleZweiteZeile, AbstractButton[] items, int selectedIndex) {
        int[] w = new int[]{3, 0};
        int zeilen = items.length;
        if (titleZweiteZeile != null) {
            ++zeilen;
        }
        if (this.text != null) {
            ++zeilen;
        }
        int[] h = new int[zeilen];
        HIGLayout layout = new HIGLayout(w, h);
        HIGConstraints c = new HIGConstraints();
        this.setLayout(layout);
        int zeile = 1;
        if (titleZweiteZeile != null) {
            JLabel labelZweiteZeile = new JLabel(titleZweiteZeile);
            labelZweiteZeile.setFont(UIHelper.getBoldFont());
            this.add((Component)labelZweiteZeile, c.rc(zeile, 2));
            ++zeile;
        }
        for (int i = 0; i < items.length; ++i) {
            this.bg.add(items[i]);
            this.add((Component)items[i], c.rc(zeile, 2));
            ++zeile;
            if (selectedIndex != i) continue;
            items[i].setSelected(true);
        }
        if (this.text != null) {
            JTextArea txt = new JTextArea(this.text);
            txt.setSize(200, 50);
            txt.setFont(new Font(this.getFont().getFontName(), 0, 9));
            txt.setAutoscrolls(false);
            txt.setEditable(false);
            txt.setLineWrap(true);
            txt.setWrapStyleWord(true);
            txt.setEnabled(true);
            txt.setFocusable(false);
            txt.setBackground(this.getBackground());
            this.add((Component)txt, c.rc(zeile, 2));
        }
    }

    protected void createChoicePanelHorizontal(AbstractButton[] items, int selectedIndex) {
        int[] w = new int[items.length * 2 + 1];
        int[] h = new int[]{1, 0, 1};
        w[0] = 5;
        for (int i = 1; i < items.length; ++i) {
            w[i * 2] = 10;
        }
        w[items.length * 2] = 5;
        HIGLayout layout = new HIGLayout(w, h);
        HIGConstraints c = new HIGConstraints();
        this.setLayout(layout);
        for (int i = 0; i < items.length; ++i) {
            items[i].setBorder(null);
            this.bg.add(items[i]);
            this.add((Component)items[i], c.rc(2, i * 2 + 2));
            if (selectedIndex != i) continue;
            items[i].setSelected(true);
        }
    }

    public void deselectAllButtons() {
        int i;
        for (i = 0; i < this.items.length; ++i) {
            this.bg.remove(this.items[i]);
        }
        for (i = 0; i < this.items.length; ++i) {
            this.items[i].setSelected(false);
        }
        for (i = 0; i < this.items.length; ++i) {
            this.bg.add(this.items[i]);
        }
    }
}

