/*
 * Decompiled with CFR 0.152.
 */
package webetk.javaclient.dialog;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.UIManager;
import javax.swing.border.LineBorder;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeCellRenderer;
import webetk.javaclient.lookandfeel.UIHelper;

public class HGFGTreeCellRenderer
implements TreeCellRenderer {
    Color textSelectionColor;
    Color textNonSelectionColor;
    Color backgroundSelectionColor;
    Color backgroundNonSelectionColor;
    Color borderSelectionColor;
    JPanel panel = new JPanel();
    Font fNode;
    Font fLeaf;
    int indent = 0;
    JLabel label = new JLabel();

    public HGFGTreeCellRenderer() {
        this.label.setOpaque(false);
        this.fLeaf = UIHelper.getNormalFont();
        this.fNode = UIHelper.getNormalFont();
        this.panel.setLayout(null);
        this.panel.add(this.label);
        this.panel.setOpaque(true);
        this.textSelectionColor = UIManager.getColor("Tree.selectionForeground");
        this.textNonSelectionColor = UIManager.getColor("Tree.textForeground");
        this.backgroundSelectionColor = UIManager.getColor("Tree.selectionBackground");
        this.backgroundNonSelectionColor = Color.white;
        this.borderSelectionColor = UIManager.getColor("Tree.selectionBorderColor");
    }

    public int getIndent() {
        return this.indent;
    }

    @Override
    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        if (selected) {
            this.panel.setBorder(new LineBorder(this.borderSelectionColor));
            this.panel.setForeground(this.textSelectionColor);
            this.panel.setBackground(this.backgroundSelectionColor);
        } else {
            this.panel.setBorder(new LineBorder(this.backgroundNonSelectionColor));
            this.panel.setForeground(this.textNonSelectionColor);
            this.panel.setBackground(this.backgroundNonSelectionColor);
        }
        this.label.setFont(leaf ? this.fLeaf : this.fNode);
        this.label.setText(value.toString());
        DefaultMutableTreeNode tn = (DefaultMutableTreeNode)value;
        Dimension d = this.label.getPreferredSize();
        int w = (2 - tn.getLevel()) * this.indent + d.width;
        this.panel.setPreferredSize(new Dimension(w, d.height));
        this.label.setBounds((2 - tn.getLevel()) * this.indent, 0, d.width, d.height);
        this.panel.setToolTipText(value.toString());
        return this.panel;
    }
}

