/*
 * Decompiled with CFR 0.152.
 */
package webetk.javaclient.dialog;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.font.FontRenderContext;
import java.awt.font.TextLayout;
import java.awt.geom.Rectangle2D;
import java.util.Collection;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.JPanel;
import org.apache.log4j.Logger;
import webetk.javaclient.dialog.HeaderString;
import webetk.javaclient.lookandfeel.UIHelper;

public class HeaderPanel
extends JPanel {
    private static final long serialVersionUID = 3586440524709446319L;
    Logger log = Logger.getLogger(HeaderPanel.class);
    Font bigTitleFont = UIHelper.getBigTitleFont();
    Font smallTitleFont = UIHelper.getSmallTitleFont();
    Font smallTitleBoldFont = this.smallTitleFont.deriveFont(1);
    String bigTitle = null;
    Collection<HeaderString> mcSmallTitles = new Vector<HeaderString>();
    Icon icon;

    public HeaderPanel(String bigTitle, Icon icon) {
        this.setBigTitle(bigTitle);
        this.setIcon(icon);
    }

    public HeaderPanel(String bigTitle, String smallTitle, Icon icon) {
        if (bigTitle == null) {
            throw new IllegalArgumentException("bigTitle must not be null for HeaderPanel");
        }
        this.setBigTitle(bigTitle);
        this.setSmallTitle(smallTitle);
        this.setIcon(icon);
    }

    public HeaderPanel(String bigTitle, Collection<HeaderString> cSmallTitles, Icon icon) {
        if (bigTitle == null) {
            throw new IllegalArgumentException("bigTitle must not be null for HeaderPanel");
        }
        this.bigTitle = bigTitle;
        this.mcSmallTitles.clear();
        this.mcSmallTitles = cSmallTitles;
        this.icon = icon;
    }

    public void setBigTitle(String sBigTitle) {
        this.bigTitle = sBigTitle;
    }

    public void setSmallTitle(String sSmallTitle) {
        this.mcSmallTitles.clear();
        sSmallTitle = sSmallTitle == null ? "" : sSmallTitle;
        sSmallTitle = sSmallTitle.trim();
        if (!sSmallTitle.equals("")) {
            HeaderString oHeaderString = new HeaderString(sSmallTitle, false);
            this.mcSmallTitles.add(oHeaderString);
        }
    }

    public void setSmallTitles(Collection<HeaderString> cSmallTitles) {
        this.mcSmallTitles.clear();
        this.mcSmallTitles = cSmallTitles;
    }

    public void setIcon(Icon sIcon) {
        this.icon = sIcon;
    }

    @Override
    public void paint(Graphics g) {
        Graphics2D g2d = (Graphics2D)g;
        g2d.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_OFF);
        g2d.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        g2d.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        g2d.setColor(Color.white);
        Dimension d = this.getSize();
        g2d.fillRect(0, 0, d.width, d.height);
        FontRenderContext ctx = g2d.getFontRenderContext();
        if (this.icon != null) {
            int x = d.width - this.icon.getIconWidth();
            int y = (d.height - this.icon.getIconHeight()) / 2;
            this.icon.paintIcon(this, g2d, x, y);
        }
        if (this.mcSmallTitles.size() > 0) {
            TextLayout tBig = new TextLayout(this.bigTitle, this.bigTitleFont, ctx);
            Rectangle2D boundsBig = tBig.getBounds();
            TextLayout tSmallBold = new TextLayout("Test", this.smallTitleBoldFont, ctx);
            Rectangle2D boundsSmallBold = tSmallBold.getBounds();
            TextLayout tSmall = new TextLayout("Test", this.smallTitleFont, ctx);
            Rectangle2D boundsSmall = tSmall.getBounds();
            double height = 0.0;
            double diff = 0.0;
            float y = 0.0f;
            if (this.hasBoldSmallTitles()) {
                height = boundsBig.getHeight() + boundsSmallBold.getHeight();
                diff = ((double)d.height - height) / 3.0;
                y = (float)((double)d.height - boundsSmallBold.getHeight() - boundsSmallBold.getY() - diff);
            } else {
                height = boundsBig.getHeight() + boundsSmall.getHeight();
                diff = ((double)d.height - height) / 3.0;
                y = (float)((double)d.height - boundsSmall.getHeight() - boundsSmall.getY() - diff);
            }
            g2d.setColor(UIHelper.getBigTitleColor());
            tBig.draw(g2d, 10.0f, (float)(3.0 + diff - boundsBig.getY()));
            Iterator<HeaderString> iterator = this.mcSmallTitles.iterator();
            float fVorgaender = 0.0f;
            while (iterator.hasNext()) {
                HeaderString oHeaderString = iterator.next();
                String sString = oHeaderString.getString();
                boolean bBold = oHeaderString.isBold();
                if (bBold) {
                    tSmallBold = new TextLayout(sString, this.smallTitleBoldFont, ctx);
                    boundsSmallBold = tSmallBold.getBounds();
                    g2d.setColor(UIHelper.getSmallTitleColor());
                    tSmallBold.draw(g2d, 20.0f + fVorgaender, y);
                    fVorgaender = (float)(boundsSmallBold.getWidth() + 5.0);
                    continue;
                }
                tSmall = new TextLayout(sString, this.smallTitleFont, ctx);
                boundsSmall = tSmall.getBounds();
                g2d.setColor(UIHelper.getSmallTitleColor());
                tSmall.draw(g2d, 20.0f + fVorgaender, y);
                fVorgaender = (float)(boundsSmall.getWidth() + 5.0);
            }
        } else {
            TextLayout tBig = new TextLayout(this.bigTitle, this.bigTitleFont, ctx);
            Rectangle2D boundsBig = tBig.getBounds();
            double height = boundsBig.getHeight();
            double diff = ((double)d.height - height) / 2.0;
            g2d.setColor(UIHelper.getBigTitleColor());
            tBig.draw(g2d, 10.0f, (float)(diff - boundsBig.getY()));
        }
    }

    private boolean hasBoldSmallTitles() {
        if (this.mcSmallTitles == null) {
            return false;
        }
        for (HeaderString oHeaderString : this.mcSmallTitles) {
            if (!oHeaderString.isBold()) continue;
            return true;
        }
        return false;
    }

    @Override
    public Dimension getPreferredSize() {
        if (this.icon != null) {
            return new Dimension(200, Math.max(40, this.icon.getIconHeight()));
        }
        return new Dimension(200, 55);
    }
}

