/*
 * Decompiled with CFR 0.152.
 */
package webetk.javaclient.dialog;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Vector;
import javax.swing.ButtonGroup;
import javax.swing.JRadioButton;
import javax.swing.border.Border;
import webetk.javaclient.dialog.TitledPanel;
import webetk.mrkprd.MarkenProdukte;
import webetk.mrkprd.Produkt;
import webetk.mrkprd.Produkte;

public class ProduktPanel
extends TitledPanel {
    private static final long serialVersionUID = 1L;
    private Vector<Produkt> vProdukte = new Vector();
    private ButtonGroup btGrp = new ButtonGroup();
    private HashMap<Produkt, JRadioButton> hJrbProdukt = new HashMap();
    private HashMap<Produkt, GridBagConstraints> hGrdBgCnst = new HashMap();

    public ProduktPanel(String title) {
        super(title);
        this.createProduktPanel();
    }

    public ProduktPanel(String title, Border border) {
        super(title, border);
        this.createProduktPanel();
    }

    private void createProduktPanel() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        gridBagLayout.columnWidths = new int[]{0, 0, 0};
        gridBagLayout.rowHeights = new int[]{0, 0};
        gridBagLayout.columnWeights = new double[]{1.0, 1.0, Double.MIN_VALUE};
        gridBagLayout.rowWeights = new double[]{1.0, Double.MIN_VALUE};
        this.setLayout(gridBagLayout);
        ArrayList<String> lProdukte = MarkenProdukte.getInstance(1).getProdukte();
        for (String sProdukt : lProdukte) {
            this.vProdukte.add(Produkte.getInstance().getProduktZurProduktBerechtigung(sProdukt));
        }
        int ind = 0;
        for (Produkt oProdukt : this.vProdukte) {
            JRadioButton jRdBt = new JRadioButton(oProdukt.getName());
            GridBagConstraints gbc_rdbtn = new GridBagConstraints();
            gbc_rdbtn.anchor = 18;
            gbc_rdbtn.insets = new Insets(0, 0, 0, 5);
            gbc_rdbtn.gridx = ind++;
            gbc_rdbtn.gridy = 0;
            this.hJrbProdukt.put(oProdukt, jRdBt);
            this.hGrdBgCnst.put(oProdukt, gbc_rdbtn);
        }
        for (Produkt oProdukt : this.vProdukte) {
            this.add((Component)this.hJrbProdukt.get(oProdukt), this.hGrdBgCnst.get(oProdukt));
            this.btGrp.add(this.hJrbProdukt.get(oProdukt));
        }
    }

    public void setUeberschrift(String title) {
        this.setTitle(title);
    }

    public ButtonGroup getBtGrp() {
        return this.btGrp;
    }

    public HashMap<Produkt, JRadioButton> getJrbProdukt() {
        return this.hJrbProdukt;
    }

    public HashMap<Produkt, GridBagConstraints> getGrdBgCnst() {
        return this.hGrdBgCnst;
    }
}

