/*
 * Decompiled with CFR 0.152.
 */
package webetk.javaclient.dialog;

import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import webetk.javaclient.lookandfeel.UIHelper;

public class TitledPanel
extends JPanel {
    private static final long serialVersionUID = -8787022250122335950L;
    protected String title;
    protected Dimension miniumBorderSize;
    protected Border border;

    public TitledPanel(String title, LayoutManager layout, Border border) {
        super(layout);
        this.title = title;
        this.border = border;
        this.createTitle();
    }

    public TitledPanel(String title, Border border) {
        this.title = title;
        this.border = border;
        this.createTitle();
    }

    public TitledPanel(String title, LayoutManager layout) {
        super(layout);
        this.title = title;
        this.createTitle();
    }

    public TitledPanel(String title) {
        this.title = title;
        this.createTitle();
    }

    private void createTitle() {
        if (this.border == null) {
            this.border = UIHelper.getStandardBorder();
        }
        if (this.title != null) {
            TitledBorder tb = new TitledBorder(this.border, this.title);
            tb.setTitleFont(UIHelper.getBoldFont());
            this.setBorder(tb);
            this.miniumBorderSize = tb.getMinimumSize(this);
        } else {
            this.setBorder(this.border);
            Insets insets = this.border.getBorderInsets(this);
            this.miniumBorderSize = new Dimension(insets.right + insets.left, insets.top + insets.bottom);
        }
        this.miniumBorderSize.width += 5;
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension contentPrefSize = super.getPreferredSize();
        contentPrefSize.width = Math.max(contentPrefSize.width, this.miniumBorderSize.width);
        contentPrefSize.height = Math.max(contentPrefSize.height, this.miniumBorderSize.height);
        return contentPrefSize;
    }

    @Override
    public Dimension getMinimumSize() {
        Dimension contentPrefSize = super.getMinimumSize();
        contentPrefSize.width = Math.max(contentPrefSize.width, this.miniumBorderSize.width);
        contentPrefSize.height = Math.max(contentPrefSize.height, this.miniumBorderSize.height);
        return contentPrefSize;
    }

    public void setTitle(String sTitle) {
        this.title = sTitle;
        this.createTitle();
    }
}

