/*
 * Decompiled with CFR 0.152.
 */
package webetk.javaclient.dialog.administration.auswertungen;

import de.esg.commonclient.GlobalObjects;
import de.esg.commonclient.dialog.AbstractDialogViewController;
import de.esg.commonclient.dialog.DialogView;
import de.esg.commonclient.dialog.JButtonEx;
import java.awt.Cursor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import javax.swing.JCheckBox;
import javax.swing.JOptionPane;
import javax.swing.JRadioButton;
import javax.swing.JSpinner;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.log4j.Logger;
import webetk.app.auswertung.User;
import webetk.communication.CommunicationException;
import webetk.communication.transferables.Command;
import webetk.communication.transferables.TrfHashMap;
import webetk.javaclient.dialog.administration.auswertungen.DlgAuswertungenModel;
import webetk.javaclient.dialog.administration.auswertungen.DlgAuswertungenView;
import webetk.javaclient.framework.MainView;
import webetk.javaclient.workflow.WorkflowStateData;
import webetk.resources.Resource;
import webetk.utils.StringUtils;

public class DlgAuswertungenController
extends AbstractDialogViewController
implements ItemListener,
ChangeListener,
ActionListener {
    private static Logger log = Logger.getLogger(DlgAuswertungenController.class);
    public static final String AUSWERTUNG = "Auswertung";
    public static final String SPINNER_MONATE = "SpinnerMonate";
    public static final String USERS_ONLINE = "UsersOnline";
    public static final String USERS_INACTIVE = "UsersInactive";
    public static final String ALLE_AUSWAEHLEN = "AlleAuswaehlen";
    public static final String SELEKTION_LOESCHEN = "SelektionLoeschen";
    DlgAuswertungenView view = new DlgAuswertungenView();
    DlgAuswertungenModel model = new DlgAuswertungenModel();

    @Override
    public DialogView getDialogView() {
        log.debug((Object)"getDialogView");
        return this.view;
    }

    @Override
    public void init(WorkflowStateData oWFStateData) {
        log.debug((Object)"init");
        this.model.init(oWFStateData);
        this.view.init(this.model, this);
    }

    @Override
    public WorkflowStateData getExitData() {
        return null;
    }

    @Override
    public boolean skipToNextState() {
        return false;
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        JRadioButton button;
        if (e.getSource() instanceof JRadioButton && (button = (JRadioButton)e.getSource()).isSelected()) {
            this.model.setTableData(null);
            this.view.update();
        }
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        JSpinner spinner;
        if (e.getSource() instanceof JSpinner && (spinner = (JSpinner)e.getSource()).getName().equals(SPINNER_MONATE)) {
            this.view.update();
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() instanceof JButtonEx) {
            JButtonEx button = (JButtonEx)e.getSource();
            if (button.getName().equals(AUSWERTUNG)) {
                this.performAuswertung();
                this.view.update();
            }
            if (button.getName().equals(SELEKTION_LOESCHEN)) {
                this.performSelektionLoeschen();
                this.view.update();
            }
        } else if (e.getSource() instanceof JCheckBox) {
            JCheckBox checkbox = (JCheckBox)e.getSource();
            if (checkbox.getName().equals(ALLE_AUSWAEHLEN)) {
                for (User user : this.model.getTableData()) {
                    user.setChecked(checkbox.isSelected());
                }
            }
            this.view.update();
        }
    }

    private void performAuswertung() {
        String auswahl = this.view.getAuswahl();
        if (auswahl.equals(USERS_ONLINE)) {
            this.performAuswertungUsersOnline();
        } else if (auswahl.equals(USERS_INACTIVE)) {
            this.performAuswertungUsersInactive();
        } else {
            log.error((Object)("Unknown command received: " + auswahl));
        }
    }

    private void performAuswertungUsersOnline() {
        String sFirmaId = GlobalObjects.getInstance().getSessionInfo().getFirmaId();
        if (sFirmaId != null) {
            ArrayList<String> aUserIdToIgnore = new ArrayList<String>(1);
            aUserIdToIgnore.add("score");
            TrfHashMap trfLog = new TrfHashMap(null);
            trfLog.setValue("firmaid", sFirmaId);
            trfLog.setValue("userids_to_ignore", aUserIdToIgnore);
            try {
                GlobalObjects.getInstance().getServiceExecutor().executeService(trfLog, Command.GET_LOGGEDIN_USERS);
            }
            catch (CommunicationException ex) {
                log.error((Object)("performAuswertungUsersOnline: " + GlobalObjects.getInstance().getServerUrl()), (Throwable)ex);
                MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
                return;
            }
            if (trfLog.getError() != null) {
                log.error((Object)Resource.getInstance().getSonstigerFehler(), (Throwable)trfLog.getError());
                MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
                return;
            }
            List users = (List)trfLog.getValue("userList");
            this.model.setTableData(users);
            this.view.update();
        }
    }

    private void performAuswertungUsersInactive() {
        String sFirmaId = GlobalObjects.getInstance().getSessionInfo().getFirmaId();
        if (sFirmaId != null) {
            ArrayList<String> aUserIdToIgnore = new ArrayList<String>();
            aUserIdToIgnore.add("score");
            GregorianCalendar cal = new GregorianCalendar();
            cal.setTime(new Date());
            cal.add(2, -this.view.getSelectedAnzahlMonate());
            Long lDateSince = Long.valueOf(new SimpleDateFormat("yyyyMMddhhmm").format(cal.getTime()));
            TrfHashMap trfLog = new TrfHashMap(null);
            trfLog.setValue("firmaid", sFirmaId);
            trfLog.setValue("userids_to_ignore", aUserIdToIgnore);
            trfLog.setValue("datum", lDateSince);
            try {
                GlobalObjects.getInstance().getServiceExecutor().executeService(trfLog, Command.GET_INACTIVE_USERS);
            }
            catch (CommunicationException ex) {
                log.error((Object)("performAuswertungUsersInactive: " + GlobalObjects.getInstance().getServerUrl()), (Throwable)ex);
                MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
                return;
            }
            if (trfLog.getError() != null) {
                log.error((Object)Resource.getInstance().getSonstigerFehler(), (Throwable)trfLog.getError());
                MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
                return;
            }
            this.model.setTableData((List)trfLog.getValue("userList"));
            this.view.update();
        }
    }

    private void performSelektionLoeschen() {
        List<User> users = this.model.getTableData();
        if (users == null || users.isEmpty()) {
            return;
        }
        MainView.getInstance().setCursor(Cursor.getPredefinedCursor(3));
        ArrayList<User> aUsersNotDeleteable = new ArrayList<User>();
        for (User user : users) {
            if (!user.isChecked() || this.deleteNutzer(user.getUserId())) continue;
            aUsersNotDeleteable.add(user);
        }
        MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
        System.out.println(aUsersNotDeleteable.size());
        if (aUsersNotDeleteable.size() > 0) {
            String message = null;
            if (aUsersNotDeleteable.size() == 1) {
                User user;
                message = "<html>";
                message = message + Resource.getInstance().getNutzerKonnteNichtGeloeschtWerden();
                message = message + "</html>";
                user = (User)aUsersNotDeleteable.get(0);
                String sUser = user.getUserName();
                sUser = sUser + "<p>";
                message = StringUtils.substituteStringStraight(message, "{0}", sUser);
            } else {
                message = "<html>";
                message = message + Resource.getInstance().getNutzerKonntenNichtGeloeschtWerden();
                message = message + "</html>";
                StringBuilder sb = new StringBuilder("<p>");
                for (User user : aUsersNotDeleteable) {
                    sb.append("&nbsp;&nbsp;");
                    sb.append(user.getUserName());
                    sb.append("<p>");
                }
                message = StringUtils.substituteStringStraight(message, "{0}", sb.toString());
            }
            JOptionPane.showMessageDialog(MainView.getInstance(), message, Resource.getInstance().getBenutzerverwaltung(), 0);
        }
        this.performAuswertung();
    }

    private boolean deleteNutzer(String sUserId) {
        if (sUserId.equals("admin")) {
            return false;
        }
        log.debug((Object)("Performing Delete Nutzer " + sUserId));
        String sFirmaId = GlobalObjects.getInstance().getSessionInfo().getFirmaId();
        TrfHashMap trfDelete = new TrfHashMap(null);
        trfDelete.setValue("user_id", sUserId);
        trfDelete.setValue("firmaid", sFirmaId);
        try {
            GlobalObjects.getInstance().getServiceExecutor().executeService(trfDelete, Command.DELETE_NUTZER);
        }
        catch (CommunicationException ex) {
            log.error((Object)("deleteNutzer: " + GlobalObjects.getInstance().getServerUrl()), (Throwable)ex);
            return false;
        }
        if (trfDelete.getError() != null) {
            log.error((Object)Resource.getInstance().getSonstigerFehler(), (Throwable)trfDelete.getError());
            return false;
        }
        return true;
    }

    public void setDatasetSelected(int index, boolean selected) {
        List<User> users = this.model.getTableData();
        if (users != null && !users.isEmpty() && index >= 0 && index < users.size()) {
            User user = users.get(index);
            user.setChecked(selected);
        }
        this.view.update();
    }
}

