/*
 * Decompiled with CFR 0.152.
 */
package webetk.javaclient.dialog.administration.auswertungen;

import de.esg.commonclient.dialog.AbstractDialogModel;
import de.esg.commonclient.dialog.AbstractDialogView;
import de.esg.commonclient.dialog.DialogViewController;
import de.esg.commonclient.dialog.JButtonEx;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Date;
import java.util.List;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTable;
import javax.swing.SpinnerNumberModel;
import javax.swing.border.TitledBorder;
import org.apache.log4j.Logger;
import webetk.app.auswertung.User;
import webetk.javaclient.dialog.HeaderPanel;
import webetk.javaclient.dialog.ImageCache;
import webetk.javaclient.dialog.TitledPanel;
import webetk.javaclient.dialog.administration.auswertungen.AuswertungCellRenderer;
import webetk.javaclient.dialog.administration.auswertungen.AuswertungenTableModel;
import webetk.javaclient.dialog.administration.auswertungen.DlgAuswertungenController;
import webetk.javaclient.dialog.administration.auswertungen.DlgAuswertungenModel;
import webetk.javaclient.dialog.administration.firmeneinstellungen.DlgFirmeneinstellungenView;
import webetk.resources.Resource;

public class DlgAuswertungenView
extends AbstractDialogView {
    private static final long serialVersionUID = -6791626948096842448L;
    Logger log = Logger.getLogger(DlgFirmeneinstellungenView.class);
    DlgAuswertungenModel model;
    DlgAuswertungenController controller;
    private JPanel panHeader;
    private JPanel panMain;
    private JPanel panAuswahl;
    private JPanel panAuswertung;
    private ButtonGroup grpAuswahl;
    private JRadioButton rbUsersOnline;
    private JRadioButton rbUsersInactive;
    private JSpinner spAnzahlMonate;
    private JLabel labMonate;
    private JButtonEx butOk;
    private AuswertungenTableModel tableModel;
    private JTable tabAuswertung;
    private JCheckBox cbAlleAuswaehlen;
    private JLabel labAlleAuswaehlen;
    private JButton butSelektionLoeschen;

    @Override
    public void init(AbstractDialogModel oDlgModel, DialogViewController oController) {
        this.log.debug((Object)"init");
        this.model = (DlgAuswertungenModel)oDlgModel;
        this.controller = (DlgAuswertungenController)oController;
        this.initComponents();
        this.update();
        this.repaint();
    }

    private void initComponents() {
        this.panHeader = new HeaderPanel(Resource.getInstance().getAuswertungen(), ImageCache.getInstance().getHeaderIcon("nutzer"));
        this.setLayout(new BorderLayout());
        this.add((Component)this.panHeader, "North");
        this.add((Component)this.getPanMain(), "Center");
    }

    private JPanel getPanMain() {
        if (this.panMain == null) {
            this.panMain = new JPanel();
            this.panMain.setLayout(new BoxLayout(this.panMain, 1));
            this.panMain.add(this.getPanAuswahl());
            this.panMain.add(this.getPanAuswertung());
            this.panMain.add(Box.createVerticalGlue());
        }
        return this.panMain;
    }

    private JPanel getPanAuswahl() {
        if (this.panAuswahl == null) {
            this.panAuswahl = new TitledPanel(Resource.getInstance().getArtDerAuswertung());
            this.panAuswahl.setMaximumSize(new Dimension(this.panAuswahl.getMaximumSize().width, 80));
            this.panAuswahl.setPreferredSize(new Dimension(this.panAuswahl.getPreferredSize().width, 80));
            this.panAuswahl.setLayout(new GridBagLayout());
            this.rbUsersOnline = new JRadioButton(Resource.getInstance().getAnwenderOnline(), true);
            this.rbUsersOnline.setName("UsersOnline");
            this.rbUsersOnline.addItemListener(this.controller);
            this.rbUsersInactive = new JRadioButton(Resource.getInstance().getAnwenderInaktiv(), false);
            this.rbUsersInactive.setName("UsersInactive");
            this.rbUsersInactive.addItemListener(this.controller);
            this.grpAuswahl = new ButtonGroup();
            this.grpAuswahl.add(this.rbUsersOnline);
            this.grpAuswahl.add(this.rbUsersInactive);
            SpinnerNumberModel spModel = new SpinnerNumberModel(6, 1, Integer.MAX_VALUE, 1);
            this.spAnzahlMonate = new JSpinner(spModel);
            this.spAnzahlMonate.setName("SpinnerMonate");
            this.spAnzahlMonate.addChangeListener(this.controller);
            this.spAnzahlMonate.setPreferredSize(new Dimension(40, this.spAnzahlMonate.getPreferredSize().height));
            this.labMonate = new JLabel(Resource.getInstance().getMonate());
            this.butOk = new JButtonEx(Resource.getInstance().getOk(), ImageCache.getInstance().getIcon("ok.gif"));
            this.butOk.setName("Auswertung");
            this.butOk.addActionListener(this.controller);
            GridBagConstraints gbc = this.setGridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 0, 17, new Insets(10, 10, 10, 0));
            this.panAuswahl.add((Component)this.rbUsersOnline, gbc);
            gbc = this.setGridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 0, 17, new Insets(10, 100, 10, 0));
            this.panAuswahl.add((Component)this.rbUsersInactive, gbc);
            gbc = this.setGridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 0, 17, new Insets(10, 5, 10, 0));
            this.panAuswahl.add((Component)this.spAnzahlMonate, gbc);
            gbc = this.setGridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 0, 17, new Insets(10, 5, 10, 0));
            this.panAuswahl.add((Component)this.labMonate, gbc);
            gbc = this.setGridBagConstraints(4, 0, 1, 1, 1.0, 0.0, 0, 14, new Insets(10, 5, 10, 10));
            this.panAuswahl.add((Component)this.butOk, gbc);
        }
        return this.panAuswahl;
    }

    private JPanel getPanAuswertung() {
        if (this.panAuswertung == null) {
            this.panAuswertung = new TitledPanel("");
            this.panAuswertung.setLayout(new GridBagLayout());
            this.tableModel = new AuswertungenTableModel(this.controller);
            this.tabAuswertung = new JTable(this.tableModel);
            this.tabAuswertung.setSelectionBackground(Color.WHITE);
            this.tabAuswertung.setDefaultRenderer(Date.class, new AuswertungCellRenderer());
            this.tabAuswertung.setDefaultRenderer(String.class, new AuswertungCellRenderer());
            this.tabAuswertung.setDefaultRenderer(Integer.class, new AuswertungCellRenderer());
            this.tabAuswertung.getColumnModel().getColumn(0).setMaxWidth(25);
            this.tabAuswertung.getColumnModel().getColumn(1).setMinWidth(100);
            this.tabAuswertung.getColumnModel().getColumn(2).setMinWidth(200);
            this.tabAuswertung.getColumnModel().getColumn(3).setMinWidth(200);
            this.tabAuswertung.getColumnModel().getColumn(4).setMinWidth(100);
            this.tabAuswertung.getColumnModel().getColumn(5).setMinWidth(100);
            JScrollPane scpAuswertung = new JScrollPane(this.tabAuswertung);
            scpAuswertung.setMaximumSize(new Dimension(1000, 400));
            scpAuswertung.setMinimumSize(new Dimension(1000, 50));
            GridBagConstraints gbc = this.setGridBagConstraints(0, 0, 4, 1, 1.0, 0.0, 2, 18, new Insets(0, 0, 5, 0));
            this.panAuswertung.add((Component)scpAuswertung, gbc);
            this.cbAlleAuswaehlen = new JCheckBox();
            this.cbAlleAuswaehlen.setName("AlleAuswaehlen");
            this.cbAlleAuswaehlen.addActionListener(this.controller);
            gbc = this.setGridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 0, 18, new Insets(0, 3, 5, 0));
            this.panAuswertung.add((Component)this.cbAlleAuswaehlen, gbc);
            this.labAlleAuswaehlen = new JLabel(Resource.getInstance().getAlleAuswaehlen());
            gbc = this.setGridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 0, 17, new Insets(0, 3, 0, 0));
            this.panAuswertung.add((Component)this.labAlleAuswaehlen, gbc);
            this.butSelektionLoeschen = new JButtonEx(Resource.getInstance().getAusgewaehlteNutzerLoeschen(), ImageCache.getInstance().getIcon("delete.gif"));
            this.butSelektionLoeschen.setName("SelektionLoeschen");
            this.butSelektionLoeschen.addActionListener(this.controller);
            gbc = this.setGridBagConstraints(2, 2, 1, 1, 0.0, 0.0, 0, 18, new Insets(0, 3, 0, 0));
            this.panAuswertung.add((Component)this.butSelektionLoeschen, gbc);
            JPanel spacer = new JPanel();
            gbc = this.setGridBagConstraints(0, 3, 4, 1, 1.0, 1.0, 1, 14, new Insets(0, 0, 0, 0));
            this.panAuswertung.add((Component)spacer, gbc);
            this.panAuswertung.setVisible(false);
        }
        return this.panAuswertung;
    }

    @Override
    public void initMenus() {
    }

    @Override
    public void update() throws IllegalStateException {
        this.spAnzahlMonate.setEnabled(this.rbUsersInactive.isSelected());
        if ((Integer)this.spAnzahlMonate.getValue() == 1) {
            this.labMonate.setText(Resource.getInstance().getMonat());
        } else {
            this.labMonate.setText(Resource.getInstance().getMonate());
        }
        List<User> users = this.model.getTableData();
        if (users == null || users.isEmpty()) {
            this.panAuswertung.setVisible(false);
            this.cbAlleAuswaehlen.setSelected(false);
        } else {
            String title = null;
            if (this.getAuswahl().equals("UsersOnline")) {
                title = Resource.getInstance().getAnwenderOnline();
                this.butSelektionLoeschen.setEnabled(false);
            } else if (this.getAuswahl().equals("UsersInactive")) {
                title = Resource.getInstance().getAnwenderInaktiv();
                title = title + " ";
                title = title + Integer.toString(this.getSelectedAnzahlMonate());
                title = title + " ";
                title = this.getSelectedAnzahlMonate() == 1 ? title + Resource.getInstance().getMonat() : title + Resource.getInstance().getMonate();
                this.butSelektionLoeschen.setEnabled(true);
            }
            ((TitledBorder)this.panAuswertung.getBorder()).setTitle(title);
            boolean anzahlZeilenChanged = false;
            if (this.tableModel.tableData == null || this.model.getTableData() == null || this.tableModel.tableData.length != this.model.getTableData().size()) {
                anzahlZeilenChanged = true;
            }
            this.tableModel.setTableData(this.model.getTableData());
            boolean alle = true;
            for (User user : this.model.getTableData()) {
                if (user.isChecked()) continue;
                alle = false;
                break;
            }
            this.cbAlleAuswaehlen.setSelected(alle);
            if (anzahlZeilenChanged) {
                this.tabAuswertung.updateUI();
            }
            this.panAuswertung.repaint();
            this.panAuswertung.setVisible(true);
        }
    }

    public String getAuswahl() {
        if (this.rbUsersOnline.isSelected()) {
            return "UsersOnline";
        }
        if (this.rbUsersInactive.isSelected()) {
            return "UsersInactive";
        }
        return null;
    }

    public int getSelectedAnzahlMonate() {
        Number num = ((SpinnerNumberModel)this.spAnzahlMonate.getModel()).getNumber();
        return num.intValue();
    }
}

