/*
 * Decompiled with CFR 0.152.
 */
package webetk.javaclient.dialog.administration.firmeneinstellungen;

import cz.autel.dmi.HIGConstraints;
import cz.autel.dmi.HIGLayout;
import de.esg.commonclient.GlobalObjects;
import de.esg.commonclient.dialog.AbstractDialogModel;
import de.esg.commonclient.dialog.AbstractDialogView;
import de.esg.commonclient.dialog.DialogViewController;
import de.esg.commonclient.dialog.EnhancedTextDocument;
import de.esg.commonclient.dialog.JButtonEx;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collections;
import java.util.List;
import java.util.Vector;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import org.apache.log4j.Logger;
import webetk.app.konfiguration.Filiale;
import webetk.app.konfiguration.Sprache;
import webetk.javaclient.dialog.HeaderPanel;
import webetk.javaclient.dialog.ImageCache;
import webetk.javaclient.dialog.TitledPanel;
import webetk.javaclient.dialog.TwoColumnsComboBoxRenderer;
import webetk.javaclient.dialog.administration.firmeneinstellungen.DlgFirmeneinstellungenController;
import webetk.javaclient.dialog.administration.firmeneinstellungen.DlgFirmeneinstellungenModel;
import webetk.javaclient.framework.MainView;
import webetk.javaclient.lookandfeel.UIHelper;
import webetk.resources.Resource;
import webetk.utils.StringUtils;

public class DlgFirmeneinstellungenView
extends AbstractDialogView {
    private static final long serialVersionUID = 1L;
    Logger log = Logger.getLogger(DlgFirmeneinstellungenView.class);
    DlgFirmeneinstellungenModel model;
    DlgFirmeneinstellungenController controller;
    private JComboBox cbFirma;
    private JTextField tfFirma;
    private JLabel labGeschaeftspartnerId;
    private JLabel txtGeschaeftspartnerId;
    private JLabel txtFirma;
    private JButtonEx buttonFirmaSpeichern;
    private JLabel txtFiliale;
    private JComboBox cbFiliale;
    private JLabel txtFilialenId;
    private JTextField tfFiliale;
    private JLabel txtSprache;
    private JComboBox cbSprache;
    private JButtonEx buttonFilialeSpeichern;
    private JButtonEx buttonFilialeLoeschen;
    private JLabel txtFilialeNeu;
    private JTextField tfFilialeNeu;
    private JLabel txtFilialenIdNeu;
    private JTextField tfFilialenIdNeu;
    private JLabel txtSpracheNeu;
    private JComboBox cbSpracheNeu;
    private JButtonEx buttonFilialeSpeichernNeu;
    private JPanel headerPanel;
    private JPanel firmenNeuPanel;
    private JPanel filialeAendernPanel;
    private JPanel filialeNeuPanel;
    private String sFirmenbenennung;
    private Vector<String> mcSprachen;

    @Override
    public void initMenus() {
    }

    private void initComponents() {
        this.headerPanel = new HeaderPanel(Resource.getInstance().getFilialverwaltung(), ImageCache.getInstance().getHeaderIcon(Resource.getInstance().getFiliale()));
        this.cbFirma = new JComboBox();
        this.cbFirma.setPreferredSize(new Dimension(200, (int)this.cbFirma.getPreferredSize().getHeight()));
        this.txtGeschaeftspartnerId = new JLabel(Resource.getInstance().getGeschaeftspartnerid() + ":");
        this.labGeschaeftspartnerId = new JLabel(GlobalObjects.getInstance().getSessionInfo().getFirmaId());
        this.txtFirma = new JLabel(Resource.getInstance().getFirma() + ":");
        this.tfFirma = new JTextField();
        EnhancedTextDocument ehDoc = new EnhancedTextDocument(40, 0);
        this.tfFirma.setDocument(ehDoc);
        this.tfFirma.setPreferredSize(new Dimension(200, (int)this.tfFirma.getPreferredSize().getHeight()));
        this.buttonFirmaSpeichern = new JButtonEx(Resource.getInstance().getSpeichern(), ImageCache.getInstance().getIcon("save.gif"));
        this.buttonFirmaSpeichern.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String sFirma = DlgFirmeneinstellungenView.this.tfFirma.getText().trim();
                if ((sFirma = StringUtils.maskiereHochkommaFuerDb(sFirma)).length() == 0) {
                    JOptionPane.showMessageDialog(MainView.getInstance(), Resource.getInstance().getBitteGebenSieEineFirmaAn(), Resource.getInstance().getFilialverwaltung(), 1);
                } else if (StringUtils.enthaeltHochkomma(sFirma)) {
                    JOptionPane.showMessageDialog(MainView.getInstance(), Resource.getInstance().getKeinHochkomma(), Resource.getInstance().getFilialverwaltung(), 1);
                } else if (DlgFirmeneinstellungenView.this.controller.existiertFirmenBenennung(sFirma) && !DlgFirmeneinstellungenView.this.sFirmenbenennung.equalsIgnoreCase(sFirma)) {
                    JOptionPane.showMessageDialog(MainView.getInstance(), Resource.getInstance().getFirmaWirdBereitsVerwendet(), Resource.getInstance().getFilialverwaltung(), 1);
                } else {
                    DlgFirmeneinstellungenView.this.controller.updateFirmenBezeichnung(sFirma);
                }
                DlgFirmeneinstellungenView.this.tfFirma.requestFocus();
            }
        });
        this.firmenNeuPanel = new TitledPanel(Resource.getInstance().getFirmaBearbeiten());
        int[] w = new int[]{10, 0, 10, 0, 40, 0, 10};
        int[] h = new int[]{10, 0, 10, 0, 10};
        HIGLayout layoutFirmenNeu = new HIGLayout(w, h);
        layoutFirmenNeu.setColumnWeight(4, 1);
        layoutFirmenNeu.setRowWeight(5, 1);
        HIGConstraints c = new HIGConstraints();
        this.firmenNeuPanel.setLayout(layoutFirmenNeu);
        this.firmenNeuPanel.add((Component)this.txtFirma, c.rc(2, 2, "l"));
        this.firmenNeuPanel.add((Component)this.tfFirma, c.rc(2, 4, "lr"));
        this.tfFirma.setText("");
        this.firmenNeuPanel.add((Component)this.buttonFirmaSpeichern, c.rc(2, 6, "lr"));
        this.firmenNeuPanel.add((Component)this.txtGeschaeftspartnerId, c.rc(4, 2, "lr"));
        this.firmenNeuPanel.add((Component)this.labGeschaeftspartnerId, c.rc(4, 4, "l"));
        this.txtFiliale = new JLabel(Resource.getInstance().getFiliale() + ":");
        this.cbFiliale = new JComboBox();
        this.cbFiliale.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DlgFirmeneinstellungenView.this.loadFiliale();
            }
        });
        this.cbFiliale.setPreferredSize(new Dimension(200, (int)this.cbFiliale.getPreferredSize().getHeight()));
        this.cbFiliale.setRenderer(new TwoColumnsComboBoxRenderer(130, 45));
        this.txtFilialenId = new JLabel(Resource.getInstance().getFiliale() + ":");
        this.tfFiliale = new JTextField();
        EnhancedTextDocument ehDocFiliale = new EnhancedTextDocument(40, 0);
        this.tfFiliale.setDocument(ehDocFiliale);
        this.tfFiliale.setPreferredSize(new Dimension(200, (int)this.tfFiliale.getPreferredSize().getHeight()));
        this.txtSprache = new JLabel(Resource.getInstance().getSprache() + ":");
        this.cbSprache = new JComboBox();
        this.cbSprache.setFont(UIHelper.getSprachenCbUnicodeFont());
        this.cbSprache.setPreferredSize(new Dimension(200, (int)this.cbSprache.getPreferredSize().getHeight()));
        this.buttonFilialeSpeichern = new JButtonEx(Resource.getInstance().getSpeichern(), ImageCache.getInstance().getIcon("save.gif"));
        this.buttonFilialeSpeichern.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String sFiliale = DlgFirmeneinstellungenView.this.tfFiliale.getText().trim();
                String sSprache = DlgFirmeneinstellungenView.this.cbSprache.getSelectedItem() != null ? DlgFirmeneinstellungenView.this.cbSprache.getSelectedItem().toString() : "";
                String sFilialeId = DlgFirmeneinstellungenView.this.cbFiliale.getSelectedItem().toString();
                int tabulatorposition = sFilialeId.indexOf("\t");
                String sId = sFilialeId.substring(tabulatorposition + 1);
                String sComboBoxFiliale = sFilialeId.substring(0, tabulatorposition);
                if ((sFiliale = StringUtils.maskiereHochkommaFuerDb(sFiliale)).length() == 0) {
                    JOptionPane.showMessageDialog(MainView.getInstance(), Resource.getInstance().getBitteGebenSieEineFilialeAn(), Resource.getInstance().getFilialverwaltung(), 1);
                    DlgFirmeneinstellungenView.this.tfFiliale.requestFocus();
                } else if (StringUtils.enthaeltHochkomma(sFiliale)) {
                    JOptionPane.showMessageDialog(MainView.getInstance(), Resource.getInstance().getKeinHochkomma(), Resource.getInstance().getFilialverwaltung(), 1);
                } else if (DlgFirmeneinstellungenView.this.controller.existiertFilialBezeichnung(sFiliale) && !sFiliale.equals(sComboBoxFiliale)) {
                    JOptionPane.showMessageDialog(MainView.getInstance(), Resource.getInstance().getFilialeWirdSchonVerwendetAndererWert(), Resource.getInstance().getFilialverwaltung(), 1);
                    DlgFirmeneinstellungenView.this.tfFiliale.requestFocus();
                } else {
                    String sRegiso = null;
                    String sIso = null;
                    List<Sprache> oSprachen = DlgFirmeneinstellungenView.this.model.getSprachen();
                    if (oSprachen != null) {
                        for (Sprache sprache : oSprachen) {
                            String sBenennung = sprache.getBenennung();
                            if (!sBenennung.equals(sSprache)) continue;
                            String dummy = sprache.getCode();
                            sIso = dummy.substring(0, 2);
                            sRegiso = dummy.substring(2, 4);
                            break;
                        }
                    }
                    DlgFirmeneinstellungenView.this.controller.updateFiliale(sFiliale, sId, sIso, sRegiso);
                    DlgFirmeneinstellungenView.this.update();
                    int nComboBoxIndex = -1;
                    for (int i = 0; i < DlgFirmeneinstellungenView.this.cbFiliale.getItemCount(); ++i) {
                        sFilialeId = DlgFirmeneinstellungenView.this.cbFiliale.getItemAt(i).toString();
                        String sNewId = sFilialeId.substring((tabulatorposition = sFilialeId.indexOf("\t")) + 1);
                        if (!sId.equalsIgnoreCase(sNewId)) continue;
                        nComboBoxIndex = i;
                    }
                    DlgFirmeneinstellungenView.this.cbFiliale.setSelectedIndex(nComboBoxIndex);
                    DlgFirmeneinstellungenView.this.loadFiliale();
                }
            }
        });
        this.buttonFilialeLoeschen = new JButtonEx(Resource.getInstance().getLoeschen(), ImageCache.getInstance().getIcon("delete.gif"));
        this.buttonFilialeLoeschen.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (DlgFirmeneinstellungenView.this.cbFiliale.getItemCount() > 1) {
                    String sId = DlgFirmeneinstellungenView.this.cbFiliale.getSelectedItem().toString();
                    int tabulatorposition = sId.indexOf("\t") + 1;
                    if (DlgFirmeneinstellungenView.this.controller.existNoUserWithFilialId(sId = sId.substring(tabulatorposition), GlobalObjects.getInstance().getFirmaId())) {
                        int nLoeschen = 0;
                        if (DlgFirmeneinstellungenView.this.controller.existLists(sId, GlobalObjects.getInstance().getSessionInfo().getFirmaId())) {
                            Object[] options = new Object[]{Resource.getInstance().getJa(), Resource.getInstance().getNein()};
                            nLoeschen = JOptionPane.showOptionDialog(MainView.getInstance(), Resource.getInstance().getListenVorhanden(), Resource.getInstance().getFilialverwaltung(), 0, 3, null, options, options[1]);
                        }
                        if (nLoeschen == 0) {
                            DlgFirmeneinstellungenView.this.controller.deleteFiliale(sId);
                            DlgFirmeneinstellungenView.this.update();
                        }
                    }
                } else {
                    JOptionPane.showMessageDialog(MainView.getInstance(), Resource.getInstance().getEinzigeFilialeKannNichtGeloeschtWerden(), Resource.getInstance().getFilialverwaltung(), 1);
                }
            }
        });
        this.filialeAendernPanel = new TitledPanel(Resource.getInstance().getFilialeBearbeiten());
        w = new int[]{10, 0, 10, 200, 40, 0, 10, 250, 40, 0, 10};
        h = new int[]{10, 0, 10, 0, 10};
        HIGLayout layoutFilialen = new HIGLayout(w, h);
        layoutFilialen.setColumnWeight(5, 1);
        layoutFilialen.setRowWeight(5, 1);
        this.filialeAendernPanel.setLayout(layoutFilialen);
        this.filialeAendernPanel.add((Component)this.txtFiliale, c.rc(2, 2, "l"));
        this.filialeAendernPanel.add((Component)this.cbFiliale, c.rc(2, 4, "lr"));
        this.filialeAendernPanel.add((Component)this.txtFilialenId, c.rc(2, 6, "l"));
        this.filialeAendernPanel.add((Component)this.tfFiliale, c.rc(2, 8, "lr"));
        this.filialeAendernPanel.add((Component)this.txtSprache, c.rc(4, 6, "l"));
        this.filialeAendernPanel.add((Component)this.cbSprache, c.rc(4, 8, "lr"));
        this.filialeAendernPanel.add((Component)this.buttonFilialeSpeichern, c.rc(2, 10, "lr"));
        this.filialeAendernPanel.add((Component)this.buttonFilialeLoeschen, c.rc(4, 10, "lr"));
        this.txtFilialeNeu = new JLabel(Resource.getInstance().getFiliale() + ":");
        this.tfFilialeNeu = new JTextField();
        EnhancedTextDocument ehDoc40 = new EnhancedTextDocument(40, 0);
        this.tfFilialeNeu.setDocument(ehDoc40);
        this.tfFilialeNeu.setPreferredSize(new Dimension(200, (int)this.tfFilialeNeu.getPreferredSize().getHeight()));
        this.txtFilialenIdNeu = new JLabel(Resource.getInstance().getFilialId() + ":");
        this.tfFilialenIdNeu = new JTextField(15);
        EnhancedTextDocument ehDoc4 = new EnhancedTextDocument(4, 0);
        this.tfFilialenIdNeu.setDocument(ehDoc4);
        this.txtSpracheNeu = new JLabel(Resource.getInstance().getSprache() + ":");
        this.cbSpracheNeu = new JComboBox();
        this.cbSpracheNeu.setFont(UIHelper.getSprachenCbUnicodeFont());
        this.cbSpracheNeu.setPreferredSize(new Dimension(200, (int)this.cbSpracheNeu.getPreferredSize().getHeight()));
        this.buttonFilialeSpeichernNeu = new JButtonEx(Resource.getInstance().getSpeichern(), ImageCache.getInstance().getIcon("save.gif"));
        this.buttonFilialeSpeichernNeu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String sFiliale = DlgFirmeneinstellungenView.this.tfFilialeNeu.getText().trim();
                String sId = DlgFirmeneinstellungenView.this.tfFilialenIdNeu.getText().trim();
                String sSprache = DlgFirmeneinstellungenView.this.cbSpracheNeu.getSelectedItem() != null ? DlgFirmeneinstellungenView.this.cbSpracheNeu.getSelectedItem().toString() : "";
                sFiliale = StringUtils.maskiereHochkommaFuerDb(sFiliale);
                if (sId.length() == 0) {
                    JOptionPane.showMessageDialog(MainView.getInstance(), Resource.getInstance().getBitteGebenSieEineFilialidAn(), Resource.getInstance().getFilialverwaltung(), 1);
                    DlgFirmeneinstellungenView.this.tfFilialenIdNeu.requestFocus();
                } else if (!StringUtils.isNMToken(sId)) {
                    JOptionPane.showMessageDialog(MainView.getInstance(), Resource.getInstance().getWrongFormatNmtoken(), Resource.getInstance().getBenutzerverwaltung(), 1);
                    DlgFirmeneinstellungenView.this.tfFilialenIdNeu.requestFocus();
                } else if (sFiliale.length() == 0) {
                    JOptionPane.showMessageDialog(MainView.getInstance(), Resource.getInstance().getBitteGebenSieEineFilialeAn(), Resource.getInstance().getFilialverwaltung(), 1);
                    DlgFirmeneinstellungenView.this.tfFilialeNeu.requestFocus();
                } else if (StringUtils.enthaeltHochkomma(sFiliale) || StringUtils.enthaeltHochkomma(sId)) {
                    JOptionPane.showMessageDialog(MainView.getInstance(), Resource.getInstance().getKeinHochkomma(), Resource.getInstance().getFilialverwaltung(), 1);
                } else if (sSprache.equals("")) {
                    JOptionPane.showMessageDialog(MainView.getInstance(), Resource.getInstance().getKeineDefaultspracheAusgewaehlt(), Resource.getInstance().getFilialverwaltung(), 1);
                    DlgFirmeneinstellungenView.this.cbSpracheNeu.requestFocus();
                } else if (DlgFirmeneinstellungenView.this.controller.existiertFilialId(sId)) {
                    JOptionPane.showMessageDialog(MainView.getInstance(), Resource.getInstance().getFilialidWirdSchonVerwendet(), Resource.getInstance().getFilialverwaltung(), 1);
                    DlgFirmeneinstellungenView.this.tfFilialenIdNeu.requestFocus();
                } else if (DlgFirmeneinstellungenView.this.controller.existiertFilialBezeichnung(sFiliale)) {
                    JOptionPane.showMessageDialog(MainView.getInstance(), Resource.getInstance().getFilialeWirdSchonVerwendetAndererWert(), Resource.getInstance().getFilialverwaltung(), 1);
                    DlgFirmeneinstellungenView.this.tfFilialeNeu.requestFocus();
                } else {
                    String sRegiso = null;
                    String sIso = null;
                    List<Sprache> oSprachen = DlgFirmeneinstellungenView.this.model.getSprachen();
                    if (oSprachen != null) {
                        for (Sprache sprache : oSprachen) {
                            String sBenennung = sprache.getBenennung();
                            if (!sBenennung.equals(sSprache)) continue;
                            String dummy = sprache.getCode();
                            sIso = dummy.substring(0, 2);
                            sRegiso = dummy.substring(2, 4);
                            break;
                        }
                    }
                    DlgFirmeneinstellungenView.this.controller.erzeugeNeueFiliale(sFiliale, sId, sIso, sRegiso);
                    DlgFirmeneinstellungenView.this.update();
                }
            }
        });
        this.filialeNeuPanel = new TitledPanel(Resource.getInstance().getNeueFilialeAnlegen());
        int[] wNeu = new int[]{10, 0, 10, 200, 40, 0, 10, 250, 40, 0, 10};
        int[] hNeu = new int[]{10, 0, 10, 0, 10};
        HIGLayout layoutFilialenNeu = new HIGLayout(wNeu, hNeu);
        layoutFilialenNeu.setColumnWeight(5, 1);
        layoutFilialenNeu.setRowWeight(5, 1);
        this.filialeNeuPanel.setLayout(layoutFilialenNeu);
        this.filialeNeuPanel.add((Component)this.txtFilialeNeu, c.rc(2, 2, "l"));
        this.filialeNeuPanel.add((Component)this.tfFilialeNeu, c.rc(2, 4, "lr"));
        this.filialeNeuPanel.add((Component)this.txtFilialenIdNeu, c.rc(2, 6, "l"));
        this.filialeNeuPanel.add((Component)this.tfFilialenIdNeu, c.rc(2, 8, "lr"));
        this.filialeNeuPanel.add((Component)this.txtSpracheNeu, c.rc(4, 6, "l"));
        this.filialeNeuPanel.add((Component)this.cbSpracheNeu, c.rc(4, 8, "lr"));
        this.filialeNeuPanel.add((Component)this.buttonFilialeSpeichernNeu, c.rc(2, 10, "lr"));
        this.createLayout();
    }

    private void createLayout() {
        this.setLayout(new BorderLayout());
        this.add((Component)this.headerPanel, "North");
        JScrollPane content = new JScrollPane(this.createContent());
        this.add((Component)content, "Center");
    }

    @Override
    public void init(AbstractDialogModel oDlgModel, DialogViewController oController) {
        this.log.debug((Object)"init");
        this.model = (DlgFirmeneinstellungenModel)oDlgModel;
        this.controller = (DlgFirmeneinstellungenController)oController;
        this.initComponents();
        this.update();
        this.repaint();
    }

    @Override
    public void update() {
        String sUserFirma = GlobalObjects.getInstance().getSessionInfo().getFirmaId();
        String sRegIso = GlobalObjects.getInstance().getSessionInfo().getLangRegion();
        sRegIso = sRegIso == null ? "  " : sRegIso;
        String sIso = GlobalObjects.getInstance().getSessionInfo().getLanguage();
        this.controller.loadFilialen(sUserFirma);
        this.controller.loadSprachen(sIso, sRegIso);
        this.controller.loadFirma();
        this.tfFirma.setText(this.model.getFirmaBenennung());
        this.sFirmenbenennung = this.tfFirma.getText();
        this.cbFiliale.removeAllItems();
        List<Filiale> oFilialen = this.model.getFilialen();
        for (Filiale filiale : oFilialen) {
            this.cbFiliale.addItem(filiale.getBezeichnung() + "\t" + filiale.getId());
        }
        this.cbSprache.removeAllItems();
        int selectedIndex = this.cbSpracheNeu.getSelectedIndex();
        this.cbSpracheNeu.removeAllItems();
        this.mcSprachen = new Vector();
        List<Sprache> oSprachen = this.model.getSprachen();
        if (oSprachen != null) {
            for (Sprache sprache : oSprachen) {
                this.mcSprachen.add(sprache.getBenennung());
            }
        }
        Collections.sort(this.mcSprachen);
        for (String sBenennung : this.mcSprachen) {
            this.cbSprache.addItem(sBenennung);
            this.cbSpracheNeu.addItem(sBenennung);
        }
        this.cbFiliale.setSelectedIndex(-1);
        this.cbSprache.setSelectedIndex(-1);
        this.cbSpracheNeu.setSelectedIndex(selectedIndex);
        if (this.cbFiliale.getModel().getSize() == 1) {
            this.cbFiliale.setSelectedIndex(0);
            this.loadFiliale();
            this.buttonFilialeSpeichern.setEnabled(true);
            this.buttonFilialeLoeschen.setEnabled(true);
        } else {
            this.buttonFilialeSpeichern.setEnabled(false);
            this.buttonFilialeLoeschen.setEnabled(false);
        }
    }

    private JPanel createContent() {
        JPanel contentPanel = new JPanel();
        int[] w = new int[]{0};
        int[] h = new int[]{0};
        HIGLayout hl = new HIGLayout(w, h);
        hl.setColumnWeight(1, 1);
        hl.setRowWeight(1, 1);
        HIGConstraints c = new HIGConstraints();
        contentPanel.setLayout(hl);
        contentPanel.add((Component)this.createAnzeigePanel(), c.rc(1, 1));
        return contentPanel;
    }

    private JPanel createAnzeigePanel() {
        JPanel anzeigePanel = new JPanel();
        int[] w_anzeige = new int[]{10, 0, 10};
        int[] h_anzeige = new int[]{10, 0, 10, 0, 10, 0, 10};
        HIGLayout layoutAnzeige = new HIGLayout(w_anzeige, h_anzeige);
        layoutAnzeige.setColumnWeight(3, 1);
        layoutAnzeige.setRowWeight(7, 1);
        HIGConstraints c = new HIGConstraints();
        anzeigePanel.setLayout(layoutAnzeige);
        anzeigePanel.add((Component)this.createFirmenPanel(), c.rcwh(2, 2, 1, 1, "lr"));
        anzeigePanel.add((Component)this.createFilialenPanel(), c.rcwh(4, 2, 1, 1, "lr"));
        return anzeigePanel;
    }

    private JPanel createFirmenPanel() {
        TitledPanel firmenPanel = new TitledPanel(Resource.getInstance().getFirma());
        int[] w_firmen = new int[]{10, 0, 10};
        int[] h_firmen = new int[]{10, 0, 10};
        HIGLayout layoutFirmen = new HIGLayout(w_firmen, h_firmen);
        layoutFirmen.setColumnWeight(2, 1);
        layoutFirmen.setRowWeight(2, 1);
        HIGConstraints c = new HIGConstraints();
        firmenPanel.setLayout(layoutFirmen);
        firmenPanel.add((Component)this.firmenNeuPanel, c.rc(2, 2, "lrtb"));
        return firmenPanel;
    }

    private JPanel createFilialenPanel() {
        TitledPanel filialenPanel = new TitledPanel(Resource.getInstance().getFilialen());
        int[] w = new int[]{10, 0, 10};
        int[] h = new int[]{10, 0, 10, 0, 10};
        HIGLayout layoutFilialen = new HIGLayout(w, h);
        layoutFilialen.setColumnWeight(3, 1);
        layoutFilialen.setRowWeight(5, 1);
        HIGConstraints c = new HIGConstraints();
        filialenPanel.setLayout(layoutFilialen);
        filialenPanel.add((Component)this.filialeAendernPanel, c.rc(2, 2, "lr"));
        filialenPanel.add((Component)this.filialeNeuPanel, c.rc(4, 2, "lr"));
        return filialenPanel;
    }

    private void loadFiliale() {
        String sFilialeUndId = (String)this.cbFiliale.getSelectedItem();
        int tabulatorposition = -1;
        if (sFilialeUndId != null) {
            tabulatorposition = sFilialeUndId.indexOf("\t");
        }
        String sFiliale = null;
        if (tabulatorposition == -1) {
            sFiliale = sFilialeUndId;
        } else {
            sFiliale = sFilialeUndId.substring(0, tabulatorposition);
            List<Filiale> oFilialen = this.model.getFilialen();
            if (oFilialen != null) {
                block0: for (Filiale filiale : oFilialen) {
                    String sId = filiale.getId();
                    if (!sId.equals(sFilialeUndId.substring(tabulatorposition + 1))) continue;
                    String sIso = filiale.getISO();
                    String sRegIso = filiale.getRegISO();
                    sRegIso = sRegIso == null ? "  " : sRegIso;
                    List<Sprache> oSprachen = this.model.getSprachen();
                    if (oSprachen == null) break;
                    for (Sprache sprache : oSprachen) {
                        String dummy = sprache.getCode();
                        String sSprachenIso = dummy.substring(0, 2);
                        String sSprachenRegIso = dummy.substring(2, 4);
                        if (!sIso.equals(sSprachenIso) || !sRegIso.equals(sSprachenRegIso)) continue;
                        String sBenennung = sprache.getBenennung();
                        this.cbSprache.setSelectedItem(sBenennung);
                        break block0;
                    }
                }
            }
        }
        this.tfFiliale.setText(sFiliale);
        this.buttonFilialeSpeichern.setEnabled(true);
        this.buttonFilialeLoeschen.setEnabled(true);
    }
}

