/*
 * Decompiled with CFR 0.152.
 */
package webetk.javaclient.dialog.administration.konfiguration;

import de.esg.commonclient.GlobalObjects;
import de.esg.commonclient.dialog.AbstractDialogViewController;
import java.awt.Cursor;
import javax.swing.JOptionPane;
import org.apache.log4j.Logger;
import webetk.app.konfiguration.Konfiguration;
import webetk.communication.CommunicationException;
import webetk.communication.LoginInfo;
import webetk.communication.transferables.Command;
import webetk.communication.transferables.TrfHashMap;
import webetk.javaclient.dialog.administration.konfiguration.DlgKonfigurationModel;
import webetk.javaclient.dialog.administration.konfiguration.DlgKonfigurationView;
import webetk.javaclient.framework.MainView;
import webetk.javaclient.utils.CommunicationUtils;
import webetk.javaclient.utils.DmsUtils;
import webetk.javaclient.workflow.WorkflowStateData;
import webetk.resources.Resource;

public class DlgKonfigurationController
extends AbstractDialogViewController {
    Logger log = Logger.getLogger(DlgKonfigurationController.class);
    DlgKonfigurationModel model = new DlgKonfigurationModel();

    @Override
    public void init(WorkflowStateData oWFStateData) {
        this.log.debug((Object)"init");
        this.dialogView = new DlgKonfigurationView();
        this.model.init(oWFStateData);
        this.dialogView.init(this.model, this);
    }

    @Override
    public WorkflowStateData getExitData() {
        return null;
    }

    @Override
    public boolean skipToNextState() {
        return false;
    }

    protected void loadKonfiguration() {
        this.model.storeKonfiguration(GlobalObjects.getInstance().getConfig());
    }

    protected void saveKonfiguration() {
        TrfHashMap trfKonfig = new TrfHashMap(null);
        trfKonfig.setValue("Haendler_Konfiguration", this.model.getKonfiguration());
        try {
            GlobalObjects.getInstance().getServiceExecutor().executeService(trfKonfig, Command.SAVE_KONFIGURATION);
        }
        catch (CommunicationException ex) {
            this.log.error((Object)("Service: " + Command.SAVE_KONFIGURATION + " URL: " + GlobalObjects.getInstance().getServerUrl()), (Throwable)ex);
            MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
        }
        if (!CommunicationUtils.checkError(trfKonfig, Resource.getInstance().getKonfiguration())) {
            return;
        }
        LoginInfo oLoginInfo = GlobalObjects.getInstance().getSessionInfo();
        boolean bDMSVerwenden = GlobalObjects.getInstance().getConfig().getDMSSchnittstelleVerwenden().equals("J");
        oLoginInfo.setDMSVerwenden(oLoginInfo.getDMSAngeschlossen() && bDMSVerwenden);
    }

    protected void doDMSAbgleich() {
        MainView.getInstance().setCursor(Cursor.getPredefinedCursor(3));
        TrfHashMap oTrf = new TrfHashMap(null);
        try {
            String sPasswort = GlobalObjects.getInstance().getEtkData().getPasswort();
            oTrf.setValue("pwd", sPasswort);
            oTrf.setValue("Haendler_Konfiguration", this.model.getKonfiguration());
            GlobalObjects.getInstance().getServiceExecutor().executeService(oTrf, Command.DO_KONFIGURATION_DMS_ABGLEICH);
        }
        catch (CommunicationException ex) {
            MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
            JOptionPane.showMessageDialog(MainView.getInstance(), ex.getMessage(), Resource.getInstance().getKonfiguration(), 0);
            return;
        }
        Integer nStatus = (Integer)oTrf.getValue("returncodes");
        if (!DmsUtils.showMsgTxt((String)oTrf.getValue("msgtxt"), nStatus)) {
            oTrf.setValue("returncodes", null);
            return;
        }
        if (oTrf.getError() != null) {
            Exception ex = oTrf.getError();
            MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
            JOptionPane.showMessageDialog(MainView.getInstance(), Resource.getInstance().getFehlerDmsAbgleich() + ": " + ex.getMessage(), Resource.getInstance().getKonfiguration(), 0);
            oTrf.setError(null);
            return;
        }
        this.model.storeKonfiguration((Konfiguration)oTrf.getValue("Haendler_Konfiguration"));
        this.dialogView.update();
        MainView.getInstance().setCursor(Cursor.getPredefinedCursor(0));
    }
}

